/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.web.filters;

import java.io.IOException;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.LoginUrlAuthenticationEntryPoint;
import org.springframework.stereotype.Component;

@Component
public class AtlasAuthenticationEntryPoint
extends LoginUrlAuthenticationEntryPoint {
    private static final Logger LOG = LoggerFactory.getLogger(AtlasAuthenticationEntryPoint.class);
    private static final String LOGIN_PATH = "/login.jsp";

    @Inject
    public AtlasAuthenticationEntryPoint(@Value(value="/login.jsp") String loginFormUrl) {
        super(loginFormUrl);
    }

    public void commence(HttpServletRequest request, HttpServletResponse response, AuthenticationException authException) throws IOException {
        String ajaxRequestHeader = request.getHeader("X-Requested-With");
        response.setHeader("X-Frame-Options", "DENY");
        if ("XMLHttpRequest".equals(ajaxRequestHeader)) {
            response.setStatus(401);
        } else {
            LOG.debug("redirecting to login page loginPath {}", (Object)LOGIN_PATH);
            response.sendRedirect(LOGIN_PATH);
        }
    }
}

