/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.web.errors;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExceptionMapperUtil {
    protected static final Logger LOGGER = LoggerFactory.getLogger(ExceptionMapperUtil.class);

    private ExceptionMapperUtil() {
    }

    protected static String formatErrorMessage(long id, Exception exception) {
        return String.format("There was an error processing your request. It has been logged (ID %016x).", id);
    }

    protected static void logException(long id, Exception exception) {
        LOGGER.error(ExceptionMapperUtil.formatLogMessage(id, exception), (Throwable)exception);
    }

    protected static String formatLogMessage(long id, Throwable exception) {
        return String.format("Error handling a request: %016x", id);
    }
}

