/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.util;

import java.io.Console;
import java.io.IOException;
import java.util.Arrays;
import org.apache.atlas.web.dao.UserDao;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.alias.CredentialProvider;
import org.apache.hadoop.security.alias.CredentialProviderFactory;

public class CredentialProviderUtility {
    private static final String[] KEYS = new String[]{"keystore.password", "truststore.password", "password"};
    private static final TextDevice DEFAULT_TEXT_DEVICE;
    public static TextDevice textDevice;

    private CredentialProviderUtility() {
    }

    public static void main(String[] args) throws IOException {
        try {
            CommandLine cmd = new DefaultParser().parse(CredentialProviderUtility.createOptions(), args);
            boolean generatePasswordOption = cmd.hasOption("g");
            String key = cmd.getOptionValue("k");
            char[] cred = null;
            String providerPath = cmd.getOptionValue("f");
            if (cmd.hasOption("p")) {
                cred = cmd.getOptionValue("p").toCharArray();
            }
            if (generatePasswordOption) {
                String userName = cmd.getOptionValue("u");
                String password = cmd.getOptionValue("p");
                if (userName != null && password != null) {
                    String encryptedPassword = UserDao.encrypt(password);
                    boolean silentOption = cmd.hasOption("s");
                    if (silentOption) {
                        System.out.println(encryptedPassword);
                    } else {
                        System.out.println("Your encrypted password is  : " + encryptedPassword);
                    }
                } else {
                    System.out.println("Please provide username and password as input. Usage: cputil.py -g -u <username> -p <password>");
                }
                return;
            }
            if (key != null && cred != null && providerPath != null) {
                if (!StringUtils.isEmpty((String)String.valueOf(cred))) {
                    Configuration conf = new Configuration(false);
                    conf.set("hadoop.security.credential.provider.path", providerPath);
                    CredentialProvider provider = (CredentialProvider)CredentialProviderFactory.getProviders((Configuration)conf).get(0);
                    provider.createCredentialEntry(key, cred);
                    provider.flush();
                    System.out.println("Password is stored in Credential Provider");
                } else {
                    System.out.println("Please enter a valid password");
                }
                return;
            }
        }
        catch (Exception e) {
            System.out.println("Exception while generatePassword  " + e.getMessage());
            return;
        }
        CredentialProvider provider = CredentialProviderUtility.getCredentialProvider(textDevice);
        if (provider != null) {
            for (String key : KEYS) {
                char[] cred = CredentialProviderUtility.getPassword(textDevice, key);
                if (provider.getCredentialEntry(key) != null) {
                    boolean overwrite;
                    String choice = textDevice.readLine("Entry for %s already exists.  Overwrite? (y/n) [y]:", key);
                    boolean bl = overwrite = StringUtils.isEmpty((String)choice) || choice.equalsIgnoreCase("y");
                    if (overwrite) {
                        provider.deleteCredentialEntry(key);
                        provider.flush();
                        provider.createCredentialEntry(key, cred);
                        provider.flush();
                        textDevice.printf("Entry for %s was overwritten with the new value.\n", key);
                        continue;
                    }
                    textDevice.printf("Entry for %s was not overwritten.\n", key);
                    continue;
                }
                provider.createCredentialEntry(key, cred);
                provider.flush();
            }
        }
    }

    private static Options createOptions() {
        Options options = new Options();
        options.addOption("k", "ldapkey", true, "key");
        options.addOption("f", "ldapPath", true, "path");
        options.addOption("g", "generatePassword", false, "Generate Password");
        options.addOption("s", "silent", false, "Silent");
        options.addOption("u", "username", true, "UserName");
        options.addOption("p", "password", true, "Password");
        return options;
    }

    private static char[] getPassword(TextDevice textDevice, String key) {
        char[] ret;
        while (true) {
            char[] passwd2;
            char[] passwd1;
            boolean isMatch;
            if (!(isMatch = Arrays.equals(passwd1 = textDevice.readPassword("Please enter the password value for %s:", key), passwd2 = textDevice.readPassword("Please enter the password value for %s again:", key)))) {
                textDevice.printf("Password entries don't match. Please try again.\n", new Object[0]);
            } else if (passwd1 == null || passwd1.length == 0) {
                textDevice.printf("An empty password is not valid.  Please try again.\n", new Object[0]);
            } else {
                ret = passwd1;
                if (passwd2 == null) break;
                Arrays.fill(passwd2, ' ');
                break;
            }
            if (passwd1 != null) {
                Arrays.fill(passwd1, ' ');
            }
            if (passwd2 == null) continue;
            Arrays.fill(passwd2, ' ');
        }
        return ret;
    }

    private static CredentialProvider getCredentialProvider(TextDevice textDevice) throws IOException {
        String providerPath = textDevice.readLine("Please enter the full path to the credential provider:", new Object[0]);
        if (providerPath != null) {
            Configuration conf = new Configuration(false);
            conf.set("hadoop.security.credential.provider.path", providerPath);
            return (CredentialProvider)CredentialProviderFactory.getProviders((Configuration)conf).get(0);
        }
        return null;
    }

    static {
        textDevice = DEFAULT_TEXT_DEVICE = new TextDevice(){
            final Console console = System.console();

            @Override
            public void printf(String fmt, Object ... params) {
                this.console.printf(fmt, params);
            }

            @Override
            public String readLine(String fmt, Object ... args) {
                return this.console.readLine(fmt, args);
            }

            @Override
            public char[] readPassword(String fmt, Object ... args) {
                return this.console.readPassword(fmt, args);
            }
        };
    }

    public static abstract class TextDevice {
        public abstract void printf(String var1, Object ... var2);

        public abstract String readLine(String var1, Object ... var2);

        public abstract char[] readPassword(String var1, Object ... var2);
    }
}

