/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.notification.preprocessor;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.AtlasObjectId;
import org.apache.atlas.notification.preprocessor.EntityPreprocessor;
import org.apache.atlas.notification.preprocessor.PreprocessorContext;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RdbmsPreprocessor {
    private static final Logger LOG = LoggerFactory.getLogger(RdbmsPreprocessor.class);
    private static final String RELATIONSHIP_TYPE_RDBMS_INSTANCE_DATABASES = "rdbms_instance_databases";
    private static final String RELATIONSHIP_TYPE_RDBMS_DB_TABLES = "rdbms_db_tables";
    private static final String RELATIONSHIP_TYPE_RDBMS_TABLE_COLUMNS = "rdbms_table_columns";
    private static final String RELATIONSHIP_TYPE_RDBMS_TABLE_INDEXES = "rdbms_table_indexes";
    private static final String RELATIONSHIP_TYPE_RDBMS_TABLE_FOREIGN_KEYS = "rdbms_table_foreign_key";

    static class RdbmsTypePreprocessor
    extends EntityPreprocessor {
        private static final Set<String> entityTypesToMove = new HashSet<String>();

        protected RdbmsTypePreprocessor(String typeName) {
            super(typeName);
        }

        @Override
        public void preprocess(AtlasEntity entity, PreprocessorContext context) {
            if (context.getRdbmsTypesRemoveOwnedRefAttrs()) {
                this.clearRefAttributesAndMove(entity, context);
                Map<String, AtlasEntity> referredEntities = context.getReferredEntities();
                if (MapUtils.isNotEmpty(referredEntities)) {
                    for (AtlasEntity referredEntity : referredEntities.values()) {
                        if (!entityTypesToMove.contains(referredEntity.getTypeName())) continue;
                        this.clearRefAttributesAndMove(referredEntity, context);
                    }
                }
            }
        }

        private void clearRefAttributesAndMove(AtlasEntity entity, PreprocessorContext context) {
            switch (entity.getTypeName()) {
                case "rdbms_instance": {
                    context.removeRefAttributeAndRegisterToMove(entity, "databases", RdbmsPreprocessor.RELATIONSHIP_TYPE_RDBMS_INSTANCE_DATABASES, "instance");
                    break;
                }
                case "rdbms_db": {
                    context.removeRefAttributeAndRegisterToMove(entity, "tables", RdbmsPreprocessor.RELATIONSHIP_TYPE_RDBMS_DB_TABLES, "db");
                    break;
                }
                case "rdbms_table": {
                    context.removeRefAttributeAndRegisterToMove(entity, "columns", RdbmsPreprocessor.RELATIONSHIP_TYPE_RDBMS_TABLE_COLUMNS, "table");
                    context.removeRefAttributeAndRegisterToMove(entity, "indexes", RdbmsPreprocessor.RELATIONSHIP_TYPE_RDBMS_TABLE_INDEXES, "table");
                    context.removeRefAttributeAndRegisterToMove(entity, "foreign_keys", RdbmsPreprocessor.RELATIONSHIP_TYPE_RDBMS_TABLE_FOREIGN_KEYS, "table");
                }
            }
        }

        static {
            entityTypesToMove.add("rdbms_db");
            entityTypesToMove.add("rdbms_table");
            entityTypesToMove.add("rdbms_column");
            entityTypesToMove.add("rdbms_index");
            entityTypesToMove.add("rdbms_foreign_key");
        }
    }

    static class RdbmsTablePreprocessor
    extends RdbmsTypePreprocessor {
        public RdbmsTablePreprocessor() {
            super("rdbms_table");
        }

        @Override
        public void preprocess(AtlasEntity entity, PreprocessorContext context) {
            String dbQualifiedName;
            super.preprocess(entity, context);
            Object db = entity.getRelationshipAttribute("db");
            if (db == null) {
                db = entity.getAttribute("db");
            }
            if (db == null && (dbQualifiedName = this.getDbQualifiedName(entity)) != null) {
                AtlasObjectId dbId = new AtlasObjectId("rdbms_db", Collections.singletonMap("qualifiedName", dbQualifiedName));
                LOG.info("missing attribute {}.{} is set to {}", new Object[]{"rdbms_table", "db", dbId});
                entity.setRelationshipAttribute("db", (Object)dbId);
            }
        }

        private String getDbQualifiedName(AtlasEntity tableEntity) {
            String ret = null;
            Object tblQualifiedName = tableEntity.getAttribute("qualifiedName");
            Object tblName = tableEntity.getAttribute("name");
            if (tblQualifiedName != null && tblName != null) {
                ret = tblQualifiedName.toString().replace("." + tblName + "@", "@");
            }
            return ret;
        }
    }

    static class RdbmsDbPreprocessor
    extends RdbmsTypePreprocessor {
        public RdbmsDbPreprocessor() {
            super("rdbms_db");
        }
    }

    static class RdbmsInstancePreprocessor
    extends RdbmsTypePreprocessor {
        public RdbmsInstancePreprocessor() {
            super("rdbms_instance");
        }
    }
}

