/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.notification.preprocessor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.atlas.kafka.AtlasKafkaMessage;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.AtlasObjectId;
import org.apache.atlas.model.instance.AtlasRelatedObjectId;
import org.apache.atlas.model.notification.HookNotification;
import org.apache.atlas.notification.EntityCorrelationManager;
import org.apache.atlas.notification.preprocessor.EntityPreprocessor;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.atlas.type.AtlasTypeUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreprocessorContext {
    private static final Logger LOG = LoggerFactory.getLogger(PreprocessorContext.class);
    private final AtlasKafkaMessage<HookNotification> kafkaMessage;
    private final AtlasTypeRegistry typeRegistry;
    private final AtlasEntity.AtlasEntitiesWithExtInfo entitiesWithExtInfo;
    private final List<Pattern> hiveTablesToIgnore;
    private final List<Pattern> hiveTablesToPrune;
    private final Map<String, PreprocessAction> hiveTablesCache;
    private final List<String> hiveDummyDatabasesToIgnore;
    private final List<String> hiveDummyTablesToIgnore;
    private final List<String> hiveTablePrefixesToIgnore;
    private final boolean updateHiveProcessNameWithQualifiedName;
    private final boolean hiveTypesRemoveOwnedRefAttrs;
    private final boolean rdbmsTypesRemoveOwnedRefAttrs;
    private final boolean s3V2DirectoryPruneObjectPrefix;
    private final boolean isHivePreProcessEnabled;
    private final Set<String> ignoredEntities = new HashSet<String>();
    private final Set<String> prunedEntities = new HashSet<String>();
    private final Set<String> referredEntitiesToMove = new HashSet<String>();
    private final Set<String> createdEntities = new HashSet<String>();
    private final Set<String> deletedEntities = new HashSet<String>();
    private final Map<String, String> guidAssignments = new HashMap<String, String>();
    private final EntityCorrelationManager correlationManager;
    private List<AtlasEntity> postUpdateEntities;

    public PreprocessorContext(AtlasKafkaMessage<HookNotification> kafkaMessage, AtlasTypeRegistry typeRegistry, List<Pattern> hiveTablesToIgnore, List<Pattern> hiveTablesToPrune, Map<String, PreprocessAction> hiveTablesCache, List<String> hiveDummyDatabasesToIgnore, List<String> hiveDummyTablesToIgnore, List<String> hiveTablePrefixesToIgnore, boolean hiveTypesRemoveOwnedRefAttrs, boolean rdbmsTypesRemoveOwnedRefAttrs, boolean s3V2DirectoryPruneObjectPrefix, boolean updateHiveProcessNameWithQualifiedName, EntityCorrelationManager correlationManager) {
        this.kafkaMessage = kafkaMessage;
        this.typeRegistry = typeRegistry;
        this.hiveTablesToIgnore = hiveTablesToIgnore;
        this.hiveTablesToPrune = hiveTablesToPrune;
        this.hiveTablesCache = hiveTablesCache;
        this.hiveDummyDatabasesToIgnore = hiveDummyDatabasesToIgnore;
        this.hiveDummyTablesToIgnore = hiveDummyTablesToIgnore;
        this.hiveTablePrefixesToIgnore = hiveTablePrefixesToIgnore;
        this.hiveTypesRemoveOwnedRefAttrs = hiveTypesRemoveOwnedRefAttrs;
        this.rdbmsTypesRemoveOwnedRefAttrs = rdbmsTypesRemoveOwnedRefAttrs;
        this.s3V2DirectoryPruneObjectPrefix = s3V2DirectoryPruneObjectPrefix;
        this.updateHiveProcessNameWithQualifiedName = updateHiveProcessNameWithQualifiedName;
        HookNotification message = (HookNotification)kafkaMessage.getMessage();
        switch (message.getType()) {
            case ENTITY_CREATE_V2: {
                this.entitiesWithExtInfo = ((HookNotification.EntityCreateRequestV2)message).getEntities();
                break;
            }
            case ENTITY_FULL_UPDATE_V2: {
                this.entitiesWithExtInfo = ((HookNotification.EntityUpdateRequestV2)message).getEntities();
                break;
            }
            default: {
                this.entitiesWithExtInfo = null;
            }
        }
        this.isHivePreProcessEnabled = hiveTypesRemoveOwnedRefAttrs || !hiveTablesToIgnore.isEmpty() || !hiveTablesToPrune.isEmpty() || !hiveDummyDatabasesToIgnore.isEmpty() || !hiveDummyTablesToIgnore.isEmpty() || !hiveTablePrefixesToIgnore.isEmpty() || updateHiveProcessNameWithQualifiedName;
        this.correlationManager = correlationManager;
    }

    public AtlasKafkaMessage<HookNotification> getKafkaMessage() {
        return this.kafkaMessage;
    }

    public long getKafkaMessageOffset() {
        return this.kafkaMessage.getOffset();
    }

    public int getKafkaPartition() {
        return this.kafkaMessage.getPartition();
    }

    public boolean updateHiveProcessNameWithQualifiedName() {
        return this.updateHiveProcessNameWithQualifiedName;
    }

    public boolean getHiveTypesRemoveOwnedRefAttrs() {
        return this.hiveTypesRemoveOwnedRefAttrs;
    }

    public boolean getRdbmsTypesRemoveOwnedRefAttrs() {
        return this.rdbmsTypesRemoveOwnedRefAttrs;
    }

    public boolean getS3V2DirectoryPruneObjectPrefix() {
        return this.s3V2DirectoryPruneObjectPrefix;
    }

    public boolean isHivePreprocessEnabled() {
        return this.isHivePreProcessEnabled;
    }

    public List<AtlasEntity> getEntities() {
        return this.entitiesWithExtInfo != null ? this.entitiesWithExtInfo.getEntities() : null;
    }

    public Map<String, AtlasEntity> getReferredEntities() {
        return this.entitiesWithExtInfo != null ? this.entitiesWithExtInfo.getReferredEntities() : null;
    }

    public AtlasEntity getEntity(String guid) {
        return this.entitiesWithExtInfo != null && guid != null ? this.entitiesWithExtInfo.getEntity(guid) : null;
    }

    public AtlasEntity removeReferredEntity(String guid) {
        Map<String, AtlasEntity> referredEntities = this.getReferredEntities();
        return referredEntities != null && guid != null ? referredEntities.remove(guid) : null;
    }

    public Set<String> getIgnoredEntities() {
        return this.ignoredEntities;
    }

    public Set<String> getPrunedEntities() {
        return this.prunedEntities;
    }

    public Set<String> getReferredEntitiesToMove() {
        return this.referredEntitiesToMove;
    }

    public Set<String> getCreatedEntities() {
        return this.createdEntities;
    }

    public Set<String> getDeletedEntities() {
        return this.deletedEntities;
    }

    public Map<String, String> getGuidAssignments() {
        return this.guidAssignments;
    }

    public List<AtlasEntity> getPostUpdateEntities() {
        return this.postUpdateEntities;
    }

    public PreprocessAction getPreprocessActionForHiveDb(String dbName) {
        PreprocessAction ret = PreprocessAction.NONE;
        if (dbName != null) {
            for (String dummyDbName : this.hiveDummyDatabasesToIgnore) {
                if (!StringUtils.equalsIgnoreCase((String)dbName, (String)dummyDbName)) continue;
                ret = PreprocessAction.IGNORE;
                break;
            }
        }
        return ret;
    }

    public PreprocessAction getPreprocessActionForHiveTable(String qualifiedName) {
        PreprocessAction ret = PreprocessAction.NONE;
        if (qualifiedName != null) {
            if ((CollectionUtils.isNotEmpty(this.hiveTablesToIgnore) || CollectionUtils.isNotEmpty(this.hiveTablesToPrune)) && (ret = this.hiveTablesCache.get(qualifiedName)) == null) {
                ret = this.isMatch(qualifiedName, this.hiveTablesToIgnore) ? PreprocessAction.IGNORE : (this.isMatch(qualifiedName, this.hiveTablesToPrune) ? PreprocessAction.PRUNE : PreprocessAction.NONE);
                this.hiveTablesCache.put(qualifiedName, ret);
            }
            if (ret != PreprocessAction.IGNORE && (CollectionUtils.isNotEmpty(this.hiveDummyTablesToIgnore) || CollectionUtils.isNotEmpty(this.hiveTablePrefixesToIgnore))) {
                String dbName;
                String tblName = this.getHiveTableNameFromQualifiedName(qualifiedName);
                if (tblName != null) {
                    for (String dummyTblName : this.hiveDummyTablesToIgnore) {
                        if (!StringUtils.equalsIgnoreCase((String)tblName, (String)dummyTblName)) continue;
                        ret = PreprocessAction.IGNORE;
                        break;
                    }
                    if (ret != PreprocessAction.IGNORE) {
                        for (String tableNamePrefix : this.hiveTablePrefixesToIgnore) {
                            if (!StringUtils.startsWithIgnoreCase((String)tblName, (String)tableNamePrefix)) continue;
                            ret = PreprocessAction.IGNORE;
                            break;
                        }
                    }
                }
                if (ret != PreprocessAction.IGNORE && CollectionUtils.isNotEmpty(this.hiveDummyDatabasesToIgnore) && (dbName = this.getHiveDbNameFromQualifiedName(qualifiedName)) != null) {
                    for (String dummyDbName : this.hiveDummyDatabasesToIgnore) {
                        if (!StringUtils.equalsIgnoreCase((String)dbName, (String)dummyDbName)) continue;
                        ret = PreprocessAction.IGNORE;
                        break;
                    }
                }
            }
        }
        return ret;
    }

    public boolean isIgnoredEntity(String guid) {
        return guid != null && this.ignoredEntities.contains(guid);
    }

    public boolean isPrunedEntity(String guid) {
        return guid != null && this.prunedEntities.contains(guid);
    }

    public void addToIgnoredEntities(AtlasEntity entity) {
        if (!this.ignoredEntities.contains(entity.getGuid())) {
            this.ignoredEntities.add(entity.getGuid());
            LOG.info("ignored entity: typeName={}, qualifiedName={}. topic-offset={}, partition={}", new Object[]{entity.getTypeName(), EntityPreprocessor.getQualifiedName(entity), this.getKafkaMessageOffset(), this.getKafkaPartition()});
        }
    }

    public void addToPrunedEntities(AtlasEntity entity) {
        if (!this.prunedEntities.contains(entity.getGuid())) {
            this.prunedEntities.add(entity.getGuid());
            LOG.info("pruned entity: typeName={}, qualifiedName={} topic-offset={}, partition={}", new Object[]{entity.getTypeName(), EntityPreprocessor.getQualifiedName(entity), this.getKafkaMessageOffset(), this.getKafkaPartition()});
        }
    }

    public void addToIgnoredEntities(String guid) {
        if (guid != null) {
            this.ignoredEntities.add(guid);
        }
    }

    public void addToPrunedEntities(String guid) {
        if (guid != null) {
            this.prunedEntities.add(guid);
        }
    }

    public void addToReferredEntitiesToMove(String guid) {
        if (guid != null) {
            this.referredEntitiesToMove.add(guid);
        }
    }

    public void addToReferredEntitiesToMove(Collection<String> guids) {
        if (guids != null) {
            for (String guid : guids) {
                this.addToReferredEntitiesToMove(guid);
            }
        }
    }

    public void addToIgnoredEntities(Object obj) {
        this.collectGuids(obj, this.ignoredEntities);
    }

    public void addToPrunedEntities(Object obj) {
        this.collectGuids(obj, this.prunedEntities);
    }

    public void removeRefAttributeAndRegisterToMove(AtlasEntity entity, String attrName, String relationshipType, String refAttrName) {
        Object attrVal = entity.removeAttribute(attrName);
        if (attrVal != null) {
            AtlasRelatedObjectId entityId = null;
            HashSet<String> guids = new HashSet<String>();
            this.collectGuids(attrVal, guids);
            this.addToPostUpdate(entity, attrName, attrVal);
            for (String guid : guids) {
                Object refAttr;
                AtlasEntity refEntity = this.getEntity(guid);
                if (refEntity == null) continue;
                if (refEntity.hasRelationshipAttribute(refAttrName)) {
                    refAttr = refEntity.getRelationshipAttribute(refAttrName);
                } else if (refEntity.hasAttribute(refAttrName)) {
                    refAttr = refEntity.getAttribute(refAttrName);
                } else {
                    if (entityId == null) {
                        entityId = AtlasTypeUtil.toAtlasRelatedObjectId((AtlasEntity)entity, (AtlasTypeRegistry)this.typeRegistry);
                    }
                    refAttr = entityId;
                }
                if (refAttr != null) {
                    refAttr = this.setRelationshipType(refAttr, relationshipType);
                }
                if (refAttr != null) {
                    refEntity.setRelationshipAttribute(refAttrName, refAttr);
                }
                this.addToReferredEntitiesToMove(guid);
            }
        }
    }

    public void moveRegisteredReferredEntities() {
        List<AtlasEntity> entities = this.getEntities();
        Map<String, AtlasEntity> referredEntities = this.getReferredEntities();
        if (entities != null && referredEntities != null && !this.referredEntitiesToMove.isEmpty()) {
            AtlasEntity firstEntity = entities.isEmpty() ? null : entities.get(0);
            for (String guid : this.referredEntitiesToMove) {
                AtlasEntity entity = referredEntities.remove(guid);
                if (entity == null) continue;
                entities.add(entity);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("moved referred entity: typeName={}, qualifiedName={}. topic-offset={}, partition={}", new Object[]{entity.getTypeName(), EntityPreprocessor.getQualifiedName(entity), this.kafkaMessage.getOffset(), this.kafkaMessage.getPartition()});
            }
            if (LOG.isDebugEnabled()) {
                if (firstEntity != null) {
                    LOG.debug("moved {} referred-entities to end of entities-list (firstEntity:typeName={}, qualifiedName={}). topic-offset={}, partition={}", new Object[]{this.referredEntitiesToMove.size(), firstEntity.getTypeName(), EntityPreprocessor.getQualifiedName(firstEntity), this.kafkaMessage.getOffset(), this.kafkaMessage.getPartition()});
                } else {
                    LOG.debug("moved {} referred-entities to entities-list. topic-offset={}, partition={}", new Object[]{this.referredEntitiesToMove.size(), this.kafkaMessage.getOffset(), this.kafkaMessage.getPartition()});
                }
            }
            this.referredEntitiesToMove.clear();
        }
    }

    public void prepareForPostUpdate() {
        if (this.postUpdateEntities != null) {
            ListIterator<AtlasEntity> iter = this.postUpdateEntities.listIterator();
            while (iter.hasNext()) {
                AtlasEntity entity = iter.next();
                String assignedGuid = this.getAssignedGuid(entity.getGuid());
                if (this.createdEntities.contains(assignedGuid) || this.deletedEntities.contains(assignedGuid)) {
                    iter.remove();
                    continue;
                }
                entity.setGuid(assignedGuid);
                if (entity.getAttributes() != null) {
                    this.setAssignedGuids(entity.getAttributes().values());
                }
                if (entity.getRelationshipAttributes() == null) continue;
                this.setAssignedGuids(entity.getRelationshipAttributes().values());
            }
        }
    }

    public String getHiveTableNameFromQualifiedName(String qualifiedName) {
        int idxEnd;
        String ret = null;
        int idxStart = qualifiedName.indexOf(46) + 1;
        if (idxStart != 0 && qualifiedName.length() > idxStart && (idxEnd = qualifiedName.indexOf(64, idxStart)) != -1) {
            ret = qualifiedName.substring(idxStart, idxEnd);
        }
        return ret;
    }

    public String getHiveDbNameFromQualifiedName(String qualifiedName) {
        String ret = null;
        int idxEnd = qualifiedName.indexOf(46);
        if (idxEnd == -1) {
            idxEnd = qualifiedName.indexOf(64);
        }
        if (idxEnd != -1) {
            ret = qualifiedName.substring(0, idxEnd);
        }
        return ret;
    }

    public String getTypeName(Object obj) {
        Object ret = obj instanceof AtlasObjectId ? ((AtlasObjectId)obj).getTypeName() : (obj instanceof Map ? ((Map)obj).get("typeName") : (obj instanceof AtlasEntity ? ((AtlasEntity)obj).getTypeName() : (obj instanceof AtlasEntity.AtlasEntityWithExtInfo ? ((AtlasEntity.AtlasEntityWithExtInfo)obj).getEntity().getTypeName() : null)));
        return ret != null ? ret.toString() : null;
    }

    public String getGuid(Object obj) {
        Object ret = obj instanceof AtlasObjectId ? ((AtlasObjectId)obj).getGuid() : (obj instanceof Map ? ((Map)obj).get("guid") : (obj instanceof AtlasEntity ? ((AtlasEntity)obj).getGuid() : (obj instanceof AtlasEntity.AtlasEntityWithExtInfo ? ((AtlasEntity.AtlasEntityWithExtInfo)obj).getEntity().getGuid() : null)));
        return ret != null ? ret.toString() : null;
    }

    public void collectGuids(Object obj, Set<String> guids) {
        if (obj != null) {
            if (obj instanceof Collection) {
                Collection objList = (Collection)obj;
                for (Object objElem : objList) {
                    this.collectGuids(objElem, guids);
                }
            } else {
                this.collectGuid(obj, guids);
            }
        }
    }

    public void collectGuid(Object obj, Set<String> guids) {
        String guid = this.getGuid(obj);
        if (guid != null) {
            guids.add(guid);
        }
    }

    public long getMsgCreated() {
        return this.kafkaMessage.getMsgCreated();
    }

    public boolean isSpooledMessage() {
        return this.kafkaMessage.getSpooled();
    }

    public String getGuidForDeletedEntity(String qualifiedName) {
        return this.correlationManager.getGuidForDeletedEntityToBeCorrelated(qualifiedName, this.kafkaMessage.getMsgCreated());
    }

    private boolean isMatch(String name, List<Pattern> patterns) {
        boolean ret = false;
        for (Pattern p : patterns) {
            if (!p.matcher(name).matches()) continue;
            ret = true;
            break;
        }
        return ret;
    }

    private AtlasRelatedObjectId setRelationshipType(Object attr, String relationshipType) {
        Object ret = attr instanceof AtlasRelatedObjectId ? (AtlasRelatedObjectId)attr : (attr instanceof AtlasObjectId ? new AtlasRelatedObjectId((AtlasObjectId)attr) : (attr instanceof Map ? new AtlasRelatedObjectId((Map)attr) : null));
        if (ret != null) {
            ret.setRelationshipType(relationshipType);
        }
        return ret;
    }

    private String getAssignedGuid(String guid) {
        String ret = this.guidAssignments.get(guid);
        return ret != null ? ret : guid;
    }

    private void setAssignedGuids(Object obj) {
        if (obj != null) {
            if (obj instanceof Collection) {
                Collection objList = (Collection)obj;
                for (Object objElem : objList) {
                    this.setAssignedGuids(objElem);
                }
            } else {
                this.setAssignedGuid(obj);
            }
        }
    }

    private void setAssignedGuid(Object obj) {
        Map objId;
        Object guid;
        if (obj instanceof AtlasRelatedObjectId) {
            AtlasRelatedObjectId objId2 = (AtlasRelatedObjectId)obj;
            objId2.setGuid(this.getAssignedGuid(objId2.getGuid()));
        } else if (obj instanceof AtlasObjectId) {
            AtlasObjectId objId3 = (AtlasObjectId)obj;
            objId3.setGuid(this.getAssignedGuid(objId3.getGuid()));
        } else if (obj instanceof Map && (guid = (objId = (Map)obj).get("guid")) != null) {
            objId.put("guid", this.getAssignedGuid(guid.toString()));
        }
    }

    private void addToPostUpdate(AtlasEntity entity, String attrName, Object attrVal) {
        LOG.debug("addToPostUpdate(guid={}, entityType={}, attrName={}", new Object[]{entity.getGuid(), entity.getTypeName(), attrName});
        AtlasEntity partialEntity = null;
        if (this.postUpdateEntities == null) {
            this.postUpdateEntities = new ArrayList<AtlasEntity>();
        }
        for (AtlasEntity existing : this.postUpdateEntities) {
            if (!StringUtils.equals((String)entity.getGuid(), (String)existing.getGuid())) continue;
            partialEntity = existing;
            break;
        }
        if (partialEntity == null) {
            partialEntity = new AtlasEntity(entity.getTypeName(), attrName, attrVal);
            partialEntity.setGuid(entity.getGuid());
            this.postUpdateEntities.add(partialEntity);
        } else {
            partialEntity.setAttribute(attrName, attrVal);
        }
    }

    public static enum PreprocessAction {
        NONE,
        IGNORE,
        PRUNE;

    }
}

