/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.notification.preprocessor;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.notification.preprocessor.EntityPreprocessor;
import org.apache.atlas.notification.preprocessor.PreprocessorContext;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HivePreprocessor {
    private static final Logger LOG = LoggerFactory.getLogger(HivePreprocessor.class);
    private static final String RELATIONSHIP_TYPE_HIVE_TABLE_COLUMNS = "hive_table_columns";
    private static final String RELATIONSHIP_TYPE_HIVE_TABLE_PARTITION_KEYS = "hive_table_partitionkeys";
    private static final String RELATIONSHIP_TYPE_HIVE_TABLE_STORAGEDESC = "hive_table_storagedesc";

    static class HiveColumnLineageProcessPreprocessor
    extends HiveProcessPreprocessor {
        public HiveColumnLineageProcessPreprocessor() {
            super("hive_column_lineage");
        }
    }

    static class HiveProcessPreprocessor
    extends EntityPreprocessor {
        public HiveProcessPreprocessor() {
            super("hive_process");
        }

        public HiveProcessPreprocessor(String typeName) {
            super(typeName);
        }

        @Override
        public void preprocess(AtlasEntity entity, PreprocessorContext context) {
            Object qualifiedName;
            Object name;
            if (context.updateHiveProcessNameWithQualifiedName() && !Objects.equals(name = entity.getAttribute("name"), qualifiedName = entity.getAttribute("qualifiedName"))) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("setting {}.name={}. topic-offset={}, partition={}", new Object[]{entity.getTypeName(), qualifiedName, context.getKafkaMessageOffset(), context.getKafkaPartition()});
                }
                entity.setAttribute("name", qualifiedName);
            }
            if (context.isIgnoredEntity(entity.getGuid())) {
                context.addToIgnoredEntities(entity);
            } else {
                boolean isAnyRemoved;
                Object inputs = entity.getAttribute("inputs");
                Object outputs = entity.getAttribute("outputs");
                String startTime = String.valueOf(entity.getAttribute("startTime"));
                String endTime = String.valueOf(entity.getAttribute("endTime"));
                if (Strings.isNullOrEmpty((String)startTime) || "null".equals(startTime)) {
                    entity.setAttribute("startTime", (Object)System.currentTimeMillis());
                }
                if (Strings.isNullOrEmpty((String)endTime) || "null".equals(endTime)) {
                    entity.setAttribute("endTime", (Object)System.currentTimeMillis());
                }
                int inputsCount = this.getCollectionSize(inputs);
                int outputsCount = this.getCollectionSize(outputs);
                this.removeIgnoredObjectIds(inputs, context);
                this.removeIgnoredObjectIds(outputs, context);
                boolean isInputsEmpty = this.isEmpty(inputs);
                boolean isOutputsEmpty = this.isEmpty(outputs);
                boolean bl = isAnyRemoved = inputsCount > this.getCollectionSize(inputs) || outputsCount > this.getCollectionSize(outputs);
                if (isAnyRemoved && (isInputsEmpty || isOutputsEmpty)) {
                    context.addToIgnoredEntities(entity);
                    if (!StringUtils.equals((String)entity.getTypeName(), (String)"hive_column_lineage")) {
                        if (!isInputsEmpty) {
                            for (Object obj : (Collection)inputs) {
                                String guid = context.getGuid(obj);
                                context.addToReferredEntitiesToMove(guid);
                            }
                        } else if (!isOutputsEmpty) {
                            for (Object obj : (Collection)outputs) {
                                String guid = context.getGuid(obj);
                                context.addToReferredEntitiesToMove(guid);
                            }
                        }
                    }
                }
            }
            this.preprocessCheckpoint(entity, context);
        }

        private void preprocessCheckpoint(AtlasEntity entity, PreprocessorContext context) {
            String[] relationshipNames;
            if (!context.isSpooledMessage()) {
                return;
            }
            for (String relationshipName : relationshipNames = new String[]{"inputs", "outputs"}) {
                Object val = entity.getRelationshipAttribute(relationshipName);
                if (this.isEmpty(val) || !(val instanceof List)) continue;
                this.updateListWithGuids(context, (List)val);
            }
        }

        private void updateListWithGuids(PreprocessorContext context, List<?> list) {
            for (Object o : list) {
                String qn = this.getQualifiedName(o);
                String guid = context.getGuidForDeletedEntity(qn);
                if (StringUtils.isEmpty((String)guid)) continue;
                this.setObjectIdWithGuid(o, guid);
            }
        }

        private int getCollectionSize(Object obj) {
            return obj instanceof Collection ? ((Collection)obj).size() : 0;
        }

        private void removeIgnoredObjectIds(Object obj, PreprocessorContext context) {
            if (!(obj instanceof Collection)) {
                return;
            }
            Collection objList = (Collection)obj;
            ArrayList toRemove = null;
            for (Object objElem : objList) {
                PreprocessorContext.PreprocessAction action;
                boolean removeEntry = false;
                String guid = context.getGuid(objElem);
                if (guid != null) {
                    AtlasEntity entity;
                    removeEntry = context.isIgnoredEntity(guid);
                    if (!removeEntry && (entity = context.getEntity(guid)) != null) {
                        switch (entity.getTypeName()) {
                            case "hive_table": {
                                action = context.getPreprocessActionForHiveTable(HiveProcessPreprocessor.getQualifiedName(entity));
                                removeEntry = action == PreprocessorContext.PreprocessAction.IGNORE;
                                break;
                            }
                            case "hive_column": {
                                action = context.getPreprocessActionForHiveTable(HiveColumnPreprocessor.getHiveTableQualifiedName(HiveProcessPreprocessor.getQualifiedName(entity)));
                                removeEntry = action == PreprocessorContext.PreprocessAction.IGNORE || action == PreprocessorContext.PreprocessAction.PRUNE;
                            }
                        }
                    }
                } else {
                    String typeName = this.getTypeName(objElem);
                    if (typeName != null) {
                        switch (typeName) {
                            case "hive_table": {
                                action = context.getPreprocessActionForHiveTable(this.getQualifiedName(objElem));
                                removeEntry = action == PreprocessorContext.PreprocessAction.IGNORE;
                                break;
                            }
                            case "hive_column": {
                                action = context.getPreprocessActionForHiveTable(HiveColumnPreprocessor.getHiveTableQualifiedName(this.getQualifiedName(objElem)));
                                boolean bl = removeEntry = action == PreprocessorContext.PreprocessAction.IGNORE || action == PreprocessorContext.PreprocessAction.PRUNE;
                            }
                        }
                    }
                }
                if (!removeEntry) continue;
                if (toRemove == null) {
                    toRemove = new ArrayList();
                }
                toRemove.add(objElem);
            }
            if (toRemove != null) {
                objList.removeAll(toRemove);
            }
        }
    }

    static class HiveStorageDescPreprocessor
    extends EntityPreprocessor {
        public HiveStorageDescPreprocessor() {
            super("hive_storagedesc");
        }

        public static String getHiveTableQualifiedName(String sdQualifiedName) {
            int sepPos = sdQualifiedName.lastIndexOf("_storage");
            return sepPos != -1 ? sdQualifiedName.substring(0, sepPos) : sdQualifiedName;
        }

        @Override
        public void preprocess(AtlasEntity entity, PreprocessorContext context) {
            PreprocessorContext.PreprocessAction action;
            if (!(context.isIgnoredEntity(entity.getGuid()) || (action = context.getPreprocessActionForHiveTable(HiveStorageDescPreprocessor.getHiveTableQualifiedName(HiveStorageDescPreprocessor.getQualifiedName(entity)))) != PreprocessorContext.PreprocessAction.IGNORE && action != PreprocessorContext.PreprocessAction.PRUNE)) {
                context.addToIgnoredEntities(entity.getGuid());
            }
        }
    }

    static class HiveColumnPreprocessor
    extends EntityPreprocessor {
        public HiveColumnPreprocessor() {
            super("hive_column");
        }

        public static String getHiveTableQualifiedName(String columnQualifiedName) {
            String dbTableName = null;
            String clusterName = null;
            int sepPos = columnQualifiedName.lastIndexOf(64);
            if (sepPos != -1 && columnQualifiedName.length() > sepPos + 1) {
                clusterName = columnQualifiedName.substring(sepPos + 1);
            }
            if ((sepPos = columnQualifiedName.lastIndexOf(46)) != -1) {
                dbTableName = columnQualifiedName.substring(0, sepPos);
            }
            return clusterName != null ? dbTableName + '@' + clusterName : dbTableName;
        }

        @Override
        public void preprocess(AtlasEntity entity, PreprocessorContext context) {
            PreprocessorContext.PreprocessAction action;
            if (!(context.isIgnoredEntity(entity.getGuid()) || (action = context.getPreprocessActionForHiveTable(HiveColumnPreprocessor.getHiveTableQualifiedName(HiveColumnPreprocessor.getQualifiedName(entity)))) != PreprocessorContext.PreprocessAction.IGNORE && action != PreprocessorContext.PreprocessAction.PRUNE)) {
                context.addToIgnoredEntities(entity.getGuid());
            }
        }
    }

    static class HiveTablePreprocessor
    extends EntityPreprocessor {
        public HiveTablePreprocessor() {
            super("hive_table");
        }

        @Override
        public void preprocess(AtlasEntity entity, PreprocessorContext context) {
            if (context.isIgnoredEntity(entity.getGuid())) {
                context.addToIgnoredEntities(entity);
            } else {
                PreprocessorContext.PreprocessAction action = context.getPreprocessActionForHiveTable(HiveTablePreprocessor.getQualifiedName(entity));
                if (action == PreprocessorContext.PreprocessAction.IGNORE) {
                    context.addToIgnoredEntities(entity);
                    context.addToIgnoredEntities(entity.getAttribute("sd"));
                    context.addToIgnoredEntities(entity.getAttribute("columns"));
                    context.addToIgnoredEntities(entity.getAttribute("partitionKeys"));
                    context.addToIgnoredEntities(entity.getAttribute("hive_table_ddl"));
                } else if (action == PreprocessorContext.PreprocessAction.PRUNE) {
                    context.addToPrunedEntities(entity);
                    context.addToIgnoredEntities(entity.getAttribute("sd"));
                    context.addToIgnoredEntities(entity.getAttribute("columns"));
                    context.addToIgnoredEntities(entity.getAttribute("partitionKeys"));
                    entity.setAttribute("sd", null);
                    entity.setAttribute("columns", null);
                    entity.setAttribute("partitionKeys", null);
                    entity.setRelationshipAttribute("sd", null);
                    entity.setRelationshipAttribute("columns", null);
                    entity.setRelationshipAttribute("partitionKeys", null);
                } else if (context.getHiveTypesRemoveOwnedRefAttrs()) {
                    context.removeRefAttributeAndRegisterToMove(entity, "sd", HivePreprocessor.RELATIONSHIP_TYPE_HIVE_TABLE_STORAGEDESC, "table");
                    context.removeRefAttributeAndRegisterToMove(entity, "columns", HivePreprocessor.RELATIONSHIP_TYPE_HIVE_TABLE_COLUMNS, "table");
                    context.removeRefAttributeAndRegisterToMove(entity, "partitionKeys", HivePreprocessor.RELATIONSHIP_TYPE_HIVE_TABLE_PARTITION_KEYS, "table");
                }
            }
        }
    }

    static class HiveDbPreprocessor
    extends EntityPreprocessor {
        public HiveDbPreprocessor() {
            super("hive_db");
        }

        @Override
        public void preprocess(AtlasEntity entity, PreprocessorContext context) {
            PreprocessorContext.PreprocessAction action;
            if (!context.isIgnoredEntity(entity.getGuid()) && (action = context.getPreprocessActionForHiveDb(HiveDbPreprocessor.getName(entity))) == PreprocessorContext.PreprocessAction.IGNORE) {
                context.addToIgnoredEntities(entity);
            }
        }
    }
}

