/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.notification.preprocessor;

import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.notification.preprocessor.EntityPreprocessor;
import org.apache.atlas.notification.preprocessor.PreprocessorContext;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveDbDDLPreprocessor
extends EntityPreprocessor {
    private static final Logger LOG = LoggerFactory.getLogger(HiveDbDDLPreprocessor.class);

    protected HiveDbDDLPreprocessor() {
        super("hive_db_ddl");
    }

    @Override
    public void preprocess(AtlasEntity entity, PreprocessorContext context) {
        if (!context.isSpooledMessage()) {
            return;
        }
        Object dbObject = entity.getRelationshipAttribute("db");
        if (dbObject == null) {
            return;
        }
        String qualifiedName = this.getQualifiedName(dbObject);
        String guid = context.getGuidForDeletedEntity(qualifiedName);
        if (StringUtils.isEmpty((String)guid)) {
            return;
        }
        this.setObjectIdWithGuid(dbObject, guid);
        LOG.debug("{}: Preprocessor: Updated: {} -> {}", new Object[]{this.getTypeName(), qualifiedName, guid});
    }
}

