/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.notification.preprocessor;

import java.util.List;
import java.util.regex.Pattern;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.notification.preprocessor.EntityPreprocessor;
import org.apache.atlas.notification.preprocessor.PreprocessorContext;
import org.apache.commons.collections.CollectionUtils;

public class GenericEntityPreprocessor
extends EntityPreprocessor {
    private final List<Pattern> entitiesToIgnore;
    private final List<Pattern> entityTypesToIgnore;

    public GenericEntityPreprocessor(List<Pattern> entityTypesToIgnore, List<Pattern> entitiesToIgnore) {
        super("Generic");
        this.entityTypesToIgnore = entityTypesToIgnore;
        this.entitiesToIgnore = entitiesToIgnore;
    }

    @Override
    public void preprocess(AtlasEntity entity, PreprocessorContext context) {
        if (entity != null && this.isToBeIgnored(entity)) {
            context.addToIgnoredEntities(entity);
        }
    }

    private boolean isMatch(String property, List<Pattern> patterns) {
        return patterns.stream().anyMatch(pattern -> pattern.matcher(property).matches());
    }

    private boolean isToBeIgnored(AtlasEntity entity) {
        String qualifiedName = GenericEntityPreprocessor.getQualifiedName(entity);
        boolean decision = CollectionUtils.isEmpty(this.entityTypesToIgnore) ? this.isMatch(qualifiedName, this.entitiesToIgnore) : (CollectionUtils.isEmpty(this.entitiesToIgnore) ? this.isMatch(entity.getTypeName(), this.entityTypesToIgnore) : this.isMatch(entity.getTypeName(), this.entityTypesToIgnore) && this.isMatch(qualifiedName, this.entitiesToIgnore));
        return decision;
    }
}

