/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.notification.preprocessor;

import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.notification.preprocessor.EntityPreprocessor;
import org.apache.atlas.notification.preprocessor.PreprocessorContext;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AWSS3V2Preprocessor {
    private static final Logger LOG = LoggerFactory.getLogger(AWSS3V2Preprocessor.class);
    private static final String AWS_S3_V2_DIR_TYPE = "aws_s3_v2_directory";
    private static final String ATTRIBUTE_OBJECT_PREFIX = "objectPrefix";
    private static final String SCHEME_SEPARATOR = "://";

    static class AWSS3V2DirectoryPreprocessor
    extends EntityPreprocessor {
        protected AWSS3V2DirectoryPreprocessor() {
            super(AWSS3V2Preprocessor.AWS_S3_V2_DIR_TYPE);
        }

        @Override
        public void preprocess(AtlasEntity entity, PreprocessorContext context) {
            String objectPrefix;
            String qualifiedName;
            if (context.getS3V2DirectoryPruneObjectPrefix() && this.isObjectPrefixPruneNeeded(qualifiedName = (String)entity.getAttribute("qualifiedName"), objectPrefix = (String)entity.getAttribute(AWSS3V2Preprocessor.ATTRIBUTE_OBJECT_PREFIX))) {
                if (objectPrefix.lastIndexOf("/") == -1) {
                    objectPrefix = "/";
                } else {
                    if (this.doesEndsWithPathSeparator(objectPrefix)) {
                        objectPrefix = this.removeLastPathSeparator(objectPrefix);
                    }
                    objectPrefix = objectPrefix.substring(0, objectPrefix.lastIndexOf("/") + 1);
                }
                LOG.info("Aws S3 V2 Preprocessor: Pruning {} from {} to {}", new Object[]{"objectPrefix@aws_s3_v2_directory", entity.getAttribute(AWSS3V2Preprocessor.ATTRIBUTE_OBJECT_PREFIX), objectPrefix});
                entity.setAttribute(AWSS3V2Preprocessor.ATTRIBUTE_OBJECT_PREFIX, (Object)objectPrefix);
            }
        }

        private boolean isObjectPrefixPruneNeeded(String qualifiedName, String objectPrefix) {
            return StringUtils.isNotBlank((String)qualifiedName) && StringUtils.isNotBlank((String)objectPrefix) && qualifiedName.contains(this.getSchemeAndBucket(qualifiedName) + objectPrefix + '@');
        }

        private String getSchemeAndBucket(String qualifiedName) {
            String ret = "";
            if (StringUtils.isNotEmpty((String)qualifiedName) && qualifiedName.contains(AWSS3V2Preprocessor.SCHEME_SEPARATOR)) {
                int schemeSeparatorEndPosition = qualifiedName.indexOf(AWSS3V2Preprocessor.SCHEME_SEPARATOR) + AWSS3V2Preprocessor.SCHEME_SEPARATOR.length();
                int bucketEndPosition = qualifiedName.indexOf("/", schemeSeparatorEndPosition);
                ret = qualifiedName.substring(0, bucketEndPosition);
            }
            return ret;
        }

        private boolean doesEndsWithPathSeparator(String path) {
            return path.endsWith("/");
        }

        private String removeLastPathSeparator(String path) {
            return StringUtils.chop((String)path);
        }
    }
}

