/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.notification;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.apache.atlas.AtlasException;
import org.apache.atlas.RequestContext;
import org.apache.atlas.listener.EntityChangeListener;
import org.apache.atlas.model.glossary.AtlasGlossaryTerm;
import org.apache.atlas.notification.EntityNotificationSender;
import org.apache.atlas.notification.NotificationInterface;
import org.apache.atlas.repository.graph.GraphHelper;
import org.apache.atlas.type.AtlasClassificationType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.atlas.utils.AtlasPerfMetrics;
import org.apache.atlas.v1.model.instance.Referenceable;
import org.apache.atlas.v1.model.instance.Struct;
import org.apache.atlas.v1.model.notification.EntityNotificationV1;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.configuration.Configuration;
import org.springframework.stereotype.Component;

@Component
public class NotificationEntityChangeListener
implements EntityChangeListener {
    protected static final String ATLAS_ENTITY_NOTIFICATION_PROPERTY = "atlas.notification.entity";
    private final AtlasTypeRegistry typeRegistry;
    private final Configuration configuration;
    private final EntityNotificationSender<EntityNotificationV1> notificationSender;
    private final Map<String, List<String>> notificationAttributesCache = new HashMap<String, List<String>>();

    @Inject
    public NotificationEntityChangeListener(NotificationInterface notificationInterface, AtlasTypeRegistry typeRegistry, Configuration configuration) {
        this.typeRegistry = typeRegistry;
        this.configuration = configuration;
        this.notificationSender = new EntityNotificationSender(notificationInterface, configuration);
    }

    @VisibleForTesting
    public static List<Struct> getAllTraits(Referenceable entityDefinition, AtlasTypeRegistry typeRegistry) {
        ArrayList<Struct> ret = new ArrayList<Struct>();
        for (String traitName : entityDefinition.getTraitNames()) {
            Struct trait = entityDefinition.getTrait(traitName);
            AtlasClassificationType traitType = typeRegistry.getClassificationTypeByName(traitName);
            Set superTypeNames = traitType != null ? traitType.getAllSuperTypes() : null;
            ret.add(trait);
            if (!CollectionUtils.isNotEmpty((Collection)superTypeNames)) continue;
            for (String superTypeName : superTypeNames) {
                AtlasClassificationType superType;
                Struct superTypeTrait = new Struct(superTypeName);
                if (MapUtils.isNotEmpty((Map)trait.getValues()) && (superType = typeRegistry.getClassificationTypeByName(superTypeName)) != null && MapUtils.isNotEmpty((Map)superType.getAllAttributes())) {
                    HashMap superTypeTraitAttributes = new HashMap();
                    for (Map.Entry attrEntry : trait.getValues().entrySet()) {
                        String attrName = (String)attrEntry.getKey();
                        if (!superType.getAllAttributes().containsKey(attrName)) continue;
                        superTypeTraitAttributes.put(attrName, attrEntry.getValue());
                    }
                    superTypeTrait.setValues(superTypeTraitAttributes);
                }
                ret.add(superTypeTrait);
            }
        }
        return ret;
    }

    public void onEntitiesAdded(Collection<Referenceable> entities, boolean isImport) throws AtlasException {
        this.notifyOfEntityEvent(entities, EntityNotificationV1.OperationType.ENTITY_CREATE);
    }

    public void onEntitiesUpdated(Collection<Referenceable> entities, boolean isImport) throws AtlasException {
        this.notifyOfEntityEvent(entities, EntityNotificationV1.OperationType.ENTITY_UPDATE);
    }

    public void onTraitsAdded(Referenceable entity, Collection<? extends Struct> traits) throws AtlasException {
        this.notifyOfEntityEvent(Collections.singleton(entity), EntityNotificationV1.OperationType.TRAIT_ADD);
    }

    public void onTraitsDeleted(Referenceable entity, Collection<? extends Struct> traits) throws AtlasException {
        this.notifyOfEntityEvent(Collections.singleton(entity), EntityNotificationV1.OperationType.TRAIT_DELETE);
    }

    public void onTraitsUpdated(Referenceable entity, Collection<? extends Struct> traits) throws AtlasException {
        this.notifyOfEntityEvent(Collections.singleton(entity), EntityNotificationV1.OperationType.TRAIT_UPDATE);
    }

    public void onEntitiesDeleted(Collection<Referenceable> entities, boolean isImport) throws AtlasException {
        this.notifyOfEntityEvent(entities, EntityNotificationV1.OperationType.ENTITY_DELETE);
    }

    public void onTermAdded(Collection<Referenceable> entities, AtlasGlossaryTerm term) {
    }

    public void onTermDeleted(Collection<Referenceable> entities, AtlasGlossaryTerm term) {
    }

    private void notifyOfEntityEvent(Collection<Referenceable> entityDefinitions, EntityNotificationV1.OperationType operationType) throws AtlasException {
        AtlasPerfMetrics.MetricRecorder metric = RequestContext.get().startMetricRecord("entityNotification");
        ArrayList<EntityNotificationV1> messages = new ArrayList<EntityNotificationV1>();
        for (Referenceable entityDefinition : entityDefinitions) {
            if (GraphHelper.isInternalType((String)entityDefinition.getTypeName())) continue;
            Referenceable entity = new Referenceable(entityDefinition);
            Map attributesMap = entity.getValuesMap();
            List<String> entityNotificationAttrs = this.getNotificationAttributes(entity.getTypeName());
            if (MapUtils.isNotEmpty((Map)attributesMap) && CollectionUtils.isNotEmpty(entityNotificationAttrs)) {
                Collection attributesToRemove = CollectionUtils.subtract(attributesMap.keySet(), entityNotificationAttrs);
                for (String attributeToRemove : attributesToRemove) {
                    attributesMap.remove(attributeToRemove);
                }
            }
            EntityNotificationV1 notification = new EntityNotificationV1(entity, operationType, NotificationEntityChangeListener.getAllTraits(entity, this.typeRegistry));
            messages.add(notification);
        }
        if (!messages.isEmpty()) {
            this.notificationSender.send(messages);
        }
        RequestContext.get().endMetricRecord(metric);
    }

    private List<String> getNotificationAttributes(String entityType) {
        List<String> ret = null;
        if (this.notificationAttributesCache.containsKey(entityType)) {
            ret = this.notificationAttributesCache.get(entityType);
        } else if (this.configuration != null) {
            String[] notificationAttributes = this.configuration.getStringArray("atlas.notification.entity." + entityType + ".attributes.include");
            if (notificationAttributes != null) {
                ret = Arrays.asList(notificationAttributes);
            }
            this.notificationAttributesCache.put(entityType, ret);
        }
        return ret;
    }
}

