/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.notification;

import java.util.ArrayList;
import java.util.List;
import org.apache.atlas.GraphTransactionInterceptor;
import org.apache.atlas.notification.NotificationException;
import org.apache.atlas.notification.NotificationInterface;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.configuration.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityNotificationSender<T> {
    private static final Logger LOG = LoggerFactory.getLogger(EntityNotificationSender.class);
    private static final boolean NOTIFY_POST_COMMIT_DEFAULT = true;
    private final NotificationSender<T> notificationSender;

    public EntityNotificationSender(NotificationInterface notificationInterface, Configuration configuration) {
        this(notificationInterface, configuration != null ? configuration.getBoolean("atlas.notification.send.postcommit", true) : true);
    }

    public EntityNotificationSender(NotificationInterface notificationInterface, boolean sendPostCommit) {
        if (sendPostCommit) {
            LOG.info("EntityNotificationSender: notifications will be sent after transaction commit");
            this.notificationSender = new PostCommitNotificationSender(notificationInterface);
        } else {
            LOG.info("EntityNotificationSender: notifications will be sent inline (i.e. not waiting for transaction to commit)");
            this.notificationSender = new InlineNotificationSender(notificationInterface);
        }
    }

    public void send(List<T> notifications) throws NotificationException {
        this.notificationSender.send(notifications);
    }

    private static class PostCommitNotificationSender<T>
    implements NotificationSender<T> {
        private final NotificationInterface notificationInterface;
        private final ThreadLocal<PostCommitNotificationHook<T>> postCommitNotificationHooks = new ThreadLocal();

        public PostCommitNotificationSender(NotificationInterface notificationInterface) {
            this.notificationInterface = notificationInterface;
        }

        @Override
        public void send(List<T> notifications) {
            PostCommitNotificationHook<T> notificationHook = this.postCommitNotificationHooks.get();
            if (notificationHook == null) {
                notificationHook = new PostCommitNotificationHook<T>(notifications);
                this.postCommitNotificationHooks.set(notificationHook);
            } else {
                notificationHook.addNotifications(notifications);
            }
        }

        class PostCommitNotificationHook<U>
        extends GraphTransactionInterceptor.PostTransactionHook {
            private final List<U> notifications = new ArrayList<U>();

            public PostCommitNotificationHook(List<U> notifications) {
                this.addNotifications(notifications);
            }

            public void addNotifications(List<U> notifications) {
                if (notifications != null) {
                    this.notifications.addAll(notifications);
                }
            }

            public void onComplete(boolean isSuccess) {
                PostCommitNotificationSender.this.postCommitNotificationHooks.remove();
                if (CollectionUtils.isNotEmpty(this.notifications)) {
                    if (isSuccess) {
                        try {
                            PostCommitNotificationSender.this.notificationInterface.send(NotificationInterface.NotificationType.ENTITIES, this.notifications);
                        }
                        catch (NotificationException excp) {
                            LOG.error("failed to send entity notifications", (Throwable)excp);
                        }
                    } else if (LOG.isDebugEnabled()) {
                        LOG.debug("Transaction not committed. Not sending {} notifications: {}", (Object)this.notifications.size(), this.notifications);
                    }
                }
            }
        }
    }

    private static class InlineNotificationSender<T>
    implements NotificationSender<T> {
        private final NotificationInterface notificationInterface;

        public InlineNotificationSender(NotificationInterface notificationInterface) {
            this.notificationInterface = notificationInterface;
        }

        @Override
        public void send(List<T> notifications) throws NotificationException {
            this.notificationInterface.send(NotificationInterface.NotificationType.ENTITIES, notifications);
        }
    }

    private static interface NotificationSender<T> {
        public void send(List<T> var1) throws NotificationException;
    }
}

