/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.notification;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.apache.atlas.AtlasErrorCode;
import org.apache.atlas.RequestContext;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.listener.EntityChangeListenerV2;
import org.apache.atlas.model.glossary.AtlasGlossaryTerm;
import org.apache.atlas.model.instance.AtlasClassification;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.AtlasEntityHeader;
import org.apache.atlas.model.instance.AtlasRelatedObjectId;
import org.apache.atlas.model.instance.AtlasRelationship;
import org.apache.atlas.model.instance.AtlasRelationshipHeader;
import org.apache.atlas.model.notification.EntityNotification;
import org.apache.atlas.notification.EntityNotificationSender;
import org.apache.atlas.notification.NotificationException;
import org.apache.atlas.notification.NotificationInterface;
import org.apache.atlas.repository.graph.GraphHelper;
import org.apache.atlas.type.AtlasClassificationType;
import org.apache.atlas.type.AtlasEntityType;
import org.apache.atlas.type.AtlasStructType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.atlas.utils.AtlasPerfMetrics;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.configuration.Configuration;
import org.springframework.stereotype.Component;

@Component
public class EntityNotificationListenerV2
implements EntityChangeListenerV2 {
    private final AtlasTypeRegistry typeRegistry;
    private final EntityNotificationSender<EntityNotification.EntityNotificationV2> notificationSender;

    @Inject
    public EntityNotificationListenerV2(AtlasTypeRegistry typeRegistry, NotificationInterface notificationInterface, Configuration configuration) {
        this.typeRegistry = typeRegistry;
        this.notificationSender = new EntityNotificationSender(notificationInterface, configuration);
    }

    public void onEntitiesAdded(List<AtlasEntity> entities, boolean isImport) throws AtlasBaseException {
        this.notifyEntityEvents(entities, EntityNotification.EntityNotificationV2.OperationType.ENTITY_CREATE);
    }

    public void onEntitiesUpdated(List<AtlasEntity> entities, boolean isImport) throws AtlasBaseException {
        this.notifyEntityEvents(entities, EntityNotification.EntityNotificationV2.OperationType.ENTITY_UPDATE);
    }

    public void onEntitiesDeleted(List<AtlasEntity> entities, boolean isImport) throws AtlasBaseException {
        this.notifyEntityEvents(entities, EntityNotification.EntityNotificationV2.OperationType.ENTITY_DELETE);
    }

    public void onEntitiesPurged(List<AtlasEntity> entities) {
    }

    public void onClassificationsAdded(AtlasEntity entity, List<AtlasClassification> classifications) throws AtlasBaseException {
        this.notifyEntityEvents(Collections.singletonList(entity), EntityNotification.EntityNotificationV2.OperationType.CLASSIFICATION_ADD);
    }

    public void onClassificationsAdded(List<AtlasEntity> entities, List<AtlasClassification> classifications) throws AtlasBaseException {
        this.notifyEntityEvents(entities, EntityNotification.EntityNotificationV2.OperationType.CLASSIFICATION_ADD);
    }

    public void onClassificationsUpdated(AtlasEntity entity, List<AtlasClassification> classifications) throws AtlasBaseException {
        Map addedPropagations = RequestContext.get().getAddedPropagations();
        Map removedPropagations = RequestContext.get().getRemovedPropagations();
        if (addedPropagations.containsKey(entity.getGuid())) {
            this.notifyEntityEvents(Collections.singletonList(entity), EntityNotification.EntityNotificationV2.OperationType.CLASSIFICATION_ADD);
        } else if (!removedPropagations.containsKey(entity.getGuid())) {
            this.notifyEntityEvents(Collections.singletonList(entity), EntityNotification.EntityNotificationV2.OperationType.CLASSIFICATION_UPDATE);
        }
    }

    public void onClassificationsDeleted(AtlasEntity entity, List<AtlasClassification> classifications) throws AtlasBaseException {
        this.notifyEntityEvents(Collections.singletonList(entity), EntityNotification.EntityNotificationV2.OperationType.CLASSIFICATION_DELETE);
    }

    public void onClassificationsDeleted(List<AtlasEntity> entities, List<AtlasClassification> classifications) throws AtlasBaseException {
        this.notifyEntityEvents(entities, EntityNotification.EntityNotificationV2.OperationType.CLASSIFICATION_DELETE);
    }

    public void onTermAdded(AtlasGlossaryTerm term, List<AtlasRelatedObjectId> entities) {
    }

    public void onTermDeleted(AtlasGlossaryTerm term, List<AtlasRelatedObjectId> entities) {
    }

    public void onRelationshipsAdded(List<AtlasRelationship> relationships, boolean isImport) throws AtlasBaseException {
        this.notifyRelationshipEvents(relationships, EntityNotification.EntityNotificationV2.OperationType.RELATIONSHIP_CREATE);
    }

    public void onRelationshipsUpdated(List<AtlasRelationship> relationships, boolean isImport) throws AtlasBaseException {
        this.notifyRelationshipEvents(relationships, EntityNotification.EntityNotificationV2.OperationType.RELATIONSHIP_UPDATE);
    }

    public void onRelationshipsDeleted(List<AtlasRelationship> relationships, boolean isImport) throws AtlasBaseException {
        this.notifyRelationshipEvents(relationships, EntityNotification.EntityNotificationV2.OperationType.RELATIONSHIP_DELETE);
    }

    public void onRelationshipsPurged(List<AtlasRelationship> relationships) {
    }

    public void onLabelsAdded(AtlasEntity entity, Set<String> labels) {
    }

    public void onLabelsDeleted(AtlasEntity entity, Set<String> labels) {
    }

    public void onBusinessAttributesUpdated(AtlasEntity entity, Map<String, Map<String, Object>> updatedBusinessAttributes) {
    }

    private void notifyEntityEvents(List<AtlasEntity> entities, EntityNotification.EntityNotificationV2.OperationType operationType) throws AtlasBaseException {
        AtlasPerfMetrics.MetricRecorder metric = RequestContext.get().startMetricRecord("entityNotification");
        ArrayList<EntityNotification.EntityNotificationV2> messages = new ArrayList<EntityNotification.EntityNotificationV2>();
        for (AtlasEntity entity : entities) {
            if (GraphHelper.isInternalType((String)entity.getTypeName())) continue;
            messages.add(new EntityNotification.EntityNotificationV2(this.toNotificationHeader(entity), operationType, RequestContext.get().getRequestTime()));
        }
        this.sendNotifications(operationType, messages);
        RequestContext.get().endMetricRecord(metric);
    }

    private void notifyRelationshipEvents(List<AtlasRelationship> relationships, EntityNotification.EntityNotificationV2.OperationType operationType) throws AtlasBaseException {
        AtlasPerfMetrics.MetricRecorder metric = RequestContext.get().startMetricRecord("entityNotification");
        ArrayList<EntityNotification.EntityNotificationV2> messages = new ArrayList<EntityNotification.EntityNotificationV2>();
        for (AtlasRelationship relationship : relationships) {
            if (GraphHelper.isInternalType((String)relationship.getTypeName())) continue;
            messages.add(new EntityNotification.EntityNotificationV2(this.toNotificationHeader(relationship), operationType, RequestContext.get().getRequestTime()));
        }
        this.sendNotifications(operationType, messages);
        RequestContext.get().endMetricRecord(metric);
    }

    private void sendNotifications(EntityNotification.EntityNotificationV2.OperationType operationType, List<EntityNotification.EntityNotificationV2> messages) throws AtlasBaseException {
        if (!messages.isEmpty()) {
            try {
                this.notificationSender.send(messages);
            }
            catch (NotificationException e) {
                throw new AtlasBaseException(AtlasErrorCode.ENTITY_NOTIFICATION_FAILED, (Throwable)e, new String[]{operationType.name()});
            }
        }
    }

    private AtlasEntityHeader toNotificationHeader(AtlasEntity entity) {
        AtlasEntityType entityType;
        AtlasEntityHeader ret = new AtlasEntityHeader(entity.getTypeName(), entity.getGuid(), new HashMap());
        Object name = entity.getAttribute("name");
        Object displayText = name != null ? name : entity.getAttribute("qualifiedName");
        ret.setGuid(entity.getGuid());
        ret.setStatus(entity.getStatus());
        ret.setIsIncomplete(entity.getIsIncomplete());
        this.setAttribute(ret, "name", name);
        this.setAttribute(ret, "description", entity.getAttribute("description"));
        this.setAttribute(ret, "owner", entity.getAttribute("owner"));
        this.setAttribute(ret, "createTime", entity.getAttribute("createTime"));
        if (displayText != null) {
            ret.setDisplayText(displayText.toString());
        }
        if ((entityType = this.typeRegistry.getEntityTypeByName(entity.getTypeName())) != null) {
            for (AtlasStructType.AtlasAttribute attribute : entityType.getAllAttributes().values()) {
                Object attrValue;
                if (!attribute.getAttributeDef().getIsUnique() && !attribute.getAttributeDef().getIncludeInNotification() || (attrValue = entity.getAttribute(attribute.getName())) == null) continue;
                ret.setAttribute(attribute.getName(), attrValue);
            }
            if (CollectionUtils.isNotEmpty((Collection)entity.getClassifications())) {
                ArrayList<AtlasClassification> classifications = new ArrayList<AtlasClassification>(entity.getClassifications().size());
                ArrayList<String> classificationNames = new ArrayList<String>(entity.getClassifications().size());
                for (AtlasClassification classification : this.getAllClassifications(entity.getClassifications())) {
                    classifications.add(classification);
                    classificationNames.add(classification.getTypeName());
                }
                ret.setClassifications(classifications);
                ret.setClassificationNames(classificationNames);
            }
        }
        return ret;
    }

    private AtlasRelationshipHeader toNotificationHeader(AtlasRelationship relationship) {
        return new AtlasRelationshipHeader(relationship);
    }

    private void setAttribute(AtlasEntityHeader entity, String attrName, Object attrValue) {
        if (attrValue != null) {
            entity.setAttribute(attrName, attrValue);
        }
    }

    private List<AtlasClassification> getAllClassifications(List<AtlasClassification> classifications) {
        ArrayList<AtlasClassification> ret = new ArrayList<AtlasClassification>();
        if (CollectionUtils.isNotEmpty(classifications)) {
            for (AtlasClassification classification : classifications) {
                AtlasClassificationType classificationType = this.typeRegistry.getClassificationTypeByName(classification.getTypeName());
                Set superTypeNames = classificationType != null ? classificationType.getAllSuperTypes() : null;
                ret.add(classification);
                if (!CollectionUtils.isNotEmpty((Collection)superTypeNames)) continue;
                for (String superTypeName : superTypeNames) {
                    AtlasClassificationType superType;
                    AtlasClassification superTypeClassification = new AtlasClassification(superTypeName);
                    superTypeClassification.setEntityGuid(classification.getEntityGuid());
                    superTypeClassification.setPropagate(classification.isPropagate());
                    if (MapUtils.isNotEmpty((Map)classification.getAttributes()) && (superType = this.typeRegistry.getClassificationTypeByName(superTypeName)) != null && MapUtils.isNotEmpty((Map)superType.getAllAttributes())) {
                        HashMap superTypeClassificationAttributes = new HashMap();
                        for (Map.Entry attrEntry : classification.getAttributes().entrySet()) {
                            String attrName = (String)attrEntry.getKey();
                            if (!superType.getAllAttributes().containsKey(attrName)) continue;
                            superTypeClassificationAttributes.put(attrName, attrEntry.getValue());
                        }
                        superTypeClassification.setAttributes(superTypeClassificationAttributes);
                    }
                    ret.add(superTypeClassification);
                }
            }
        }
        return ret;
    }
}

