/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.examples;

import com.google.common.annotations.VisibleForTesting;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.atlas.ApplicationProperties;
import org.apache.atlas.AtlasClientV2;
import org.apache.atlas.AtlasException;
import org.apache.atlas.AtlasServiceException;
import org.apache.atlas.model.SearchFilter;
import org.apache.atlas.model.discovery.AtlasSearchResult;
import org.apache.atlas.model.instance.AtlasClassification;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.AtlasEntityHeader;
import org.apache.atlas.model.instance.EntityMutationResponse;
import org.apache.atlas.model.instance.EntityMutations;
import org.apache.atlas.model.lineage.AtlasLineageInfo;
import org.apache.atlas.model.typedef.AtlasBusinessMetadataDef;
import org.apache.atlas.model.typedef.AtlasClassificationDef;
import org.apache.atlas.model.typedef.AtlasEntityDef;
import org.apache.atlas.model.typedef.AtlasRelationshipDef;
import org.apache.atlas.model.typedef.AtlasRelationshipEndDef;
import org.apache.atlas.model.typedef.AtlasStructDef;
import org.apache.atlas.model.typedef.AtlasTypesDef;
import org.apache.atlas.type.AtlasType;
import org.apache.atlas.type.AtlasTypeUtil;
import org.apache.atlas.utils.AuthenticationUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.ArrayUtils;

public class QuickStartV2 {
    public static final String ATLAS_REST_ADDRESS = "atlas.rest.address";
    public static final String SALES_DB = "Sales";
    public static final String REPORTING_DB = "Reporting";
    public static final String LOGGING_DB = "Logging";
    public static final String SALES_FACT_TABLE = "sales_fact";
    public static final String PRODUCT_DIM_TABLE = "product_dim";
    public static final String CUSTOMER_DIM_TABLE = "customer_dim";
    public static final String TIME_DIM_TABLE = "time_dim";
    public static final String SALES_FACT_DAILY_MV_TABLE = "sales_fact_daily_mv";
    public static final String SALES_FACT_MONTHLY_MV_TABLE = "sales_fact_monthly_mv";
    public static final String LOG_FACT_DAILY_MV_TABLE = "log_fact_daily_mv";
    public static final String LOG_FACT_MONTHLY_MV_TABLE = "logging_fact_monthly_mv";
    public static final String TIME_ID_COLUMN = "time_id";
    public static final String PRODUCT_ID_COLUMN = "product_id";
    public static final String CUSTOMER_ID_COLUMN = "customer_id";
    public static final String APP_ID_COLUMN = "app_id";
    public static final String MACHINE_ID_COLUMN = "machine_id";
    public static final String PRODUCT_NAME_COLUMN = "product_name";
    public static final String BRAND_NAME_COLUMN = "brand_name";
    public static final String NAME_COLUMN = "name";
    public static final String SALES_COLUMN = "sales";
    public static final String LOG_COLUMN = "log";
    public static final String ADDRESS_COLUMN = "address";
    public static final String DAY_OF_YEAR_COLUMN = "dayOfYear";
    public static final String WEEKDAY_COLUMN = "weekDay";
    public static final String DIMENSION_CLASSIFICATION = "Dimension";
    public static final String FACT_CLASSIFICATION = "Fact";
    public static final String PII_CLASSIFICATION = "PII";
    public static final String METRIC_CLASSIFICATION = "Metric";
    public static final String ETL_CLASSIFICATION = "ETL";
    public static final String JDBC_CLASSIFICATION = "JdbcAccess";
    public static final String LOGDATA_CLASSIFICATION = "Log Data";
    public static final String LOAD_SALES_DAILY_PROCESS = "loadSalesDaily";
    public static final String LOAD_SALES_DAILY_PROCESS_EXEC1 = "loadSalesDailyExec1";
    public static final String LOAD_SALES_DAILY_PROCESS_EXEC2 = "loadSalesDailyExec2";
    public static final String LOAD_SALES_MONTHLY_PROCESS = "loadSalesMonthly";
    public static final String LOAD_SALES_MONTHLY_PROCESS_EXEC1 = "loadSalesMonthlyExec1";
    public static final String LOAD_SALES_MONTHLY_PROCESS_EXEC2 = "loadSalesMonthlyExec2";
    public static final String LOAD_LOGS_MONTHLY_PROCESS = "loadLogsMonthly";
    public static final String LOAD_LOGS_MONTHLY_PROCESS_EXEC1 = "loadLogsMonthlyExec1";
    public static final String LOAD_LOGS_MONTHLY_PROCESS_EXEC2 = "loadLogsMonthlyExec2";
    public static final String PRODUCT_DIM_VIEW = "product_dim_view";
    public static final String CUSTOMER_DIM_VIEW = "customer_dim_view";
    public static final String DATABASE_TYPE = "DB";
    public static final String COLUMN_TYPE = "Column";
    public static final String TABLE_TYPE = "Table";
    public static final String VIEW_TYPE = "View";
    public static final String LOAD_PROCESS_TYPE = "LoadProcess";
    public static final String LOAD_PROCESS_EXECUTION_TYPE = "LoadProcessExecution";
    public static final String STORAGE_DESC_TYPE = "StorageDesc";
    public static final String TABLE_DATABASE_TYPE = "Table_DB";
    public static final String VIEW_DATABASE_TYPE = "View_DB";
    public static final String VIEW_TABLES_TYPE = "View_Tables";
    public static final String TABLE_COLUMNS_TYPE = "Table_Columns";
    public static final String TABLE_STORAGE_DESC_TYPE = "Table_StorageDesc";
    public static final String PROCESS_PROCESS_EXECUTION_DESC_TYPE = "Process_ProcessExecution";
    public static final String VERSION_1 = "1.0";
    public static final String MANAGED_TABLE = "Managed";
    public static final String EXTERNAL_TABLE = "External";
    public static final String CLUSTER_SUFFIX = "@cl1";
    public static final String[] TYPES = new String[]{"DB", "Table", "StorageDesc", "Column", "LoadProcess", "LoadProcessExecution", "View", "JdbcAccess", "ETL", "Metric", "PII", "Fact", "Dimension", "Log Data", "Table_DB", "View_DB", "View_Tables", "Table_Columns", "Table_StorageDesc"};
    private final AtlasClientV2 atlasClientV2;

    QuickStartV2(String[] urls, String[] basicAuthUsernamePassword) {
        this.atlasClientV2 = new AtlasClientV2(urls, basicAuthUsernamePassword);
    }

    QuickStartV2(String[] urls) throws AtlasException {
        this.atlasClientV2 = new AtlasClientV2(urls);
    }

    public static void main(String[] args) throws Exception {
        String[] basicAuthUsernamePassword = null;
        if (!AuthenticationUtil.isKerberosAuthenticationEnabled()) {
            basicAuthUsernamePassword = AuthenticationUtil.getBasicAuthenticationInput();
        }
        QuickStartV2.runQuickstart(args, basicAuthUsernamePassword);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    static void runQuickstart(String[] args, String[] basicAuthUsernamePassword) throws Exception {
        String[] urls = QuickStartV2.getServerUrl(args);
        QuickStartV2 quickStartV2 = null;
        try {
            quickStartV2 = !AuthenticationUtil.isKerberosAuthenticationEnabled() ? new QuickStartV2(urls, basicAuthUsernamePassword) : new QuickStartV2(urls);
            quickStartV2.createTypes();
            quickStartV2.createEntities();
            quickStartV2.search();
            quickStartV2.lineage();
            if (quickStartV2 != null) {
                quickStartV2.closeConnection();
            }
        }
        catch (Throwable throwable) {
            if (quickStartV2 != null) {
                super.closeConnection();
            }
            throw throwable;
        }
    }

    static String[] getServerUrl(String[] args) throws AtlasException {
        if (args.length > 0) {
            return args[0].split(",");
        }
        Configuration configuration = ApplicationProperties.get();
        Object[] urls = configuration.getStringArray(ATLAS_REST_ADDRESS);
        if (ArrayUtils.isEmpty((Object[])urls)) {
            System.out.println("org.apache.atlas.examples.QuickStartV2 <Atlas REST address <http/https>://<atlas-fqdn>:<atlas-port> like http://localhost:21000>");
            System.exit(-1);
        }
        return urls;
    }

    void createTypes() throws Exception {
        AtlasTypesDef atlasTypesDef = this.createTypeDefinitions();
        System.out.println("\nCreating sample types: ");
        this.atlasClientV2.createAtlasTypeDefs(atlasTypesDef);
        this.verifyTypesCreated();
    }

    AtlasTypesDef createTypeDefinitions() {
        AtlasEntityDef dbTypeDef = AtlasTypeUtil.createClassTypeDef((String)DATABASE_TYPE, (String)DATABASE_TYPE, (String)VERSION_1, Collections.singleton("DataSet"), (AtlasStructDef.AtlasAttributeDef[])new AtlasStructDef.AtlasAttributeDef[]{AtlasTypeUtil.createOptionalAttrDef((String)"locationUri", (String)"string"), AtlasTypeUtil.createOptionalAttrDef((String)"createTime", (String)"long")});
        AtlasEntityDef tableTypeDef = AtlasTypeUtil.createClassTypeDef((String)TABLE_TYPE, (String)TABLE_TYPE, (String)VERSION_1, Collections.singleton("DataSet"), new HashMap<String, String>(Collections.singletonMap("schemaElementsAttribute", "columns")), (AtlasStructDef.AtlasAttributeDef[])new AtlasStructDef.AtlasAttributeDef[]{AtlasTypeUtil.createOptionalAttrDef((String)"createTime", (String)"long"), AtlasTypeUtil.createOptionalAttrDef((String)"lastAccessTime", (String)"long"), AtlasTypeUtil.createOptionalAttrDef((String)"retention", (String)"long"), AtlasTypeUtil.createOptionalAttrDef((String)"viewOriginalText", (String)"string"), AtlasTypeUtil.createOptionalAttrDef((String)"viewExpandedText", (String)"string"), AtlasTypeUtil.createOptionalAttrDef((String)"tableType", (String)"string"), AtlasTypeUtil.createOptionalAttrDef((String)"temporary", (String)"boolean")});
        AtlasEntityDef colTypeDef = AtlasTypeUtil.createClassTypeDef((String)COLUMN_TYPE, (String)COLUMN_TYPE, (String)VERSION_1, Collections.singleton("DataSet"), new HashMap<String, String>(Collections.singletonMap("schemaAttributes", "[\"name\", \"description\", \"owner\", \"type\", \"comment\", \"position\"]")), (AtlasStructDef.AtlasAttributeDef[])new AtlasStructDef.AtlasAttributeDef[]{AtlasTypeUtil.createOptionalAttrDef((String)"dataType", (String)"string"), AtlasTypeUtil.createOptionalAttrDef((String)"comment", (String)"string")});
        AtlasEntityDef sdTypeDef = AtlasTypeUtil.createClassTypeDef((String)STORAGE_DESC_TYPE, (String)STORAGE_DESC_TYPE, (String)VERSION_1, Collections.singleton("DataSet"), (AtlasStructDef.AtlasAttributeDef[])new AtlasStructDef.AtlasAttributeDef[]{AtlasTypeUtil.createOptionalAttrDef((String)"location", (String)"string"), AtlasTypeUtil.createOptionalAttrDef((String)"inputFormat", (String)"string"), AtlasTypeUtil.createOptionalAttrDef((String)"outputFormat", (String)"string"), AtlasTypeUtil.createRequiredAttrDef((String)"compressed", (String)"boolean")});
        AtlasEntityDef processTypeDef = AtlasTypeUtil.createClassTypeDef((String)LOAD_PROCESS_TYPE, (String)LOAD_PROCESS_TYPE, (String)VERSION_1, Collections.singleton("Process"), (AtlasStructDef.AtlasAttributeDef[])new AtlasStructDef.AtlasAttributeDef[]{AtlasTypeUtil.createOptionalAttrDef((String)"userName", (String)"string"), AtlasTypeUtil.createOptionalAttrDef((String)"startTime", (String)"long"), AtlasTypeUtil.createOptionalAttrDef((String)"endTime", (String)"long"), AtlasTypeUtil.createRequiredAttrDef((String)"queryText", (String)"string"), AtlasTypeUtil.createRequiredAttrDef((String)"queryPlan", (String)"string"), AtlasTypeUtil.createRequiredAttrDef((String)"queryId", (String)"string"), AtlasTypeUtil.createRequiredAttrDef((String)"queryGraph", (String)"string")});
        AtlasEntityDef processExecutionTypeDef = AtlasTypeUtil.createClassTypeDef((String)LOAD_PROCESS_EXECUTION_TYPE, (String)LOAD_PROCESS_EXECUTION_TYPE, (String)VERSION_1, Collections.singleton("ProcessExecution"), (AtlasStructDef.AtlasAttributeDef[])new AtlasStructDef.AtlasAttributeDef[]{AtlasTypeUtil.createOptionalAttrDef((String)"userName", (String)"string"), AtlasTypeUtil.createOptionalAttrDef((String)"startTime", (String)"long"), AtlasTypeUtil.createOptionalAttrDef((String)"endTime", (String)"long"), AtlasTypeUtil.createRequiredAttrDef((String)"queryText", (String)"string"), AtlasTypeUtil.createRequiredAttrDef((String)"queryPlan", (String)"string"), AtlasTypeUtil.createRequiredAttrDef((String)"queryId", (String)"string"), AtlasTypeUtil.createRequiredAttrDef((String)"queryGraph", (String)"string")});
        processExecutionTypeDef.setOption("displayTextAttribute", "queryText");
        AtlasEntityDef viewTypeDef = AtlasTypeUtil.createClassTypeDef((String)VIEW_TYPE, (String)VIEW_TYPE, (String)VERSION_1, Collections.singleton("DataSet"), (AtlasStructDef.AtlasAttributeDef[])new AtlasStructDef.AtlasAttributeDef[0]);
        AtlasRelationshipDef tableDatabaseTypeDef = AtlasTypeUtil.createRelationshipTypeDef((String)TABLE_DATABASE_TYPE, (String)TABLE_DATABASE_TYPE, (String)VERSION_1, (AtlasRelationshipDef.RelationshipCategory)AtlasRelationshipDef.RelationshipCategory.AGGREGATION, (AtlasRelationshipDef.PropagateTags)AtlasRelationshipDef.PropagateTags.NONE, (AtlasRelationshipEndDef)AtlasTypeUtil.createRelationshipEndDef((String)TABLE_TYPE, (String)"db", (AtlasStructDef.AtlasAttributeDef.Cardinality)AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE, (boolean)false), (AtlasRelationshipEndDef)AtlasTypeUtil.createRelationshipEndDef((String)DATABASE_TYPE, (String)"tables", (AtlasStructDef.AtlasAttributeDef.Cardinality)AtlasStructDef.AtlasAttributeDef.Cardinality.SET, (boolean)true), (AtlasStructDef.AtlasAttributeDef[])new AtlasStructDef.AtlasAttributeDef[0]);
        AtlasRelationshipDef viewDatabaseTypeDef = AtlasTypeUtil.createRelationshipTypeDef((String)VIEW_DATABASE_TYPE, (String)VIEW_DATABASE_TYPE, (String)VERSION_1, (AtlasRelationshipDef.RelationshipCategory)AtlasRelationshipDef.RelationshipCategory.AGGREGATION, (AtlasRelationshipDef.PropagateTags)AtlasRelationshipDef.PropagateTags.NONE, (AtlasRelationshipEndDef)AtlasTypeUtil.createRelationshipEndDef((String)VIEW_TYPE, (String)"db", (AtlasStructDef.AtlasAttributeDef.Cardinality)AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE, (boolean)false), (AtlasRelationshipEndDef)AtlasTypeUtil.createRelationshipEndDef((String)DATABASE_TYPE, (String)"views", (AtlasStructDef.AtlasAttributeDef.Cardinality)AtlasStructDef.AtlasAttributeDef.Cardinality.SET, (boolean)true), (AtlasStructDef.AtlasAttributeDef[])new AtlasStructDef.AtlasAttributeDef[0]);
        AtlasRelationshipDef viewTablesTypeDef = AtlasTypeUtil.createRelationshipTypeDef((String)VIEW_TABLES_TYPE, (String)VIEW_TABLES_TYPE, (String)VERSION_1, (AtlasRelationshipDef.RelationshipCategory)AtlasRelationshipDef.RelationshipCategory.AGGREGATION, (AtlasRelationshipDef.PropagateTags)AtlasRelationshipDef.PropagateTags.NONE, (AtlasRelationshipEndDef)AtlasTypeUtil.createRelationshipEndDef((String)VIEW_TYPE, (String)"inputTables", (AtlasStructDef.AtlasAttributeDef.Cardinality)AtlasStructDef.AtlasAttributeDef.Cardinality.SET, (boolean)true), (AtlasRelationshipEndDef)AtlasTypeUtil.createRelationshipEndDef((String)TABLE_TYPE, (String)"view", (AtlasStructDef.AtlasAttributeDef.Cardinality)AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE, (boolean)false), (AtlasStructDef.AtlasAttributeDef[])new AtlasStructDef.AtlasAttributeDef[0]);
        AtlasRelationshipDef tableColumnsTypeDef = AtlasTypeUtil.createRelationshipTypeDef((String)TABLE_COLUMNS_TYPE, (String)TABLE_COLUMNS_TYPE, (String)VERSION_1, (AtlasRelationshipDef.RelationshipCategory)AtlasRelationshipDef.RelationshipCategory.COMPOSITION, (AtlasRelationshipDef.PropagateTags)AtlasRelationshipDef.PropagateTags.NONE, (AtlasRelationshipEndDef)AtlasTypeUtil.createRelationshipEndDef((String)TABLE_TYPE, (String)"columns", (AtlasStructDef.AtlasAttributeDef.Cardinality)AtlasStructDef.AtlasAttributeDef.Cardinality.SET, (boolean)true), (AtlasRelationshipEndDef)AtlasTypeUtil.createRelationshipEndDef((String)COLUMN_TYPE, (String)"table", (AtlasStructDef.AtlasAttributeDef.Cardinality)AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE, (boolean)false), (AtlasStructDef.AtlasAttributeDef[])new AtlasStructDef.AtlasAttributeDef[0]);
        AtlasRelationshipDef tableStorageDescTypeDef = AtlasTypeUtil.createRelationshipTypeDef((String)TABLE_STORAGE_DESC_TYPE, (String)TABLE_STORAGE_DESC_TYPE, (String)VERSION_1, (AtlasRelationshipDef.RelationshipCategory)AtlasRelationshipDef.RelationshipCategory.COMPOSITION, (AtlasRelationshipDef.PropagateTags)AtlasRelationshipDef.PropagateTags.NONE, (AtlasRelationshipEndDef)AtlasTypeUtil.createRelationshipEndDef((String)TABLE_TYPE, (String)"sd", (AtlasStructDef.AtlasAttributeDef.Cardinality)AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE, (boolean)true), (AtlasRelationshipEndDef)AtlasTypeUtil.createRelationshipEndDef((String)STORAGE_DESC_TYPE, (String)"table", (AtlasStructDef.AtlasAttributeDef.Cardinality)AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE, (boolean)false), (AtlasStructDef.AtlasAttributeDef[])new AtlasStructDef.AtlasAttributeDef[0]);
        AtlasRelationshipDef processProcessExecutionTypeDef = AtlasTypeUtil.createRelationshipTypeDef((String)PROCESS_PROCESS_EXECUTION_DESC_TYPE, (String)PROCESS_PROCESS_EXECUTION_DESC_TYPE, (String)VERSION_1, (AtlasRelationshipDef.RelationshipCategory)AtlasRelationshipDef.RelationshipCategory.AGGREGATION, (AtlasRelationshipDef.PropagateTags)AtlasRelationshipDef.PropagateTags.NONE, (AtlasRelationshipEndDef)AtlasTypeUtil.createRelationshipEndDef((String)LOAD_PROCESS_TYPE, (String)"processExecutions", (AtlasStructDef.AtlasAttributeDef.Cardinality)AtlasStructDef.AtlasAttributeDef.Cardinality.SET, (boolean)true), (AtlasRelationshipEndDef)AtlasTypeUtil.createRelationshipEndDef((String)LOAD_PROCESS_EXECUTION_TYPE, (String)"process", (AtlasStructDef.AtlasAttributeDef.Cardinality)AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE, (boolean)false), (AtlasStructDef.AtlasAttributeDef[])new AtlasStructDef.AtlasAttributeDef[0]);
        AtlasClassificationDef dimClassifDef = AtlasTypeUtil.createTraitTypeDef((String)DIMENSION_CLASSIFICATION, (String)"Dimension Classification", (String)VERSION_1, Collections.emptySet(), (AtlasStructDef.AtlasAttributeDef[])new AtlasStructDef.AtlasAttributeDef[0]);
        AtlasClassificationDef factClassifDef = AtlasTypeUtil.createTraitTypeDef((String)FACT_CLASSIFICATION, (String)"Fact Classification", (String)VERSION_1, Collections.emptySet(), (AtlasStructDef.AtlasAttributeDef[])new AtlasStructDef.AtlasAttributeDef[0]);
        AtlasClassificationDef piiClassifDef = AtlasTypeUtil.createTraitTypeDef((String)PII_CLASSIFICATION, (String)"PII Classification", (String)VERSION_1, Collections.emptySet(), (AtlasStructDef.AtlasAttributeDef[])new AtlasStructDef.AtlasAttributeDef[0]);
        AtlasClassificationDef metricClassifDef = AtlasTypeUtil.createTraitTypeDef((String)METRIC_CLASSIFICATION, (String)"Metric Classification", (String)VERSION_1, Collections.emptySet(), (AtlasStructDef.AtlasAttributeDef[])new AtlasStructDef.AtlasAttributeDef[0]);
        AtlasClassificationDef etlClassifDef = AtlasTypeUtil.createTraitTypeDef((String)ETL_CLASSIFICATION, (String)"ETL Classification", (String)VERSION_1, Collections.emptySet(), (AtlasStructDef.AtlasAttributeDef[])new AtlasStructDef.AtlasAttributeDef[0]);
        AtlasClassificationDef jdbcClassifDef = AtlasTypeUtil.createTraitTypeDef((String)JDBC_CLASSIFICATION, (String)"JdbcAccess Classification", (String)VERSION_1, Collections.emptySet(), (AtlasStructDef.AtlasAttributeDef[])new AtlasStructDef.AtlasAttributeDef[0]);
        AtlasClassificationDef logClassifDef = AtlasTypeUtil.createTraitTypeDef((String)LOGDATA_CLASSIFICATION, (String)"LogData Classification", (String)VERSION_1, Collections.emptySet(), (AtlasStructDef.AtlasAttributeDef[])new AtlasStructDef.AtlasAttributeDef[0]);
        List<AtlasEntityDef> entityDefs = Arrays.asList(dbTypeDef, sdTypeDef, colTypeDef, tableTypeDef, processTypeDef, processExecutionTypeDef, viewTypeDef);
        List<AtlasRelationshipDef> relationshipDefs = Arrays.asList(tableDatabaseTypeDef, viewDatabaseTypeDef, viewTablesTypeDef, tableColumnsTypeDef, tableStorageDescTypeDef, processProcessExecutionTypeDef);
        List<AtlasClassificationDef> classificationDefs = Arrays.asList(dimClassifDef, factClassifDef, piiClassifDef, metricClassifDef, etlClassifDef, jdbcClassifDef, logClassifDef);
        AtlasStructDef.AtlasAttributeDef bmAttrDef1 = new AtlasStructDef.AtlasAttributeDef("attr1", "int");
        AtlasStructDef.AtlasAttributeDef bmAttrDef2 = new AtlasStructDef.AtlasAttributeDef("attr2", "int");
        bmAttrDef1.setOption("applicableEntityTypes", AtlasType.toJson(Collections.singleton(TABLE_TYPE)));
        bmAttrDef1.setIsOptional(true);
        bmAttrDef1.setIsUnique(false);
        bmAttrDef2.setOption("applicableEntityTypes", AtlasType.toJson(Collections.singleton(TABLE_TYPE)));
        bmAttrDef2.setIsOptional(true);
        bmAttrDef2.setIsUnique(false);
        AtlasBusinessMetadataDef testBusinessMetadataDef = new AtlasBusinessMetadataDef("test_businessMetadata", "test_description", VERSION_1);
        testBusinessMetadataDef.setAttributeDefs(Arrays.asList(bmAttrDef1, bmAttrDef2));
        List<AtlasBusinessMetadataDef> businessMetadataDefs = Collections.singletonList(testBusinessMetadataDef);
        return new AtlasTypesDef(Collections.emptyList(), Collections.emptyList(), classificationDefs, entityDefs, relationshipDefs, businessMetadataDefs);
    }

    void createEntities() throws Exception {
        System.out.println("\nCreating sample entities: ");
        AtlasEntity salesDB = this.createDatabase(SALES_DB, "sales database", "John ETL", "hdfs://host:8000/apps/warehouse/sales", new String[0]);
        AtlasEntity reportingDB = this.createDatabase(REPORTING_DB, "reporting database", "Jane BI", "hdfs://host:8000/apps/warehouse/reporting", new String[0]);
        AtlasEntity logDB = this.createDatabase(LOGGING_DB, "logging database", "Tim ETL", "hdfs://host:8000/apps/warehouse/logging", new String[0]);
        AtlasEntity salesFact = this.createTable(SALES_FACT_TABLE, "sales fact table", salesDB, "Joe", MANAGED_TABLE, Arrays.asList(this.createColumn(SALES_DB, SALES_FACT_TABLE, TIME_ID_COLUMN, "int", "time id", new String[0]), this.createColumn(SALES_DB, SALES_FACT_TABLE, PRODUCT_ID_COLUMN, "int", "product id", new String[0]), this.createColumn(SALES_DB, SALES_FACT_TABLE, CUSTOMER_ID_COLUMN, "int", "customer id", PII_CLASSIFICATION), this.createColumn(SALES_DB, SALES_FACT_TABLE, SALES_COLUMN, "double", "product id", METRIC_CLASSIFICATION)), FACT_CLASSIFICATION);
        AtlasEntity productDim = this.createTable(PRODUCT_DIM_TABLE, "product dimension table", salesDB, "John Doe", MANAGED_TABLE, Arrays.asList(this.createColumn(SALES_DB, PRODUCT_DIM_TABLE, PRODUCT_ID_COLUMN, "int", "product id", new String[0]), this.createColumn(SALES_DB, PRODUCT_DIM_TABLE, PRODUCT_NAME_COLUMN, "string", "product name", new String[0]), this.createColumn(SALES_DB, PRODUCT_DIM_TABLE, BRAND_NAME_COLUMN, "int", "brand name", new String[0])), DIMENSION_CLASSIFICATION);
        AtlasEntity customerDim = this.createTable(CUSTOMER_DIM_TABLE, "customer dimension table", salesDB, "fetl", EXTERNAL_TABLE, Arrays.asList(this.createColumn(SALES_DB, CUSTOMER_DIM_TABLE, CUSTOMER_ID_COLUMN, "int", "customer id", PII_CLASSIFICATION), this.createColumn(SALES_DB, CUSTOMER_DIM_TABLE, NAME_COLUMN, "string", "customer name", PII_CLASSIFICATION), this.createColumn(SALES_DB, CUSTOMER_DIM_TABLE, ADDRESS_COLUMN, "string", "customer address", PII_CLASSIFICATION)), DIMENSION_CLASSIFICATION);
        AtlasEntity timeDim = this.createTable(TIME_DIM_TABLE, "time dimension table", salesDB, "John Doe", EXTERNAL_TABLE, Arrays.asList(this.createColumn(SALES_DB, TIME_DIM_TABLE, TIME_ID_COLUMN, "int", "time id", new String[0]), this.createColumn(SALES_DB, TIME_DIM_TABLE, DAY_OF_YEAR_COLUMN, "int", "day Of Year", new String[0]), this.createColumn(SALES_DB, TIME_DIM_TABLE, WEEKDAY_COLUMN, "int", "week Day", new String[0])), DIMENSION_CLASSIFICATION);
        AtlasEntity loggingFactDaily = this.createTable(LOG_FACT_DAILY_MV_TABLE, "log fact daily materialized view", logDB, "Tim ETL", MANAGED_TABLE, Arrays.asList(this.createColumn(LOGGING_DB, LOG_FACT_DAILY_MV_TABLE, TIME_ID_COLUMN, "int", "time id", new String[0]), this.createColumn(LOGGING_DB, LOG_FACT_DAILY_MV_TABLE, APP_ID_COLUMN, "int", "app id", new String[0]), this.createColumn(LOGGING_DB, LOG_FACT_DAILY_MV_TABLE, MACHINE_ID_COLUMN, "int", "machine id", new String[0]), this.createColumn(LOGGING_DB, LOG_FACT_DAILY_MV_TABLE, LOG_COLUMN, "string", "log data", LOGDATA_CLASSIFICATION)), LOGDATA_CLASSIFICATION);
        AtlasEntity loggingFactMonthly = this.createTable(LOG_FACT_MONTHLY_MV_TABLE, "logging fact monthly materialized view", logDB, "Tim ETL", MANAGED_TABLE, Arrays.asList(this.createColumn(LOGGING_DB, LOG_FACT_MONTHLY_MV_TABLE, TIME_ID_COLUMN, "int", "time id", new String[0]), this.createColumn(LOGGING_DB, LOG_FACT_MONTHLY_MV_TABLE, APP_ID_COLUMN, "int", "app id", new String[0]), this.createColumn(LOGGING_DB, LOG_FACT_MONTHLY_MV_TABLE, MACHINE_ID_COLUMN, "int", "machine id", new String[0]), this.createColumn(LOGGING_DB, LOG_FACT_MONTHLY_MV_TABLE, LOG_COLUMN, "string", "log data", LOGDATA_CLASSIFICATION)), LOGDATA_CLASSIFICATION);
        AtlasEntity salesFactDaily = this.createTable(SALES_FACT_DAILY_MV_TABLE, "sales fact daily materialized view", reportingDB, "Joe BI", MANAGED_TABLE, Arrays.asList(this.createColumn(REPORTING_DB, SALES_FACT_DAILY_MV_TABLE, TIME_ID_COLUMN, "int", "time id", new String[0]), this.createColumn(REPORTING_DB, SALES_FACT_DAILY_MV_TABLE, PRODUCT_ID_COLUMN, "int", "product id", new String[0]), this.createColumn(REPORTING_DB, SALES_FACT_DAILY_MV_TABLE, CUSTOMER_ID_COLUMN, "int", "customer id", PII_CLASSIFICATION), this.createColumn(REPORTING_DB, SALES_FACT_DAILY_MV_TABLE, SALES_COLUMN, "double", "product id", METRIC_CLASSIFICATION)), METRIC_CLASSIFICATION);
        AtlasEntity salesFactMonthly = this.createTable(SALES_FACT_MONTHLY_MV_TABLE, "sales fact monthly materialized view", reportingDB, "Jane BI", MANAGED_TABLE, Arrays.asList(this.createColumn(REPORTING_DB, SALES_FACT_MONTHLY_MV_TABLE, TIME_ID_COLUMN, "int", "time id", new String[0]), this.createColumn(REPORTING_DB, SALES_FACT_MONTHLY_MV_TABLE, PRODUCT_ID_COLUMN, "int", "product id", new String[0]), this.createColumn(REPORTING_DB, SALES_FACT_MONTHLY_MV_TABLE, CUSTOMER_ID_COLUMN, "int", "customer id", PII_CLASSIFICATION), this.createColumn(REPORTING_DB, SALES_FACT_MONTHLY_MV_TABLE, SALES_COLUMN, "double", "product id", METRIC_CLASSIFICATION)), METRIC_CLASSIFICATION);
        this.createView(PRODUCT_DIM_VIEW, reportingDB, Collections.singletonList(productDim), DIMENSION_CLASSIFICATION, JDBC_CLASSIFICATION);
        this.createView(CUSTOMER_DIM_VIEW, reportingDB, Collections.singletonList(customerDim), DIMENSION_CLASSIFICATION, JDBC_CLASSIFICATION);
        AtlasEntity loadProcess = this.createProcess(LOAD_SALES_DAILY_PROCESS, "hive query for daily summary", "John ETL", Arrays.asList(salesFact, timeDim), Collections.singletonList(salesFactDaily), "create table as select ", "plan", "id", "graph", ETL_CLASSIFICATION);
        this.createProcessExecution(loadProcess, LOAD_SALES_DAILY_PROCESS_EXEC1, "hive query execution 1 for daily summary", "John ETL", "create table as select ", "plan", "id", "graph", ETL_CLASSIFICATION);
        this.createProcessExecution(loadProcess, LOAD_SALES_DAILY_PROCESS_EXEC2, "hive query execution 2 for daily summary", "John ETL", "create table as select ", "plan", "id", "graph", ETL_CLASSIFICATION);
        AtlasEntity loadProcess2 = this.createProcess(LOAD_SALES_MONTHLY_PROCESS, "hive query for monthly summary", "John ETL", Collections.singletonList(salesFactDaily), Collections.singletonList(salesFactMonthly), "create table as select ", "plan", "id", "graph", ETL_CLASSIFICATION);
        this.createProcessExecution(loadProcess2, LOAD_SALES_MONTHLY_PROCESS_EXEC1, "hive query execution 1 for monthly summary", "John ETL", "create table as select ", "plan", "id", "graph", ETL_CLASSIFICATION);
        this.createProcessExecution(loadProcess2, LOAD_SALES_MONTHLY_PROCESS_EXEC2, "hive query execution 2 for monthly summary", "John ETL", "create table as select ", "plan", "id", "graph", ETL_CLASSIFICATION);
        AtlasEntity loadProcess3 = this.createProcess(LOAD_LOGS_MONTHLY_PROCESS, "hive query for monthly summary", "Tim ETL", Collections.singletonList(loggingFactDaily), Collections.singletonList(loggingFactMonthly), "create table as select ", "plan", "id", "graph", ETL_CLASSIFICATION);
        this.createProcessExecution(loadProcess3, LOAD_LOGS_MONTHLY_PROCESS_EXEC1, "hive query execution 1 for monthly summary", "Tim ETL", "create table as select ", "plan", "id", "graph", ETL_CLASSIFICATION);
        this.createProcessExecution(loadProcess3, LOAD_LOGS_MONTHLY_PROCESS_EXEC2, "hive query execution 1 for monthly summary", "Tim ETL", "create table as select ", "plan", "id", "graph", ETL_CLASSIFICATION);
    }

    AtlasEntity createDatabase(String name, String description, String owner, String locationUri, String ... classificationNames) throws Exception {
        AtlasEntity entity = new AtlasEntity(DATABASE_TYPE);
        entity.setAttribute(NAME_COLUMN, (Object)name);
        entity.setAttribute("qualifiedName", (Object)(name + CLUSTER_SUFFIX));
        entity.setAttribute("description", (Object)description);
        entity.setAttribute("owner", (Object)owner);
        entity.setAttribute("locationUri", (Object)locationUri);
        entity.setAttribute("createTime", (Object)System.currentTimeMillis());
        entity.setClassifications(this.toAtlasClassifications(classificationNames));
        return this.createInstance(entity);
    }

    AtlasEntity createStorageDescriptor(String location, String inputFormat, String outputFormat, boolean compressed) {
        AtlasEntity ret = new AtlasEntity(STORAGE_DESC_TYPE);
        ret.setAttribute(NAME_COLUMN, (Object)("sd:" + location));
        ret.setAttribute("qualifiedName", (Object)("sd:" + location + CLUSTER_SUFFIX));
        ret.setAttribute("location", (Object)location);
        ret.setAttribute("inputFormat", (Object)inputFormat);
        ret.setAttribute("outputFormat", (Object)outputFormat);
        ret.setAttribute("compressed", (Object)compressed);
        return ret;
    }

    AtlasEntity createColumn(String databaseName, String tableName, String columnName, String dataType, String comment, String ... classificationNames) {
        AtlasEntity ret = new AtlasEntity(COLUMN_TYPE);
        ret.setAttribute(NAME_COLUMN, (Object)columnName);
        ret.setAttribute("qualifiedName", (Object)(databaseName + "." + tableName + "." + columnName + CLUSTER_SUFFIX));
        ret.setAttribute("dataType", (Object)dataType);
        ret.setAttribute("comment", (Object)comment);
        ret.setClassifications(this.toAtlasClassifications(classificationNames));
        return ret;
    }

    AtlasEntity createTable(String name, String description, AtlasEntity database, String owner, String tableType, List<AtlasEntity> columns, String ... classificationNames) throws Exception {
        AtlasEntity tblEntity = new AtlasEntity(TABLE_TYPE);
        tblEntity.setAttribute(NAME_COLUMN, (Object)name);
        tblEntity.setAttribute("qualifiedName", (Object)(name + CLUSTER_SUFFIX));
        tblEntity.setAttribute("description", (Object)description);
        tblEntity.setAttribute("owner", (Object)owner);
        tblEntity.setAttribute("tableType", (Object)tableType);
        tblEntity.setAttribute("createTime", (Object)System.currentTimeMillis());
        tblEntity.setAttribute("lastAccessTime", (Object)System.currentTimeMillis());
        tblEntity.setAttribute("retention", (Object)System.currentTimeMillis());
        AtlasEntity storageDesc = this.createStorageDescriptor("hdfs://host:8000/apps/warehouse/sales", "TextInputFormat", "TextOutputFormat", true);
        storageDesc.setRelationshipAttribute("table", (Object)AtlasTypeUtil.toAtlasRelatedObjectId((AtlasEntity)tblEntity));
        tblEntity.setRelationshipAttribute("db", (Object)AtlasTypeUtil.toAtlasRelatedObjectId((AtlasEntity)database));
        tblEntity.setRelationshipAttribute("sd", (Object)AtlasTypeUtil.toAtlasRelatedObjectId((AtlasEntity)storageDesc));
        tblEntity.setRelationshipAttribute("columns", (Object)AtlasTypeUtil.toAtlasRelatedObjectIds(columns));
        tblEntity.setClassifications(this.toAtlasClassifications(classificationNames));
        AtlasEntity.AtlasEntityWithExtInfo entityWithExtInfo = new AtlasEntity.AtlasEntityWithExtInfo();
        entityWithExtInfo.setEntity(tblEntity);
        entityWithExtInfo.addReferredEntity(storageDesc);
        for (AtlasEntity column : columns) {
            column.setRelationshipAttribute("table", (Object)AtlasTypeUtil.toAtlasRelatedObjectId((AtlasEntity)tblEntity));
            entityWithExtInfo.addReferredEntity(column);
        }
        return this.createInstance(entityWithExtInfo);
    }

    AtlasEntity createProcess(String name, String description, String user, List<AtlasEntity> inputs, List<AtlasEntity> outputs, String queryText, String queryPlan, String queryId, String queryGraph, String ... classificationNames) throws Exception {
        AtlasEntity entity = new AtlasEntity(LOAD_PROCESS_TYPE);
        entity.setAttribute(NAME_COLUMN, (Object)name);
        entity.setAttribute("qualifiedName", (Object)(name + CLUSTER_SUFFIX));
        entity.setAttribute("description", (Object)description);
        entity.setAttribute("user", (Object)user);
        entity.setAttribute("startTime", (Object)System.currentTimeMillis());
        entity.setAttribute("endTime", (Object)(System.currentTimeMillis() + 10000L));
        entity.setAttribute("queryText", (Object)queryText);
        entity.setAttribute("queryPlan", (Object)queryPlan);
        entity.setAttribute("queryId", (Object)queryId);
        entity.setAttribute("queryGraph", (Object)queryGraph);
        entity.setRelationshipAttribute("inputs", (Object)AtlasTypeUtil.toAtlasRelatedObjectIds(inputs));
        entity.setRelationshipAttribute("outputs", (Object)AtlasTypeUtil.toAtlasRelatedObjectIds(outputs));
        entity.setClassifications(this.toAtlasClassifications(classificationNames));
        return this.createInstance(entity);
    }

    AtlasEntity createProcessExecution(AtlasEntity hiveProcess, String name, String description, String user, String queryText, String queryPlan, String queryId, String queryGraph, String ... classificationNames) throws Exception {
        AtlasEntity entity = new AtlasEntity(LOAD_PROCESS_EXECUTION_TYPE);
        Long startTime = System.currentTimeMillis();
        Long endTime = System.currentTimeMillis() + 10000L;
        entity.setAttribute(NAME_COLUMN, (Object)name);
        entity.setAttribute("qualifiedName", (Object)(name + CLUSTER_SUFFIX + startTime + endTime));
        entity.setAttribute("description", (Object)description);
        entity.setAttribute("user", (Object)user);
        entity.setAttribute("startTime", (Object)startTime);
        entity.setAttribute("endTime", (Object)endTime);
        entity.setAttribute("queryText", (Object)queryText);
        entity.setAttribute("queryPlan", (Object)queryPlan);
        entity.setAttribute("queryId", (Object)queryId);
        entity.setAttribute("queryGraph", (Object)queryGraph);
        entity.setRelationshipAttribute("process", (Object)AtlasTypeUtil.toAtlasRelatedObjectId((AtlasEntity)hiveProcess));
        entity.setClassifications(this.toAtlasClassifications(classificationNames));
        return this.createInstance(entity);
    }

    AtlasEntity createView(String name, AtlasEntity database, List<AtlasEntity> inputTables, String ... classificationNames) throws Exception {
        AtlasEntity entity = new AtlasEntity(VIEW_TYPE);
        entity.setAttribute(NAME_COLUMN, (Object)name);
        entity.setAttribute("qualifiedName", (Object)(name + CLUSTER_SUFFIX));
        entity.setRelationshipAttribute("db", (Object)AtlasTypeUtil.toAtlasRelatedObjectId((AtlasEntity)database));
        entity.setRelationshipAttribute("inputTables", (Object)AtlasTypeUtil.toAtlasRelatedObjectIds(inputTables));
        entity.setClassifications(this.toAtlasClassifications(classificationNames));
        return this.createInstance(entity);
    }

    private AtlasEntity createInstance(AtlasEntity entity) throws Exception {
        return this.createInstance(new AtlasEntity.AtlasEntityWithExtInfo(entity));
    }

    private AtlasEntity createInstance(AtlasEntity.AtlasEntityWithExtInfo entityWithExtInfo) throws Exception {
        AtlasEntity ret = null;
        EntityMutationResponse response = this.atlasClientV2.createEntity(entityWithExtInfo);
        List entities = response.getEntitiesByOperation(EntityMutations.EntityOperation.CREATE);
        if (CollectionUtils.isNotEmpty((Collection)entities)) {
            AtlasEntity.AtlasEntityWithExtInfo getByGuidResponse = this.atlasClientV2.getEntityByGuid(((AtlasEntityHeader)entities.get(0)).getGuid());
            ret = getByGuidResponse.getEntity();
            System.out.println("Created entity of type [" + ret.getTypeName() + "], guid: " + ret.getGuid());
        }
        return ret;
    }

    private List<AtlasClassification> toAtlasClassifications(String[] classificationNames) {
        ArrayList<AtlasClassification> ret = new ArrayList<AtlasClassification>();
        List<String> classifications = Arrays.asList(classificationNames);
        if (CollectionUtils.isNotEmpty(classifications)) {
            for (String classificationName : classifications) {
                ret.add(new AtlasClassification(classificationName));
            }
        }
        return ret;
    }

    private void verifyTypesCreated() throws Exception {
        MultivaluedMapImpl searchParams = new MultivaluedMapImpl();
        for (String typeName : TYPES) {
            searchParams.clear();
            searchParams.add((Object)NAME_COLUMN, (Object)typeName);
            SearchFilter searchFilter = new SearchFilter((MultivaluedMap)searchParams);
            AtlasTypesDef searchDefs = this.atlasClientV2.getAllTypeDefs(searchFilter);
            System.out.println("Created type [" + typeName + "]");
        }
    }

    private String[] getDSLQueries() {
        return new String[]{"from DB", DATABASE_TYPE, "DB where name=%22Reporting%22", "DB where name=%22encode_db_name%22", "Table where name=%2522sales_fact%2522", "DB where name=\"Reporting\"", "DB where DB.name=\"Reporting\"", "DB name = \"Reporting\"", "DB DB.name = \"Reporting\"", "DB where name=\"Reporting\" select name, owner", "DB where DB.name=\"Reporting\" select name, owner", "DB has name", "DB where DB has name", "DB is JdbcAccess", "from Table", TABLE_TYPE, "Table is Dimension", "Column where Column isa PII", "View is Dimension", "Column select Column.name", "Column select name", "Column where Column.name=\"customer_id\"", "from Table select Table.name", "DB where (name = \"Reporting\")", "DB where DB is JdbcAccess", "DB where DB has name", "DB as db1 Table where (db1.name = \"Reporting\")", DIMENSION_CLASSIFICATION, JDBC_CLASSIFICATION, ETL_CLASSIFICATION, METRIC_CLASSIFICATION, PII_CLASSIFICATION, "`Log Data`", "Table where name=\"sales_fact\", columns", "Table where name=\"sales_fact\", columns as column select column.name, column.dataType, column.comment", "from DataSet", "from Process"};
    }

    private void search() {
        System.out.println("\nSample DSL Queries: ");
        for (String dslQuery : this.getDSLQueries()) {
            try {
                AtlasSearchResult results = this.atlasClientV2.dslSearchWithParams(dslQuery, 10, 0);
                if (results != null) {
                    List entitiesResult = results.getEntities();
                    List fullTextResults = results.getFullTextResult();
                    AtlasSearchResult.AttributeSearchResult attribResult = results.getAttributes();
                    if (CollectionUtils.isNotEmpty((Collection)entitiesResult)) {
                        System.out.println("query [" + dslQuery + "] returned [" + entitiesResult.size() + "] rows.");
                        continue;
                    }
                    if (CollectionUtils.isNotEmpty((Collection)fullTextResults)) {
                        System.out.println("query [" + dslQuery + "] returned [" + fullTextResults.size() + "] rows.");
                        continue;
                    }
                    if (attribResult != null) {
                        System.out.println("query [" + dslQuery + "] returned [" + attribResult.getValues().size() + "] rows.");
                        continue;
                    }
                    System.out.println("query [" + dslQuery + "] returned [ 0 ] rows.");
                    continue;
                }
                System.out.println("query [" + dslQuery + "] failed, results:" + results);
            }
            catch (Exception e) {
                System.out.println("query [" + dslQuery + "] execution failed!");
            }
        }
    }

    private void lineage() throws AtlasServiceException {
        System.out.println("\nSample Lineage Info: ");
        AtlasLineageInfo lineageInfo = this.atlasClientV2.getLineageInfo(this.getTableId(SALES_FACT_DAILY_MV_TABLE), AtlasLineageInfo.LineageDirection.BOTH, 0);
        Set relations = lineageInfo.getRelations();
        Map guidEntityMap = lineageInfo.getGuidEntityMap();
        for (AtlasLineageInfo.LineageRelation relation : relations) {
            AtlasEntityHeader fromEntity = (AtlasEntityHeader)guidEntityMap.get(relation.getFromEntityId());
            AtlasEntityHeader toEntity = (AtlasEntityHeader)guidEntityMap.get(relation.getToEntityId());
            System.out.println(fromEntity.getDisplayText() + "(" + fromEntity.getTypeName() + ") -> " + toEntity.getDisplayText() + "(" + toEntity.getTypeName() + ")");
        }
    }

    private String getTableId(String tableName) throws AtlasServiceException {
        Map<String, String> attributes = Collections.singletonMap("qualifiedName", tableName + CLUSTER_SUFFIX);
        AtlasEntity tableEntity = this.atlasClientV2.getEntityByAttribute(TABLE_TYPE, attributes).getEntity();
        return tableEntity.getGuid();
    }

    private void closeConnection() {
        if (this.atlasClientV2 != null) {
            this.atlasClientV2.close();
        }
    }
}

