/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.ha;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.apache.atlas.AtlasException;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.net.NetUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtlasServerIdSelector {
    private static final Logger LOG = LoggerFactory.getLogger(AtlasServerIdSelector.class);

    public static String selectServerId(Configuration configuration) throws AtlasException {
        Object[] ids = configuration.getStringArray("atlas.server.ids");
        String matchingServerId = null;
        int appPort = Integer.parseInt(System.getProperty("atlas.app.port"));
        for (String string : ids) {
            String hostPort = configuration.getString("atlas.server.address." + string);
            if (!StringUtils.isEmpty((String)hostPort)) {
                InetSocketAddress socketAddress;
                try {
                    socketAddress = NetUtils.createSocketAddr((String)hostPort);
                }
                catch (Exception e) {
                    LOG.warn("Exception while trying to get socket address for {}", (Object)hostPort, (Object)e);
                    continue;
                }
                if (socketAddress.isUnresolved() || !NetUtils.isLocalAddress((InetAddress)socketAddress.getAddress()) || appPort != socketAddress.getPort()) continue;
                LOG.info("Found matched server id {} with host port: {}", (Object)string, (Object)hostPort);
                matchingServerId = string;
                break;
            }
            LOG.info("Could not find matching address entry for id: {}", (Object)string);
        }
        if (matchingServerId == null) {
            String msg = String.format("Could not find server id for this instance. Unable to find IDs matching any local host and port binding among %s", StringUtils.join((Object[])ids, (String)","));
            throw new AtlasException(msg);
        }
        return matchingServerId;
    }
}

