package org.apache.atlas.query.antlr4;

import org.antlr.v4.runtime.NoViableAltException;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.RuntimeMetaData;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.Vocabulary;
import org.antlr.v4.runtime.VocabularyImpl;
import org.antlr.v4.runtime.atn.ATN;
import org.antlr.v4.runtime.atn.ATNDeserializer;
import org.antlr.v4.runtime.atn.ParserATNSimulator;
import org.antlr.v4.runtime.atn.PredictionContextCache;
import org.antlr.v4.runtime.dfa.DFA;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeVisitor;
import org.antlr.v4.runtime.tree.TerminalNode;

import java.util.List;

@SuppressWarnings({"all", "warnings", "unchecked", "unused", "cast"})
public class AtlasDSLParser extends Parser {
    public static final    int
                                                  SINGLE_LINE_COMMENT = 1, MULTILINE_COMMENT = 2, WS = 3, NUMBER = 4, FLOATING_NUMBER = 5,
            BOOL                                                      = 6, K_COMMA = 7, K_PLUS = 8, K_MINUS = 9, K_STAR = 10, K_DIV = 11, K_DOT = 12,
            K_LIKE                                                    = 13, K_AND = 14, K_OR = 15, K_LPAREN = 16, K_LBRACKET = 17, K_RPAREN = 18,
            K_RBRACKET                                                = 19, K_LT = 20, K_LTE = 21, K_EQ = 22, K_NEQ = 23, K_GT = 24, K_GTE = 25,
            K_FROM                                                    = 26, K_WHERE = 27, K_ORDERBY = 28, K_GROUPBY = 29, K_LIMIT = 30, K_SELECT = 31,
            K_MAX                                                     = 32, K_MIN = 33, K_SUM = 34, K_COUNT = 35, K_OFFSET = 36, K_AS = 37, K_ISA = 38,
            K_IS                                                      = 39, K_HAS = 40, K_ASC = 41, K_DESC = 42, K_TRUE = 43, K_FALSE = 44, K_HASTERM = 45,
            KEYWORD                                                   = 46, ID = 47, STRING = 48;
    public static final int
            RULE_identifier            = 0, RULE_operator = 1, RULE_sortOrder = 2, RULE_valueArray = 3,
            RULE_literal               = 4, RULE_limitClause = 5, RULE_offsetClause = 6, RULE_atomE = 7,
            RULE_multiERight           = 8, RULE_multiE = 9, RULE_arithERight = 10, RULE_arithE = 11,
            RULE_comparisonClause      = 12, RULE_isClause = 13, RULE_hasTermClause = 14,
            RULE_hasClause             = 15, RULE_countClause = 16, RULE_maxClause = 17, RULE_minClause = 18,
            RULE_sumClause             = 19, RULE_exprRight = 20, RULE_compE = 21, RULE_expr = 22,
            RULE_limitOffset           = 23, RULE_selectExpression = 24, RULE_selectExpr = 25,
            RULE_aliasExpr             = 26, RULE_orderByExpr = 27, RULE_fromSrc = 28, RULE_whereClause = 29,
            RULE_fromExpression        = 30, RULE_fromClause = 31, RULE_selectClause = 32,
            RULE_singleQrySrc          = 33, RULE_groupByExpression = 34, RULE_commaDelimitedQueries = 35,
            RULE_spaceDelimitedQueries = 36, RULE_querySrc = 37, RULE_query = 38;
    public static final String[] ruleNames = makeRuleNames();
    /**
     * @deprecated Use {@link #VOCABULARY} instead.
     */
    @Deprecated
    public static final String[] tokenNames;
    public static final String _serializedATN =
            "\3\u608b\ua72a\u8133\ub9ed\u417c\u3be7\u7786\u5964\3\62\u0129\4\2\t\2" +
                    "\4\3\t\3\4\4\t\4\4\5\t\5\4\6\t\6\4\7\t\7\4\b\t\b\4\t\t\t\4\n\t\n\4\13" +
                    "\t\13\4\f\t\f\4\r\t\r\4\16\t\16\4\17\t\17\4\20\t\20\4\21\t\21\4\22\t\22" +
                    "\4\23\t\23\4\24\t\24\4\25\t\25\4\26\t\26\4\27\t\27\4\30\t\30\4\31\t\31" +
                    "\4\32\t\32\4\33\t\33\4\34\t\34\4\35\t\35\4\36\t\36\4\37\t\37\4 \t \4!" +
                    "\t!\4\"\t\"\4#\t#\4$\t$\4%\t%\4&\t&\4\'\t\'\4(\t(\3\2\3\2\3\3\3\3\3\4" +
                    "\3\4\3\5\3\5\3\5\3\5\7\5[\n\5\f\5\16\5^\13\5\3\5\3\5\3\6\3\6\3\6\3\6\3" +
                    "\6\5\6g\n\6\5\6i\n\6\3\7\3\7\3\7\3\b\3\b\3\b\3\t\3\t\5\ts\n\t\3\t\3\t" +
                    "\3\t\3\t\5\ty\n\t\3\n\3\n\3\n\3\13\3\13\7\13\u0080\n\13\f\13\16\13\u0083" +
                    "\13\13\3\f\3\f\3\f\3\r\3\r\7\r\u008a\n\r\f\r\16\r\u008d\13\r\3\16\3\16" +
                    "\3\16\3\16\3\17\3\17\3\17\3\17\5\17\u0097\n\17\3\20\3\20\3\20\3\20\5\20" +
                    "\u009d\n\20\3\21\3\21\3\21\3\21\3\22\3\22\3\22\3\22\3\23\3\23\3\23\3\23" +
                    "\3\23\3\24\3\24\3\24\3\24\3\24\3\25\3\25\3\25\3\25\3\25\3\26\3\26\3\26" +
                    "\3\27\3\27\3\27\3\27\3\27\3\27\3\27\3\27\3\27\5\27\u00c2\n\27\3\30\3\30" +
                    "\7\30\u00c6\n\30\f\30\16\30\u00c9\13\30\3\31\3\31\5\31\u00cd\n\31\3\32" +
                    "\3\32\3\32\5\32\u00d2\n\32\3\33\3\33\3\33\7\33\u00d7\n\33\f\33\16\33\u00da" +
                    "\13\33\3\34\3\34\5\34\u00de\n\34\3\34\3\34\3\34\3\35\3\35\3\35\5\35\u00e6" +
                    "\n\35\3\36\3\36\3\36\5\36\u00eb\n\36\5\36\u00ed\n\36\3\37\3\37\3\37\3" +
                    " \3 \5 \u00f4\n \3!\3!\3!\3\"\3\"\3\"\3#\3#\3#\3#\5#\u0100\n#\3$\3$\3" +
                    "$\3$\3$\3%\3%\3%\7%\u010a\n%\f%\16%\u010d\13%\3&\3&\7&\u0111\n&\f&\16" +
                    "&\u0114\13&\3\'\3\'\5\'\u0118\n\'\3(\3(\5(\u011c\n(\3(\5(\u011f\n(\3(" +
                    "\5(\u0122\n(\3(\5(\u0125\n(\3(\3(\3(\2\2)\2\4\6\b\n\f\16\20\22\24\26\30" +
                    "\32\34\36 \"$&(*,.\60\62\64\668:<>@BDFHJLN\2\b\4\2\17\17\26\33\3\2+,\3" +
                    "\2\f\r\3\2\n\13\3\2()\3\2\20\21\2\u0127\2P\3\2\2\2\4R\3\2\2\2\6T\3\2\2" +
                    "\2\bV\3\2\2\2\nh\3\2\2\2\fj\3\2\2\2\16m\3\2\2\2\20x\3\2\2\2\22z\3\2\2" +
                    "\2\24}\3\2\2\2\26\u0084\3\2\2\2\30\u0087\3\2\2\2\32\u008e\3\2\2\2\34\u0092" +
                    "\3\2\2\2\36\u0098\3\2\2\2 \u009e\3\2\2\2\"\u00a2\3\2\2\2$\u00a6\3\2\2" +
                    "\2&\u00ab\3\2\2\2(\u00b0\3\2\2\2*\u00b5\3\2\2\2,\u00c1\3\2\2\2.\u00c3" +
                    "\3\2\2\2\60\u00ca\3\2\2\2\62\u00ce\3\2\2\2\64\u00d3\3\2\2\2\66\u00dd\3" +
                    "\2\2\28\u00e2\3\2\2\2:\u00ec\3\2\2\2<\u00ee\3\2\2\2>\u00f1\3\2\2\2@\u00f5" +
                    "\3\2\2\2B\u00f8\3\2\2\2D\u00ff\3\2\2\2F\u0101\3\2\2\2H\u0106\3\2\2\2J" +
                    "\u010e\3\2\2\2L\u0117\3\2\2\2N\u0119\3\2\2\2PQ\7\61\2\2Q\3\3\2\2\2RS\t" +
                    "\2\2\2S\5\3\2\2\2TU\t\3\2\2U\7\3\2\2\2VW\7\23\2\2W\\\7\61\2\2XY\7\t\2" +
                    "\2Y[\7\61\2\2ZX\3\2\2\2[^\3\2\2\2\\Z\3\2\2\2\\]\3\2\2\2]_\3\2\2\2^\\\3" +
                    "\2\2\2_`\7\25\2\2`\t\3\2\2\2ai\7\b\2\2bi\7\6\2\2ci\7\7\2\2dg\7\61\2\2" +
                    "eg\5\b\5\2fd\3\2\2\2fe\3\2\2\2gi\3\2\2\2ha\3\2\2\2hb\3\2\2\2hc\3\2\2\2" +
                    "hf\3\2\2\2i\13\3\2\2\2jk\7 \2\2kl\7\6\2\2l\r\3\2\2\2mn\7&\2\2no\7\6\2" +
                    "\2o\17\3\2\2\2ps\5\2\2\2qs\5\n\6\2rp\3\2\2\2rq\3\2\2\2sy\3\2\2\2tu\7\22" +
                    "\2\2uv\5.\30\2vw\7\24\2\2wy\3\2\2\2xr\3\2\2\2xt\3\2\2\2y\21\3\2\2\2z{" +
                    "\t\4\2\2{|\5\20\t\2|\23\3\2\2\2}\u0081\5\20\t\2~\u0080\5\22\n\2\177~\3" +
                    "\2\2\2\u0080\u0083\3\2\2\2\u0081\177\3\2\2\2\u0081\u0082\3\2\2\2\u0082" +
                    "\25\3\2\2\2\u0083\u0081\3\2\2\2\u0084\u0085\t\5\2\2\u0085\u0086\5\24\13" +
                    "\2\u0086\27\3\2\2\2\u0087\u008b\5\24\13\2\u0088\u008a\5\26\f\2\u0089\u0088" +
                    "\3\2\2\2\u008a\u008d\3\2\2\2\u008b\u0089\3\2\2\2\u008b\u008c\3\2\2\2\u008c" +
                    "\31\3\2\2\2\u008d\u008b\3\2\2\2\u008e\u008f\5\30\r\2\u008f\u0090\5\4\3" +
                    "\2\u0090\u0091\5\30\r\2\u0091\33\3\2\2\2\u0092\u0093\5\30\r\2\u0093\u0096" +
                    "\t\6\2\2\u0094\u0097\5\2\2\2\u0095\u0097\5.\30\2\u0096\u0094\3\2\2\2\u0096" +
                    "\u0095\3\2\2\2\u0097\35\3\2\2\2\u0098\u0099\5\30\r\2\u0099\u009c\7/\2" +
                    "\2\u009a\u009d\5\2\2\2\u009b\u009d\5.\30\2\u009c\u009a\3\2\2\2\u009c\u009b" +
                    "\3\2\2\2\u009d\37\3\2\2\2\u009e\u009f\5\30\r\2\u009f\u00a0\7*\2\2\u00a0" +
                    "\u00a1\5\2\2\2\u00a1!\3\2\2\2\u00a2\u00a3\7%\2\2\u00a3\u00a4\7\22\2\2" +
                    "\u00a4\u00a5\7\24\2\2\u00a5#\3\2\2\2\u00a6\u00a7\7\"\2\2\u00a7\u00a8\7" +
                    "\22\2\2\u00a8\u00a9\5.\30\2\u00a9\u00aa\7\24\2\2\u00aa%\3\2\2\2\u00ab" +
                    "\u00ac\7#\2\2\u00ac\u00ad\7\22\2\2\u00ad\u00ae\5.\30\2\u00ae\u00af\7\24" +
                    "\2\2\u00af\'\3\2\2\2\u00b0\u00b1\7$\2\2\u00b1\u00b2\7\22\2\2\u00b2\u00b3" +
                    "\5.\30\2\u00b3\u00b4\7\24\2\2\u00b4)\3\2\2\2\u00b5\u00b6\t\7\2\2\u00b6" +
                    "\u00b7\5,\27\2\u00b7+\3\2\2\2\u00b8\u00c2\5\32\16\2\u00b9\u00c2\5\34\17" +
                    "\2\u00ba\u00c2\5 \21\2\u00bb\u00c2\5\30\r\2\u00bc\u00c2\5\"\22\2\u00bd" +
                    "\u00c2\5$\23\2\u00be\u00c2\5&\24\2\u00bf\u00c2\5(\25\2\u00c0\u00c2\5\36" +
                    "\20\2\u00c1\u00b8\3\2\2\2\u00c1\u00b9\3\2\2\2\u00c1\u00ba\3\2\2\2\u00c1" +
                    "\u00bb\3\2\2\2\u00c1\u00bc\3\2\2\2\u00c1\u00bd\3\2\2\2\u00c1\u00be\3\2" +
                    "\2\2\u00c1\u00bf\3\2\2\2\u00c1\u00c0\3\2\2\2\u00c2-\3\2\2\2\u00c3\u00c7" +
                    "\5,\27\2\u00c4\u00c6\5*\26\2\u00c5\u00c4\3\2\2\2\u00c6\u00c9\3\2\2\2\u00c7" +
                    "\u00c5\3\2\2\2\u00c7\u00c8\3\2\2\2\u00c8/\3\2\2\2\u00c9\u00c7\3\2\2\2" +
                    "\u00ca\u00cc\5\f\7\2\u00cb\u00cd\5\16\b\2\u00cc\u00cb\3\2\2\2\u00cc\u00cd" +
                    "\3\2\2\2\u00cd\61\3\2\2\2\u00ce\u00d1\5.\30\2\u00cf\u00d0\7\'\2\2\u00d0" +
                    "\u00d2\5\2\2\2\u00d1\u00cf\3\2\2\2\u00d1\u00d2\3\2\2\2\u00d2\63\3\2\2" +
                    "\2\u00d3\u00d8\5\62\32\2\u00d4\u00d5\7\t\2\2\u00d5\u00d7\5\62\32\2\u00d6" +
                    "\u00d4\3\2\2\2\u00d7\u00da\3\2\2\2\u00d8\u00d6\3\2\2\2\u00d8\u00d9\3\2" +
                    "\2\2\u00d9\65\3\2\2\2\u00da\u00d8\3\2\2\2\u00db\u00de\5\2\2\2\u00dc\u00de" +
                    "\5\n\6\2\u00dd\u00db\3\2\2\2\u00dd\u00dc\3\2\2\2\u00de\u00df\3\2\2\2\u00df" +
                    "\u00e0\7\'\2\2\u00e0\u00e1\5\2\2\2\u00e1\67\3\2\2\2\u00e2\u00e3\7\36\2" +
                    "\2\u00e3\u00e5\5.\30\2\u00e4\u00e6\5\6\4\2\u00e5\u00e4\3\2\2\2\u00e5\u00e6" +
                    "\3\2\2\2\u00e69\3\2\2\2\u00e7\u00ed\5\66\34\2\u00e8\u00eb\5\2\2\2\u00e9" +
                    "\u00eb\5\n\6\2\u00ea\u00e8\3\2\2\2\u00ea\u00e9\3\2\2\2\u00eb\u00ed\3\2" +
                    "\2\2\u00ec\u00e7\3\2\2\2\u00ec\u00ea\3\2\2\2\u00ed;\3\2\2\2\u00ee\u00ef" +
                    "\7\35\2\2\u00ef\u00f0\5.\30\2\u00f0=\3\2\2\2\u00f1\u00f3\5:\36\2\u00f2" +
                    "\u00f4\5<\37\2\u00f3\u00f2\3\2\2\2\u00f3\u00f4\3\2\2\2\u00f4?\3\2\2\2" +
                    "\u00f5\u00f6\7\34\2\2\u00f6\u00f7\5> \2\u00f7A\3\2\2\2\u00f8\u00f9\7!" +
                    "\2\2\u00f9\u00fa\5\64\33\2\u00faC\3\2\2\2\u00fb\u0100\5@!\2\u00fc\u0100" +
                    "\5<\37\2\u00fd\u0100\5> \2\u00fe\u0100\5.\30\2\u00ff\u00fb\3\2\2\2\u00ff" +
                    "\u00fc\3\2\2\2\u00ff\u00fd\3\2\2\2\u00ff\u00fe\3\2\2\2\u0100E\3\2\2\2" +
                    "\u0101\u0102\7\37\2\2\u0102\u0103\7\22\2\2\u0103\u0104\5\64\33\2\u0104" +
                    "\u0105\7\24\2\2\u0105G\3\2\2\2\u0106\u010b\5D#\2\u0107\u0108\7\t\2\2\u0108" +
                    "\u010a\5D#\2\u0109\u0107\3\2\2\2\u010a\u010d\3\2\2\2\u010b\u0109\3\2\2" +
                    "\2\u010b\u010c\3\2\2\2\u010cI\3\2\2\2\u010d\u010b\3\2\2\2\u010e\u0112" +
                    "\5D#\2\u010f\u0111\5D#\2\u0110\u010f\3\2\2\2\u0111\u0114\3\2\2\2\u0112" +
                    "\u0110\3\2\2\2\u0112\u0113\3\2\2\2\u0113K\3\2\2\2\u0114\u0112\3\2\2\2" +
                    "\u0115\u0118\5H%\2\u0116\u0118\5J&\2\u0117\u0115\3\2\2\2\u0117\u0116\3" +
                    "\2\2\2\u0118M\3\2\2\2\u0119\u011b\5L\'\2\u011a\u011c\5F$\2\u011b\u011a" +
                    "\3\2\2\2\u011b\u011c\3\2\2\2\u011c\u011e\3\2\2\2\u011d\u011f\5B\"\2\u011e" +
                    "\u011d\3\2\2\2\u011e\u011f\3\2\2\2\u011f\u0121\3\2\2\2\u0120\u0122\58" +
                    "\35\2\u0121\u0120\3\2\2\2\u0121\u0122\3\2\2\2\u0122\u0124\3\2\2\2\u0123" +
                    "\u0125\5\60\31\2\u0124\u0123\3\2\2\2\u0124\u0125\3\2\2\2\u0125\u0126\3" +
                    "\2\2\2\u0126\u0127\7\2\2\3\u0127O\3\2\2\2\35\\fhrx\u0081\u008b\u0096\u009c" +
                    "\u00c1\u00c7\u00cc\u00d1\u00d8\u00dd\u00e5\u00ea\u00ec\u00f3\u00ff\u010b" +
                    "\u0112\u0117\u011b\u011e\u0121\u0124";
    public static final ATN    _ATN           =
            new ATNDeserializer().deserialize(_serializedATN.toCharArray());
    protected static final DFA[]                  _decisionToDFA;
    protected static final PredictionContextCache _sharedContextCache =
            new PredictionContextCache();
    private static final String[] _LITERAL_NAMES = makeLiteralNames();
    private static final String[]   _SYMBOLIC_NAMES = makeSymbolicNames();
    public static final  Vocabulary VOCABULARY      = new VocabularyImpl(_LITERAL_NAMES, _SYMBOLIC_NAMES);
    public AtlasDSLParser(TokenStream input) {
        super(input);
        _interp = new ParserATNSimulator(this, _ATN, _decisionToDFA, _sharedContextCache);
    }

    @Override
    @Deprecated
    public String[] getTokenNames() {
        return tokenNames;
    }

    @Override
    public String[] getRuleNames() {return ruleNames;}

    @Override

    public Vocabulary getVocabulary() {
        return VOCABULARY;
    }

    @Override
    public String getSerializedATN() {return _serializedATN;}

    @Override
    public String getGrammarFileName() {return "AtlasDSLParser.g4";}

    @Override
    public ATN getATN() {return _ATN;}

    public final IdentifierContext identifier() throws RecognitionException {
        IdentifierContext _localctx = new IdentifierContext(_ctx, getState());
        enterRule(_localctx, 0, RULE_identifier);
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(78);
                match(ID);
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    public final OperatorContext operator() throws RecognitionException {
        OperatorContext _localctx = new OperatorContext(_ctx, getState());
        enterRule(_localctx, 2, RULE_operator);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(80);
                _la = _input.LA(1);
                if (!((((_la) & ~0x3f) == 0 && ((1L << _la) & ((1L << K_LIKE) | (1L << K_LT) | (1L << K_LTE) | (1L << K_EQ) | (1L << K_NEQ) | (1L << K_GT) | (1L << K_GTE))) != 0))) {
                    _errHandler.recoverInline(this);
                } else {
                    if (_input.LA(1) == Token.EOF) {
                        matchedEOF = true;
                    }
                    _errHandler.reportMatch(this);
                    consume();
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    public final SortOrderContext sortOrder() throws RecognitionException {
        SortOrderContext _localctx = new SortOrderContext(_ctx, getState());
        enterRule(_localctx, 4, RULE_sortOrder);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(82);
                _la = _input.LA(1);
                if (!(_la == K_ASC || _la == K_DESC)) {
                    _errHandler.recoverInline(this);
                } else {
                    if (_input.LA(1) == Token.EOF) {
                        matchedEOF = true;
                    }
                    _errHandler.reportMatch(this);
                    consume();
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    public final ValueArrayContext valueArray() throws RecognitionException {
        ValueArrayContext _localctx = new ValueArrayContext(_ctx, getState());
        enterRule(_localctx, 6, RULE_valueArray);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(84);
                match(K_LBRACKET);
                setState(85);
                match(ID);
                setState(90);
                _errHandler.sync(this);
                _la = _input.LA(1);
                while (_la == K_COMMA) {
                    {
                        {
                            setState(86);
                            match(K_COMMA);
                            setState(87);
                            match(ID);
                        }
                    }
                    setState(92);
                    _errHandler.sync(this);
                    _la = _input.LA(1);
                }
                setState(93);
                match(K_RBRACKET);
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    public final LiteralContext literal() throws RecognitionException {
        LiteralContext _localctx = new LiteralContext(_ctx, getState());
        enterRule(_localctx, 8, RULE_literal);
        try {
            setState(102);
            _errHandler.sync(this);
            switch (_input.LA(1)) {
                case BOOL:
                    enterOuterAlt(_localctx, 1);
                {
                    setState(95);
                    match(BOOL);
                }
                break;
                case NUMBER:
                    enterOuterAlt(_localctx, 2);
                {
                    setState(96);
                    match(NUMBER);
                }
                break;
                case FLOATING_NUMBER:
                    enterOuterAlt(_localctx, 3);
                {
                    setState(97);
                    match(FLOATING_NUMBER);
                }
                break;
                case K_LBRACKET:
                case ID:
                    enterOuterAlt(_localctx, 4);
                {
                    setState(100);
                    _errHandler.sync(this);
                    switch (_input.LA(1)) {
                        case ID: {
                            setState(98);
                            match(ID);
                        }
                        break;
                        case K_LBRACKET: {
                            setState(99);
                            valueArray();
                        }
                        break;
                        default:
                            throw new NoViableAltException(this);
                    }
                }
                break;
                default:
                    throw new NoViableAltException(this);
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    public final LimitClauseContext limitClause() throws RecognitionException {
        LimitClauseContext _localctx = new LimitClauseContext(_ctx, getState());
        enterRule(_localctx, 10, RULE_limitClause);
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(104);
                match(K_LIMIT);
                setState(105);
                match(NUMBER);
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    public final OffsetClauseContext offsetClause() throws RecognitionException {
        OffsetClauseContext _localctx = new OffsetClauseContext(_ctx, getState());
        enterRule(_localctx, 12, RULE_offsetClause);
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(107);
                match(K_OFFSET);
                setState(108);
                match(NUMBER);
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    public final AtomEContext atomE() throws RecognitionException {
        AtomEContext _localctx = new AtomEContext(_ctx, getState());
        enterRule(_localctx, 14, RULE_atomE);
        try {
            setState(118);
            _errHandler.sync(this);
            switch (_input.LA(1)) {
                case NUMBER:
                case FLOATING_NUMBER:
                case BOOL:
                case K_LBRACKET:
                case ID:
                    enterOuterAlt(_localctx, 1);
                {
                    setState(112);
                    _errHandler.sync(this);
                    switch (getInterpreter().adaptivePredict(_input, 3, _ctx)) {
                        case 1: {
                            setState(110);
                            identifier();
                        }
                        break;
                        case 2: {
                            setState(111);
                            literal();
                        }
                        break;
                    }
                }
                break;
                case K_LPAREN:
                    enterOuterAlt(_localctx, 2);
                {
                    setState(114);
                    match(K_LPAREN);
                    setState(115);
                    expr();
                    setState(116);
                    match(K_RPAREN);
                }
                break;
                default:
                    throw new NoViableAltException(this);
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    public final MultiERightContext multiERight() throws RecognitionException {
        MultiERightContext _localctx = new MultiERightContext(_ctx, getState());
        enterRule(_localctx, 16, RULE_multiERight);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(120);
                _la = _input.LA(1);
                if (!(_la == K_STAR || _la == K_DIV)) {
                    _errHandler.recoverInline(this);
                } else {
                    if (_input.LA(1) == Token.EOF) {
                        matchedEOF = true;
                    }
                    _errHandler.reportMatch(this);
                    consume();
                }
                setState(121);
                atomE();
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    public final MultiEContext multiE() throws RecognitionException {
        MultiEContext _localctx = new MultiEContext(_ctx, getState());
        enterRule(_localctx, 18, RULE_multiE);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(123);
                atomE();
                setState(127);
                _errHandler.sync(this);
                _la = _input.LA(1);
                while (_la == K_STAR || _la == K_DIV) {
                    {
                        {
                            setState(124);
                            multiERight();
                        }
                    }
                    setState(129);
                    _errHandler.sync(this);
                    _la = _input.LA(1);
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    public final ArithERightContext arithERight() throws RecognitionException {
        ArithERightContext _localctx = new ArithERightContext(_ctx, getState());
        enterRule(_localctx, 20, RULE_arithERight);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(130);
                _la = _input.LA(1);
                if (!(_la == K_PLUS || _la == K_MINUS)) {
                    _errHandler.recoverInline(this);
                } else {
                    if (_input.LA(1) == Token.EOF) {
                        matchedEOF = true;
                    }
                    _errHandler.reportMatch(this);
                    consume();
                }
                setState(131);
                multiE();
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    public final ArithEContext arithE() throws RecognitionException {
        ArithEContext _localctx = new ArithEContext(_ctx, getState());
        enterRule(_localctx, 22, RULE_arithE);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(133);
                multiE();
                setState(137);
                _errHandler.sync(this);
                _la = _input.LA(1);
                while (_la == K_PLUS || _la == K_MINUS) {
                    {
                        {
                            setState(134);
                            arithERight();
                        }
                    }
                    setState(139);
                    _errHandler.sync(this);
                    _la = _input.LA(1);
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    public final ComparisonClauseContext comparisonClause() throws RecognitionException {
        ComparisonClauseContext _localctx = new ComparisonClauseContext(_ctx, getState());
        enterRule(_localctx, 24, RULE_comparisonClause);
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(140);
                arithE();
                setState(141);
                operator();
                setState(142);
                arithE();
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    public final IsClauseContext isClause() throws RecognitionException {
        IsClauseContext _localctx = new IsClauseContext(_ctx, getState());
        enterRule(_localctx, 26, RULE_isClause);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(144);
                arithE();
                setState(145);
                _la = _input.LA(1);
                if (!(_la == K_ISA || _la == K_IS)) {
                    _errHandler.recoverInline(this);
                } else {
                    if (_input.LA(1) == Token.EOF) {
                        matchedEOF = true;
                    }
                    _errHandler.reportMatch(this);
                    consume();
                }
                setState(148);
                _errHandler.sync(this);
                switch (getInterpreter().adaptivePredict(_input, 7, _ctx)) {
                    case 1: {
                        setState(146);
                        identifier();
                    }
                    break;
                    case 2: {
                        setState(147);
                        expr();
                    }
                    break;
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    public final HasTermClauseContext hasTermClause() throws RecognitionException {
        HasTermClauseContext _localctx = new HasTermClauseContext(_ctx, getState());
        enterRule(_localctx, 28, RULE_hasTermClause);
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(150);
                arithE();
                setState(151);
                match(K_HASTERM);
                setState(154);
                _errHandler.sync(this);
                switch (getInterpreter().adaptivePredict(_input, 8, _ctx)) {
                    case 1: {
                        setState(152);
                        identifier();
                    }
                    break;
                    case 2: {
                        setState(153);
                        expr();
                    }
                    break;
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    public final HasClauseContext hasClause() throws RecognitionException {
        HasClauseContext _localctx = new HasClauseContext(_ctx, getState());
        enterRule(_localctx, 30, RULE_hasClause);
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(156);
                arithE();
                setState(157);
                match(K_HAS);
                setState(158);
                identifier();
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    public final CountClauseContext countClause() throws RecognitionException {
        CountClauseContext _localctx = new CountClauseContext(_ctx, getState());
        enterRule(_localctx, 32, RULE_countClause);
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(160);
                match(K_COUNT);
                setState(161);
                match(K_LPAREN);
                setState(162);
                match(K_RPAREN);
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    public final MaxClauseContext maxClause() throws RecognitionException {
        MaxClauseContext _localctx = new MaxClauseContext(_ctx, getState());
        enterRule(_localctx, 34, RULE_maxClause);
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(164);
                match(K_MAX);
                setState(165);
                match(K_LPAREN);
                setState(166);
                expr();
                setState(167);
                match(K_RPAREN);
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    public final MinClauseContext minClause() throws RecognitionException {
        MinClauseContext _localctx = new MinClauseContext(_ctx, getState());
        enterRule(_localctx, 36, RULE_minClause);
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(169);
                match(K_MIN);
                setState(170);
                match(K_LPAREN);
                setState(171);
                expr();
                setState(172);
                match(K_RPAREN);
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    public final SumClauseContext sumClause() throws RecognitionException {
        SumClauseContext _localctx = new SumClauseContext(_ctx, getState());
        enterRule(_localctx, 38, RULE_sumClause);
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(174);
                match(K_SUM);
                setState(175);
                match(K_LPAREN);
                setState(176);
                expr();
                setState(177);
                match(K_RPAREN);
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    public final ExprRightContext exprRight() throws RecognitionException {
        ExprRightContext _localctx = new ExprRightContext(_ctx, getState());
        enterRule(_localctx, 40, RULE_exprRight);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(179);
                _la = _input.LA(1);
                if (!(_la == K_AND || _la == K_OR)) {
                    _errHandler.recoverInline(this);
                } else {
                    if (_input.LA(1) == Token.EOF) {
                        matchedEOF = true;
                    }
                    _errHandler.reportMatch(this);
                    consume();
                }
                setState(180);
                compE();
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    public final CompEContext compE() throws RecognitionException {
        CompEContext _localctx = new CompEContext(_ctx, getState());
        enterRule(_localctx, 42, RULE_compE);
        try {
            setState(191);
            _errHandler.sync(this);
            switch (getInterpreter().adaptivePredict(_input, 9, _ctx)) {
                case 1:
                    enterOuterAlt(_localctx, 1);
                {
                    setState(182);
                    comparisonClause();
                }
                break;
                case 2:
                    enterOuterAlt(_localctx, 2);
                {
                    setState(183);
                    isClause();
                }
                break;
                case 3:
                    enterOuterAlt(_localctx, 3);
                {
                    setState(184);
                    hasClause();
                }
                break;
                case 4:
                    enterOuterAlt(_localctx, 4);
                {
                    setState(185);
                    arithE();
                }
                break;
                case 5:
                    enterOuterAlt(_localctx, 5);
                {
                    setState(186);
                    countClause();
                }
                break;
                case 6:
                    enterOuterAlt(_localctx, 6);
                {
                    setState(187);
                    maxClause();
                }
                break;
                case 7:
                    enterOuterAlt(_localctx, 7);
                {
                    setState(188);
                    minClause();
                }
                break;
                case 8:
                    enterOuterAlt(_localctx, 8);
                {
                    setState(189);
                    sumClause();
                }
                break;
                case 9:
                    enterOuterAlt(_localctx, 9);
                {
                    setState(190);
                    hasTermClause();
                }
                break;
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    public final ExprContext expr() throws RecognitionException {
        ExprContext _localctx = new ExprContext(_ctx, getState());
        enterRule(_localctx, 44, RULE_expr);
        try {
            int _alt;
            enterOuterAlt(_localctx, 1);
            {
                setState(193);
                compE();
                setState(197);
                _errHandler.sync(this);
                _alt = getInterpreter().adaptivePredict(_input, 10, _ctx);
                while (_alt != 2 && _alt != org.antlr.v4.runtime.atn.ATN.INVALID_ALT_NUMBER) {
                    if (_alt == 1) {
                        {
                            {
                                setState(194);
                                exprRight();
                            }
                        }
                    }
                    setState(199);
                    _errHandler.sync(this);
                    _alt = getInterpreter().adaptivePredict(_input, 10, _ctx);
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    public final LimitOffsetContext limitOffset() throws RecognitionException {
        LimitOffsetContext _localctx = new LimitOffsetContext(_ctx, getState());
        enterRule(_localctx, 46, RULE_limitOffset);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(200);
                limitClause();
                setState(202);
                _errHandler.sync(this);
                _la = _input.LA(1);
                if (_la == K_OFFSET) {
                    {
                        setState(201);
                        offsetClause();
                    }
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    public final SelectExpressionContext selectExpression() throws RecognitionException {
        SelectExpressionContext _localctx = new SelectExpressionContext(_ctx, getState());
        enterRule(_localctx, 48, RULE_selectExpression);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(204);
                expr();
                setState(207);
                _errHandler.sync(this);
                _la = _input.LA(1);
                if (_la == K_AS) {
                    {
                        setState(205);
                        match(K_AS);
                        setState(206);
                        identifier();
                    }
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    public final SelectExprContext selectExpr() throws RecognitionException {
        SelectExprContext _localctx = new SelectExprContext(_ctx, getState());
        enterRule(_localctx, 50, RULE_selectExpr);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(209);
                selectExpression();
                setState(214);
                _errHandler.sync(this);
                _la = _input.LA(1);
                while (_la == K_COMMA) {
                    {
                        {
                            setState(210);
                            match(K_COMMA);
                            setState(211);
                            selectExpression();
                        }
                    }
                    setState(216);
                    _errHandler.sync(this);
                    _la = _input.LA(1);
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    public final AliasExprContext aliasExpr() throws RecognitionException {
        AliasExprContext _localctx = new AliasExprContext(_ctx, getState());
        enterRule(_localctx, 52, RULE_aliasExpr);
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(219);
                _errHandler.sync(this);
                switch (getInterpreter().adaptivePredict(_input, 14, _ctx)) {
                    case 1: {
                        setState(217);
                        identifier();
                    }
                    break;
                    case 2: {
                        setState(218);
                        literal();
                    }
                    break;
                }
                setState(221);
                match(K_AS);
                setState(222);
                identifier();
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    public final OrderByExprContext orderByExpr() throws RecognitionException {
        OrderByExprContext _localctx = new OrderByExprContext(_ctx, getState());
        enterRule(_localctx, 54, RULE_orderByExpr);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(224);
                match(K_ORDERBY);
                setState(225);
                expr();
                setState(227);
                _errHandler.sync(this);
                _la = _input.LA(1);
                if (_la == K_ASC || _la == K_DESC) {
                    {
                        setState(226);
                        sortOrder();
                    }
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    public final FromSrcContext fromSrc() throws RecognitionException {
        FromSrcContext _localctx = new FromSrcContext(_ctx, getState());
        enterRule(_localctx, 56, RULE_fromSrc);
        try {
            setState(234);
            _errHandler.sync(this);
            switch (getInterpreter().adaptivePredict(_input, 17, _ctx)) {
                case 1:
                    enterOuterAlt(_localctx, 1);
                {
                    setState(229);
                    aliasExpr();
                }
                break;
                case 2:
                    enterOuterAlt(_localctx, 2);
                {
                    setState(232);
                    _errHandler.sync(this);
                    switch (getInterpreter().adaptivePredict(_input, 16, _ctx)) {
                        case 1: {
                            setState(230);
                            identifier();
                        }
                        break;
                        case 2: {
                            setState(231);
                            literal();
                        }
                        break;
                    }
                }
                break;
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    public final WhereClauseContext whereClause() throws RecognitionException {
        WhereClauseContext _localctx = new WhereClauseContext(_ctx, getState());
        enterRule(_localctx, 58, RULE_whereClause);
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(236);
                match(K_WHERE);
                setState(237);
                expr();
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    public final FromExpressionContext fromExpression() throws RecognitionException {
        FromExpressionContext _localctx = new FromExpressionContext(_ctx, getState());
        enterRule(_localctx, 60, RULE_fromExpression);
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(239);
                fromSrc();
                setState(241);
                _errHandler.sync(this);
                switch (getInterpreter().adaptivePredict(_input, 18, _ctx)) {
                    case 1: {
                        setState(240);
                        whereClause();
                    }
                    break;
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    public final FromClauseContext fromClause() throws RecognitionException {
        FromClauseContext _localctx = new FromClauseContext(_ctx, getState());
        enterRule(_localctx, 62, RULE_fromClause);
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(243);
                match(K_FROM);
                setState(244);
                fromExpression();
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    public final SelectClauseContext selectClause() throws RecognitionException {
        SelectClauseContext _localctx = new SelectClauseContext(_ctx, getState());
        enterRule(_localctx, 64, RULE_selectClause);
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(246);
                match(K_SELECT);
                setState(247);
                selectExpr();
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    public final SingleQrySrcContext singleQrySrc() throws RecognitionException {
        SingleQrySrcContext _localctx = new SingleQrySrcContext(_ctx, getState());
        enterRule(_localctx, 66, RULE_singleQrySrc);
        try {
            setState(253);
            _errHandler.sync(this);
            switch (getInterpreter().adaptivePredict(_input, 19, _ctx)) {
                case 1:
                    enterOuterAlt(_localctx, 1);
                {
                    setState(249);
                    fromClause();
                }
                break;
                case 2:
                    enterOuterAlt(_localctx, 2);
                {
                    setState(250);
                    whereClause();
                }
                break;
                case 3:
                    enterOuterAlt(_localctx, 3);
                {
                    setState(251);
                    fromExpression();
                }
                break;
                case 4:
                    enterOuterAlt(_localctx, 4);
                {
                    setState(252);
                    expr();
                }
                break;
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    public final GroupByExpressionContext groupByExpression() throws RecognitionException {
        GroupByExpressionContext _localctx = new GroupByExpressionContext(_ctx, getState());
        enterRule(_localctx, 68, RULE_groupByExpression);
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(255);
                match(K_GROUPBY);
                setState(256);
                match(K_LPAREN);
                setState(257);
                selectExpr();
                setState(258);
                match(K_RPAREN);
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    public final CommaDelimitedQueriesContext commaDelimitedQueries() throws RecognitionException {
        CommaDelimitedQueriesContext _localctx = new CommaDelimitedQueriesContext(_ctx, getState());
        enterRule(_localctx, 70, RULE_commaDelimitedQueries);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(260);
                singleQrySrc();
                setState(265);
                _errHandler.sync(this);
                _la = _input.LA(1);
                while (_la == K_COMMA) {
                    {
                        {
                            setState(261);
                            match(K_COMMA);
                            setState(262);
                            singleQrySrc();
                        }
                    }
                    setState(267);
                    _errHandler.sync(this);
                    _la = _input.LA(1);
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    public final SpaceDelimitedQueriesContext spaceDelimitedQueries() throws RecognitionException {
        SpaceDelimitedQueriesContext _localctx = new SpaceDelimitedQueriesContext(_ctx, getState());
        enterRule(_localctx, 72, RULE_spaceDelimitedQueries);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(268);
                singleQrySrc();
                setState(272);
                _errHandler.sync(this);
                _la = _input.LA(1);
                while ((((_la) & ~0x3f) == 0 && ((1L << _la) & ((1L << NUMBER) | (1L << FLOATING_NUMBER) | (1L << BOOL) | (1L << K_LPAREN) | (1L << K_LBRACKET) | (1L << K_FROM) | (1L << K_WHERE) | (1L << K_MAX) | (1L << K_MIN) | (1L << K_SUM) | (1L << K_COUNT) | (1L << ID))) != 0)) {
                    {
                        {
                            setState(269);
                            singleQrySrc();
                        }
                    }
                    setState(274);
                    _errHandler.sync(this);
                    _la = _input.LA(1);
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    public final QuerySrcContext querySrc() throws RecognitionException {
        QuerySrcContext _localctx = new QuerySrcContext(_ctx, getState());
        enterRule(_localctx, 74, RULE_querySrc);
        try {
            setState(277);
            _errHandler.sync(this);
            switch (getInterpreter().adaptivePredict(_input, 22, _ctx)) {
                case 1:
                    enterOuterAlt(_localctx, 1);
                {
                    setState(275);
                    commaDelimitedQueries();
                }
                break;
                case 2:
                    enterOuterAlt(_localctx, 2);
                {
                    setState(276);
                    spaceDelimitedQueries();
                }
                break;
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    public final QueryContext query() throws RecognitionException {
        QueryContext _localctx = new QueryContext(_ctx, getState());
        enterRule(_localctx, 76, RULE_query);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(279);
                querySrc();
                setState(281);
                _errHandler.sync(this);
                _la = _input.LA(1);
                if (_la == K_GROUPBY) {
                    {
                        setState(280);
                        groupByExpression();
                    }
                }

                setState(284);
                _errHandler.sync(this);
                _la = _input.LA(1);
                if (_la == K_SELECT) {
                    {
                        setState(283);
                        selectClause();
                    }
                }

                setState(287);
                _errHandler.sync(this);
                _la = _input.LA(1);
                if (_la == K_ORDERBY) {
                    {
                        setState(286);
                        orderByExpr();
                    }
                }

                setState(290);
                _errHandler.sync(this);
                _la = _input.LA(1);
                if (_la == K_LIMIT) {
                    {
                        setState(289);
                        limitOffset();
                    }
                }

                setState(292);
                match(EOF);
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    private static String[] makeRuleNames() {
        return new String[] {
                "identifier", "operator", "sortOrder", "valueArray", "literal", "limitClause",
                "offsetClause", "atomE", "multiERight", "multiE", "arithERight", "arithE",
                "comparisonClause", "isClause", "hasTermClause", "hasClause", "countClause",
                "maxClause", "minClause", "sumClause", "exprRight", "compE", "expr",
                "limitOffset", "selectExpression", "selectExpr", "aliasExpr", "orderByExpr",
                "fromSrc", "whereClause", "fromExpression", "fromClause", "selectClause",
                "singleQrySrc", "groupByExpression", "commaDelimitedQueries", "spaceDelimitedQueries",
                "querySrc", "query"
        };
    }

    private static String[] makeLiteralNames() {
        return new String[] {
                null, null, null, null, null, null, null, "','", "'+'", "'-'", "'*'",
                "'/'", "'.'", null, null, null, "'('", "'['", "')'", "']'"
        };
    }

    private static String[] makeSymbolicNames() {
        return new String[] {
                null, "SINGLE_LINE_COMMENT", "MULTILINE_COMMENT", "WS", "NUMBER", "FLOATING_NUMBER",
                "BOOL", "K_COMMA", "K_PLUS", "K_MINUS", "K_STAR", "K_DIV", "K_DOT", "K_LIKE",
                "K_AND", "K_OR", "K_LPAREN", "K_LBRACKET", "K_RPAREN", "K_RBRACKET",
                "K_LT", "K_LTE", "K_EQ", "K_NEQ", "K_GT", "K_GTE", "K_FROM", "K_WHERE",
                "K_ORDERBY", "K_GROUPBY", "K_LIMIT", "K_SELECT", "K_MAX", "K_MIN", "K_SUM",
                "K_COUNT", "K_OFFSET", "K_AS", "K_ISA", "K_IS", "K_HAS", "K_ASC", "K_DESC",
                "K_TRUE", "K_FALSE", "K_HASTERM", "KEYWORD", "ID", "STRING"
        };
    }

    public static class IdentifierContext extends ParserRuleContext {
        public IdentifierContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        public TerminalNode ID() {return getToken(AtlasDSLParser.ID, 0);}

        @Override
        public int getRuleIndex() {return RULE_identifier;}

        @Override
        public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
            if (visitor instanceof AtlasDSLParserVisitor) {
                return ((AtlasDSLParserVisitor<? extends T>) visitor).visitIdentifier(this);
            } else {
                return visitor.visitChildren(this);
            }
        }

        @Override
        public void enterRule(ParseTreeListener listener) {
            if (listener instanceof AtlasDSLParserListener) {
                ((AtlasDSLParserListener) listener).enterIdentifier(this);
            }
        }

        @Override
        public void exitRule(ParseTreeListener listener) {
            if (listener instanceof AtlasDSLParserListener) {
                ((AtlasDSLParserListener) listener).exitIdentifier(this);
            }
        }
    }

    public static class OperatorContext extends ParserRuleContext {
        public OperatorContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        public TerminalNode K_LT()   {return getToken(AtlasDSLParser.K_LT, 0);}

        public TerminalNode K_LTE()  {return getToken(AtlasDSLParser.K_LTE, 0);}

        public TerminalNode K_EQ()   {return getToken(AtlasDSLParser.K_EQ, 0);}

        public TerminalNode K_NEQ()  {return getToken(AtlasDSLParser.K_NEQ, 0);}

        public TerminalNode K_GT()   {return getToken(AtlasDSLParser.K_GT, 0);}

        public TerminalNode K_GTE()  {return getToken(AtlasDSLParser.K_GTE, 0);}

        public TerminalNode K_LIKE() {return getToken(AtlasDSLParser.K_LIKE, 0);}

        @Override
        public int getRuleIndex() {return RULE_operator;}

        @Override
        public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
            if (visitor instanceof AtlasDSLParserVisitor) {
                return ((AtlasDSLParserVisitor<? extends T>) visitor).visitOperator(this);
            } else {
                return visitor.visitChildren(this);
            }
        }

        @Override
        public void enterRule(ParseTreeListener listener) {
            if (listener instanceof AtlasDSLParserListener) {
                ((AtlasDSLParserListener) listener).enterOperator(this);
            }
        }

        @Override
        public void exitRule(ParseTreeListener listener) {
            if (listener instanceof AtlasDSLParserListener) {
                ((AtlasDSLParserListener) listener).exitOperator(this);
            }
        }
    }

    public static class SortOrderContext extends ParserRuleContext {
        public SortOrderContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        public TerminalNode K_ASC()  {return getToken(AtlasDSLParser.K_ASC, 0);}

        public TerminalNode K_DESC() {return getToken(AtlasDSLParser.K_DESC, 0);}

        @Override
        public int getRuleIndex() {return RULE_sortOrder;}

        @Override
        public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
            if (visitor instanceof AtlasDSLParserVisitor) {
                return ((AtlasDSLParserVisitor<? extends T>) visitor).visitSortOrder(this);
            } else {
                return visitor.visitChildren(this);
            }
        }

        @Override
        public void enterRule(ParseTreeListener listener) {
            if (listener instanceof AtlasDSLParserListener) {
                ((AtlasDSLParserListener) listener).enterSortOrder(this);
            }
        }

        @Override
        public void exitRule(ParseTreeListener listener) {
            if (listener instanceof AtlasDSLParserListener) {
                ((AtlasDSLParserListener) listener).exitSortOrder(this);
            }
        }
    }

    public static class ValueArrayContext extends ParserRuleContext {
        public ValueArrayContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        public TerminalNode K_LBRACKET() {return getToken(AtlasDSLParser.K_LBRACKET, 0);}

        public List<TerminalNode> ID()   {return getTokens(AtlasDSLParser.ID);}

        public TerminalNode ID(int i) {
            return getToken(AtlasDSLParser.ID, i);
        }

        public TerminalNode K_RBRACKET()    {return getToken(AtlasDSLParser.K_RBRACKET, 0);}

        public List<TerminalNode> K_COMMA() {return getTokens(AtlasDSLParser.K_COMMA);}

        public TerminalNode K_COMMA(int i) {
            return getToken(AtlasDSLParser.K_COMMA, i);
        }

        @Override
        public int getRuleIndex() {return RULE_valueArray;}

        @Override
        public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
            if (visitor instanceof AtlasDSLParserVisitor) {
                return ((AtlasDSLParserVisitor<? extends T>) visitor).visitValueArray(this);
            } else {
                return visitor.visitChildren(this);
            }
        }

        @Override
        public void enterRule(ParseTreeListener listener) {
            if (listener instanceof AtlasDSLParserListener) {
                ((AtlasDSLParserListener) listener).enterValueArray(this);
            }
        }

        @Override
        public void exitRule(ParseTreeListener listener) {
            if (listener instanceof AtlasDSLParserListener) {
                ((AtlasDSLParserListener) listener).exitValueArray(this);
            }
        }
    }

    public static class LiteralContext extends ParserRuleContext {
        public LiteralContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        public TerminalNode BOOL()            {return getToken(AtlasDSLParser.BOOL, 0);}

        public TerminalNode NUMBER()          {return getToken(AtlasDSLParser.NUMBER, 0);}

        public TerminalNode FLOATING_NUMBER() {return getToken(AtlasDSLParser.FLOATING_NUMBER, 0);}

        public TerminalNode ID()              {return getToken(AtlasDSLParser.ID, 0);}

        public ValueArrayContext valueArray() {
            return getRuleContext(ValueArrayContext.class, 0);
        }

        @Override
        public int getRuleIndex() {return RULE_literal;}

        @Override
        public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
            if (visitor instanceof AtlasDSLParserVisitor) {
                return ((AtlasDSLParserVisitor<? extends T>) visitor).visitLiteral(this);
            } else {
                return visitor.visitChildren(this);
            }
        }

        @Override
        public void enterRule(ParseTreeListener listener) {
            if (listener instanceof AtlasDSLParserListener) {
                ((AtlasDSLParserListener) listener).enterLiteral(this);
            }
        }

        @Override
        public void exitRule(ParseTreeListener listener) {
            if (listener instanceof AtlasDSLParserListener) {
                ((AtlasDSLParserListener) listener).exitLiteral(this);
            }
        }
    }

    public static class LimitClauseContext extends ParserRuleContext {
        public LimitClauseContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        public TerminalNode K_LIMIT() {return getToken(AtlasDSLParser.K_LIMIT, 0);}

        public TerminalNode NUMBER()  {return getToken(AtlasDSLParser.NUMBER, 0);}

        @Override
        public int getRuleIndex() {return RULE_limitClause;}

        @Override
        public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
            if (visitor instanceof AtlasDSLParserVisitor) {
                return ((AtlasDSLParserVisitor<? extends T>) visitor).visitLimitClause(this);
            } else {
                return visitor.visitChildren(this);
            }
        }

        @Override
        public void enterRule(ParseTreeListener listener) {
            if (listener instanceof AtlasDSLParserListener) {
                ((AtlasDSLParserListener) listener).enterLimitClause(this);
            }
        }

        @Override
        public void exitRule(ParseTreeListener listener) {
            if (listener instanceof AtlasDSLParserListener) {
                ((AtlasDSLParserListener) listener).exitLimitClause(this);
            }
        }
    }

    public static class OffsetClauseContext extends ParserRuleContext {
        public OffsetClauseContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        public TerminalNode K_OFFSET() {return getToken(AtlasDSLParser.K_OFFSET, 0);}

        public TerminalNode NUMBER()   {return getToken(AtlasDSLParser.NUMBER, 0);}

        @Override
        public int getRuleIndex() {return RULE_offsetClause;}

        @Override
        public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
            if (visitor instanceof AtlasDSLParserVisitor) {
                return ((AtlasDSLParserVisitor<? extends T>) visitor).visitOffsetClause(this);
            } else {
                return visitor.visitChildren(this);
            }
        }

        @Override
        public void enterRule(ParseTreeListener listener) {
            if (listener instanceof AtlasDSLParserListener) {
                ((AtlasDSLParserListener) listener).enterOffsetClause(this);
            }
        }

        @Override
        public void exitRule(ParseTreeListener listener) {
            if (listener instanceof AtlasDSLParserListener) {
                ((AtlasDSLParserListener) listener).exitOffsetClause(this);
            }
        }
    }

    public static class AtomEContext extends ParserRuleContext {
        public AtomEContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        public IdentifierContext identifier() {
            return getRuleContext(IdentifierContext.class, 0);
        }

        public LiteralContext literal() {
            return getRuleContext(LiteralContext.class, 0);
        }

        public TerminalNode K_LPAREN() {return getToken(AtlasDSLParser.K_LPAREN, 0);}

        public ExprContext expr() {
            return getRuleContext(ExprContext.class, 0);
        }

        public TerminalNode K_RPAREN() {return getToken(AtlasDSLParser.K_RPAREN, 0);}

        @Override
        public int getRuleIndex() {return RULE_atomE;}

        @Override
        public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
            if (visitor instanceof AtlasDSLParserVisitor) {
                return ((AtlasDSLParserVisitor<? extends T>) visitor).visitAtomE(this);
            } else {
                return visitor.visitChildren(this);
            }
        }

        @Override
        public void enterRule(ParseTreeListener listener) {
            if (listener instanceof AtlasDSLParserListener) {
                ((AtlasDSLParserListener) listener).enterAtomE(this);
            }
        }

        @Override
        public void exitRule(ParseTreeListener listener) {
            if (listener instanceof AtlasDSLParserListener) {
                ((AtlasDSLParserListener) listener).exitAtomE(this);
            }
        }
    }

    public static class MultiERightContext extends ParserRuleContext {
        public MultiERightContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        public AtomEContext atomE() {
            return getRuleContext(AtomEContext.class, 0);
        }

        public TerminalNode K_STAR() {return getToken(AtlasDSLParser.K_STAR, 0);}

        public TerminalNode K_DIV()  {return getToken(AtlasDSLParser.K_DIV, 0);}

        @Override
        public int getRuleIndex() {return RULE_multiERight;}

        @Override
        public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
            if (visitor instanceof AtlasDSLParserVisitor) {
                return ((AtlasDSLParserVisitor<? extends T>) visitor).visitMultiERight(this);
            } else {
                return visitor.visitChildren(this);
            }
        }

        @Override
        public void enterRule(ParseTreeListener listener) {
            if (listener instanceof AtlasDSLParserListener) {
                ((AtlasDSLParserListener) listener).enterMultiERight(this);
            }
        }

        @Override
        public void exitRule(ParseTreeListener listener) {
            if (listener instanceof AtlasDSLParserListener) {
                ((AtlasDSLParserListener) listener).exitMultiERight(this);
            }
        }
    }

    public static class MultiEContext extends ParserRuleContext {
        public MultiEContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        public AtomEContext atomE() {
            return getRuleContext(AtomEContext.class, 0);
        }

        public List<MultiERightContext> multiERight() {
            return getRuleContexts(MultiERightContext.class);
        }

        public MultiERightContext multiERight(int i) {
            return getRuleContext(MultiERightContext.class, i);
        }

        @Override
        public int getRuleIndex() {return RULE_multiE;}

        @Override
        public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
            if (visitor instanceof AtlasDSLParserVisitor) {
                return ((AtlasDSLParserVisitor<? extends T>) visitor).visitMultiE(this);
            } else {
                return visitor.visitChildren(this);
            }
        }

        @Override
        public void enterRule(ParseTreeListener listener) {
            if (listener instanceof AtlasDSLParserListener) {
                ((AtlasDSLParserListener) listener).enterMultiE(this);
            }
        }

        @Override
        public void exitRule(ParseTreeListener listener) {
            if (listener instanceof AtlasDSLParserListener) {
                ((AtlasDSLParserListener) listener).exitMultiE(this);
            }
        }
    }

    public static class ArithERightContext extends ParserRuleContext {
        public ArithERightContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        public MultiEContext multiE() {
            return getRuleContext(MultiEContext.class, 0);
        }

        public TerminalNode K_PLUS()  {return getToken(AtlasDSLParser.K_PLUS, 0);}

        public TerminalNode K_MINUS() {return getToken(AtlasDSLParser.K_MINUS, 0);}

        @Override
        public int getRuleIndex() {return RULE_arithERight;}

        @Override
        public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
            if (visitor instanceof AtlasDSLParserVisitor) {
                return ((AtlasDSLParserVisitor<? extends T>) visitor).visitArithERight(this);
            } else {
                return visitor.visitChildren(this);
            }
        }

        @Override
        public void enterRule(ParseTreeListener listener) {
            if (listener instanceof AtlasDSLParserListener) {
                ((AtlasDSLParserListener) listener).enterArithERight(this);
            }
        }

        @Override
        public void exitRule(ParseTreeListener listener) {
            if (listener instanceof AtlasDSLParserListener) {
                ((AtlasDSLParserListener) listener).exitArithERight(this);
            }
        }
    }

    public static class ArithEContext extends ParserRuleContext {
        public ArithEContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        public MultiEContext multiE() {
            return getRuleContext(MultiEContext.class, 0);
        }

        public List<ArithERightContext> arithERight() {
            return getRuleContexts(ArithERightContext.class);
        }

        public ArithERightContext arithERight(int i) {
            return getRuleContext(ArithERightContext.class, i);
        }

        @Override
        public int getRuleIndex() {return RULE_arithE;}

        @Override
        public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
            if (visitor instanceof AtlasDSLParserVisitor) {
                return ((AtlasDSLParserVisitor<? extends T>) visitor).visitArithE(this);
            } else {
                return visitor.visitChildren(this);
            }
        }

        @Override
        public void enterRule(ParseTreeListener listener) {
            if (listener instanceof AtlasDSLParserListener) {
                ((AtlasDSLParserListener) listener).enterArithE(this);
            }
        }

        @Override
        public void exitRule(ParseTreeListener listener) {
            if (listener instanceof AtlasDSLParserListener) {
                ((AtlasDSLParserListener) listener).exitArithE(this);
            }
        }
    }

    public static class ComparisonClauseContext extends ParserRuleContext {
        public ComparisonClauseContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        public List<ArithEContext> arithE() {
            return getRuleContexts(ArithEContext.class);
        }

        public ArithEContext arithE(int i) {
            return getRuleContext(ArithEContext.class, i);
        }

        public OperatorContext operator() {
            return getRuleContext(OperatorContext.class, 0);
        }

        @Override
        public int getRuleIndex() {return RULE_comparisonClause;}

        @Override
        public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
            if (visitor instanceof AtlasDSLParserVisitor) {
                return ((AtlasDSLParserVisitor<? extends T>) visitor).visitComparisonClause(this);
            } else {
                return visitor.visitChildren(this);
            }
        }

        @Override
        public void enterRule(ParseTreeListener listener) {
            if (listener instanceof AtlasDSLParserListener) {
                ((AtlasDSLParserListener) listener).enterComparisonClause(this);
            }
        }

        @Override
        public void exitRule(ParseTreeListener listener) {
            if (listener instanceof AtlasDSLParserListener) {
                ((AtlasDSLParserListener) listener).exitComparisonClause(this);
            }
        }
    }

    public static class IsClauseContext extends ParserRuleContext {
        public IsClauseContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        public ArithEContext arithE() {
            return getRuleContext(ArithEContext.class, 0);
        }

        public TerminalNode K_ISA() {return getToken(AtlasDSLParser.K_ISA, 0);}

        public TerminalNode K_IS()  {return getToken(AtlasDSLParser.K_IS, 0);}

        public IdentifierContext identifier() {
            return getRuleContext(IdentifierContext.class, 0);
        }

        public ExprContext expr() {
            return getRuleContext(ExprContext.class, 0);
        }

        @Override
        public int getRuleIndex() {return RULE_isClause;}

        @Override
        public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
            if (visitor instanceof AtlasDSLParserVisitor) {
                return ((AtlasDSLParserVisitor<? extends T>) visitor).visitIsClause(this);
            } else {
                return visitor.visitChildren(this);
            }
        }

        @Override
        public void enterRule(ParseTreeListener listener) {
            if (listener instanceof AtlasDSLParserListener) {
                ((AtlasDSLParserListener) listener).enterIsClause(this);
            }
        }

        @Override
        public void exitRule(ParseTreeListener listener) {
            if (listener instanceof AtlasDSLParserListener) {
                ((AtlasDSLParserListener) listener).exitIsClause(this);
            }
        }
    }

    public static class HasTermClauseContext extends ParserRuleContext {
        public HasTermClauseContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        public ArithEContext arithE() {
            return getRuleContext(ArithEContext.class, 0);
        }

        public TerminalNode K_HASTERM() {return getToken(AtlasDSLParser.K_HASTERM, 0);}

        public IdentifierContext identifier() {
            return getRuleContext(IdentifierContext.class, 0);
        }

        public ExprContext expr() {
            return getRuleContext(ExprContext.class, 0);
        }

        @Override
        public int getRuleIndex() {return RULE_hasTermClause;}

        @Override
        public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
            if (visitor instanceof AtlasDSLParserVisitor) {
                return ((AtlasDSLParserVisitor<? extends T>) visitor).visitHasTermClause(this);
            } else {
                return visitor.visitChildren(this);
            }
        }

        @Override
        public void enterRule(ParseTreeListener listener) {
            if (listener instanceof AtlasDSLParserListener) {
                ((AtlasDSLParserListener) listener).enterHasTermClause(this);
            }
        }

        @Override
        public void exitRule(ParseTreeListener listener) {
            if (listener instanceof AtlasDSLParserListener) {
                ((AtlasDSLParserListener) listener).exitHasTermClause(this);
            }
        }
    }

    public static class HasClauseContext extends ParserRuleContext {
        public HasClauseContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        public ArithEContext arithE() {
            return getRuleContext(ArithEContext.class, 0);
        }

        public TerminalNode K_HAS() {return getToken(AtlasDSLParser.K_HAS, 0);}

        public IdentifierContext identifier() {
            return getRuleContext(IdentifierContext.class, 0);
        }

        @Override
        public int getRuleIndex() {return RULE_hasClause;}

        @Override
        public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
            if (visitor instanceof AtlasDSLParserVisitor) {
                return ((AtlasDSLParserVisitor<? extends T>) visitor).visitHasClause(this);
            } else {
                return visitor.visitChildren(this);
            }
        }

        @Override
        public void enterRule(ParseTreeListener listener) {
            if (listener instanceof AtlasDSLParserListener) {
                ((AtlasDSLParserListener) listener).enterHasClause(this);
            }
        }

        @Override
        public void exitRule(ParseTreeListener listener) {
            if (listener instanceof AtlasDSLParserListener) {
                ((AtlasDSLParserListener) listener).exitHasClause(this);
            }
        }
    }

    public static class CountClauseContext extends ParserRuleContext {
        public CountClauseContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        public TerminalNode K_COUNT()  {return getToken(AtlasDSLParser.K_COUNT, 0);}

        public TerminalNode K_LPAREN() {return getToken(AtlasDSLParser.K_LPAREN, 0);}

        public TerminalNode K_RPAREN() {return getToken(AtlasDSLParser.K_RPAREN, 0);}

        @Override
        public int getRuleIndex() {return RULE_countClause;}

        @Override
        public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
            if (visitor instanceof AtlasDSLParserVisitor) {
                return ((AtlasDSLParserVisitor<? extends T>) visitor).visitCountClause(this);
            } else {
                return visitor.visitChildren(this);
            }
        }

        @Override
        public void enterRule(ParseTreeListener listener) {
            if (listener instanceof AtlasDSLParserListener) {
                ((AtlasDSLParserListener) listener).enterCountClause(this);
            }
        }

        @Override
        public void exitRule(ParseTreeListener listener) {
            if (listener instanceof AtlasDSLParserListener) {
                ((AtlasDSLParserListener) listener).exitCountClause(this);
            }
        }
    }

    public static class MaxClauseContext extends ParserRuleContext {
        public MaxClauseContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        public TerminalNode K_MAX()    {return getToken(AtlasDSLParser.K_MAX, 0);}

        public TerminalNode K_LPAREN() {return getToken(AtlasDSLParser.K_LPAREN, 0);}

        public ExprContext expr() {
            return getRuleContext(ExprContext.class, 0);
        }

        public TerminalNode K_RPAREN() {return getToken(AtlasDSLParser.K_RPAREN, 0);}

        @Override
        public int getRuleIndex() {return RULE_maxClause;}

        @Override
        public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
            if (visitor instanceof AtlasDSLParserVisitor) {
                return ((AtlasDSLParserVisitor<? extends T>) visitor).visitMaxClause(this);
            } else {
                return visitor.visitChildren(this);
            }
        }

        @Override
        public void enterRule(ParseTreeListener listener) {
            if (listener instanceof AtlasDSLParserListener) {
                ((AtlasDSLParserListener) listener).enterMaxClause(this);
            }
        }

        @Override
        public void exitRule(ParseTreeListener listener) {
            if (listener instanceof AtlasDSLParserListener) {
                ((AtlasDSLParserListener) listener).exitMaxClause(this);
            }
        }
    }

    public static class MinClauseContext extends ParserRuleContext {
        public MinClauseContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        public TerminalNode K_MIN()    {return getToken(AtlasDSLParser.K_MIN, 0);}

        public TerminalNode K_LPAREN() {return getToken(AtlasDSLParser.K_LPAREN, 0);}

        public ExprContext expr() {
            return getRuleContext(ExprContext.class, 0);
        }

        public TerminalNode K_RPAREN() {return getToken(AtlasDSLParser.K_RPAREN, 0);}

        @Override
        public int getRuleIndex() {return RULE_minClause;}

        @Override
        public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
            if (visitor instanceof AtlasDSLParserVisitor) {
                return ((AtlasDSLParserVisitor<? extends T>) visitor).visitMinClause(this);
            } else {
                return visitor.visitChildren(this);
            }
        }

        @Override
        public void enterRule(ParseTreeListener listener) {
            if (listener instanceof AtlasDSLParserListener) {
                ((AtlasDSLParserListener) listener).enterMinClause(this);
            }
        }

        @Override
        public void exitRule(ParseTreeListener listener) {
            if (listener instanceof AtlasDSLParserListener) {
                ((AtlasDSLParserListener) listener).exitMinClause(this);
            }
        }
    }

    public static class SumClauseContext extends ParserRuleContext {
        public SumClauseContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        public TerminalNode K_SUM()    {return getToken(AtlasDSLParser.K_SUM, 0);}

        public TerminalNode K_LPAREN() {return getToken(AtlasDSLParser.K_LPAREN, 0);}

        public ExprContext expr() {
            return getRuleContext(ExprContext.class, 0);
        }

        public TerminalNode K_RPAREN() {return getToken(AtlasDSLParser.K_RPAREN, 0);}

        @Override
        public int getRuleIndex() {return RULE_sumClause;}

        @Override
        public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
            if (visitor instanceof AtlasDSLParserVisitor) {
                return ((AtlasDSLParserVisitor<? extends T>) visitor).visitSumClause(this);
            } else {
                return visitor.visitChildren(this);
            }
        }

        @Override
        public void enterRule(ParseTreeListener listener) {
            if (listener instanceof AtlasDSLParserListener) {
                ((AtlasDSLParserListener) listener).enterSumClause(this);
            }
        }

        @Override
        public void exitRule(ParseTreeListener listener) {
            if (listener instanceof AtlasDSLParserListener) {
                ((AtlasDSLParserListener) listener).exitSumClause(this);
            }
        }
    }

    public static class ExprRightContext extends ParserRuleContext {
        public ExprRightContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        public CompEContext compE() {
            return getRuleContext(CompEContext.class, 0);
        }

        public TerminalNode K_AND() {return getToken(AtlasDSLParser.K_AND, 0);}

        public TerminalNode K_OR()  {return getToken(AtlasDSLParser.K_OR, 0);}

        @Override
        public int getRuleIndex() {return RULE_exprRight;}

        @Override
        public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
            if (visitor instanceof AtlasDSLParserVisitor) {
                return ((AtlasDSLParserVisitor<? extends T>) visitor).visitExprRight(this);
            } else {
                return visitor.visitChildren(this);
            }
        }

        @Override
        public void enterRule(ParseTreeListener listener) {
            if (listener instanceof AtlasDSLParserListener) {
                ((AtlasDSLParserListener) listener).enterExprRight(this);
            }
        }

        @Override
        public void exitRule(ParseTreeListener listener) {
            if (listener instanceof AtlasDSLParserListener) {
                ((AtlasDSLParserListener) listener).exitExprRight(this);
            }
        }
    }

    public static class CompEContext extends ParserRuleContext {
        public CompEContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        public ComparisonClauseContext comparisonClause() {
            return getRuleContext(ComparisonClauseContext.class, 0);
        }

        public IsClauseContext isClause() {
            return getRuleContext(IsClauseContext.class, 0);
        }

        public HasClauseContext hasClause() {
            return getRuleContext(HasClauseContext.class, 0);
        }

        public ArithEContext arithE() {
            return getRuleContext(ArithEContext.class, 0);
        }

        public CountClauseContext countClause() {
            return getRuleContext(CountClauseContext.class, 0);
        }

        public MaxClauseContext maxClause() {
            return getRuleContext(MaxClauseContext.class, 0);
        }

        public MinClauseContext minClause() {
            return getRuleContext(MinClauseContext.class, 0);
        }

        public SumClauseContext sumClause() {
            return getRuleContext(SumClauseContext.class, 0);
        }

        public HasTermClauseContext hasTermClause() {
            return getRuleContext(HasTermClauseContext.class, 0);
        }

        @Override
        public int getRuleIndex() {return RULE_compE;}

        @Override
        public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
            if (visitor instanceof AtlasDSLParserVisitor) {
                return ((AtlasDSLParserVisitor<? extends T>) visitor).visitCompE(this);
            } else {
                return visitor.visitChildren(this);
            }
        }

        @Override
        public void enterRule(ParseTreeListener listener) {
            if (listener instanceof AtlasDSLParserListener) {
                ((AtlasDSLParserListener) listener).enterCompE(this);
            }
        }

        @Override
        public void exitRule(ParseTreeListener listener) {
            if (listener instanceof AtlasDSLParserListener) {
                ((AtlasDSLParserListener) listener).exitCompE(this);
            }
        }
    }

    public static class ExprContext extends ParserRuleContext {
        public ExprContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        public CompEContext compE() {
            return getRuleContext(CompEContext.class, 0);
        }

        public List<ExprRightContext> exprRight() {
            return getRuleContexts(ExprRightContext.class);
        }

        public ExprRightContext exprRight(int i) {
            return getRuleContext(ExprRightContext.class, i);
        }

        @Override
        public int getRuleIndex() {return RULE_expr;}

        @Override
        public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
            if (visitor instanceof AtlasDSLParserVisitor) {
                return ((AtlasDSLParserVisitor<? extends T>) visitor).visitExpr(this);
            } else {
                return visitor.visitChildren(this);
            }
        }

        @Override
        public void enterRule(ParseTreeListener listener) {
            if (listener instanceof AtlasDSLParserListener) {
                ((AtlasDSLParserListener) listener).enterExpr(this);
            }
        }

        @Override
        public void exitRule(ParseTreeListener listener) {
            if (listener instanceof AtlasDSLParserListener) {
                ((AtlasDSLParserListener) listener).exitExpr(this);
            }
        }
    }

    public static class LimitOffsetContext extends ParserRuleContext {
        public LimitOffsetContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        public LimitClauseContext limitClause() {
            return getRuleContext(LimitClauseContext.class, 0);
        }

        public OffsetClauseContext offsetClause() {
            return getRuleContext(OffsetClauseContext.class, 0);
        }

        @Override
        public int getRuleIndex() {return RULE_limitOffset;}

        @Override
        public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
            if (visitor instanceof AtlasDSLParserVisitor) {
                return ((AtlasDSLParserVisitor<? extends T>) visitor).visitLimitOffset(this);
            } else {
                return visitor.visitChildren(this);
            }
        }

        @Override
        public void enterRule(ParseTreeListener listener) {
            if (listener instanceof AtlasDSLParserListener) {
                ((AtlasDSLParserListener) listener).enterLimitOffset(this);
            }
        }

        @Override
        public void exitRule(ParseTreeListener listener) {
            if (listener instanceof AtlasDSLParserListener) {
                ((AtlasDSLParserListener) listener).exitLimitOffset(this);
            }
        }
    }

    public static class SelectExpressionContext extends ParserRuleContext {
        public SelectExpressionContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        public ExprContext expr() {
            return getRuleContext(ExprContext.class, 0);
        }

        public TerminalNode K_AS() {return getToken(AtlasDSLParser.K_AS, 0);}

        public IdentifierContext identifier() {
            return getRuleContext(IdentifierContext.class, 0);
        }

        @Override
        public int getRuleIndex() {return RULE_selectExpression;}

        @Override
        public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
            if (visitor instanceof AtlasDSLParserVisitor) {
                return ((AtlasDSLParserVisitor<? extends T>) visitor).visitSelectExpression(this);
            } else {
                return visitor.visitChildren(this);
            }
        }

        @Override
        public void enterRule(ParseTreeListener listener) {
            if (listener instanceof AtlasDSLParserListener) {
                ((AtlasDSLParserListener) listener).enterSelectExpression(this);
            }
        }

        @Override
        public void exitRule(ParseTreeListener listener) {
            if (listener instanceof AtlasDSLParserListener) {
                ((AtlasDSLParserListener) listener).exitSelectExpression(this);
            }
        }
    }

    public static class SelectExprContext extends ParserRuleContext {
        public SelectExprContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        public List<SelectExpressionContext> selectExpression() {
            return getRuleContexts(SelectExpressionContext.class);
        }

        public SelectExpressionContext selectExpression(int i) {
            return getRuleContext(SelectExpressionContext.class, i);
        }

        public List<TerminalNode> K_COMMA() {return getTokens(AtlasDSLParser.K_COMMA);}

        public TerminalNode K_COMMA(int i) {
            return getToken(AtlasDSLParser.K_COMMA, i);
        }

        @Override
        public int getRuleIndex() {return RULE_selectExpr;}

        @Override
        public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
            if (visitor instanceof AtlasDSLParserVisitor) {
                return ((AtlasDSLParserVisitor<? extends T>) visitor).visitSelectExpr(this);
            } else {
                return visitor.visitChildren(this);
            }
        }

        @Override
        public void enterRule(ParseTreeListener listener) {
            if (listener instanceof AtlasDSLParserListener) {
                ((AtlasDSLParserListener) listener).enterSelectExpr(this);
            }
        }

        @Override
        public void exitRule(ParseTreeListener listener) {
            if (listener instanceof AtlasDSLParserListener) {
                ((AtlasDSLParserListener) listener).exitSelectExpr(this);
            }
        }
    }

    public static class AliasExprContext extends ParserRuleContext {
        public AliasExprContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        public TerminalNode K_AS() {return getToken(AtlasDSLParser.K_AS, 0);}

        public List<IdentifierContext> identifier() {
            return getRuleContexts(IdentifierContext.class);
        }

        public IdentifierContext identifier(int i) {
            return getRuleContext(IdentifierContext.class, i);
        }

        public LiteralContext literal() {
            return getRuleContext(LiteralContext.class, 0);
        }

        @Override
        public int getRuleIndex() {return RULE_aliasExpr;}

        @Override
        public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
            if (visitor instanceof AtlasDSLParserVisitor) {
                return ((AtlasDSLParserVisitor<? extends T>) visitor).visitAliasExpr(this);
            } else {
                return visitor.visitChildren(this);
            }
        }

        @Override
        public void enterRule(ParseTreeListener listener) {
            if (listener instanceof AtlasDSLParserListener) {
                ((AtlasDSLParserListener) listener).enterAliasExpr(this);
            }
        }

        @Override
        public void exitRule(ParseTreeListener listener) {
            if (listener instanceof AtlasDSLParserListener) {
                ((AtlasDSLParserListener) listener).exitAliasExpr(this);
            }
        }
    }

    public static class OrderByExprContext extends ParserRuleContext {
        public OrderByExprContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        public TerminalNode K_ORDERBY() {return getToken(AtlasDSLParser.K_ORDERBY, 0);}

        public ExprContext expr() {
            return getRuleContext(ExprContext.class, 0);
        }

        public SortOrderContext sortOrder() {
            return getRuleContext(SortOrderContext.class, 0);
        }

        @Override
        public int getRuleIndex() {return RULE_orderByExpr;}

        @Override
        public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
            if (visitor instanceof AtlasDSLParserVisitor) {
                return ((AtlasDSLParserVisitor<? extends T>) visitor).visitOrderByExpr(this);
            } else {
                return visitor.visitChildren(this);
            }
        }

        @Override
        public void enterRule(ParseTreeListener listener) {
            if (listener instanceof AtlasDSLParserListener) {
                ((AtlasDSLParserListener) listener).enterOrderByExpr(this);
            }
        }

        @Override
        public void exitRule(ParseTreeListener listener) {
            if (listener instanceof AtlasDSLParserListener) {
                ((AtlasDSLParserListener) listener).exitOrderByExpr(this);
            }
        }
    }

    public static class FromSrcContext extends ParserRuleContext {
        public FromSrcContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        public AliasExprContext aliasExpr() {
            return getRuleContext(AliasExprContext.class, 0);
        }

        public IdentifierContext identifier() {
            return getRuleContext(IdentifierContext.class, 0);
        }

        public LiteralContext literal() {
            return getRuleContext(LiteralContext.class, 0);
        }

        @Override
        public int getRuleIndex() {return RULE_fromSrc;}

        @Override
        public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
            if (visitor instanceof AtlasDSLParserVisitor) {
                return ((AtlasDSLParserVisitor<? extends T>) visitor).visitFromSrc(this);
            } else {
                return visitor.visitChildren(this);
            }
        }

        @Override
        public void enterRule(ParseTreeListener listener) {
            if (listener instanceof AtlasDSLParserListener) {
                ((AtlasDSLParserListener) listener).enterFromSrc(this);
            }
        }

        @Override
        public void exitRule(ParseTreeListener listener) {
            if (listener instanceof AtlasDSLParserListener) {
                ((AtlasDSLParserListener) listener).exitFromSrc(this);
            }
        }
    }

    public static class WhereClauseContext extends ParserRuleContext {
        public WhereClauseContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        public TerminalNode K_WHERE() {return getToken(AtlasDSLParser.K_WHERE, 0);}

        public ExprContext expr() {
            return getRuleContext(ExprContext.class, 0);
        }

        @Override
        public int getRuleIndex() {return RULE_whereClause;}

        @Override
        public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
            if (visitor instanceof AtlasDSLParserVisitor) {
                return ((AtlasDSLParserVisitor<? extends T>) visitor).visitWhereClause(this);
            } else {
                return visitor.visitChildren(this);
            }
        }

        @Override
        public void enterRule(ParseTreeListener listener) {
            if (listener instanceof AtlasDSLParserListener) {
                ((AtlasDSLParserListener) listener).enterWhereClause(this);
            }
        }

        @Override
        public void exitRule(ParseTreeListener listener) {
            if (listener instanceof AtlasDSLParserListener) {
                ((AtlasDSLParserListener) listener).exitWhereClause(this);
            }
        }
    }

    public static class FromExpressionContext extends ParserRuleContext {
        public FromExpressionContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        public FromSrcContext fromSrc() {
            return getRuleContext(FromSrcContext.class, 0);
        }

        public WhereClauseContext whereClause() {
            return getRuleContext(WhereClauseContext.class, 0);
        }

        @Override
        public int getRuleIndex() {return RULE_fromExpression;}

        @Override
        public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
            if (visitor instanceof AtlasDSLParserVisitor) {
                return ((AtlasDSLParserVisitor<? extends T>) visitor).visitFromExpression(this);
            } else {
                return visitor.visitChildren(this);
            }
        }

        @Override
        public void enterRule(ParseTreeListener listener) {
            if (listener instanceof AtlasDSLParserListener) {
                ((AtlasDSLParserListener) listener).enterFromExpression(this);
            }
        }

        @Override
        public void exitRule(ParseTreeListener listener) {
            if (listener instanceof AtlasDSLParserListener) {
                ((AtlasDSLParserListener) listener).exitFromExpression(this);
            }
        }
    }

    public static class FromClauseContext extends ParserRuleContext {
        public FromClauseContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        public TerminalNode K_FROM() {return getToken(AtlasDSLParser.K_FROM, 0);}

        public FromExpressionContext fromExpression() {
            return getRuleContext(FromExpressionContext.class, 0);
        }

        @Override
        public int getRuleIndex() {return RULE_fromClause;}

        @Override
        public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
            if (visitor instanceof AtlasDSLParserVisitor) {
                return ((AtlasDSLParserVisitor<? extends T>) visitor).visitFromClause(this);
            } else {
                return visitor.visitChildren(this);
            }
        }

        @Override
        public void enterRule(ParseTreeListener listener) {
            if (listener instanceof AtlasDSLParserListener) {
                ((AtlasDSLParserListener) listener).enterFromClause(this);
            }
        }

        @Override
        public void exitRule(ParseTreeListener listener) {
            if (listener instanceof AtlasDSLParserListener) {
                ((AtlasDSLParserListener) listener).exitFromClause(this);
            }
        }
    }

    public static class SelectClauseContext extends ParserRuleContext {
        public SelectClauseContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        public TerminalNode K_SELECT() {return getToken(AtlasDSLParser.K_SELECT, 0);}

        public SelectExprContext selectExpr() {
            return getRuleContext(SelectExprContext.class, 0);
        }

        @Override
        public int getRuleIndex() {return RULE_selectClause;}

        @Override
        public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
            if (visitor instanceof AtlasDSLParserVisitor) {
                return ((AtlasDSLParserVisitor<? extends T>) visitor).visitSelectClause(this);
            } else {
                return visitor.visitChildren(this);
            }
        }

        @Override
        public void enterRule(ParseTreeListener listener) {
            if (listener instanceof AtlasDSLParserListener) {
                ((AtlasDSLParserListener) listener).enterSelectClause(this);
            }
        }

        @Override
        public void exitRule(ParseTreeListener listener) {
            if (listener instanceof AtlasDSLParserListener) {
                ((AtlasDSLParserListener) listener).exitSelectClause(this);
            }
        }
    }

    public static class SingleQrySrcContext extends ParserRuleContext {
        public SingleQrySrcContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        public FromClauseContext fromClause() {
            return getRuleContext(FromClauseContext.class, 0);
        }

        public WhereClauseContext whereClause() {
            return getRuleContext(WhereClauseContext.class, 0);
        }

        public FromExpressionContext fromExpression() {
            return getRuleContext(FromExpressionContext.class, 0);
        }

        public ExprContext expr() {
            return getRuleContext(ExprContext.class, 0);
        }

        @Override
        public int getRuleIndex() {return RULE_singleQrySrc;}

        @Override
        public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
            if (visitor instanceof AtlasDSLParserVisitor) {
                return ((AtlasDSLParserVisitor<? extends T>) visitor).visitSingleQrySrc(this);
            } else {
                return visitor.visitChildren(this);
            }
        }

        @Override
        public void enterRule(ParseTreeListener listener) {
            if (listener instanceof AtlasDSLParserListener) {
                ((AtlasDSLParserListener) listener).enterSingleQrySrc(this);
            }
        }

        @Override
        public void exitRule(ParseTreeListener listener) {
            if (listener instanceof AtlasDSLParserListener) {
                ((AtlasDSLParserListener) listener).exitSingleQrySrc(this);
            }
        }
    }

    public static class GroupByExpressionContext extends ParserRuleContext {
        public GroupByExpressionContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        public TerminalNode K_GROUPBY() {return getToken(AtlasDSLParser.K_GROUPBY, 0);}

        public TerminalNode K_LPAREN()  {return getToken(AtlasDSLParser.K_LPAREN, 0);}

        public SelectExprContext selectExpr() {
            return getRuleContext(SelectExprContext.class, 0);
        }

        public TerminalNode K_RPAREN() {return getToken(AtlasDSLParser.K_RPAREN, 0);}

        @Override
        public int getRuleIndex() {return RULE_groupByExpression;}

        @Override
        public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
            if (visitor instanceof AtlasDSLParserVisitor) {
                return ((AtlasDSLParserVisitor<? extends T>) visitor).visitGroupByExpression(this);
            } else {
                return visitor.visitChildren(this);
            }
        }

        @Override
        public void enterRule(ParseTreeListener listener) {
            if (listener instanceof AtlasDSLParserListener) {
                ((AtlasDSLParserListener) listener).enterGroupByExpression(this);
            }
        }

        @Override
        public void exitRule(ParseTreeListener listener) {
            if (listener instanceof AtlasDSLParserListener) {
                ((AtlasDSLParserListener) listener).exitGroupByExpression(this);
            }
        }
    }

    public static class CommaDelimitedQueriesContext extends ParserRuleContext {
        public CommaDelimitedQueriesContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        public List<SingleQrySrcContext> singleQrySrc() {
            return getRuleContexts(SingleQrySrcContext.class);
        }

        public SingleQrySrcContext singleQrySrc(int i) {
            return getRuleContext(SingleQrySrcContext.class, i);
        }

        public List<TerminalNode> K_COMMA() {return getTokens(AtlasDSLParser.K_COMMA);}

        public TerminalNode K_COMMA(int i) {
            return getToken(AtlasDSLParser.K_COMMA, i);
        }

        @Override
        public int getRuleIndex() {return RULE_commaDelimitedQueries;}

        @Override
        public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
            if (visitor instanceof AtlasDSLParserVisitor) {
                return ((AtlasDSLParserVisitor<? extends T>) visitor).visitCommaDelimitedQueries(this);
            } else {
                return visitor.visitChildren(this);
            }
        }

        @Override
        public void enterRule(ParseTreeListener listener) {
            if (listener instanceof AtlasDSLParserListener) {
                ((AtlasDSLParserListener) listener).enterCommaDelimitedQueries(this);
            }
        }

        @Override
        public void exitRule(ParseTreeListener listener) {
            if (listener instanceof AtlasDSLParserListener) {
                ((AtlasDSLParserListener) listener).exitCommaDelimitedQueries(this);
            }
        }
    }

    public static class SpaceDelimitedQueriesContext extends ParserRuleContext {
        public SpaceDelimitedQueriesContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        public List<SingleQrySrcContext> singleQrySrc() {
            return getRuleContexts(SingleQrySrcContext.class);
        }

        public SingleQrySrcContext singleQrySrc(int i) {
            return getRuleContext(SingleQrySrcContext.class, i);
        }

        @Override
        public int getRuleIndex() {return RULE_spaceDelimitedQueries;}

        @Override
        public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
            if (visitor instanceof AtlasDSLParserVisitor) {
                return ((AtlasDSLParserVisitor<? extends T>) visitor).visitSpaceDelimitedQueries(this);
            } else {
                return visitor.visitChildren(this);
            }
        }

        @Override
        public void enterRule(ParseTreeListener listener) {
            if (listener instanceof AtlasDSLParserListener) {
                ((AtlasDSLParserListener) listener).enterSpaceDelimitedQueries(this);
            }
        }

        @Override
        public void exitRule(ParseTreeListener listener) {
            if (listener instanceof AtlasDSLParserListener) {
                ((AtlasDSLParserListener) listener).exitSpaceDelimitedQueries(this);
            }
        }
    }

    public static class QuerySrcContext extends ParserRuleContext {
        public QuerySrcContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        public CommaDelimitedQueriesContext commaDelimitedQueries() {
            return getRuleContext(CommaDelimitedQueriesContext.class, 0);
        }

        public SpaceDelimitedQueriesContext spaceDelimitedQueries() {
            return getRuleContext(SpaceDelimitedQueriesContext.class, 0);
        }

        @Override
        public int getRuleIndex() {return RULE_querySrc;}

        @Override
        public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
            if (visitor instanceof AtlasDSLParserVisitor) {
                return ((AtlasDSLParserVisitor<? extends T>) visitor).visitQuerySrc(this);
            } else {
                return visitor.visitChildren(this);
            }
        }

        @Override
        public void enterRule(ParseTreeListener listener) {
            if (listener instanceof AtlasDSLParserListener) {
                ((AtlasDSLParserListener) listener).enterQuerySrc(this);
            }
        }

        @Override
        public void exitRule(ParseTreeListener listener) {
            if (listener instanceof AtlasDSLParserListener) {
                ((AtlasDSLParserListener) listener).exitQuerySrc(this);
            }
        }
    }

    public static class QueryContext extends ParserRuleContext {
        public QueryContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        public QuerySrcContext querySrc() {
            return getRuleContext(QuerySrcContext.class, 0);
        }

        public TerminalNode EOF() {return getToken(AtlasDSLParser.EOF, 0);}

        public GroupByExpressionContext groupByExpression() {
            return getRuleContext(GroupByExpressionContext.class, 0);
        }

        public SelectClauseContext selectClause() {
            return getRuleContext(SelectClauseContext.class, 0);
        }

        public OrderByExprContext orderByExpr() {
            return getRuleContext(OrderByExprContext.class, 0);
        }

        public LimitOffsetContext limitOffset() {
            return getRuleContext(LimitOffsetContext.class, 0);
        }

        @Override
        public int getRuleIndex() {return RULE_query;}

        @Override
        public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
            if (visitor instanceof AtlasDSLParserVisitor) {
                return ((AtlasDSLParserVisitor<? extends T>) visitor).visitQuery(this);
            } else {
                return visitor.visitChildren(this);
            }
        }

        @Override
        public void enterRule(ParseTreeListener listener) {
            if (listener instanceof AtlasDSLParserListener) {
                ((AtlasDSLParserListener) listener).enterQuery(this);
            }
        }

        @Override
        public void exitRule(ParseTreeListener listener) {
            if (listener instanceof AtlasDSLParserListener) {
                ((AtlasDSLParserListener) listener).exitQuery(this);
            }
        }
    }

    static {
        RuntimeMetaData.checkVersion("4.7.2", RuntimeMetaData.VERSION);
    }

    static {
        tokenNames = new String[_SYMBOLIC_NAMES.length];
        for (int i = 0; i < tokenNames.length; i++) {
            tokenNames[i] = VOCABULARY.getLiteralName(i);
            if (tokenNames[i] == null) {
                tokenNames[i] = VOCABULARY.getSymbolicName(i);
            }

            if (tokenNames[i] == null) {
                tokenNames[i] = "<INVALID>";
            }
        }
    }

    static {
        _decisionToDFA = new DFA[_ATN.getNumberOfDecisions()];
        for (int i = 0; i < _ATN.getNumberOfDecisions(); i++) {
            _decisionToDFA[i] = new DFA(_ATN.getDecisionState(i), i);
        }
    }
}
