/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.tasks;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.apache.atlas.annotation.GraphTransaction;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.tasks.AtlasTask;
import org.apache.atlas.repository.Constants;
import org.apache.atlas.repository.graphdb.AtlasGraph;
import org.apache.atlas.repository.graphdb.AtlasGraphQuery;
import org.apache.atlas.repository.graphdb.AtlasVertex;
import org.apache.atlas.repository.store.graph.v2.AtlasGraphUtilsV2;
import org.apache.atlas.type.AtlasType;
import org.apache.atlas.utils.AtlasJson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Lazy
@Component
public class TaskRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(TaskRegistry.class);
    private AtlasGraph graph;

    @Inject
    public TaskRegistry(AtlasGraph graph) {
        this.graph = graph;
    }

    @GraphTransaction
    public AtlasTask save(AtlasTask task) {
        AtlasVertex vertex = this.createVertex(task);
        return this.toAtlasTask(vertex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GraphTransaction
    public List<AtlasTask> getPendingTasks() {
        ArrayList<AtlasTask> ret = new ArrayList<AtlasTask>();
        try {
            AtlasGraphQuery query = this.graph.query().has(Constants.TASK_TYPE_PROPERTY_KEY, (Object)"__AtlasTaskDef").has(Constants.TASK_STATUS, (Object)AtlasTask.Status.PENDING).orderBy(Constants.TASK_CREATED_TIME, AtlasGraphQuery.SortOrder.ASC);
            for (AtlasVertex vertex : query.vertices()) {
                ret.add(this.toAtlasTask(vertex));
            }
        }
        catch (Exception exception) {
            LOG.error("Error fetching pending tasks!", (Throwable)exception);
        }
        finally {
            this.graph.commit();
        }
        return ret;
    }

    @GraphTransaction
    public List<AtlasTask> getPendingTasksByType(String type) {
        ArrayList<AtlasTask> ret = new ArrayList<AtlasTask>();
        try {
            AtlasGraphQuery query = this.graph.query().has(Constants.TASK_TYPE_PROPERTY_KEY, (Object)"__AtlasTaskDef").has(Constants.TASK_STATUS, (Object)AtlasTask.Status.PENDING).has(Constants.TASK_TYPE, (Object)type).orderBy(Constants.TASK_CREATED_TIME, AtlasGraphQuery.SortOrder.ASC);
            for (AtlasVertex vertex : query.vertices()) {
                ret.add(this.toAtlasTask(vertex));
            }
        }
        catch (Exception exception) {
            LOG.error("Error fetching pending tasks by type!", (Throwable)exception);
        }
        return ret;
    }

    @GraphTransaction
    public void updateStatus(AtlasVertex taskVertex, AtlasTask task) {
        if (taskVertex == null) {
            return;
        }
        AtlasGraphUtilsV2.setEncodedProperty(taskVertex, Constants.TASK_ATTEMPT_COUNT, task.getAttemptCount());
        AtlasGraphUtilsV2.setEncodedProperty(taskVertex, Constants.TASK_STATUS, task.getStatus().toString());
        AtlasGraphUtilsV2.setEncodedProperty(taskVertex, Constants.TASK_UPDATED_TIME, System.currentTimeMillis());
        AtlasGraphUtilsV2.setEncodedProperty(taskVertex, Constants.TASK_ERROR_MESSAGE, task.getErrorMessage());
    }

    @GraphTransaction
    public void deleteByGuid(String guid) throws AtlasBaseException {
        try {
            AtlasGraphQuery query = this.graph.query().has(Constants.TASK_TYPE_PROPERTY_KEY, (Object)"__AtlasTaskDef").has(Constants.TASK_GUID, (Object)guid);
            Iterator results = query.vertices().iterator();
            if (results.hasNext()) {
                this.graph.removeVertex((AtlasVertex)results.next());
            }
        }
        catch (Exception exception) {
            LOG.error("Error: deletingByGuid: {}", (Object)guid);
            throw new AtlasBaseException((Throwable)exception);
        }
    }

    @GraphTransaction
    public void deleteComplete(AtlasVertex taskVertex, AtlasTask task) {
        this.updateStatus(taskVertex, task);
        this.deleteVertex(taskVertex);
    }

    @GraphTransaction
    public AtlasTask getById(String guid) {
        AtlasGraphQuery query = this.graph.query().has(Constants.TASK_TYPE_PROPERTY_KEY, (Object)"__AtlasTaskDef").has(Constants.TASK_GUID, (Object)guid);
        Iterator results = query.vertices().iterator();
        return results.hasNext() ? this.toAtlasTask((AtlasVertex)results.next()) : null;
    }

    @GraphTransaction
    public AtlasVertex getVertex(String taskGuid) {
        AtlasGraphQuery query = this.graph.query().has(Constants.TASK_GUID, (Object)taskGuid);
        Iterator results = query.vertices().iterator();
        return results.hasNext() ? (AtlasVertex)results.next() : null;
    }

    @GraphTransaction
    public List<AtlasTask> getAll() {
        ArrayList<AtlasTask> ret = new ArrayList<AtlasTask>();
        AtlasGraphQuery query = this.graph.query().has(Constants.TASK_TYPE_PROPERTY_KEY, (Object)"__AtlasTaskDef").orderBy(Constants.TASK_CREATED_TIME, AtlasGraphQuery.SortOrder.ASC);
        Iterator results = query.vertices().iterator();
        while (results.hasNext()) {
            ret.add(this.toAtlasTask((AtlasVertex)results.next()));
        }
        return ret;
    }

    public void commit() {
        this.graph.commit();
    }

    public AtlasTask createVertex(String taskType, String createdBy, Map<String, Object> parameters) {
        AtlasTask ret = new AtlasTask(taskType, createdBy, parameters);
        this.createVertex(ret);
        return ret;
    }

    private void deleteVertex(AtlasVertex taskVertex) {
        if (taskVertex == null) {
            return;
        }
        this.graph.removeVertex(taskVertex);
    }

    private AtlasTask toAtlasTask(AtlasVertex v) {
        String errorMessage;
        Integer attemptCount;
        String parametersJson;
        Long endTime;
        Long startTime;
        Long updatedTime;
        Long createdTime;
        String createdBy;
        String status;
        String type;
        AtlasTask ret = new AtlasTask();
        String guid = (String)v.getProperty(Constants.TASK_GUID, String.class);
        if (guid != null) {
            ret.setGuid(guid);
        }
        if ((type = (String)v.getProperty(Constants.TASK_TYPE, String.class)) != null) {
            ret.setType(type);
        }
        if ((status = (String)v.getProperty(Constants.TASK_STATUS, String.class)) != null) {
            ret.setStatus(status);
        }
        if ((createdBy = (String)v.getProperty(Constants.TASK_CREATED_BY, String.class)) != null) {
            ret.setCreatedBy(createdBy);
        }
        if ((createdTime = (Long)v.getProperty(Constants.TASK_CREATED_TIME, Long.class)) != null) {
            ret.setCreatedTime(new Date(createdTime));
        }
        if ((updatedTime = (Long)v.getProperty(Constants.TASK_UPDATED_TIME, Long.class)) != null) {
            ret.setUpdatedTime(new Date(updatedTime));
        }
        if ((startTime = (Long)v.getProperty(Constants.TASK_START_TIME, Long.class)) != null) {
            ret.setStartTime(new Date(startTime));
        }
        if ((endTime = (Long)v.getProperty(Constants.TASK_END_TIME, Long.class)) != null) {
            ret.setEndTime(new Date(endTime));
        }
        if ((parametersJson = (String)v.getProperty(Constants.TASK_PARAMETERS, String.class)) != null) {
            ret.setParameters((Map)AtlasType.fromJson((String)parametersJson, Map.class));
        }
        if ((attemptCount = (Integer)v.getProperty(Constants.TASK_ATTEMPT_COUNT, Integer.class)) != null) {
            ret.setAttemptCount(attemptCount.intValue());
        }
        if ((errorMessage = (String)v.getProperty(Constants.TASK_ERROR_MESSAGE, String.class)) != null) {
            ret.setErrorMessage(errorMessage);
        }
        return ret;
    }

    private AtlasVertex createVertex(AtlasTask task) {
        AtlasVertex ret = this.graph.addVertex();
        AtlasGraphUtilsV2.setEncodedProperty(ret, Constants.TASK_GUID, task.getGuid());
        AtlasGraphUtilsV2.setEncodedProperty(ret, Constants.TASK_TYPE_PROPERTY_KEY, "__AtlasTaskDef");
        AtlasGraphUtilsV2.setEncodedProperty(ret, Constants.TASK_STATUS, task.getStatus().toString());
        AtlasGraphUtilsV2.setEncodedProperty(ret, Constants.TASK_TYPE, task.getType());
        AtlasGraphUtilsV2.setEncodedProperty(ret, Constants.TASK_CREATED_BY, task.getCreatedBy());
        AtlasGraphUtilsV2.setEncodedProperty(ret, Constants.TASK_CREATED_TIME, task.getCreatedTime());
        AtlasGraphUtilsV2.setEncodedProperty(ret, Constants.TASK_UPDATED_TIME, task.getUpdatedTime());
        if (task.getStartTime() != null) {
            AtlasGraphUtilsV2.setEncodedProperty(ret, Constants.TASK_START_TIME, task.getStartTime().getTime());
        }
        if (task.getEndTime() != null) {
            AtlasGraphUtilsV2.setEncodedProperty(ret, Constants.TASK_END_TIME, task.getEndTime().getTime());
        }
        AtlasGraphUtilsV2.setEncodedProperty(ret, Constants.TASK_PARAMETERS, AtlasJson.toJson((Object)task.getParameters()));
        AtlasGraphUtilsV2.setEncodedProperty(ret, Constants.TASK_ATTEMPT_COUNT, task.getAttemptCount());
        AtlasGraphUtilsV2.setEncodedProperty(ret, Constants.TASK_ERROR_MESSAGE, task.getErrorMessage());
        return ret;
    }
}

