/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.tasks;

import java.util.Set;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.atlas.AtlasException;
import org.apache.atlas.tasks.TaskFactory;
import org.apache.atlas.tasks.TaskManagement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class TaskFactoryRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(TaskFactoryRegistry.class);
    private final TaskManagement taskManagement;

    @Inject
    public TaskFactoryRegistry(TaskManagement taskManagement, Set<TaskFactory> factories) {
        this.taskManagement = taskManagement;
        for (TaskFactory factory : factories) {
            taskManagement.addFactory(factory);
        }
        LOG.info("TaskFactoryRegistry: TaskManagement updated with factories: {}", (Object)factories.size());
    }

    @PostConstruct
    public void startTaskManagement() throws AtlasException {
        try {
            if (!this.taskManagement.hasStarted()) {
                LOG.info("TaskFactoryRegistry: TaskManagement start skipped! Someone else will start it.");
                return;
            }
            LOG.info("TaskFactoryRegistry: Starting TaskManagement...");
            this.taskManagement.start();
        }
        catch (AtlasException e) {
            LOG.error("Error starting TaskManagement!", (Throwable)e);
            throw e;
        }
    }
}

