/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.store.graph.v2.tasks.searchdownload;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.atlas.ApplicationProperties;
import org.apache.atlas.discovery.AtlasDiscoveryService;
import org.apache.atlas.model.tasks.AtlasTask;
import org.apache.atlas.repository.store.graph.v2.tasks.searchdownload.SearchResultDownloadTask;
import org.apache.atlas.tasks.AbstractTask;
import org.apache.atlas.tasks.TaskFactory;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Singleton
@Service
@EnableScheduling
public class SearchResultDownloadTaskFactory
implements TaskFactory {
    private static final Logger LOG = LoggerFactory.getLogger(SearchResultDownloadTaskFactory.class);
    public static final String SEARCH_RESULT_DOWNLOAD = "SEARCH_RESULT_DOWNLOAD";
    public static int MAX_PENDING_TASKS_ALLOWED;
    private static final int MAX_PENDING_TASKS_ALLOWED_DEFAULT = 50;
    private static final String MAX_PENDING_TASKS_ALLOWED_KEY = "atlas.download.search.max.pending.tasks";
    private static final String FILES_CLEANUP_INTERVAL = "0 0/1 * * * *";
    private static final long FILE_EXP_DURATION_IN_MILLIS_DEFAULT = 86400000L;
    private static long FILE_EXP_DURATION_IN_MILLIS;
    private static final String FILE_EXP_DURATION_IN_MILLIS_KEY = "atlas.download.search.file.expiry.millis";
    private static Configuration configuration;
    private static final List<String> supportedTypes;
    private final AtlasDiscoveryService discoveryService;
    private final AtlasTypeRegistry typeRegistry;

    @Inject
    public SearchResultDownloadTaskFactory(AtlasDiscoveryService discoveryService, AtlasTypeRegistry typeRegistry) {
        this.discoveryService = discoveryService;
        this.typeRegistry = typeRegistry;
    }

    @Override
    public AbstractTask create(AtlasTask task) {
        String taskType = task.getType();
        String taskGuid = task.getGuid();
        switch (taskType) {
            case "SEARCH_RESULT_DOWNLOAD": {
                return new SearchResultDownloadTask(task, this.discoveryService, this.typeRegistry);
            }
        }
        LOG.warn("Type: {} - {} not found!. The task will be ignored.", (Object)taskType, (Object)taskGuid);
        return null;
    }

    @Override
    public List<String> getSupportedTypes() {
        return supportedTypes;
    }

    @Scheduled(cron="#{getCronExpressionForCleanup}")
    public void cleanupExpiredFiles() {
        File csvDir = new File(SearchResultDownloadTask.DOWNLOAD_DIR_PATH);
        this.deleteFiles(csvDir);
    }

    @Bean
    private String getCronExpressionForCleanup() {
        return FILES_CLEANUP_INTERVAL;
    }

    private void deleteFiles(File downloadDir) {
        Object[] subDirs = downloadDir.listFiles();
        if (ArrayUtils.isNotEmpty((Object[])subDirs)) {
            for (Object subDir : subDirs) {
                Object[] csvFiles = ((File)subDir).listFiles();
                if (!ArrayUtils.isNotEmpty((Object[])csvFiles)) continue;
                for (Object csv : csvFiles) {
                    BasicFileAttributes attr;
                    try {
                        attr = Files.readAttributes(((File)csv).toPath(), BasicFileAttributes.class, new LinkOption[0]);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    Date now = new Date();
                    long fileAgeInMillis = now.getTime() - attr.creationTime().toMillis();
                    if (FILE_EXP_DURATION_IN_MILLIS >= fileAgeInMillis) continue;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("deleting file: {}", (Object)((File)csv).getName());
                    }
                    ((File)csv).delete();
                }
            }
        }
    }

    static {
        try {
            configuration = ApplicationProperties.get();
        }
        catch (Exception e) {
            LOG.info("Failed to load application properties", (Throwable)e);
        }
        if (configuration != null) {
            MAX_PENDING_TASKS_ALLOWED = configuration.getInt(MAX_PENDING_TASKS_ALLOWED_KEY, 50);
            FILE_EXP_DURATION_IN_MILLIS = configuration.getLong(FILE_EXP_DURATION_IN_MILLIS_KEY, 86400000L);
        } else {
            MAX_PENDING_TASKS_ALLOWED = 50;
            FILE_EXP_DURATION_IN_MILLIS = 86400000L;
        }
        supportedTypes = new ArrayList<String>(){
            {
                this.add(SearchResultDownloadTaskFactory.SEARCH_RESULT_DOWNLOAD);
            }
        };
    }
}

