/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.store.graph.v2.tasks.searchdownload;

import com.opencsv.CSVWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.atlas.ApplicationProperties;
import org.apache.atlas.AtlasConfiguration;
import org.apache.atlas.AtlasException;
import org.apache.atlas.RequestContext;
import org.apache.atlas.discovery.AtlasDiscoveryService;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.discovery.AtlasSearchResult;
import org.apache.atlas.model.discovery.SearchParameters;
import org.apache.atlas.model.instance.AtlasEntityHeader;
import org.apache.atlas.model.instance.AtlasObjectId;
import org.apache.atlas.model.tasks.AtlasTask;
import org.apache.atlas.tasks.AbstractTask;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.atlas.utils.AtlasJson;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchResultDownloadTask
extends AbstractTask {
    private static final Logger LOG = LoggerFactory.getLogger(SearchResultDownloadTask.class);
    public static final String SEARCH_PARAMETERS_JSON_KEY = "search_parameters_json";
    public static final String CSV_FILE_NAME_KEY = "csv_file_Name";
    public static final String SEARCH_TYPE_KEY = "search_type";
    public static final String ATTRIBUTE_LABEL_MAP_KEY = "attribute_label_map";
    public static final String QUERY_KEY = "query";
    public static final String TYPE_NAME_KEY = "type_name";
    public static final String CLASSIFICATION_KEY = "classification";
    public static final String LIMIT_KEY = "limit";
    public static final String OFFSET_KEY = "offset";
    public static final String CSV_FILE_EXTENSION = ".csv";
    public static String DOWNLOAD_DIR_PATH;
    private static final String EMPTY_STRING = "";
    private static final String DOWNLOAD_DIR_PATH_KEY = "atlas.download.search.dir.path";
    private static final String DOWNLOAD_DIR_PATH_DEFAULT;
    private static final String CSV_DOWNLOAD_DIR = "search_result_downloads";
    private static Configuration configuration;
    private final AtlasDiscoveryService discoveryService;
    private final AtlasTypeRegistry typeRegistry;

    public SearchResultDownloadTask(AtlasTask task, AtlasDiscoveryService discoveryService, AtlasTypeRegistry typeRegistry) {
        super(task);
        this.discoveryService = discoveryService;
        this.typeRegistry = typeRegistry;
    }

    @Override
    public AtlasTask.Status perform() throws Exception {
        RequestContext.clear();
        Map params = this.getTaskDef().getParameters();
        if (MapUtils.isEmpty((Map)params)) {
            LOG.warn("Task: {}: Unable to process task: Parameters is not readable!", (Object)this.getTaskGuid());
            return AtlasTask.Status.FAILED;
        }
        String userName = this.getTaskDef().getCreatedBy();
        if (StringUtils.isEmpty((String)userName)) {
            LOG.warn("Task: {}: Unable to process task as user name is empty!", (Object)this.getTaskGuid());
            return AtlasTask.Status.FAILED;
        }
        RequestContext.get().setUser(userName, null);
        try {
            this.run(params);
            this.setStatus(AtlasTask.Status.COMPLETE);
        }
        catch (Exception e) {
            LOG.error("Task: {}: Error performing task!", (Object)this.getTaskGuid(), (Object)e);
            this.setStatus(AtlasTask.Status.FAILED);
            throw e;
        }
        finally {
            RequestContext.clear();
        }
        return this.getStatus();
    }

    protected void run(Map<String, Object> parameters) throws AtlasBaseException, IOException {
        AtlasSearchResult searchResult = null;
        AtlasSearchResult.AtlasQueryType queryType = null;
        if (parameters.get(SEARCH_TYPE_KEY) == AtlasSearchResult.AtlasQueryType.BASIC) {
            String searchParametersJson = (String)parameters.get(SEARCH_PARAMETERS_JSON_KEY);
            SearchParameters searchParameters = (SearchParameters)AtlasJson.fromJson((String)searchParametersJson, SearchParameters.class);
            searchParameters.setLimit(AtlasConfiguration.SEARCH_MAX_LIMIT.getInt());
            searchResult = this.discoveryService.searchWithParameters(searchParameters);
            queryType = AtlasSearchResult.AtlasQueryType.BASIC;
        } else if (parameters.get(SEARCH_TYPE_KEY) == AtlasSearchResult.AtlasQueryType.DSL) {
            String query = (String)parameters.get(QUERY_KEY);
            String typeName = (String)parameters.get(TYPE_NAME_KEY);
            String classification = (String)parameters.get(CLASSIFICATION_KEY);
            int offset = (Integer)parameters.get(OFFSET_KEY);
            String queryStr = this.discoveryService.getDslQueryUsingTypeNameClassification(query, typeName, classification);
            searchResult = this.discoveryService.searchUsingDslQuery(queryStr, AtlasConfiguration.SEARCH_MAX_LIMIT.getInt(), offset);
            queryType = AtlasSearchResult.AtlasQueryType.DSL;
        }
        String attributeLabelMapJson = (String)parameters.get(ATTRIBUTE_LABEL_MAP_KEY);
        Map attributeLabelMap = (Map)AtlasJson.fromJson((String)attributeLabelMapJson, Map.class);
        this.generateCSVFileFromSearchResult(searchResult, attributeLabelMap, queryType);
    }

    private void generateCSVFileFromSearchResult(AtlasSearchResult searchResult, Map<String, String> attributeLabelMap, AtlasSearchResult.AtlasQueryType queryType) throws IOException {
        List allEntityHeaders = searchResult.getEntities();
        AtlasSearchResult.AttributeSearchResult attributeSearchResult = searchResult.getAttributes();
        String fileName = (String)this.getTaskDef().getParameters().get(CSV_FILE_NAME_KEY);
        if (queryType == AtlasSearchResult.AtlasQueryType.BASIC && CollectionUtils.isEmpty((Collection)allEntityHeaders) || queryType == AtlasSearchResult.AtlasQueryType.DSL && CollectionUtils.isEmpty((Collection)allEntityHeaders) && attributeSearchResult == null) {
            LOG.info("No result found. Not generating csv file: {}", (Object)fileName);
            return;
        }
        File dir = new File(DOWNLOAD_DIR_PATH, RequestContext.getCurrentUser());
        if (!dir.exists()) {
            dir.mkdirs();
        }
        File csvFile = new File(dir, fileName);
        try (FileWriter fileWriter = new FileWriter(csvFile);
             CSVWriter csvWriter = new CSVWriter((Writer)fileWriter);){
            int i;
            String[] defaultHeaders = new String[]{"Type name", "Name", "Classifications", "Terms"};
            int attrSize = 0;
            if (attributeLabelMap == null) {
                attributeLabelMap = new HashMap<String, String>();
            }
            attributeLabelMap.put("Owner", "owner");
            attributeLabelMap.put("Description", "description");
            Collection<String> attributeHeaderLabels = attributeLabelMap.keySet();
            if (queryType == AtlasSearchResult.AtlasQueryType.DSL && CollectionUtils.isEmpty((Collection)allEntityHeaders) && attributeSearchResult != null) {
                attributeHeaderLabels = attributeSearchResult.getName();
                defaultHeaders = new String[]{};
            }
            attrSize = attributeHeaderLabels == null ? 0 : attributeHeaderLabels.size();
            Object[] attributeHeaders = new String[attrSize];
            if (attributeHeaderLabels != null) {
                attributeHeaders = attributeHeaderLabels.toArray(attributeHeaders);
            }
            int headerSize = attrSize + defaultHeaders.length;
            String[] headers = new String[headerSize];
            System.arraycopy(defaultHeaders, 0, headers, 0, defaultHeaders.length);
            if (ArrayUtils.isNotEmpty((Object[])attributeHeaders)) {
                System.arraycopy(attributeHeaders, 0, headers, defaultHeaders.length, attrSize);
            }
            csvWriter.writeNext(headers);
            String[] entityRecords = new String[headerSize];
            if (CollectionUtils.isNotEmpty((Collection)allEntityHeaders)) {
                for (AtlasEntityHeader entityHeader : allEntityHeaders) {
                    entityRecords[0] = entityHeader.getTypeName();
                    entityRecords[1] = entityHeader.getDisplayText() != null ? entityHeader.getDisplayText() : entityHeader.getGuid();
                    entityRecords[2] = String.join((CharSequence)",", entityHeader.getClassificationNames());
                    entityRecords[3] = String.join((CharSequence)",", entityHeader.getMeaningNames());
                    if (MapUtils.isNotEmpty((Map)entityHeader.getAttributes())) {
                        for (i = defaultHeaders.length; i < headerSize; ++i) {
                            Object attrValue = entityHeader.getAttribute(attributeLabelMap.get(headers[i]));
                            if (attrValue instanceof AtlasObjectId) {
                                entityRecords[i] = String.valueOf(((AtlasObjectId)attrValue).getUniqueAttributes().get("qualifiedName"));
                                continue;
                            }
                            if (attrValue instanceof List) {
                                if (!CollectionUtils.isNotEmpty((Collection)((List)attrValue))) continue;
                                ArrayList<String> valueList = new ArrayList<String>();
                                for (Object attrVal : (List)attrValue) {
                                    if (attrVal instanceof AtlasObjectId) {
                                        String value = String.valueOf(((AtlasObjectId)attrVal).getUniqueAttributes().get("qualifiedName"));
                                        valueList.add(value);
                                        continue;
                                    }
                                    valueList.add(String.valueOf(attrVal));
                                }
                                entityRecords[i] = String.join((CharSequence)",", valueList);
                                continue;
                            }
                            entityRecords[i] = attrValue == null ? EMPTY_STRING : String.valueOf(attrValue);
                        }
                    }
                    csvWriter.writeNext(entityRecords);
                }
            }
            if (queryType == AtlasSearchResult.AtlasQueryType.DSL && attributeSearchResult != null) {
                for (List resultSet : attributeSearchResult.getValues()) {
                    for (i = defaultHeaders.length; i < headerSize; ++i) {
                        entityRecords[i] = resultSet.get(i) == null ? EMPTY_STRING : String.valueOf(resultSet.get(i));
                    }
                    csvWriter.writeNext(entityRecords);
                }
            }
        }
    }

    static {
        DOWNLOAD_DIR_PATH_DEFAULT = System.getProperty("user.dir");
        try {
            configuration = ApplicationProperties.get();
        }
        catch (AtlasException e) {
            LOG.error("Failed to load application properties", (Throwable)e);
        }
        DOWNLOAD_DIR_PATH = configuration != null ? configuration.getString(DOWNLOAD_DIR_PATH_KEY, DOWNLOAD_DIR_PATH_DEFAULT) + File.separator + CSV_DOWNLOAD_DIR : DOWNLOAD_DIR_PATH_DEFAULT + File.separator + CSV_DOWNLOAD_DIR;
    }
}

