/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.store.graph.v2.tasks;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.apache.atlas.ApplicationProperties;
import org.apache.atlas.discovery.AtlasDiscoveryService;
import org.apache.atlas.model.tasks.AtlasTask;
import org.apache.atlas.repository.Constants;
import org.apache.atlas.repository.audit.EntityAuditRepository;
import org.apache.atlas.repository.graphdb.AtlasGraph;
import org.apache.atlas.repository.store.graph.v2.tasks.AuditReductionEntityRetrievalTask;
import org.apache.atlas.repository.store.graph.v2.tasks.AuditReductionTask;
import org.apache.atlas.tasks.AbstractTask;
import org.apache.atlas.tasks.TaskFactory;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.commons.configuration.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AuditReductionTaskFactory
implements TaskFactory {
    private static final Logger LOG = LoggerFactory.getLogger(AuditReductionTaskFactory.class);
    private static Configuration configuration;
    public static final int MAX_PENDING_TASKS_ALLOWED;
    private static final int MAX_PENDING_TASKS_ALLOWED_DEFAULT = 50;
    private static final String MAX_PENDING_TASKS_ALLOWED_KEY = "atlas.audit.reduction.max.pending.tasks";
    public static final String ATLAS_AUDIT_REDUCTION = "ATLAS_AUDIT_REDUCTION";
    public static final String ATLAS_AUDIT_REDUCTION_ENTITY_RETRIEVAL = "AUDIT_REDUCTION_ENTITY_RETRIEVAL";
    private static final List<String> supportedTypes;
    public static final Map<Constants.AtlasAuditAgingType, String> AGING_TYPE_PROPERTY_KEY_MAP;
    private final EntityAuditRepository auditRepository;
    private final AtlasGraph graph;
    private final AtlasDiscoveryService discoveryService;
    private final AtlasTypeRegistry typeRegistry;

    @Inject
    public AuditReductionTaskFactory(EntityAuditRepository auditRepository, AtlasGraph graph, AtlasDiscoveryService discoveryService, AtlasTypeRegistry typeRegistry) {
        this.auditRepository = auditRepository;
        this.graph = graph;
        this.discoveryService = discoveryService;
        this.typeRegistry = typeRegistry;
    }

    @Override
    public AbstractTask create(AtlasTask task) {
        String taskType = task.getType();
        String taskGuid = task.getGuid();
        switch (taskType) {
            case "ATLAS_AUDIT_REDUCTION": {
                return new AuditReductionTask(task, this.auditRepository, this.graph);
            }
            case "AUDIT_REDUCTION_ENTITY_RETRIEVAL": {
                return new AuditReductionEntityRetrievalTask(task, this.graph, this.discoveryService, this.typeRegistry);
            }
        }
        LOG.warn("Type: {} - {} not found!. The task will be ignored.", (Object)taskType, (Object)taskGuid);
        return null;
    }

    @Override
    public List<String> getSupportedTypes() {
        return supportedTypes;
    }

    static {
        try {
            configuration = ApplicationProperties.get();
        }
        catch (Exception e) {
            LOG.info("Failed to load application properties", (Throwable)e);
        }
        MAX_PENDING_TASKS_ALLOWED = configuration != null ? configuration.getInt(MAX_PENDING_TASKS_ALLOWED_KEY, 50) : 50;
        supportedTypes = new ArrayList<String>(){
            {
                this.add(AuditReductionTaskFactory.ATLAS_AUDIT_REDUCTION);
                this.add(AuditReductionTaskFactory.ATLAS_AUDIT_REDUCTION_ENTITY_RETRIEVAL);
            }
        };
        AGING_TYPE_PROPERTY_KEY_MAP = new HashMap<Constants.AtlasAuditAgingType, String>(){
            {
                this.put(Constants.AtlasAuditAgingType.DEFAULT, Constants.PROPERTY_KEY_GUIDS_TO_AGEOUT_BY_DEFAULT);
                this.put(Constants.AtlasAuditAgingType.SWEEP, Constants.PROPERTY_KEY_GUIDS_TO_SWEEPOUT);
                this.put(Constants.AtlasAuditAgingType.CUSTOM, Constants.PROPERTY_KEY_GUIDS_TO_AGEOUT_BY_CUSTOM);
            }
        };
    }
}

