/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.store.graph.v2.tasks;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.atlas.AtlasException;
import org.apache.atlas.RequestContext;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.audit.EntityAuditEventV2;
import org.apache.atlas.model.tasks.AtlasTask;
import org.apache.atlas.repository.Constants;
import org.apache.atlas.repository.audit.EntityAuditRepository;
import org.apache.atlas.repository.graphdb.AtlasGraph;
import org.apache.atlas.repository.graphdb.AtlasGraphQuery;
import org.apache.atlas.repository.graphdb.AtlasVertex;
import org.apache.atlas.repository.store.graph.v2.tasks.AuditReductionTaskFactory;
import org.apache.atlas.tasks.AbstractTask;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditReductionTask
extends AbstractTask {
    private static final Logger LOG = LoggerFactory.getLogger(AuditReductionTask.class);
    private static final int GUID_BATCH_SIZE_PER_AGE_OUT_TASK = 100;
    private final EntityAuditRepository auditRepository;
    private final AtlasGraph graph;

    public AuditReductionTask(AtlasTask task, EntityAuditRepository auditRepository, AtlasGraph graph) {
        super(task);
        this.auditRepository = auditRepository;
        this.graph = graph;
    }

    @Override
    public AtlasTask.Status perform() throws Exception {
        RequestContext.clear();
        Map params = this.getTaskDef().getParameters();
        if (MapUtils.isEmpty((Map)params)) {
            LOG.warn("Task: {}: Unable to process task: Parameters is not readable!", (Object)this.getTaskGuid());
            return AtlasTask.Status.FAILED;
        }
        String userName = this.getTaskDef().getCreatedBy();
        if (StringUtils.isEmpty((String)userName)) {
            LOG.warn("Task: {}: Unable to process task as user name is empty!", (Object)this.getTaskGuid());
            return AtlasTask.Status.FAILED;
        }
        RequestContext.get().setUser(userName, null);
        try {
            this.run(params);
            this.setStatus(AtlasTask.Status.COMPLETE);
        }
        catch (Exception e) {
            LOG.error("Task: {}: Error performing task!", (Object)this.getTaskGuid(), (Object)e);
            this.setStatus(AtlasTask.Status.FAILED);
            throw e;
        }
        finally {
            RequestContext.clear();
        }
        return this.getStatus();
    }

    protected void run(Map<String, Object> parameters) throws AtlasBaseException, IOException, AtlasException {
        AtlasVertex vertex = this.findVertex();
        if (vertex == null) {
            return;
        }
        HashMap<String, List<EntityAuditEventV2>> entitiesWithSucceededAgeout = new HashMap<String, List<EntityAuditEventV2>>();
        Constants.AtlasAuditAgingType auditAgingType = Constants.AtlasAuditAgingType.valueOf((String)String.valueOf(parameters.get("auditAgingType")));
        Set actionTypes = ((Collection)parameters.get("actionTypes")).stream().collect(Collectors.toSet());
        int auditCountInput = (Integer)parameters.get("auditCount");
        short auditCount = auditCountInput > Short.MAX_VALUE ? (short)Short.MAX_VALUE : (auditCountInput < Short.MIN_VALUE ? (short)Short.MIN_VALUE : (short)auditCountInput);
        int ttl = (Integer)parameters.get("ttl");
        boolean createEventsAgeoutAllowed = (Boolean)parameters.get("createEventsAgeoutAllowed");
        String vertexPropertyKeyForGuids = AuditReductionTaskFactory.AGING_TYPE_PROPERTY_KEY_MAP.get(auditAgingType);
        List entityGuidsEligibleForAuditAgeout = (List)vertex.getProperty(vertexPropertyKeyForGuids, List.class);
        int guidsCount = CollectionUtils.isNotEmpty((Collection)entityGuidsEligibleForAuditAgeout) ? entityGuidsEligibleForAuditAgeout.size() : 0;
        int batchIndex = 1;
        Set<EntityAuditEventV2.EntityAuditActionV2> entityAuditActions = actionTypes.stream().map(x -> EntityAuditEventV2.EntityAuditActionV2.fromString((String)x)).collect(Collectors.toSet());
        int startIndex = 0;
        while (startIndex < guidsCount) {
            int endIndex = startIndex + 100 < guidsCount ? startIndex + 100 : guidsCount;
            List guidsBatch = entityGuidsEligibleForAuditAgeout.subList(startIndex, endIndex);
            for (String guid : guidsBatch) {
                List<EntityAuditEventV2> deletedAuditEvents = this.auditRepository.deleteEventsV2(guid, entityAuditActions, auditCount, ttl, createEventsAgeoutAllowed, auditAgingType);
                entitiesWithSucceededAgeout.put(guid, deletedAuditEvents);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} Audit aging completed for batch-{} with guids: {}", new Object[]{auditAgingType.toString(), batchIndex, Arrays.toString(entitiesWithSucceededAgeout.keySet().toArray())});
            }
            entitiesWithSucceededAgeout.clear();
            startIndex = endIndex;
            ++batchIndex;
            ArrayList remainingGuids = startIndex < guidsCount ? new ArrayList(entityGuidsEligibleForAuditAgeout.subList(startIndex, guidsCount)) : null;
            vertex.setProperty(vertexPropertyKeyForGuids, (Object)remainingGuids);
        }
    }

    public AtlasVertex findVertex() {
        AtlasGraphQuery query = this.graph.query().has(Constants.PROPERTY_KEY_AUDIT_REDUCTION_NAME, (Object)"__auditReductionInfo");
        Iterator results = query.vertices().iterator();
        return results.hasNext() ? (AtlasVertex)results.next() : null;
    }
}

