/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.store.graph.v2.tasks;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.atlas.AtlasConfiguration;
import org.apache.atlas.AtlasException;
import org.apache.atlas.RequestContext;
import org.apache.atlas.annotation.GraphTransaction;
import org.apache.atlas.discovery.AtlasDiscoveryService;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.discovery.SearchParameters;
import org.apache.atlas.model.tasks.AtlasTask;
import org.apache.atlas.repository.Constants;
import org.apache.atlas.repository.graphdb.AtlasGraph;
import org.apache.atlas.repository.graphdb.AtlasGraphQuery;
import org.apache.atlas.repository.graphdb.AtlasVertex;
import org.apache.atlas.repository.store.graph.v2.AtlasGraphUtilsV2;
import org.apache.atlas.repository.store.graph.v2.tasks.AuditReductionTaskFactory;
import org.apache.atlas.tasks.AbstractTask;
import org.apache.atlas.type.AtlasEntityType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditReductionEntityRetrievalTask
extends AbstractTask {
    private static final Logger LOG = LoggerFactory.getLogger(AuditReductionEntityRetrievalTask.class);
    private static final String VALUE_DELIMITER = ",";
    private final AtlasDiscoveryService discoveryService;
    private final AtlasTypeRegistry typeRegistry;
    private final AtlasGraph graph;

    public AuditReductionEntityRetrievalTask(AtlasTask task, AtlasGraph graph, AtlasDiscoveryService discoveryService, AtlasTypeRegistry typeRegistry) {
        super(task);
        this.graph = graph;
        this.discoveryService = discoveryService;
        this.typeRegistry = typeRegistry;
    }

    @Override
    public AtlasTask.Status perform() throws Exception {
        RequestContext.clear();
        Map params = this.getTaskDef().getParameters();
        if (MapUtils.isEmpty((Map)params)) {
            LOG.warn("Task: {}: Unable to process task: Parameters is not readable!", (Object)this.getTaskGuid());
            return AtlasTask.Status.FAILED;
        }
        String userName = this.getTaskDef().getCreatedBy();
        if (StringUtils.isEmpty((String)userName)) {
            LOG.warn("Task: {}: Unable to process task as user name is empty!", (Object)this.getTaskGuid());
            return AtlasTask.Status.FAILED;
        }
        RequestContext.get().setUser(userName, null);
        try {
            this.run(params);
            this.setStatus(AtlasTask.Status.COMPLETE);
        }
        catch (Exception e) {
            LOG.error("Task: {}: Error performing task!", (Object)this.getTaskGuid(), (Object)e);
            this.setStatus(AtlasTask.Status.FAILED);
            throw e;
        }
        finally {
            RequestContext.clear();
        }
        return this.getStatus();
    }

    protected void run(Map<String, Object> parameters) throws AtlasBaseException, IOException, AtlasException {
        try {
            AtlasTask auditAgingTask = this.createAgingTaskWithEligibleGUIDs(parameters);
            if (auditAgingTask != null) {
                LOG.info("{} task created for audit aging type-{}", (Object)"ATLAS_AUDIT_REDUCTION", parameters.get("auditAgingType"));
            }
        }
        catch (Exception e) {
            LOG.error("Error while retrieving entities eligible for audit aging and creating audit aging tasks", (Object)e.getMessage());
        }
    }

    protected AtlasTask createAgingTaskWithEligibleGUIDs(Map<String, Object> parameters) throws AtlasBaseException {
        String ALL_ENTITY_TYPES = "_ALL_ENTITY_TYPES";
        boolean SEARCH_OFFSET = false;
        int SEARCH_LIMIT = AtlasConfiguration.ATLAS_AUDIT_AGING_SEARCH_MAX_LIMIT.getInt();
        Set<String> entityTypes = ((Collection)parameters.get("entityTypes")).stream().collect(Collectors.toSet());
        Constants.AtlasAuditAgingType auditAgingType = (Constants.AtlasAuditAgingType)parameters.get("auditAgingType");
        boolean subTypesIncluded = (Boolean)parameters.get("subTypesIncluded");
        SearchParameters searchEntitiesToReduceAudit = new SearchParameters();
        searchEntitiesToReduceAudit.setTypeName("_ALL_ENTITY_TYPES");
        searchEntitiesToReduceAudit.setOffset(0);
        searchEntitiesToReduceAudit.setLimit(SEARCH_LIMIT);
        searchEntitiesToReduceAudit.setIncludeSubTypes(subTypesIncluded);
        if (CollectionUtils.isNotEmpty(entityTypes)) {
            if (!this.validateTypesAndIncludeSubTypes(entityTypes, auditAgingType, subTypesIncluded)) {
                LOG.error("All entity type names provided for audit aging type-{} are invalid", (Object)auditAgingType);
                return null;
            }
            String queryString = String.join((CharSequence)VALUE_DELIMITER, entityTypes);
            if (auditAgingType == Constants.AtlasAuditAgingType.DEFAULT && StringUtils.isNotEmpty((String)queryString)) {
                queryString = "!" + queryString;
            }
            searchEntitiesToReduceAudit.setQuery(queryString);
        }
        LOG.info("Getting GUIDs eligible for Audit aging type-{} with SearchParameters: {}", (Object)auditAgingType.toString(), (Object)searchEntitiesToReduceAudit.toString());
        Set<String> guids = this.discoveryService.searchGUIDsWithParameters(auditAgingType, entityTypes, searchEntitiesToReduceAudit);
        AtlasVertex auditReductionVertex = this.getOrCreateVertex();
        AtlasTask ageoutTask = this.updateVertexWithGuidsAndCreateAgingTask(auditReductionVertex, AuditReductionTaskFactory.AGING_TYPE_PROPERTY_KEY_MAP.get(auditAgingType), guids, parameters);
        if (ageoutTask != null) {
            if (auditAgingType == Constants.AtlasAuditAgingType.DEFAULT && CollectionUtils.isNotEmpty(entityTypes)) {
                ageoutTask.getParameters().put("excludeEntityTypes", true);
            } else {
                ageoutTask.getParameters().put("excludeEntityTypes", false);
            }
        }
        return ageoutTask;
    }

    private boolean validateTypesAndIncludeSubTypes(Set<String> entityTypes, Constants.AtlasAuditAgingType auditAgingType, boolean subTypesIncluded) throws AtlasBaseException {
        Collection allEntityTypeNames = this.typeRegistry.getAllEntityDefNames();
        HashSet entityTypesToSearch = new HashSet();
        HashSet invalidEntityTypeNames = new HashSet();
        entityTypes.stream().forEach(entityType -> {
            if (entityType.endsWith("*")) {
                String suffix = entityType.replace("*", "");
                entityTypesToSearch.addAll(allEntityTypeNames.stream().filter(e -> e.startsWith(suffix)).collect(Collectors.toSet()));
            } else if (allEntityTypeNames.contains(entityType)) {
                entityTypesToSearch.add(entityType);
            } else {
                invalidEntityTypeNames.add(entityType);
            }
        });
        if (auditAgingType != Constants.AtlasAuditAgingType.DEFAULT) {
            if (CollectionUtils.isNotEmpty(invalidEntityTypeNames)) {
                LOG.warn("Invalid entity type name(s) {} provided for aging type-{}", (Object)String.join((CharSequence)VALUE_DELIMITER, invalidEntityTypeNames), (Object)auditAgingType);
            }
            if (CollectionUtils.isEmpty(entityTypesToSearch)) {
                return false;
            }
        }
        entityTypes.clear();
        entityTypes.addAll(subTypesIncluded ? AtlasEntityType.getEntityTypesAndAllSubTypes(entityTypesToSearch, (AtlasTypeRegistry)this.typeRegistry) : entityTypesToSearch);
        return true;
    }

    @GraphTransaction
    private AtlasTask updateVertexWithGuidsAndCreateAgingTask(AtlasVertex vertex, String vertexProperty, Set<String> guids, Map<String, Object> params) throws AtlasBaseException {
        ArrayList<String> guidsEligibleForAuditReduction = (ArrayList<String>)vertex.getProperty(vertexProperty, List.class);
        if (CollectionUtils.isEmpty((Collection)guidsEligibleForAuditReduction) && CollectionUtils.isEmpty(guids)) {
            return null;
        }
        if (CollectionUtils.isEmpty((Collection)guidsEligibleForAuditReduction)) {
            guidsEligibleForAuditReduction = new ArrayList<String>();
        }
        if (CollectionUtils.isNotEmpty(guids)) {
            guidsEligibleForAuditReduction.addAll(guids);
            AtlasGraphUtilsV2.setEncodedProperty(vertex, vertexProperty, guidsEligibleForAuditReduction);
        }
        return this.discoveryService.createAndQueueAuditReductionTask(params, "ATLAS_AUDIT_REDUCTION");
    }

    private AtlasVertex getOrCreateVertex() {
        AtlasVertex auditReductionVertex;
        AtlasGraphQuery query = this.graph.query().has(Constants.PROPERTY_KEY_AUDIT_REDUCTION_NAME, (Object)"__auditReductionInfo");
        Iterator results = query.vertices().iterator();
        AtlasVertex atlasVertex = auditReductionVertex = results.hasNext() ? (AtlasVertex)results.next() : null;
        if (auditReductionVertex == null) {
            auditReductionVertex = this.graph.addVertex();
            AtlasGraphUtilsV2.setEncodedProperty(auditReductionVertex, Constants.PROPERTY_KEY_AUDIT_REDUCTION_NAME, "__auditReductionInfo");
        }
        return auditReductionVertex;
    }
}

