/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.store.graph.v2.bulkimport;

import java.util.Map;
import org.apache.atlas.AtlasErrorCode;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.impexp.AtlasImportResult;
import org.apache.atlas.model.instance.EntityMutationResponse;
import org.apache.atlas.repository.converters.AtlasFormatConverters;
import org.apache.atlas.repository.converters.AtlasInstanceConverter;
import org.apache.atlas.repository.graph.AtlasGraphProvider;
import org.apache.atlas.repository.graphdb.AtlasGraph;
import org.apache.atlas.repository.migration.DataMigrationStatusService;
import org.apache.atlas.repository.store.graph.v1.DeleteHandlerDelegate;
import org.apache.atlas.repository.store.graph.v2.AtlasEntityStoreV2;
import org.apache.atlas.repository.store.graph.v2.AtlasRelationshipStoreV2;
import org.apache.atlas.repository.store.graph.v2.EntityGraphMapper;
import org.apache.atlas.repository.store.graph.v2.EntityGraphRetriever;
import org.apache.atlas.repository.store.graph.v2.EntityImportStream;
import org.apache.atlas.repository.store.graph.v2.bulkimport.EntityChangeNotifierNop;
import org.apache.atlas.repository.store.graph.v2.bulkimport.FullTextMapperV2Nop;
import org.apache.atlas.repository.store.graph.v2.bulkimport.ImportStrategy;
import org.apache.atlas.repository.store.graph.v2.bulkimport.pc.EntityConsumerBuilder;
import org.apache.atlas.repository.store.graph.v2.bulkimport.pc.EntityCreationManager;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.atlas.utils.AtlasStringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrationImport
extends ImportStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(MigrationImport.class);
    private final AtlasGraph graph;
    private final AtlasGraphProvider graphProvider;
    private final AtlasTypeRegistry typeRegistry;

    public MigrationImport(AtlasGraph graph, AtlasGraphProvider graphProvider, AtlasTypeRegistry typeRegistry) {
        this.graph = graph;
        this.graphProvider = graphProvider;
        this.typeRegistry = typeRegistry;
        LOG.info("MigrationImport: Using bulkLoading...");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EntityMutationResponse run(EntityImportStream entityStream, AtlasImportResult importResult) throws AtlasBaseException {
        if (entityStream == null || !entityStream.hasNext()) {
            throw new AtlasBaseException(AtlasErrorCode.INVALID_PARAMETERS, new String[]{"no entities to create/update."});
        }
        if (importResult.getRequest() == null) {
            throw new AtlasBaseException(AtlasErrorCode.INVALID_PARAMETERS, new String[]{"importResult should contain request"});
        }
        DataMigrationStatusService dataMigrationStatusService = this.createMigrationStatusService(importResult);
        long index = 0L;
        int streamSize = entityStream.size();
        EntityMutationResponse ret = new EntityMutationResponse();
        EntityCreationManager creationManager = this.createEntityCreationManager(importResult, dataMigrationStatusService);
        try {
            LOG.info("Migration Import: Size: {}: Starting...", (Object)streamSize);
            index = creationManager.read(entityStream);
            creationManager.drain();
            creationManager.extractResults();
        }
        catch (Exception ex) {
            LOG.error("Migration Import: Error: Current position: {}", (Object)index, (Object)ex);
        }
        finally {
            this.shutdownEntityCreationManager(creationManager);
        }
        LOG.info("Migration Import: Size: {}: Done!", (Object)streamSize);
        return ret;
    }

    private DataMigrationStatusService createMigrationStatusService(AtlasImportResult importResult) {
        DataMigrationStatusService dataMigrationStatusService = new DataMigrationStatusService();
        dataMigrationStatusService.init(AtlasStringUtil.getOption((Map)importResult.getRequest().getOptions(), (String)"migrationFileName"));
        return dataMigrationStatusService;
    }

    private EntityCreationManager createEntityCreationManager(AtlasImportResult importResult, DataMigrationStatusService dataMigrationStatusService) {
        AtlasGraph graphBulk = this.graphProvider.getBulkLoading();
        EntityGraphRetriever entityGraphRetriever = new EntityGraphRetriever(this.graph, this.typeRegistry);
        EntityGraphRetriever entityGraphRetrieverBulk = new EntityGraphRetriever(graphBulk, this.typeRegistry);
        AtlasEntityStoreV2 entityStore = this.createEntityStore(this.graph, this.typeRegistry);
        AtlasEntityStoreV2 entityStoreBulk = this.createEntityStore(graphBulk, this.typeRegistry);
        int batchSize = importResult.getRequest().getOptionKeyBatchSize();
        int numWorkers = MigrationImport.getNumWorkers(importResult.getRequest().getOptionKeyNumWorkers());
        boolean isMigrationImport = false;
        if (importResult.getRequest().getOptions().get("migration") != null) {
            isMigrationImport = Boolean.valueOf((String)importResult.getRequest().getOptions().get("migration"));
        }
        EntityConsumerBuilder consumerBuilder = new EntityConsumerBuilder(this.typeRegistry, this.graph, entityStore, entityGraphRetriever, graphBulk, entityStoreBulk, entityGraphRetrieverBulk, batchSize, isMigrationImport);
        LOG.info("MigrationImport: EntityCreationManager: Created!");
        return new EntityCreationManager(consumerBuilder, batchSize, numWorkers, importResult, dataMigrationStatusService);
    }

    private static int getNumWorkers(int numWorkersFromOptions) {
        int ret = numWorkersFromOptions > 0 ? numWorkersFromOptions : 1;
        LOG.info("Migration Import: Setting numWorkers: {}", (Object)ret);
        return ret;
    }

    private AtlasEntityStoreV2 createEntityStore(AtlasGraph graph, AtlasTypeRegistry typeRegistry) {
        FullTextMapperV2Nop fullTextMapperV2 = new FullTextMapperV2Nop();
        EntityChangeNotifierNop entityChangeNotifier = new EntityChangeNotifierNop();
        DeleteHandlerDelegate deleteDelegate = new DeleteHandlerDelegate(graph, typeRegistry, null);
        AtlasFormatConverters formatConverters = new AtlasFormatConverters(typeRegistry);
        AtlasInstanceConverter instanceConverter = new AtlasInstanceConverter(graph, typeRegistry, formatConverters);
        AtlasRelationshipStoreV2 relationshipStore = new AtlasRelationshipStoreV2(graph, typeRegistry, deleteDelegate, entityChangeNotifier);
        EntityGraphMapper entityGraphMapper = new EntityGraphMapper(deleteDelegate, typeRegistry, graph, relationshipStore, entityChangeNotifier, instanceConverter, fullTextMapperV2, null);
        return new AtlasEntityStoreV2(graph, deleteDelegate, typeRegistry, entityChangeNotifier, entityGraphMapper);
    }

    private void shutdownEntityCreationManager(EntityCreationManager creationManager) {
        try {
            creationManager.shutdown();
        }
        catch (InterruptedException e) {
            LOG.error("Migration Import: Shutdown: Interrupted!", (Throwable)e);
        }
    }
}

