/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.store.graph.v2;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.atlas.AtlasConfiguration;
import org.apache.atlas.AtlasErrorCode;
import org.apache.atlas.GraphTransactionInterceptor;
import org.apache.atlas.RequestContext;
import org.apache.atlas.annotation.GraphTransaction;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.exception.EntityNotFoundException;
import org.apache.atlas.model.TypeCategory;
import org.apache.atlas.model.instance.AtlasClassification;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.AtlasEntityHeader;
import org.apache.atlas.model.instance.AtlasObjectId;
import org.apache.atlas.model.instance.AtlasRelatedObjectId;
import org.apache.atlas.model.instance.AtlasRelationship;
import org.apache.atlas.model.instance.AtlasStruct;
import org.apache.atlas.model.instance.EntityMutationResponse;
import org.apache.atlas.model.instance.EntityMutations;
import org.apache.atlas.model.tasks.AtlasTask;
import org.apache.atlas.model.typedef.AtlasEntityDef;
import org.apache.atlas.model.typedef.AtlasStructDef;
import org.apache.atlas.repository.Constants;
import org.apache.atlas.repository.RepositoryException;
import org.apache.atlas.repository.converters.AtlasInstanceConverter;
import org.apache.atlas.repository.graph.GraphHelper;
import org.apache.atlas.repository.graph.IFullTextMapper;
import org.apache.atlas.repository.graphdb.AtlasEdge;
import org.apache.atlas.repository.graphdb.AtlasEdgeDirection;
import org.apache.atlas.repository.graphdb.AtlasElement;
import org.apache.atlas.repository.graphdb.AtlasGraph;
import org.apache.atlas.repository.graphdb.AtlasVertex;
import org.apache.atlas.repository.store.graph.AtlasRelationshipStore;
import org.apache.atlas.repository.store.graph.EntityGraphDiscoveryContext;
import org.apache.atlas.repository.store.graph.v1.DeleteHandlerDelegate;
import org.apache.atlas.repository.store.graph.v2.AtlasGraphUtilsV2;
import org.apache.atlas.repository.store.graph.v2.AttributeMutationContext;
import org.apache.atlas.repository.store.graph.v2.EntityGraphRetriever;
import org.apache.atlas.repository.store.graph.v2.EntityMutationContext;
import org.apache.atlas.repository.store.graph.v2.IAtlasEntityChangeNotifier;
import org.apache.atlas.tasks.TaskManagement;
import org.apache.atlas.type.AtlasArrayType;
import org.apache.atlas.type.AtlasBuiltInTypes;
import org.apache.atlas.type.AtlasBusinessMetadataType;
import org.apache.atlas.type.AtlasClassificationType;
import org.apache.atlas.type.AtlasEntityType;
import org.apache.atlas.type.AtlasMapType;
import org.apache.atlas.type.AtlasStructType;
import org.apache.atlas.type.AtlasType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.atlas.type.AtlasTypeUtil;
import org.apache.atlas.utils.AtlasEntityUtil;
import org.apache.atlas.utils.AtlasJson;
import org.apache.atlas.utils.AtlasPerfMetrics;
import org.apache.atlas.utils.AtlasPerfTracer;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class EntityGraphMapper {
    private static final Logger LOG = LoggerFactory.getLogger(EntityGraphMapper.class);
    private static final Logger PERF_LOG = AtlasPerfTracer.getPerfLogger((String)"entityGraphMapper");
    private static final String SOFT_REF_FORMAT = "%s:%s";
    private static final int INDEXED_STR_SAFE_LEN = AtlasConfiguration.GRAPHSTORE_INDEXED_STRING_SAFE_LENGTH.getInt();
    private static final boolean WARN_ON_NO_RELATIONSHIP = AtlasConfiguration.RELATIONSHIP_WARN_NO_RELATIONSHIPS.getBoolean();
    private static final String CUSTOM_ATTRIBUTE_KEY_SPECIAL_PREFIX = AtlasConfiguration.CUSTOM_ATTRIBUTE_KEY_SPECIAL_PREFIX.getString();
    private static final String CLASSIFICATION_NAME_DELIMITER = "|";
    private static final Pattern CUSTOM_ATTRIBUTE_KEY_REGEX = Pattern.compile("^[\u2e80-\u2fd5\u3190-\u319f\u3400-\u4dbf\u4e00-\u9fcc\uf900-\ufaada-zA-Z0-9_-]*$");
    private static final Pattern LABEL_REGEX = Pattern.compile("^[\u2e80-\u2fd5\u3190-\u319f\u3400-\u4dbf\u4e00-\u9fcc\uf900-\ufaada-zA-Z0-9_-]*$");
    private static final int CUSTOM_ATTRIBUTE_KEY_MAX_LENGTH = AtlasConfiguration.CUSTOM_ATTRIBUTE_KEY_MAX_LENGTH.getInt();
    private static final int CUSTOM_ATTRIBUTE_VALUE_MAX_LENGTH = AtlasConfiguration.CUSTOM_ATTRIBUTE_VALUE_MAX_LENGTH.getInt();
    private static final boolean ENTITY_CHANGE_NOTIFY_IGNORE_RELATIONSHIP_ATTRIBUTES = AtlasConfiguration.ENTITY_CHANGE_NOTIFY_IGNORE_RELATIONSHIP_ATTRIBUTES.getBoolean();
    private static final boolean CLASSIFICATION_PROPAGATION_DEFAULT = AtlasConfiguration.CLASSIFICATION_PROPAGATION_DEFAULT.getBoolean();
    private boolean DEFERRED_ACTION_ENABLED = AtlasConfiguration.TASKS_USE_ENABLED.getBoolean();
    private final GraphHelper graphHelper;
    private final AtlasGraph graph;
    private final DeleteHandlerDelegate deleteDelegate;
    private final AtlasTypeRegistry typeRegistry;
    private final AtlasRelationshipStore relationshipStore;
    private final IAtlasEntityChangeNotifier entityChangeNotifier;
    private final AtlasInstanceConverter instanceConverter;
    private final EntityGraphRetriever entityRetriever;
    private final IFullTextMapper fullTextMapperV2;
    private final TaskManagement taskManagement;

    @Inject
    public EntityGraphMapper(DeleteHandlerDelegate deleteDelegate, AtlasTypeRegistry typeRegistry, AtlasGraph graph, AtlasRelationshipStore relationshipStore, IAtlasEntityChangeNotifier entityChangeNotifier, AtlasInstanceConverter instanceConverter, IFullTextMapper fullTextMapperV2, TaskManagement taskManagement) {
        this.graphHelper = new GraphHelper(graph);
        this.deleteDelegate = deleteDelegate;
        this.typeRegistry = typeRegistry;
        this.graph = graph;
        this.relationshipStore = relationshipStore;
        this.entityChangeNotifier = entityChangeNotifier;
        this.instanceConverter = instanceConverter;
        this.entityRetriever = new EntityGraphRetriever(graph, typeRegistry);
        this.fullTextMapperV2 = fullTextMapperV2;
        this.taskManagement = taskManagement;
    }

    @VisibleForTesting
    public void setTasksUseFlag(boolean value) {
        this.DEFERRED_ACTION_ENABLED = value;
    }

    public AtlasVertex createVertex(AtlasEntity entity) throws AtlasBaseException {
        String guid = UUID.randomUUID().toString();
        return this.createVertexWithGuid(entity, guid);
    }

    public AtlasVertex createShellEntityVertex(AtlasObjectId objectId, EntityGraphDiscoveryContext context) throws AtlasBaseException {
        String guid;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> createShellEntityVertex({})", (Object)objectId.getTypeName());
        }
        if (!AtlasTypeUtil.isAssignedGuid((String)(guid = objectId.getGuid()))) {
            guid = UUID.randomUUID().toString();
        }
        AtlasEntityType entityType = this.typeRegistry.getEntityTypeByName(objectId.getTypeName());
        AtlasVertex ret = this.createStructVertex(objectId);
        for (String superTypeName : entityType.getAllSuperTypes()) {
            AtlasGraphUtilsV2.addEncodedProperty(ret, Constants.SUPER_TYPES_PROPERTY_KEY, (Object)superTypeName);
        }
        AtlasGraphUtilsV2.setEncodedProperty(ret, Constants.GUID_PROPERTY_KEY, guid);
        AtlasGraphUtilsV2.setEncodedProperty(ret, Constants.VERSION_PROPERTY_KEY, this.getEntityVersion(null));
        AtlasGraphUtilsV2.setEncodedProperty(ret, Constants.IS_INCOMPLETE_PROPERTY_KEY, Constants.INCOMPLETE_ENTITY_VALUE);
        Map uniqueAttributes = objectId.getUniqueAttributes();
        EntityMutationContext mutationContext = new EntityMutationContext(context);
        for (AtlasStructType.AtlasAttribute attribute : entityType.getUniqAttributes().values()) {
            String attrName = attribute.getName();
            if (!uniqueAttributes.containsKey(attrName)) continue;
            Object attrValue = attribute.getAttributeType().getNormalizedValue(uniqueAttributes.get(attrName));
            this.mapAttribute(attribute, attrValue, ret, EntityMutations.EntityOperation.CREATE, mutationContext);
        }
        GraphTransactionInterceptor.addToVertexCache(guid, ret);
        return ret;
    }

    public AtlasVertex createShellEntityVertex(AtlasEntity entity, EntityGraphDiscoveryContext context) throws AtlasBaseException {
        AtlasObjectId objectId = new AtlasObjectId(entity.getGuid(), entity.getTypeName(), entity.getAttributes());
        return this.createShellEntityVertex(objectId, context);
    }

    public AtlasVertex createVertexWithGuid(AtlasEntity entity, String guid) throws AtlasBaseException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> createVertexWithGuid({})", (Object)entity.getTypeName());
        }
        AtlasEntityType entityType = this.typeRegistry.getEntityTypeByName(entity.getTypeName());
        AtlasVertex ret = this.createStructVertex((AtlasStruct)entity);
        for (String superTypeName : entityType.getAllSuperTypes()) {
            AtlasGraphUtilsV2.addEncodedProperty(ret, Constants.SUPER_TYPES_PROPERTY_KEY, (Object)superTypeName);
        }
        AtlasGraphUtilsV2.setEncodedProperty(ret, Constants.GUID_PROPERTY_KEY, guid);
        AtlasGraphUtilsV2.setEncodedProperty(ret, Constants.VERSION_PROPERTY_KEY, this.getEntityVersion(entity));
        this.setCustomAttributes(ret, entity);
        this.setLabels(ret, entity.getLabels());
        GraphTransactionInterceptor.addToVertexCache(guid, ret);
        return ret;
    }

    public void updateSystemAttributes(AtlasVertex vertex, AtlasEntity entity) throws AtlasBaseException {
        if (entity.getVersion() != null) {
            AtlasGraphUtilsV2.setEncodedProperty(vertex, Constants.VERSION_PROPERTY_KEY, entity.getVersion());
        }
        if (entity.getCreateTime() != null) {
            AtlasGraphUtilsV2.setEncodedProperty(vertex, Constants.TIMESTAMP_PROPERTY_KEY, entity.getCreateTime().getTime());
        }
        if (entity.getUpdateTime() != null) {
            AtlasGraphUtilsV2.setEncodedProperty(vertex, Constants.MODIFICATION_TIMESTAMP_PROPERTY_KEY, entity.getUpdateTime().getTime());
        }
        if (StringUtils.isNotEmpty((CharSequence)entity.getCreatedBy())) {
            AtlasGraphUtilsV2.setEncodedProperty(vertex, Constants.CREATED_BY_KEY, entity.getCreatedBy());
        }
        if (StringUtils.isNotEmpty((CharSequence)entity.getUpdatedBy())) {
            AtlasGraphUtilsV2.setEncodedProperty(vertex, Constants.MODIFIED_BY_KEY, entity.getUpdatedBy());
        }
        if (StringUtils.isNotEmpty((CharSequence)entity.getHomeId())) {
            AtlasGraphUtilsV2.setEncodedProperty(vertex, Constants.HOME_ID_KEY, entity.getHomeId());
        }
        if (entity.isProxy() != null) {
            AtlasGraphUtilsV2.setEncodedProperty(vertex, Constants.IS_PROXY_KEY, entity.isProxy());
        }
        if (entity.getProvenanceType() != null) {
            AtlasGraphUtilsV2.setEncodedProperty(vertex, Constants.PROVENANCE_TYPE_KEY, entity.getProvenanceType());
        }
        if (entity.getCustomAttributes() != null) {
            this.setCustomAttributes(vertex, entity);
        }
        if (entity.getLabels() != null) {
            this.setLabels(vertex, entity.getLabels());
        }
    }

    public EntityMutationResponse mapAttributesAndClassifications(EntityMutationContext context, boolean isPartialUpdate, boolean replaceClassifications, boolean replaceBusinessAttributes) throws AtlasBaseException {
        RequestContext requestContext;
        EntityMutations.EntityOperation updateType;
        AtlasPerfMetrics.MetricRecorder metric = RequestContext.get().startMetricRecord("mapAttributesAndClassifications");
        EntityMutationResponse resp = new EntityMutationResponse();
        RequestContext reqContext = RequestContext.get();
        Collection<AtlasEntity> createdEntities = context.getCreatedEntities();
        Collection<AtlasEntity> updatedEntities = context.getUpdatedEntities();
        if (CollectionUtils.isNotEmpty(createdEntities)) {
            for (AtlasEntity atlasEntity : createdEntities) {
                String guid = atlasEntity.getGuid();
                AtlasVertex vertex = context.getVertex(guid);
                AtlasEntityType entityType = context.getType(guid);
                this.mapRelationshipAttributes(atlasEntity, entityType, vertex, EntityMutations.EntityOperation.CREATE, context);
                this.mapAttributes((AtlasStruct)atlasEntity, (AtlasStructType)entityType, vertex, EntityMutations.EntityOperation.CREATE, context);
                this.setCustomAttributes(vertex, atlasEntity);
                resp.addEntity(EntityMutations.EntityOperation.CREATE, this.constructHeader(atlasEntity, vertex));
                this.addClassifications(context, guid, atlasEntity.getClassifications());
                this.addOrUpdateBusinessAttributes(vertex, entityType, atlasEntity.getBusinessAttributes());
                reqContext.cache(atlasEntity);
            }
        }
        EntityMutations.EntityOperation entityOperation = updateType = isPartialUpdate ? EntityMutations.EntityOperation.PARTIAL_UPDATE : EntityMutations.EntityOperation.UPDATE;
        if (CollectionUtils.isNotEmpty(updatedEntities)) {
            for (AtlasEntity updatedEntity : updatedEntities) {
                String guid = updatedEntity.getGuid();
                AtlasVertex vertex = context.getVertex(guid);
                AtlasEntityType entityType = context.getType(guid);
                this.mapRelationshipAttributes(updatedEntity, entityType, vertex, EntityMutations.EntityOperation.UPDATE, context);
                this.mapAttributes((AtlasStruct)updatedEntity, (AtlasStructType)entityType, vertex, updateType, context);
                this.setCustomAttributes(vertex, updatedEntity);
                if (replaceClassifications) {
                    this.deleteClassifications(guid);
                    this.addClassifications(context, guid, updatedEntity.getClassifications());
                }
                if (replaceBusinessAttributes) {
                    this.setBusinessAttributes(vertex, entityType, updatedEntity.getBusinessAttributes());
                }
                resp.addEntity(updateType, this.constructHeader(updatedEntity, vertex));
                reqContext.cache(updatedEntity);
            }
        }
        if (CollectionUtils.isNotEmpty(context.getEntitiesToDelete())) {
            this.deleteDelegate.getHandler().deleteEntities(context.getEntitiesToDelete());
        }
        if (!(requestContext = RequestContext.get()).isPurgeRequested()) {
            for (AtlasEntityHeader entity : requestContext.getDeletedEntities()) {
                resp.addEntity(EntityMutations.EntityOperation.DELETE, entity);
            }
        }
        for (AtlasEntityHeader entity : requestContext.getUpdatedEntities()) {
            resp.addEntity(updateType, entity);
        }
        RequestContext.get().endMetricRecord(metric);
        return resp;
    }

    public void setCustomAttributes(AtlasVertex vertex, AtlasEntity entity) {
        String customAttributesString = this.getCustomAttributesString(entity);
        if (customAttributesString != null) {
            AtlasGraphUtilsV2.setEncodedProperty(vertex, Constants.CUSTOM_ATTRIBUTES_PROPERTY_KEY, customAttributesString);
        }
    }

    public void setLabels(AtlasVertex vertex, Set<String> labels) throws AtlasBaseException {
        Set<String> removedLabels;
        Set<String> addedLabels;
        Set<String> currentLabels = GraphHelper.getLabels((AtlasElement)vertex);
        if (CollectionUtils.isEmpty(currentLabels)) {
            addedLabels = labels;
            removedLabels = null;
        } else if (CollectionUtils.isEmpty(labels)) {
            addedLabels = null;
            removedLabels = currentLabels;
        } else {
            addedLabels = new HashSet<String>(CollectionUtils.subtract(labels, currentLabels));
            removedLabels = new HashSet<String>(CollectionUtils.subtract(currentLabels, labels));
        }
        this.updateLabels(vertex, labels);
        GraphHelper.updateModificationMetadata(vertex);
        this.entityChangeNotifier.onLabelsUpdatedFromEntity(GraphHelper.getGuid(vertex), addedLabels, removedLabels);
    }

    public void addLabels(AtlasVertex vertex, Set<String> labels) throws AtlasBaseException {
        if (CollectionUtils.isNotEmpty(labels)) {
            Set<String> updatedLabels;
            Set<String> existingLabels = GraphHelper.getLabels((AtlasElement)vertex);
            if (CollectionUtils.isEmpty(existingLabels)) {
                updatedLabels = labels;
            } else {
                updatedLabels = new HashSet<String>(existingLabels);
                updatedLabels.addAll(labels);
            }
            if (!updatedLabels.equals(existingLabels)) {
                this.updateLabels(vertex, updatedLabels);
                updatedLabels.removeAll(existingLabels);
                GraphHelper.updateModificationMetadata(vertex);
                this.entityChangeNotifier.onLabelsUpdatedFromEntity(GraphHelper.getGuid(vertex), updatedLabels, null);
            }
        }
    }

    public void removeLabels(AtlasVertex vertex, Set<String> labels) throws AtlasBaseException {
        if (CollectionUtils.isNotEmpty(labels)) {
            Set<String> existingLabels = GraphHelper.getLabels((AtlasElement)vertex);
            if (CollectionUtils.isNotEmpty(existingLabels)) {
                HashSet<String> updatedLabels = new HashSet<String>(existingLabels);
                updatedLabels.removeAll(labels);
                if (!updatedLabels.equals(existingLabels)) {
                    this.updateLabels(vertex, updatedLabels);
                    existingLabels.removeAll(updatedLabels);
                    GraphHelper.updateModificationMetadata(vertex);
                    this.entityChangeNotifier.onLabelsUpdatedFromEntity(GraphHelper.getGuid(vertex), null, existingLabels);
                }
            }
        }
    }

    public void setBusinessAttributes(AtlasVertex entityVertex, AtlasEntityType entityType, Map<String, Map<String, Object>> businessAttributes) throws AtlasBaseException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> setBusinessAttributes(entityVertex={}, entityType={}, businessAttributes={}", new Object[]{entityVertex, entityType.getTypeName(), businessAttributes});
        }
        Map entityTypeBusinessAttributes = entityType.getBusinessAttributes();
        HashMap<String, Map<String, Object>> updatedBusinessAttributes = new HashMap<String, Map<String, Object>>();
        for (Map.Entry entry : entityTypeBusinessAttributes.entrySet()) {
            String bmName = (String)entry.getKey();
            Map bmAttributes = (Map)entry.getValue();
            Map<String, Object> entityBmAttributes = MapUtils.isEmpty(businessAttributes) ? null : businessAttributes.get(bmName);
            for (AtlasBusinessMetadataType.AtlasBusinessAttribute bmAttribute : bmAttributes.values()) {
                Object bmAttrNewValue;
                String bmAttrName = bmAttribute.getName();
                Object bmAttrExistingValue = entityVertex.getProperty(bmAttribute.getVertexPropertyName(), Object.class);
                Object object = bmAttrNewValue = MapUtils.isEmpty(entityBmAttributes) ? null : entityBmAttributes.get(bmAttrName);
                if (bmAttrExistingValue == null) {
                    if (bmAttrNewValue == null) continue;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("setBusinessAttributes(): adding {}.{}={}", new Object[]{bmName, bmAttribute.getName(), bmAttrNewValue});
                    }
                    this.mapAttribute((AtlasStructType.AtlasAttribute)bmAttribute, bmAttrNewValue, entityVertex, EntityMutations.EntityOperation.CREATE, new EntityMutationContext());
                    this.addToUpdatedBusinessAttributes(updatedBusinessAttributes, bmAttribute, bmAttrNewValue);
                    continue;
                }
                if (bmAttrNewValue != null) {
                    if (Objects.equals(bmAttrExistingValue, bmAttrNewValue)) continue;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("setBusinessAttributes(): updating {}.{}={}", new Object[]{bmName, bmAttribute.getName(), bmAttrNewValue});
                    }
                    this.mapAttribute((AtlasStructType.AtlasAttribute)bmAttribute, bmAttrNewValue, entityVertex, EntityMutations.EntityOperation.UPDATE, new EntityMutationContext());
                    this.addToUpdatedBusinessAttributes(updatedBusinessAttributes, bmAttribute, bmAttrNewValue);
                    continue;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("setBusinessAttributes(): removing {}.{}", (Object)bmName, (Object)bmAttribute.getName());
                }
                entityVertex.removeProperty(bmAttribute.getVertexPropertyName());
                this.addToUpdatedBusinessAttributes(updatedBusinessAttributes, bmAttribute, bmAttrNewValue);
            }
        }
        if (MapUtils.isNotEmpty(updatedBusinessAttributes)) {
            GraphHelper.updateModificationMetadata(entityVertex);
            this.entityChangeNotifier.onBusinessAttributesUpdated(AtlasGraphUtilsV2.getIdFromVertex(entityVertex), updatedBusinessAttributes);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== setBusinessAttributes(entityVertex={}, entityType={}, businessAttributes={}", new Object[]{entityVertex, entityType.getTypeName(), businessAttributes});
        }
        GraphHelper.updateModificationMetadata(entityVertex);
    }

    public void addOrUpdateBusinessAttributes(AtlasVertex entityVertex, AtlasEntityType entityType, Map<String, Map<String, Object>> businessAttributes) throws AtlasBaseException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> addOrUpdateBusinessAttributes(entityVertex={}, entityType={}, businessAttributes={}", new Object[]{entityVertex, entityType.getTypeName(), businessAttributes});
        }
        Map entityTypeBusinessAttributes = entityType.getBusinessAttributes();
        HashMap<String, Map<String, Object>> updatedBusinessAttributes = new HashMap<String, Map<String, Object>>();
        if (MapUtils.isNotEmpty((Map)entityTypeBusinessAttributes) && MapUtils.isNotEmpty(businessAttributes)) {
            for (Map.Entry entry : entityTypeBusinessAttributes.entrySet()) {
                String bmName = (String)entry.getKey();
                Map bmAttributes = (Map)entry.getValue();
                Map<String, Object> entityBmAttributes = businessAttributes.get(bmName);
                if (MapUtils.isEmpty(entityBmAttributes)) continue;
                for (AtlasBusinessMetadataType.AtlasBusinessAttribute bmAttribute : bmAttributes.values()) {
                    String bmAttrName = bmAttribute.getName();
                    if (!entityBmAttributes.containsKey(bmAttrName)) continue;
                    Object bmAttrValue = entityBmAttributes.get(bmAttrName);
                    Object existingValue = AtlasGraphUtilsV2.getEncodedProperty(entityVertex, bmAttribute.getVertexPropertyName(), Object.class);
                    if (existingValue == null) {
                        if (bmAttrValue == null) continue;
                        this.mapAttribute((AtlasStructType.AtlasAttribute)bmAttribute, bmAttrValue, entityVertex, EntityMutations.EntityOperation.CREATE, new EntityMutationContext());
                        this.addToUpdatedBusinessAttributes(updatedBusinessAttributes, bmAttribute, bmAttrValue);
                        continue;
                    }
                    if (Objects.equals(existingValue, bmAttrValue)) continue;
                    this.mapAttribute((AtlasStructType.AtlasAttribute)bmAttribute, bmAttrValue, entityVertex, EntityMutations.EntityOperation.UPDATE, new EntityMutationContext());
                    this.addToUpdatedBusinessAttributes(updatedBusinessAttributes, bmAttribute, bmAttrValue);
                }
            }
        }
        if (MapUtils.isNotEmpty(updatedBusinessAttributes)) {
            GraphHelper.updateModificationMetadata(entityVertex);
            this.entityChangeNotifier.onBusinessAttributesUpdated(AtlasGraphUtilsV2.getIdFromVertex(entityVertex), updatedBusinessAttributes);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== addOrUpdateBusinessAttributes(entityVertex={}, entityType={}, businessAttributes={}", new Object[]{entityVertex, entityType.getTypeName(), businessAttributes});
        }
    }

    public void removeBusinessAttributes(AtlasVertex entityVertex, AtlasEntityType entityType, Map<String, Map<String, Object>> businessAttributes) throws AtlasBaseException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> removeBusinessAttributes(entityVertex={}, entityType={}, businessAttributes={}", new Object[]{entityVertex, entityType.getTypeName(), businessAttributes});
        }
        Map entityTypeBusinessAttributes = entityType.getBusinessAttributes();
        HashMap<String, Map<String, Object>> updatedBusinessAttributes = new HashMap<String, Map<String, Object>>();
        if (MapUtils.isNotEmpty((Map)entityTypeBusinessAttributes) && MapUtils.isNotEmpty(businessAttributes)) {
            for (Map.Entry entry : entityTypeBusinessAttributes.entrySet()) {
                String bmName = (String)entry.getKey();
                Map bmAttributes = (Map)entry.getValue();
                if (!businessAttributes.containsKey(bmName)) continue;
                Map<String, Object> entityBmAttributes = businessAttributes.get(bmName);
                for (AtlasBusinessMetadataType.AtlasBusinessAttribute bmAttribute : bmAttributes.values()) {
                    if (!MapUtils.isEmpty(entityBmAttributes) && !entityBmAttributes.containsKey(bmAttribute.getName())) continue;
                    entityVertex.removeProperty(bmAttribute.getVertexPropertyName());
                    this.addToUpdatedBusinessAttributes(updatedBusinessAttributes, bmAttribute, null);
                }
            }
        }
        if (MapUtils.isNotEmpty(updatedBusinessAttributes)) {
            GraphHelper.updateModificationMetadata(entityVertex);
            this.entityChangeNotifier.onBusinessAttributesUpdated(AtlasGraphUtilsV2.getIdFromVertex(entityVertex), updatedBusinessAttributes);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== removeBusinessAttributes(entityVertex={}, entityType={}, businessAttributes={}", new Object[]{entityVertex, entityType.getTypeName(), businessAttributes});
        }
    }

    private AtlasVertex createStructVertex(AtlasStruct struct) {
        return this.createStructVertex(struct.getTypeName());
    }

    private AtlasVertex createStructVertex(AtlasObjectId objectId) {
        return this.createStructVertex(objectId.getTypeName());
    }

    private AtlasVertex createStructVertex(String typeName) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> createStructVertex({})", (Object)typeName);
        }
        AtlasVertex ret = this.graph.addVertex();
        AtlasGraphUtilsV2.setEncodedProperty(ret, Constants.ENTITY_TYPE_PROPERTY_KEY, typeName);
        AtlasGraphUtilsV2.setEncodedProperty(ret, Constants.STATE_PROPERTY_KEY, AtlasEntity.Status.ACTIVE.name());
        AtlasGraphUtilsV2.setEncodedProperty(ret, Constants.TIMESTAMP_PROPERTY_KEY, RequestContext.get().getRequestTime());
        AtlasGraphUtilsV2.setEncodedProperty(ret, Constants.MODIFICATION_TIMESTAMP_PROPERTY_KEY, RequestContext.get().getRequestTime());
        AtlasGraphUtilsV2.setEncodedProperty(ret, Constants.CREATED_BY_KEY, RequestContext.get().getUser());
        AtlasGraphUtilsV2.setEncodedProperty(ret, Constants.MODIFIED_BY_KEY, RequestContext.get().getUser());
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== createStructVertex({})", (Object)typeName);
        }
        return ret;
    }

    private AtlasVertex createClassificationVertex(AtlasClassification classification) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> createVertex({})", (Object)classification.getTypeName());
        }
        AtlasClassificationType classificationType = this.typeRegistry.getClassificationTypeByName(classification.getTypeName());
        AtlasVertex ret = this.createStructVertex((AtlasStruct)classification);
        AtlasGraphUtilsV2.addEncodedProperty(ret, Constants.SUPER_TYPES_PROPERTY_KEY, classificationType.getAllSuperTypes());
        AtlasGraphUtilsV2.setEncodedProperty(ret, Constants.CLASSIFICATION_ENTITY_GUID, classification.getEntityGuid());
        AtlasGraphUtilsV2.setEncodedProperty(ret, Constants.CLASSIFICATION_ENTITY_STATUS, classification.getEntityStatus().name());
        return ret;
    }

    private void mapAttributes(AtlasStruct struct, AtlasVertex vertex, EntityMutations.EntityOperation op, EntityMutationContext context) throws AtlasBaseException {
        this.mapAttributes(struct, this.getStructType(struct.getTypeName()), vertex, op, context);
    }

    private void mapAttributes(AtlasStruct struct, AtlasStructType structType, AtlasVertex vertex, EntityMutations.EntityOperation op, EntityMutationContext context) throws AtlasBaseException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> mapAttributes({}, {})", (Object)op, (Object)struct.getTypeName());
        }
        if (MapUtils.isNotEmpty((Map)struct.getAttributes())) {
            AtlasPerfMetrics.MetricRecorder metric = RequestContext.get().startMetricRecord("mapAttributes");
            if (op.equals((Object)EntityMutations.EntityOperation.CREATE)) {
                for (AtlasStructType.AtlasAttribute attribute : structType.getAllAttributes().values()) {
                    Object attrValue = struct.getAttribute(attribute.getName());
                    this.mapAttribute(attribute, attrValue, vertex, op, context);
                }
            } else if (op.equals((Object)EntityMutations.EntityOperation.UPDATE) || op.equals((Object)EntityMutations.EntityOperation.PARTIAL_UPDATE)) {
                for (String attrName : struct.getAttributes().keySet()) {
                    AtlasStructType.AtlasAttribute attribute = structType.getAttribute(attrName);
                    if (attribute != null) {
                        Object attrValue = struct.getAttribute(attrName);
                        this.mapAttribute(attribute, attrValue, vertex, op, context);
                        continue;
                    }
                    LOG.warn("mapAttributes(): invalid attribute {}.{}. Ignored..", (Object)struct.getTypeName(), (Object)attrName);
                }
            }
            GraphHelper.updateModificationMetadata(vertex);
            RequestContext.get().endMetricRecord(metric);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== mapAttributes({}, {})", (Object)op, (Object)struct.getTypeName());
        }
    }

    private void mapRelationshipAttributes(AtlasEntity entity, AtlasEntityType entityType, AtlasVertex vertex, EntityMutations.EntityOperation op, EntityMutationContext context) throws AtlasBaseException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> mapRelationshipAttributes({}, {})", (Object)op, (Object)entity.getTypeName());
        }
        if (MapUtils.isNotEmpty((Map)entity.getRelationshipAttributes())) {
            AtlasPerfMetrics.MetricRecorder metric = RequestContext.get().startMetricRecord("mapRelationshipAttributes");
            if (op.equals((Object)EntityMutations.EntityOperation.CREATE)) {
                for (String attrName : entityType.getRelationshipAttributes().keySet()) {
                    Object attrValue = entity.getRelationshipAttribute(attrName);
                    String relationType = AtlasEntityUtil.getRelationshipType((Object)attrValue);
                    AtlasStructType.AtlasAttribute attribute = entityType.getRelationshipAttribute(attrName, relationType);
                    this.mapAttribute(attribute, attrValue, vertex, op, context);
                }
            } else if (op.equals((Object)EntityMutations.EntityOperation.UPDATE) || op.equals((Object)EntityMutations.EntityOperation.PARTIAL_UPDATE)) {
                for (String attrName : entityType.getRelationshipAttributes().keySet()) {
                    if (!entity.hasRelationshipAttribute(attrName)) continue;
                    Object attrValue = entity.getRelationshipAttribute(attrName);
                    String relationType = AtlasEntityUtil.getRelationshipType((Object)attrValue);
                    AtlasStructType.AtlasAttribute attribute = entityType.getRelationshipAttribute(attrName, relationType);
                    this.mapAttribute(attribute, attrValue, vertex, op, context);
                }
            }
            GraphHelper.updateModificationMetadata(vertex);
            RequestContext.get().endMetricRecord(metric);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== mapRelationshipAttributes({}, {})", (Object)op, (Object)entity.getTypeName());
        }
    }

    private void mapAttribute(AtlasStructType.AtlasAttribute attribute, Object attrValue, AtlasVertex vertex, EntityMutations.EntityOperation op, EntityMutationContext context) throws AtlasBaseException {
        boolean isDeletedEntity = context.isDeletedEntity(vertex);
        AtlasType attrType = attribute.getAttributeType();
        if (attrValue == null) {
            AtlasStructDef.AtlasAttributeDef attributeDef = attribute.getAttributeDef();
            if (attrType.getTypeCategory() == TypeCategory.PRIMITIVE) {
                attrValue = attributeDef.getDefaultValue() != null ? attrType.createDefaultValue((Object)attributeDef.getDefaultValue()) : (attribute.getAttributeDef().getIsOptional() ? attrType.createOptionalDefaultValue() : attrType.createDefaultValue());
            }
        }
        if (attrType.getTypeCategory() == TypeCategory.PRIMITIVE || attrType.getTypeCategory() == TypeCategory.ENUM) {
            this.mapPrimitiveValue(vertex, attribute, attrValue, isDeletedEntity);
        } else {
            AttributeMutationContext ctx = new AttributeMutationContext(op, vertex, attribute, attrValue);
            this.mapToVertexByTypeCategory(ctx, context);
        }
    }

    private Object mapToVertexByTypeCategory(AttributeMutationContext ctx, EntityMutationContext context) throws AtlasBaseException {
        if (ctx.getOp() == EntityMutations.EntityOperation.CREATE && ctx.getValue() == null) {
            return null;
        }
        switch (ctx.getAttrType().getTypeCategory()) {
            case PRIMITIVE: 
            case ENUM: {
                return this.mapPrimitiveValue(ctx, context);
            }
            case STRUCT: {
                String edgeLabel = AtlasGraphUtilsV2.getEdgeLabel(ctx.getVertexProperty());
                AtlasEdge currentEdge = this.graphHelper.getEdgeForLabel(ctx.getReferringVertex(), edgeLabel);
                AtlasEdge edge = currentEdge != null ? currentEdge : null;
                ctx.setExistingEdge(edge);
                AtlasEdge newEdge = this.mapStructValue(ctx, context);
                if (currentEdge != null && !currentEdge.equals(newEdge)) {
                    this.deleteDelegate.getHandler().deleteEdgeReference(currentEdge, ctx.getAttrType().getTypeCategory(), false, true, ctx.getReferringVertex());
                }
                return newEdge;
            }
            case OBJECT_ID_TYPE: {
                String relationshipGuid;
                if (ctx.getAttributeDef().isSoftReferenced()) {
                    return this.mapSoftRefValueWithUpdate(ctx, context);
                }
                AtlasStructType.AtlasAttribute.AtlasRelationshipEdgeDirection edgeDirection = ctx.getAttribute().getRelationshipEdgeDirection();
                String edgeLabel = ctx.getAttribute().getRelationshipEdgeLabel();
                if (StringUtils.isEmpty((CharSequence)edgeLabel)) {
                    edgeLabel = AtlasGraphUtilsV2.getEdgeLabel(ctx.getVertexProperty());
                }
                AtlasEdge currentEdge = StringUtils.isNotEmpty((CharSequence)(relationshipGuid = EntityGraphMapper.getRelationshipGuid(ctx.getValue()))) && !RequestContext.get().isImportInProgress() ? this.graphHelper.getEdgeForGUID(relationshipGuid) : this.graphHelper.getEdgeForLabel(ctx.getReferringVertex(), edgeLabel, edgeDirection);
                AtlasEdge newEdge = null;
                if (ctx.getValue() != null) {
                    AtlasEntityType instanceType = this.getInstanceType(ctx.getValue(), context);
                    AtlasEdge edge = currentEdge != null ? currentEdge : null;
                    ctx.setElementType((AtlasType)instanceType);
                    ctx.setExistingEdge(edge);
                    newEdge = this.mapObjectIdValueUsingRelationship(ctx, context);
                    if (ctx.getAttribute().getInverseRefAttribute() != null) {
                        this.addInverseReference(context, ctx.getAttribute().getInverseRefAttribute(), newEdge, EntityGraphMapper.getRelationshipAttributes(ctx.getValue()));
                    }
                }
                if (currentEdge == null && newEdge != null) {
                    if (edgeDirection == AtlasStructType.AtlasAttribute.AtlasRelationshipEdgeDirection.IN) {
                        this.recordEntityUpdate(newEdge.getOutVertex());
                    } else {
                        this.recordEntityUpdate(newEdge.getInVertex());
                    }
                }
                if (currentEdge != null && !currentEdge.equals(newEdge)) {
                    if (GraphHelper.isRelationshipEdge(newEdge)) {
                        AtlasVertex attrVertex = context.getDiscoveryContext().getResolvedEntityVertex(EntityGraphMapper.getGuid(ctx.getValue()));
                        this.recordEntityUpdate(attrVertex);
                    }
                    this.deleteDelegate.getHandler().deleteEdgeReference(currentEdge, ctx.getAttrType().getTypeCategory(), ctx.getAttribute().isOwnedRef(), true, ctx.getAttribute().getRelationshipEdgeDirection(), ctx.getReferringVertex());
                }
                return newEdge;
            }
            case MAP: {
                return this.mapMapValue(ctx, context);
            }
            case ARRAY: {
                return this.mapArrayValue(ctx, context);
            }
        }
        throw new AtlasBaseException(AtlasErrorCode.TYPE_CATEGORY_INVALID, new String[]{ctx.getAttrType().getTypeCategory().name()});
    }

    private String mapSoftRefValue(AttributeMutationContext ctx, EntityMutationContext context) {
        String ret = null;
        if (ctx.getValue() instanceof AtlasObjectId) {
            AtlasObjectId objectId = (AtlasObjectId)ctx.getValue();
            String typeName = objectId.getTypeName();
            String guid = AtlasTypeUtil.isUnAssignedGuid((String)objectId.getGuid()) ? context.getGuidAssignments().get(objectId.getGuid()) : objectId.getGuid();
            ret = AtlasEntityUtil.formatSoftRefValue((String)typeName, (String)guid);
        } else if (ctx.getValue() != null) {
            LOG.warn("mapSoftRefValue: Was expecting AtlasObjectId, but found: {}", ctx.getValue().getClass());
        }
        this.setAssignedGuid(ctx.getValue(), context);
        return ret;
    }

    private Object mapSoftRefValueWithUpdate(AttributeMutationContext ctx, EntityMutationContext context) {
        String softRefValue = this.mapSoftRefValue(ctx, context);
        AtlasGraphUtilsV2.setProperty(ctx.getReferringVertex(), ctx.getVertexProperty(), softRefValue);
        return softRefValue;
    }

    private void addInverseReference(EntityMutationContext context, AtlasStructType.AtlasAttribute inverseAttribute, AtlasEdge edge, Map<String, Object> relationshipAttributes) throws AtlasBaseException {
        AtlasStructType inverseType = inverseAttribute.getDefinedInType();
        AtlasVertex inverseVertex = edge.getInVertex();
        String inverseEdgeLabel = inverseAttribute.getRelationshipEdgeLabel();
        AtlasEdge inverseEdge = this.graphHelper.getEdgeForLabel(inverseVertex, inverseEdgeLabel);
        String propertyName = AtlasGraphUtilsV2.getQualifiedAttributePropertyKey(inverseType, inverseAttribute.getName());
        AtlasEdge newEdge = this.createInverseReferenceUsingRelationship(context, inverseAttribute, edge, relationshipAttributes);
        boolean inverseUpdated = true;
        switch (inverseAttribute.getAttributeType().getTypeCategory()) {
            case OBJECT_ID_TYPE: {
                if (inverseEdge == null) break;
                if (!inverseEdge.equals(newEdge)) {
                    this.deleteDelegate.getHandler().deleteEdgeReference(inverseEdge, inverseAttribute.getAttributeType().getTypeCategory(), inverseAttribute.isOwnedRef(), true, inverseVertex);
                    break;
                }
                inverseUpdated = false;
                break;
            }
            case ARRAY: {
                ArrayList<String> elements = (ArrayList<String>)inverseVertex.getProperty(propertyName, List.class);
                if (newEdge != null && elements == null) {
                    elements = new ArrayList<String>();
                    elements.add(newEdge.getId().toString());
                    inverseVertex.setProperty(propertyName, elements);
                    break;
                }
                if (newEdge != null && !elements.contains(newEdge.getId().toString())) {
                    elements.add(newEdge.getId().toString());
                    inverseVertex.setProperty(propertyName, elements);
                    break;
                }
                inverseUpdated = false;
                break;
            }
        }
        if (inverseUpdated) {
            RequestContext requestContext = RequestContext.get();
            if (!requestContext.isDeletedEntity(GraphHelper.getGuid(inverseVertex))) {
                GraphHelper.updateModificationMetadata(inverseVertex);
                requestContext.recordEntityUpdate(this.entityRetriever.toAtlasEntityHeader(inverseVertex));
            }
        }
    }

    private AtlasEdge createInverseReferenceUsingRelationship(EntityMutationContext context, AtlasStructType.AtlasAttribute inverseAttribute, AtlasEdge edge, Map<String, Object> relationshipAttributes) throws AtlasBaseException {
        AtlasEdge ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> createInverseReferenceUsingRelationship()");
        }
        String inverseAttributeName = inverseAttribute.getName();
        AtlasStructType inverseAttributeType = inverseAttribute.getDefinedInType();
        AtlasVertex inverseVertex = edge.getInVertex();
        AtlasVertex vertex = edge.getOutVertex();
        if (inverseAttributeType instanceof AtlasEntityType) {
            AtlasEntityType entityType = (AtlasEntityType)inverseAttributeType;
            if (entityType.hasRelationshipAttribute(inverseAttributeName)) {
                String relationshipName = this.graphHelper.getRelationshipTypeName(inverseVertex, entityType, inverseAttributeName);
                ret = this.getOrCreateRelationship(inverseVertex, vertex, relationshipName, relationshipAttributes);
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("No RelationshipDef defined between {} and {} on attribute: {}", new Object[]{inverseAttributeType, AtlasGraphUtilsV2.getTypeName((AtlasElement)vertex), inverseAttributeName});
                }
                ret = this.createInverseReference(inverseAttribute, inverseAttributeType, inverseVertex, vertex);
            }
        } else {
            ret = this.createInverseReference(inverseAttribute, inverseAttributeType, inverseVertex, vertex);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== createInverseReferenceUsingRelationship()");
        }
        this.updateRelationshipGuidForImport(context, inverseAttributeName, inverseVertex, ret);
        return ret;
    }

    private void updateRelationshipGuidForImport(EntityMutationContext context, String inverseAttributeName, AtlasVertex inverseVertex, AtlasEdge edge) throws AtlasBaseException {
        if (!RequestContext.get().isImportInProgress()) {
            return;
        }
        String parentGuid = GraphHelper.getGuid(inverseVertex);
        if (StringUtils.isEmpty((CharSequence)parentGuid)) {
            return;
        }
        AtlasEntity entity = context.getCreatedOrUpdatedEntity(parentGuid);
        if (entity == null) {
            return;
        }
        String parentRelationshipGuid = EntityGraphMapper.getRelationshipGuid(entity.getRelationshipAttribute(inverseAttributeName));
        if (StringUtils.isEmpty((CharSequence)parentRelationshipGuid)) {
            return;
        }
        AtlasGraphUtilsV2.setEncodedProperty(edge, Constants.RELATIONSHIP_GUID_PROPERTY_KEY, parentRelationshipGuid);
    }

    private AtlasEdge createInverseReference(AtlasStructType.AtlasAttribute inverseAttribute, AtlasStructType inverseAttributeType, AtlasVertex inverseVertex, AtlasVertex vertex) throws AtlasBaseException {
        AtlasEdge ret;
        String propertyName = AtlasGraphUtilsV2.getQualifiedAttributePropertyKey(inverseAttributeType, inverseAttribute.getName());
        String inverseEdgeLabel = AtlasGraphUtilsV2.getEdgeLabel(propertyName);
        try {
            ret = this.graphHelper.getOrCreateEdge(inverseVertex, vertex, inverseEdgeLabel);
        }
        catch (RepositoryException e) {
            throw new AtlasBaseException(AtlasErrorCode.INTERNAL_ERROR, (Throwable)((Object)e), new String[0]);
        }
        return ret;
    }

    private Object mapPrimitiveValue(AttributeMutationContext ctx, EntityMutationContext context) {
        return this.mapPrimitiveValue(ctx.getReferringVertex(), ctx.getAttribute(), ctx.getValue(), context.isDeletedEntity(ctx.referringVertex));
    }

    private Object mapPrimitiveValue(AtlasVertex vertex, AtlasStructType.AtlasAttribute attribute, Object valueFromEntity, boolean isDeletedEntity) {
        String uniqPropName;
        String value;
        boolean isIndexableStrAttr = attribute.getAttributeDef().getIsIndexable() && attribute.getAttributeType() instanceof AtlasBuiltInTypes.AtlasStringType;
        Object ret = valueFromEntity;
        if (ret != null && isIndexableStrAttr && (value = ret.toString()).length() > INDEXED_STR_SAFE_LEN) {
            RequestContext requestContext = RequestContext.get();
            int trimmedLength = requestContext.getAttemptCount() <= 1 ? value.length() : (requestContext.getAttemptCount() >= requestContext.getMaxAttempts() ? INDEXED_STR_SAFE_LEN : (requestContext.getAttemptCount() == 2 ? Math.min(4 * INDEXED_STR_SAFE_LEN, value.length()) : (requestContext.getAttemptCount() == 3 ? Math.min(2 * INDEXED_STR_SAFE_LEN, value.length()) : INDEXED_STR_SAFE_LEN)));
            if (trimmedLength < value.length()) {
                LOG.warn("Length of indexed attribute {} is {} characters, longer than safe-limit {}; trimming to {} - attempt #{}", new Object[]{attribute.getQualifiedName(), value.length(), INDEXED_STR_SAFE_LEN, trimmedLength, requestContext.getAttemptCount()});
                String checksumSuffix = ":" + DigestUtils.sha256Hex((String)value);
                ret = value.substring(0, trimmedLength - checksumSuffix.length()) + checksumSuffix;
            } else {
                LOG.warn("Length of indexed attribute {} is {} characters, longer than safe-limit {}", new Object[]{attribute.getQualifiedName(), value.length(), INDEXED_STR_SAFE_LEN});
            }
        }
        AtlasGraphUtilsV2.setEncodedProperty(vertex, attribute.getVertexPropertyName(), ret);
        String string = uniqPropName = attribute != null ? attribute.getVertexUniquePropertyName() : null;
        if (uniqPropName != null) {
            if (isDeletedEntity || AtlasGraphUtilsV2.getState((AtlasElement)vertex) == AtlasEntity.Status.DELETED) {
                vertex.removeProperty(uniqPropName);
            } else {
                AtlasGraphUtilsV2.setEncodedProperty(vertex, uniqPropName, ret);
            }
        }
        return ret;
    }

    private AtlasEdge mapStructValue(AttributeMutationContext ctx, EntityMutationContext context) throws AtlasBaseException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> mapStructValue({})", (Object)ctx);
        }
        AtlasEdge ret = null;
        if (ctx.getCurrentEdge() != null) {
            AtlasStruct structVal = null;
            if (ctx.getValue() instanceof AtlasStruct) {
                structVal = (AtlasStruct)ctx.getValue();
            } else if (ctx.getValue() instanceof Map) {
                structVal = new AtlasStruct(ctx.getAttrType().getTypeName(), AtlasTypeUtil.toStructAttributes((Map)((Map)ctx.getValue())));
            }
            if (structVal != null) {
                this.updateVertex(structVal, ctx.getCurrentEdge().getInVertex(), context);
            }
            ret = ctx.getCurrentEdge();
        } else if (ctx.getValue() != null) {
            String edgeLabel = AtlasGraphUtilsV2.getEdgeLabel(ctx.getVertexProperty());
            AtlasStruct structVal = null;
            if (ctx.getValue() instanceof AtlasStruct) {
                structVal = (AtlasStruct)ctx.getValue();
            } else if (ctx.getValue() instanceof Map) {
                structVal = new AtlasStruct(ctx.getAttrType().getTypeName(), AtlasTypeUtil.toStructAttributes((Map)((Map)ctx.getValue())));
            }
            if (structVal != null) {
                ret = this.createVertex(structVal, ctx.getReferringVertex(), edgeLabel, context);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== mapStructValue({})", (Object)ctx);
        }
        return ret;
    }

    private AtlasEdge mapObjectIdValue(AttributeMutationContext ctx, EntityMutationContext context) throws AtlasBaseException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> mapObjectIdValue({})", (Object)ctx);
        }
        AtlasEdge ret = null;
        String guid = EntityGraphMapper.getGuid(ctx.getValue());
        AtlasVertex entityVertex = context.getDiscoveryContext().getResolvedEntityVertex(guid);
        if (entityVertex == null) {
            AtlasObjectId objId;
            if (AtlasTypeUtil.isAssignedGuid((String)guid)) {
                entityVertex = context.getVertex(guid);
            }
            if (entityVertex == null && (objId = EntityGraphMapper.getObjectId(ctx.getValue())) != null) {
                entityVertex = context.getDiscoveryContext().getResolvedEntityVertex(objId);
            }
        }
        if (entityVertex == null) {
            throw new AtlasBaseException(AtlasErrorCode.INVALID_OBJECT_ID, new String[]{ctx.getValue() == null ? null : ctx.getValue().toString()});
        }
        if (ctx.getCurrentEdge() != null) {
            ret = this.updateEdge(ctx.getAttributeDef(), ctx.getValue(), ctx.getCurrentEdge(), entityVertex);
        } else if (ctx.getValue() != null) {
            String edgeLabel = AtlasGraphUtilsV2.getEdgeLabel(ctx.getVertexProperty());
            try {
                ret = this.graphHelper.getOrCreateEdge(ctx.getReferringVertex(), entityVertex, edgeLabel);
            }
            catch (RepositoryException e) {
                throw new AtlasBaseException(AtlasErrorCode.INTERNAL_ERROR, (Throwable)((Object)e), new String[0]);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== mapObjectIdValue({})", (Object)ctx);
        }
        return ret;
    }

    private AtlasEdge mapObjectIdValueUsingRelationship(AttributeMutationContext ctx, EntityMutationContext context) throws AtlasBaseException {
        AtlasEdge ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> mapObjectIdValueUsingRelationship({})", (Object)ctx);
        }
        String guid = EntityGraphMapper.getGuid(ctx.getValue());
        AtlasVertex attributeVertex = context.getDiscoveryContext().getResolvedEntityVertex(guid);
        AtlasVertex entityVertex = ctx.getReferringVertex();
        if (attributeVertex == null) {
            if (AtlasTypeUtil.isAssignedGuid((String)guid)) {
                attributeVertex = context.getVertex(guid);
            }
            if (attributeVertex == null) {
                AtlasObjectId objectId = EntityGraphMapper.getObjectId(ctx.getValue());
                AtlasVertex atlasVertex = attributeVertex = objectId != null ? context.getDiscoveryContext().getResolvedEntityVertex(objectId) : null;
            }
        }
        if (attributeVertex == null) {
            if (RequestContext.get().isImportInProgress()) {
                return null;
            }
            throw new AtlasBaseException(AtlasErrorCode.INVALID_OBJECT_ID, new String[]{ctx.getValue() == null ? null : ctx.getValue().toString()});
        }
        AtlasType type = this.typeRegistry.getType(AtlasGraphUtilsV2.getTypeName((AtlasElement)entityVertex));
        if (type instanceof AtlasEntityType) {
            AtlasEntityType entityType = (AtlasEntityType)type;
            AtlasStructType.AtlasAttribute attribute = ctx.getAttribute();
            String attributeName = attribute.getName();
            if (entityType.hasRelationshipAttribute(attributeName)) {
                Map<String, Object> relationshipAttributes = EntityGraphMapper.getRelationshipAttributes(ctx.getValue());
                if (ctx.getCurrentEdge() != null) {
                    ret = this.updateRelationship(ctx.getCurrentEdge(), entityVertex, attributeVertex, attribute.getRelationshipEdgeDirection(), relationshipAttributes);
                } else {
                    String relationshipGuid;
                    boolean isCreated;
                    AtlasVertex toVertex;
                    AtlasVertex fromVertex;
                    String relationshipName = attribute.getRelationshipName();
                    if (StringUtils.isEmpty((CharSequence)relationshipName)) {
                        relationshipName = this.graphHelper.getRelationshipTypeName(entityVertex, entityType, attributeName);
                    }
                    if (attribute.getRelationshipEdgeDirection() == AtlasStructType.AtlasAttribute.AtlasRelationshipEdgeDirection.IN) {
                        fromVertex = attributeVertex;
                        toVertex = entityVertex;
                    } else {
                        fromVertex = entityVertex;
                        toVertex = attributeVertex;
                    }
                    ret = this.getOrCreateRelationship(fromVertex, toVertex, relationshipName, relationshipAttributes);
                    boolean bl = isCreated = GraphHelper.getCreatedTime((AtlasElement)ret) == RequestContext.get().getRequestTime();
                    if (isCreated) {
                        this.recordEntityUpdate(attributeVertex);
                    }
                    if (RequestContext.get().isImportInProgress() && !StringUtils.isEmpty((CharSequence)(relationshipGuid = EntityGraphMapper.getRelationshipGuid(ctx.getValue())))) {
                        AtlasGraphUtilsV2.setEncodedProperty(ret, Constants.RELATIONSHIP_GUID_PROPERTY_KEY, relationshipGuid);
                    }
                }
            } else {
                if (WARN_ON_NO_RELATIONSHIP || LOG.isDebugEnabled()) {
                    LOG.warn("No RelationshipDef defined between {} and {} on attribute: {}. This can lead to severe performance degradation.", new Object[]{GraphHelper.getTypeName((AtlasElement)entityVertex), GraphHelper.getTypeName((AtlasElement)attributeVertex), attributeName});
                }
                ret = this.mapObjectIdValue(ctx, context);
            }
        } else {
            ret = this.mapObjectIdValue(ctx, context);
        }
        this.setAssignedGuid(ctx.getValue(), context);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== mapObjectIdValueUsingRelationship({})", (Object)ctx);
        }
        return ret;
    }

    private Map<String, Object> mapMapValue(AttributeMutationContext ctx, EntityMutationContext context) throws AtlasBaseException {
        boolean isNewValNull;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> mapMapValue({})", (Object)ctx);
        }
        HashMap<Object, Object> newVal = (HashMap)ctx.getValue();
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        AtlasMapType mapType = (AtlasMapType)ctx.getAttrType();
        AtlasStructType.AtlasAttribute attribute = ctx.getAttribute();
        Map<String, Object> currentMap = GraphHelper.getMapElementsProperty(mapType, ctx.getReferringVertex(), ctx.getVertexProperty(), attribute);
        boolean isReference = AtlasGraphUtilsV2.isReference(mapType.getValueType());
        boolean isSoftReference = ctx.getAttribute().getAttributeDef().isSoftReferenced();
        if (EntityMutations.EntityOperation.PARTIAL_UPDATE.equals((Object)ctx.getOp()) && attribute.getAttributeDef().isAppendOnPartialUpdate() && MapUtils.isNotEmpty(currentMap)) {
            if (MapUtils.isEmpty((Map)newVal)) {
                newVal = new HashMap<String, Object>(currentMap);
            } else {
                HashMap<String, Object> mergedVal = new HashMap<String, Object>(currentMap);
                for (Map.Entry entry : newVal.entrySet()) {
                    String newKey = entry.getKey().toString();
                    mergedVal.put(newKey, entry.getValue());
                }
                newVal = mergedVal;
            }
        }
        boolean bl = isNewValNull = newVal == null;
        if (isNewValNull) {
            newVal = new HashMap();
        }
        String propertyName = ctx.getVertexProperty();
        if (isReference) {
            for (Map.Entry entry : newVal.entrySet()) {
                String key2 = entry.getKey().toString();
                AtlasEdge existingEdge = isSoftReference ? null : EntityGraphMapper.getEdgeIfExists(mapType, currentMap, key2);
                AttributeMutationContext mapCtx = new AttributeMutationContext(ctx.getOp(), ctx.getReferringVertex(), attribute, entry.getValue(), propertyName, mapType.getValueType(), existingEdge);
                Object newEntry = this.mapCollectionElementsToVertex(mapCtx, context);
                if (!isSoftReference && newEntry instanceof AtlasEdge) {
                    AtlasEdge edge = (AtlasEdge)newEntry;
                    edge.setProperty(Constants.ATTRIBUTE_KEY_PROPERTY_KEY, (Object)key2);
                    AtlasStructType.AtlasAttribute inverseRefAttribute = attribute.getInverseRefAttribute();
                    if (inverseRefAttribute != null) {
                        this.addInverseReference(context, inverseRefAttribute, edge, EntityGraphMapper.getRelationshipAttributes(ctx.getValue()));
                    }
                    this.updateInConsistentOwnedMapVertices(ctx, mapType, newEntry);
                    newMap.put(key2, newEntry);
                }
                if (!isSoftReference) continue;
                newMap.put(key2, newEntry);
            }
            Map<String, Object> map = this.removeUnusedMapEntries(attribute, ctx.getReferringVertex(), currentMap, newMap);
            newMap.putAll(map);
        } else {
            if (isNewValNull) {
                ctx.getReferringVertex().setProperty(propertyName, null);
            } else {
                ctx.getReferringVertex().setProperty(propertyName, new HashMap<Object, Object>(newVal));
            }
            newVal.forEach((key, value) -> newMap.put(key.toString(), value));
        }
        if (isSoftReference) {
            if (isNewValNull) {
                ctx.getReferringVertex().setProperty(propertyName, null);
            } else {
                ctx.getReferringVertex().setProperty(propertyName, new HashMap<String, Object>(newMap));
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== mapMapValue({})", (Object)ctx);
        }
        return newMap;
    }

    public List mapArrayValue(AttributeMutationContext ctx, EntityMutationContext context) throws AtlasBaseException {
        int index;
        boolean isNewElementsNull;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> mapArrayValue({})", (Object)ctx);
        }
        AtlasStructType.AtlasAttribute attribute = ctx.getAttribute();
        List<Object> newElements = (ArrayList)ctx.getValue();
        AtlasArrayType arrType = (AtlasArrayType)attribute.getAttributeType();
        AtlasType elementType = arrType.getElementType();
        boolean isReference = AtlasGraphUtilsV2.isReference(elementType);
        boolean isSoftReference = ctx.getAttribute().getAttributeDef().isSoftReferenced();
        AtlasStructType.AtlasAttribute inverseRefAttribute = attribute.getInverseRefAttribute();
        AtlasStructDef.AtlasAttributeDef.Cardinality cardinality = attribute.getAttributeDef().getCardinality();
        ArrayList<AtlasEdge> newElementsCreated = new ArrayList<AtlasEdge>();
        List<AtlasEdge> allArrayElements = null;
        List<Object> currentElements = isReference && !isSoftReference ? GraphHelper.getCollectionElementsUsingRelationship(ctx.getReferringVertex(), attribute) : EntityGraphMapper.getArrayElementsProperty(elementType, isSoftReference, ctx.getReferringVertex(), ctx.getVertexProperty());
        if (EntityMutations.EntityOperation.PARTIAL_UPDATE.equals((Object)ctx.getOp()) && attribute.getAttributeDef().isAppendOnPartialUpdate() && CollectionUtils.isNotEmpty(currentElements)) {
            if (CollectionUtils.isEmpty((Collection)newElements)) {
                newElements = new ArrayList<AtlasEdge>(currentElements);
            } else {
                ArrayList<AtlasEdge> mergedVal = new ArrayList<AtlasEdge>(currentElements);
                mergedVal.addAll(newElements);
                newElements = mergedVal;
            }
        }
        boolean bl = isNewElementsNull = newElements == null;
        if (isNewElementsNull) {
            newElements = new ArrayList();
        }
        if (cardinality == AtlasStructDef.AtlasAttributeDef.Cardinality.SET) {
            newElements = newElements.stream().distinct().collect(Collectors.toList());
        }
        for (index = 0; index < newElements.size(); ++index) {
            AtlasEdge existingEdge = isSoftReference ? null : this.getEdgeAt(currentElements, index, elementType);
            AttributeMutationContext arrCtx = new AttributeMutationContext(ctx.getOp(), ctx.getReferringVertex(), ctx.getAttribute(), newElements.get(index), ctx.getVertexProperty(), elementType, existingEdge);
            Object newEntry = this.mapCollectionElementsToVertex(arrCtx, context);
            if (isReference && newEntry != null && newEntry instanceof AtlasEdge && inverseRefAttribute != null) {
                AtlasEdge newEdge = (AtlasEdge)newEntry;
                this.addInverseReference(context, inverseRefAttribute, newEdge, EntityGraphMapper.getRelationshipAttributes(ctx.getValue()));
            }
            if (newEntry == null) continue;
            newElementsCreated.add((AtlasEdge)newEntry);
        }
        if (isReference && !isSoftReference) {
            boolean isAppendOnPartialUpdate;
            boolean bl2 = isAppendOnPartialUpdate = RequestContext.get().isMigrationInProgress() || this.getAppendOptionForRelationship(ctx.getReferringVertex(), attribute.getName());
            if (isAppendOnPartialUpdate) {
                allArrayElements = this.unionCurrentAndNewElements(attribute, currentElements, newElementsCreated);
            } else {
                List<AtlasEdge> activeCurrentElements = this.removeUnusedArrayEntries(attribute, currentElements, newElementsCreated, ctx.getReferringVertex());
                allArrayElements = this.unionCurrentAndNewElements(attribute, activeCurrentElements, newElementsCreated);
            }
        } else {
            allArrayElements = newElementsCreated;
        }
        for (index = 0; allArrayElements != null && index < allArrayElements.size(); ++index) {
            Object element = allArrayElements.get(index);
            if (!(element instanceof AtlasEdge) || GraphHelper.getEdgeStatus((AtlasElement)((AtlasEdge)element)) != AtlasRelationship.Status.ACTIVE) continue;
            AtlasGraphUtilsV2.setEncodedProperty((AtlasEdge)element, Constants.ATTRIBUTE_INDEX_PROPERTY_KEY, index);
        }
        if (isNewElementsNull) {
            this.setArrayElementsProperty(elementType, isSoftReference, ctx.getReferringVertex(), ctx.getVertexProperty(), null);
        } else {
            this.setArrayElementsProperty(elementType, isSoftReference, ctx.getReferringVertex(), ctx.getVertexProperty(), allArrayElements);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== mapArrayValue({})", (Object)ctx);
        }
        return allArrayElements;
    }

    private boolean getAppendOptionForRelationship(AtlasVertex entityVertex, String relationshipAttributeName) {
        boolean ret = false;
        String entityTypeName = AtlasGraphUtilsV2.getTypeName((AtlasElement)entityVertex);
        AtlasEntityDef entityDef = this.typeRegistry.getEntityDefByName(entityTypeName);
        List relationshipAttributeDefs = entityDef.getRelationshipAttributeDefs();
        if (CollectionUtils.isNotEmpty((Collection)relationshipAttributeDefs)) {
            ret = relationshipAttributeDefs.stream().anyMatch(relationshipAttrDef -> relationshipAttrDef.getName().equals(relationshipAttributeName) && relationshipAttrDef.isAppendOnPartialUpdate());
        }
        return ret;
    }

    private AtlasEdge createVertex(AtlasStruct struct, AtlasVertex referringVertex, String edgeLabel, EntityMutationContext context) throws AtlasBaseException {
        AtlasVertex vertex = this.createStructVertex(struct);
        this.mapAttributes(struct, vertex, EntityMutations.EntityOperation.CREATE, context);
        try {
            return this.graphHelper.getOrCreateEdge(referringVertex, vertex, edgeLabel);
        }
        catch (RepositoryException e) {
            throw new AtlasBaseException(AtlasErrorCode.INTERNAL_ERROR, (Throwable)((Object)e), new String[0]);
        }
    }

    private void updateVertex(AtlasStruct struct, AtlasVertex vertex, EntityMutationContext context) throws AtlasBaseException {
        this.mapAttributes(struct, vertex, EntityMutations.EntityOperation.UPDATE, context);
    }

    private Long getEntityVersion(AtlasEntity entity) {
        Long ret = entity != null ? entity.getVersion() : null;
        return ret != null ? ret : 0L;
    }

    private String getCustomAttributesString(AtlasEntity entity) {
        String ret = null;
        Map customAttributes = entity.getCustomAttributes();
        if (customAttributes != null) {
            ret = AtlasType.toJson((Object)customAttributes);
        }
        return ret;
    }

    private AtlasStructType getStructType(String typeName) throws AtlasBaseException {
        AtlasType objType = this.typeRegistry.getType(typeName);
        if (!(objType instanceof AtlasStructType)) {
            throw new AtlasBaseException(AtlasErrorCode.TYPE_NAME_INVALID, new String[]{typeName});
        }
        return (AtlasStructType)objType;
    }

    private AtlasEntityType getEntityType(String typeName) throws AtlasBaseException {
        AtlasType objType = this.typeRegistry.getType(typeName);
        if (!(objType instanceof AtlasEntityType)) {
            throw new AtlasBaseException(AtlasErrorCode.TYPE_NAME_INVALID, new String[]{typeName});
        }
        return (AtlasEntityType)objType;
    }

    private Object mapCollectionElementsToVertex(AttributeMutationContext ctx, EntityMutationContext context) throws AtlasBaseException {
        switch (ctx.getAttrType().getTypeCategory()) {
            case PRIMITIVE: 
            case ENUM: 
            case MAP: 
            case ARRAY: {
                return ctx.getValue();
            }
            case STRUCT: {
                return this.mapStructValue(ctx, context);
            }
            case OBJECT_ID_TYPE: {
                AtlasEntityType instanceType = this.getInstanceType(ctx.getValue(), context);
                ctx.setElementType((AtlasType)instanceType);
                if (ctx.getAttributeDef().isSoftReferenced()) {
                    return this.mapSoftRefValue(ctx, context);
                }
                return this.mapObjectIdValueUsingRelationship(ctx, context);
            }
        }
        throw new AtlasBaseException(AtlasErrorCode.TYPE_CATEGORY_INVALID, new String[]{ctx.getAttrType().getTypeCategory().name()});
    }

    private static AtlasObjectId getObjectId(Object val) throws AtlasBaseException {
        Object ret = null;
        if (val != null) {
            if (val instanceof AtlasObjectId) {
                ret = (AtlasObjectId)val;
            } else if (val instanceof Map) {
                Map map = (Map)val;
                ret = map.containsKey("relationshipType") ? new AtlasRelatedObjectId(map) : new AtlasObjectId((Map)val);
                if (!AtlasTypeUtil.isValid((AtlasObjectId)ret)) {
                    throw new AtlasBaseException(AtlasErrorCode.INVALID_OBJECT_ID, new String[]{val.toString()});
                }
            } else {
                throw new AtlasBaseException(AtlasErrorCode.INVALID_OBJECT_ID, new String[]{val.toString()});
            }
        }
        return ret;
    }

    private static String getGuid(Object val) throws AtlasBaseException {
        if (val != null) {
            if (val instanceof AtlasObjectId) {
                return ((AtlasObjectId)val).getGuid();
            }
            if (val instanceof Map) {
                Object guidVal = ((Map)val).get("guid");
                return guidVal != null ? guidVal.toString() : null;
            }
        }
        return null;
    }

    private void setAssignedGuid(Object val, EntityMutationContext context) {
        if (val != null) {
            Map<String, String> guidAssignements = context.getGuidAssignments();
            if (val instanceof AtlasObjectId) {
                AtlasObjectId objId = (AtlasObjectId)val;
                String guid = objId.getGuid();
                String assignedGuid = null;
                if (StringUtils.isNotEmpty((CharSequence)guid)) {
                    if (!AtlasTypeUtil.isAssignedGuid((String)guid) && MapUtils.isNotEmpty(guidAssignements)) {
                        assignedGuid = guidAssignements.get(guid);
                    }
                } else {
                    AtlasVertex vertex = context.getDiscoveryContext().getResolvedEntityVertex(objId);
                    if (vertex != null) {
                        assignedGuid = GraphHelper.getGuid(vertex);
                    }
                }
                if (StringUtils.isNotEmpty(assignedGuid)) {
                    RequestContext.get().recordEntityGuidUpdate(objId, guid);
                    objId.setGuid(assignedGuid);
                }
            } else if (val instanceof Map) {
                Map mapObjId = (Map)val;
                Object guidVal = mapObjId.get("guid");
                String guid = guidVal != null ? guidVal.toString() : null;
                String assignedGuid = null;
                if (StringUtils.isNotEmpty((CharSequence)guid)) {
                    if (!AtlasTypeUtil.isAssignedGuid((String)guid) && MapUtils.isNotEmpty(guidAssignements)) {
                        assignedGuid = guidAssignements.get(guid);
                    }
                } else {
                    AtlasVertex vertex = context.getDiscoveryContext().getResolvedEntityVertex(new AtlasObjectId(mapObjId));
                    if (vertex != null) {
                        assignedGuid = GraphHelper.getGuid(vertex);
                    }
                }
                if (StringUtils.isNotEmpty(assignedGuid)) {
                    RequestContext.get().recordEntityGuidUpdate(mapObjId, guid);
                    mapObjId.put("guid", assignedGuid);
                }
            }
        }
    }

    private static Map<String, Object> getRelationshipAttributes(Object val) throws AtlasBaseException {
        Object relationshipStruct;
        if (val instanceof AtlasRelatedObjectId) {
            AtlasStruct relationshipStruct2 = ((AtlasRelatedObjectId)val).getRelationshipAttributes();
            return relationshipStruct2 != null ? relationshipStruct2.getAttributes() : null;
        }
        if (val instanceof Map && (relationshipStruct = ((Map)val).get("relationshipAttributes")) instanceof Map) {
            return AtlasTypeUtil.toStructAttributes((Map)((Map)relationshipStruct));
        }
        return null;
    }

    private static String getRelationshipGuid(Object val) throws AtlasBaseException {
        if (val instanceof AtlasRelatedObjectId) {
            return ((AtlasRelatedObjectId)val).getRelationshipGuid();
        }
        if (val instanceof Map) {
            Object relationshipGuidVal = ((Map)val).get("relationshipGuid");
            return relationshipGuidVal != null ? relationshipGuidVal.toString() : null;
        }
        return null;
    }

    private AtlasEntityType getInstanceType(Object val, EntityMutationContext context) throws AtlasBaseException {
        AtlasEntityType ret = null;
        if (val != null) {
            AtlasVertex vertex;
            String typeName = null;
            String guid = null;
            if (val instanceof AtlasObjectId) {
                AtlasObjectId objId = (AtlasObjectId)val;
                typeName = objId.getTypeName();
                guid = objId.getGuid();
            } else if (val instanceof Map) {
                Map map = (Map)val;
                Object typeNameVal = map.get("typeName");
                Object guidVal = map.get("guid");
                if (typeNameVal != null) {
                    typeName = typeNameVal.toString();
                }
                if (guidVal != null) {
                    guid = guidVal.toString();
                }
            }
            if (typeName == null && guid != null && (ret = context.getType(guid)) == null && (vertex = context.getDiscoveryContext().getResolvedEntityVertex(guid)) != null) {
                typeName = AtlasGraphUtilsV2.getTypeName((AtlasElement)vertex);
            }
            if (ret == null && typeName != null) {
                ret = this.typeRegistry.getEntityTypeByName(typeName);
            }
            if (ret == null) {
                throw new AtlasBaseException(AtlasErrorCode.INVALID_OBJECT_ID, new String[]{val.toString()});
            }
        }
        return ret;
    }

    private Map<String, Object> removeUnusedMapEntries(AtlasStructType.AtlasAttribute attribute, AtlasVertex vertex, Map<String, Object> currentMap, Map<String, Object> newMap) throws AtlasBaseException {
        HashMap<String, Object> additionalMap = new HashMap<String, Object>();
        AtlasMapType mapType = (AtlasMapType)attribute.getAttributeType();
        for (String currentKey : currentMap.keySet()) {
            boolean deleted;
            AtlasEdge currentEdge = (AtlasEdge)currentMap.get(currentKey);
            if (newMap.values().contains(currentEdge) || (deleted = this.deleteDelegate.getHandler().deleteEdgeReference(currentEdge, mapType.getValueType().getTypeCategory(), attribute.isOwnedRef(), true, vertex))) continue;
            additionalMap.put(currentKey, currentEdge);
        }
        return additionalMap;
    }

    private static AtlasEdge getEdgeIfExists(AtlasMapType mapType, Map<String, Object> currentMap, String keyStr) {
        Object val;
        AtlasEdge ret = null;
        if (AtlasGraphUtilsV2.isReference(mapType.getValueType()) && (val = currentMap.get(keyStr)) != null) {
            ret = (AtlasEdge)val;
        }
        return ret;
    }

    private AtlasEdge updateEdge(AtlasStructDef.AtlasAttributeDef attributeDef, Object value, AtlasEdge currentEdge, AtlasVertex entityVertex) throws AtlasBaseException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Updating entity reference {} for reference attribute {}", (Object)attributeDef.getName());
        }
        AtlasVertex currentVertex = currentEdge.getInVertex();
        String currentEntityId = AtlasGraphUtilsV2.getIdFromVertex(currentVertex);
        String newEntityId = AtlasGraphUtilsV2.getIdFromVertex(entityVertex);
        AtlasEdge newEdge = currentEdge;
        if (!currentEntityId.equals(newEntityId) && entityVertex != null) {
            try {
                newEdge = this.graphHelper.getOrCreateEdge(currentEdge.getOutVertex(), entityVertex, currentEdge.getLabel());
            }
            catch (RepositoryException e) {
                throw new AtlasBaseException(AtlasErrorCode.INTERNAL_ERROR, (Throwable)((Object)e), new String[0]);
            }
        }
        return newEdge;
    }

    private AtlasEdge updateRelationship(AtlasEdge currentEdge, AtlasVertex parentEntityVertex, AtlasVertex newEntityVertex, AtlasStructType.AtlasAttribute.AtlasRelationshipEdgeDirection edgeDirection, Map<String, Object> relationshipAttributes) throws AtlasBaseException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Updating entity reference using relationship {} for reference attribute {}", (Object)GraphHelper.getTypeName((AtlasElement)newEntityVertex));
        }
        String currentEntityId = edgeDirection == AtlasStructType.AtlasAttribute.AtlasRelationshipEdgeDirection.IN ? this.getIdFromOutVertex(currentEdge) : (edgeDirection == AtlasStructType.AtlasAttribute.AtlasRelationshipEdgeDirection.OUT ? this.getIdFromInVertex(currentEdge) : this.getIdFromBothVertex(currentEdge, parentEntityVertex));
        String newEntityId = AtlasGraphUtilsV2.getIdFromVertex(newEntityVertex);
        AtlasEdge ret = currentEdge;
        if (!currentEntityId.equals(newEntityId)) {
            String relationshipName = AtlasGraphUtilsV2.getTypeName((AtlasElement)currentEdge);
            if (relationshipName == null) {
                relationshipName = currentEdge.getLabel();
            }
            ret = edgeDirection == AtlasStructType.AtlasAttribute.AtlasRelationshipEdgeDirection.IN ? this.getOrCreateRelationship(newEntityVertex, currentEdge.getInVertex(), relationshipName, relationshipAttributes) : (edgeDirection == AtlasStructType.AtlasAttribute.AtlasRelationshipEdgeDirection.OUT ? this.getOrCreateRelationship(currentEdge.getOutVertex(), newEntityVertex, relationshipName, relationshipAttributes) : this.getOrCreateRelationship(newEntityVertex, parentEntityVertex, relationshipName, relationshipAttributes));
            this.recordEntityUpdate(newEntityVertex);
        }
        return ret;
    }

    public static List<Object> getArrayElementsProperty(AtlasType elementType, boolean isSoftReference, AtlasVertex vertex, String vertexPropertyName) {
        if (!isSoftReference && AtlasGraphUtilsV2.isReference(elementType)) {
            return vertex.getListProperty(vertexPropertyName, AtlasEdge.class);
        }
        return vertex.getListProperty(vertexPropertyName);
    }

    private AtlasEdge getEdgeAt(List<Object> currentElements, int index, AtlasType elemType) {
        AtlasEdge ret = null;
        if (AtlasGraphUtilsV2.isReference(elemType) && currentElements != null && index < currentElements.size()) {
            ret = (AtlasEdge)currentElements.get(index);
        }
        return ret;
    }

    private List<AtlasEdge> unionCurrentAndNewElements(AtlasStructType.AtlasAttribute attribute, List<AtlasEdge> currentElements, List<AtlasEdge> newElements) {
        Collection ret = null;
        AtlasType arrayElementType = ((AtlasArrayType)attribute.getAttributeType()).getElementType();
        if (arrayElementType != null && AtlasGraphUtilsV2.isReference(arrayElementType)) {
            ret = CollectionUtils.union(currentElements, newElements);
        }
        return CollectionUtils.isNotEmpty(ret) ? new ArrayList(ret) : Collections.emptyList();
    }

    private List<AtlasEdge> removeUnusedArrayEntries(AtlasStructType.AtlasAttribute attribute, List<AtlasEdge> currentEntries, List<AtlasEdge> newEntries, AtlasVertex entityVertex) throws AtlasBaseException {
        Collection edgesToRemove;
        AtlasType entryType;
        if (CollectionUtils.isNotEmpty(currentEntries) && AtlasGraphUtilsV2.isReference(entryType = ((AtlasArrayType)attribute.getAttributeType()).getElementType()) && CollectionUtils.isNotEmpty((Collection)(edgesToRemove = CollectionUtils.subtract(currentEntries, newEntries)))) {
            ArrayList<AtlasEdge> additionalElements = new ArrayList<AtlasEdge>();
            for (AtlasEdge edge : edgesToRemove) {
                boolean deleted = this.deleteDelegate.getHandler().deleteEdgeReference(edge, entryType.getTypeCategory(), attribute.isOwnedRef(), true, attribute.getRelationshipEdgeDirection(), entityVertex);
                if (deleted) continue;
                additionalElements.add(edge);
            }
            return additionalElements;
        }
        return Collections.emptyList();
    }

    private void setArrayElementsProperty(AtlasType elementType, boolean isSoftReference, AtlasVertex vertex, String vertexPropertyName, List<Object> values) {
        if (!AtlasGraphUtilsV2.isReference(elementType) || isSoftReference) {
            AtlasGraphUtilsV2.setEncodedProperty(vertex, vertexPropertyName, values);
        }
    }

    private AtlasEntityHeader constructHeader(AtlasEntity entity, AtlasVertex vertex) throws AtlasBaseException {
        AtlasEntityHeader header = this.entityRetriever.toAtlasEntityHeaderWithClassifications(vertex);
        if (entity.getClassifications() == null) {
            entity.setClassifications(header.getClassifications());
        }
        return header;
    }

    private void updateInConsistentOwnedMapVertices(AttributeMutationContext ctx, AtlasMapType mapType, Object val) {
        if (mapType.getValueType().getTypeCategory() == TypeCategory.OBJECT_ID_TYPE && !ctx.getAttributeDef().isSoftReferenced()) {
            AtlasEdge edge = (AtlasEdge)val;
            if (ctx.getAttribute().isOwnedRef() && GraphHelper.getStatus(edge) == AtlasEntity.Status.DELETED && GraphHelper.getStatus(edge.getInVertex()) == AtlasEntity.Status.DELETED) {
                AtlasGraphUtilsV2.setEncodedProperty(edge, Constants.STATE_PROPERTY_KEY, AtlasEntity.Status.ACTIVE.name());
                AtlasGraphUtilsV2.setEncodedProperty(edge.getInVertex(), Constants.STATE_PROPERTY_KEY, AtlasEntity.Status.ACTIVE.name());
            }
        }
    }

    public void addClassifications(EntityMutationContext context, String guid, List<AtlasClassification> classifications) throws AtlasBaseException {
        if (CollectionUtils.isNotEmpty(classifications)) {
            AtlasPerfMetrics.MetricRecorder metric = RequestContext.get().startMetricRecord("addClassifications");
            final AtlasVertex entityVertex = context.getVertex(guid);
            AtlasEntityType entityType = context.getType(guid);
            List<AtlasVertex> entitiesToPropagateTo = null;
            HashMap addedClassifications = new HashMap();
            ArrayList<AtlasClassification> addClassifications = new ArrayList<AtlasClassification>(classifications.size());
            for (AtlasClassification c : classifications) {
                AtlasClassification classification = new AtlasClassification(c);
                String classificationName = classification.getTypeName();
                Boolean propagateTags = classification.isPropagate();
                Boolean removePropagations = classification.getRemovePropagationsOnEntityDelete();
                if (propagateTags != null && propagateTags.booleanValue() && classification.getEntityGuid() != null && !StringUtils.equals((CharSequence)classification.getEntityGuid(), (CharSequence)guid)) continue;
                if (propagateTags == null) {
                    RequestContext reqContext = RequestContext.get();
                    propagateTags = reqContext.isImportInProgress() || reqContext.isInNotificationProcessing() ? Boolean.valueOf(false) : Boolean.valueOf(CLASSIFICATION_PROPAGATION_DEFAULT);
                    classification.setPropagate(propagateTags);
                }
                if (removePropagations == null) {
                    removePropagations = this.graphHelper.getDefaultRemovePropagations();
                    classification.setRemovePropagationsOnEntityDelete(removePropagations);
                }
                if (classification.getEntityGuid() == null) {
                    classification.setEntityGuid(guid);
                }
                if (classification.getEntityStatus() == null) {
                    classification.setEntityStatus(AtlasEntity.Status.ACTIVE);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Adding classification [{}] to [{}] using edge label: [{}]", new Object[]{classificationName, entityType.getTypeName(), GraphHelper.getTraitLabel(classificationName)});
                }
                this.addToClassificationNames(entityVertex, classificationName);
                AtlasVertex classificationVertex = this.createClassificationVertex(classification);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("created vertex {} for trait {}", (Object)GraphHelper.string(classificationVertex), (Object)classificationName);
                }
                if (propagateTags.booleanValue() && this.taskManagement != null && this.DEFERRED_ACTION_ENABLED) {
                    propagateTags = false;
                    this.createAndQueueTask("CLASSIFICATION_PROPAGATION_ADD", entityVertex, classificationVertex.getIdForDisplay(), classificationName);
                }
                this.mapClassification(EntityMutations.EntityOperation.CREATE, context, classification, entityType, entityVertex, classificationVertex);
                GraphHelper.updateModificationMetadata(entityVertex);
                if (addedClassifications.get(classification) == null) {
                    addedClassifications.put(classification, new HashSet());
                }
                ((HashSet)addedClassifications.get(classification)).add(entityVertex);
                if (propagateTags.booleanValue()) {
                    if (entitiesToPropagateTo == null) {
                        entitiesToPropagateTo = this.entityRetriever.getImpactedVerticesV2(entityVertex);
                    }
                    if (CollectionUtils.isNotEmpty(entitiesToPropagateTo)) {
                        List<AtlasVertex> entitiesPropagatedTo;
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Propagating tag: [{}][{}] to {}", new Object[]{classificationName, entityType.getTypeName(), GraphHelper.getTypeNames(entitiesToPropagateTo)});
                        }
                        if (CollectionUtils.isNotEmpty(entitiesPropagatedTo = this.deleteDelegate.getHandler().addTagPropagation(classificationVertex, entitiesToPropagateTo))) {
                            ((HashSet)addedClassifications.get(classification)).addAll(entitiesPropagatedTo);
                        }
                    } else if (LOG.isDebugEnabled()) {
                        LOG.debug(" --> Not propagating classification: [{}][{}] - no entities found to propagate to.", (Object)GraphHelper.getTypeName((AtlasElement)classificationVertex), (Object)entityType.getTypeName());
                    }
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug(" --> Not propagating classification: [{}][{}] - propagation is disabled.", (Object)GraphHelper.getTypeName((AtlasElement)classificationVertex), (Object)entityType.getTypeName());
                }
                addClassifications.add(classification);
            }
            ArrayList<AtlasVertex> notificationVertices = new ArrayList<AtlasVertex>(){
                {
                    this.add(entityVertex);
                }
            };
            if (CollectionUtils.isNotEmpty(entitiesToPropagateTo)) {
                notificationVertices.addAll(entitiesToPropagateTo);
            }
            for (AtlasClassification classification : addedClassifications.keySet()) {
                Set vertices = (Set)addedClassifications.get(classification);
                List<AtlasEntity> propagatedEntities = this.updateClassificationText(classification, vertices);
                this.entityChangeNotifier.onClassificationsAddedToEntities(propagatedEntities, Collections.singletonList(classification));
            }
            RequestContext.get().endMetricRecord(metric);
        }
    }

    @GraphTransaction
    public List<String> propagateClassification(String entityGuid, String classificationVertexId, String relationshipGuid) throws AtlasBaseException {
        try {
            if (StringUtils.isEmpty((CharSequence)entityGuid) || StringUtils.isEmpty((CharSequence)classificationVertexId)) {
                LOG.warn("propagateClassification(entityGuid={}, classificationVertexId={}): entityGuid and/or classification vertex id is empty", (Object)entityGuid, (Object)classificationVertexId);
                return null;
            }
            AtlasVertex entityVertex = this.graphHelper.getVertexForGUID(entityGuid);
            if (entityVertex == null) {
                LOG.warn("propagateClassification(entityGuid={}, classificationVertexId={}): entity vertex not found", (Object)entityGuid, (Object)classificationVertexId);
                return null;
            }
            AtlasVertex classificationVertex = this.graph.getVertex(classificationVertexId);
            if (classificationVertex == null) {
                LOG.warn("propagateClassification(entityGuid={}, classificationVertexId={}): classification vertex not found", (Object)entityGuid, (Object)classificationVertexId);
                return null;
            }
            List<AtlasVertex> impactedVertices = this.entityRetriever.getIncludedImpactedVerticesV2(entityVertex, relationshipGuid, classificationVertexId);
            if (CollectionUtils.isEmpty(impactedVertices)) {
                LOG.debug("propagateClassification(entityGuid={}, classificationVertexId={}): found no entities to propagate the classification", (Object)entityGuid, (Object)classificationVertexId);
                return null;
            }
            List<String> impactedVerticesGuidsToLock = impactedVertices.stream().map(x -> GraphHelper.getGuid(x)).collect(Collectors.toList());
            GraphTransactionInterceptor.lockObjectAndReleasePostCommit(impactedVerticesGuidsToLock);
            AtlasClassification classification = this.entityRetriever.toAtlasClassification(classificationVertex);
            List<AtlasVertex> entitiesPropagatedTo = this.deleteDelegate.getHandler().addTagPropagation(classificationVertex, impactedVertices);
            if (CollectionUtils.isEmpty(entitiesPropagatedTo)) {
                return null;
            }
            List<AtlasEntity> propagatedEntities = this.updateClassificationText(classification, entitiesPropagatedTo);
            this.entityChangeNotifier.onClassificationsAddedToEntities(propagatedEntities, Collections.singletonList(classification));
            return propagatedEntities.stream().map(x -> x.getGuid()).collect(Collectors.toList());
        }
        catch (Exception e) {
            LOG.error("propagateClassification(entityGuid={}, classificationVertexId={}): error while propagating classification", new Object[]{entityGuid, classificationVertexId, e});
            throw new AtlasBaseException((Throwable)e);
        }
    }

    public void deleteClassification(String entityGuid, String classificationName, String associatedEntityGuid) throws AtlasBaseException {
        if (StringUtils.isEmpty((CharSequence)associatedEntityGuid) || associatedEntityGuid.equals(entityGuid)) {
            this.deleteClassification(entityGuid, classificationName);
        } else {
            this.deletePropagatedClassification(entityGuid, classificationName, associatedEntityGuid);
        }
    }

    private void deletePropagatedClassification(String entityGuid, String classificationName, String associatedEntityGuid) throws AtlasBaseException {
        if (StringUtils.isEmpty((CharSequence)classificationName)) {
            throw new AtlasBaseException(AtlasErrorCode.INVALID_CLASSIFICATION_PARAMS, new String[]{"delete", entityGuid});
        }
        AtlasVertex entityVertex = AtlasGraphUtilsV2.findByGuid(this.graph, entityGuid);
        if (entityVertex == null) {
            throw new AtlasBaseException(AtlasErrorCode.INSTANCE_GUID_NOT_FOUND, new String[]{entityGuid});
        }
        this.deleteDelegate.getHandler().deletePropagatedClassification(entityVertex, classificationName, associatedEntityGuid);
    }

    public void deleteClassification(String entityGuid, String classificationName) throws AtlasBaseException {
        List<Object> entityVertices;
        List<String> traitNames;
        if (StringUtils.isEmpty((CharSequence)classificationName)) {
            throw new AtlasBaseException(AtlasErrorCode.INVALID_CLASSIFICATION_PARAMS, new String[]{"delete", entityGuid});
        }
        AtlasVertex entityVertex = AtlasGraphUtilsV2.findByGuid(this.graph, entityGuid);
        if (entityVertex == null) {
            throw new AtlasBaseException(AtlasErrorCode.INSTANCE_GUID_NOT_FOUND, new String[]{entityGuid});
        }
        AtlasPerfTracer perf = null;
        if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
            perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)"EntityGraphMapper.deleteClassification");
        }
        if (CollectionUtils.isEmpty(traitNames = GraphHelper.getTraitNames(entityVertex))) {
            throw new AtlasBaseException(AtlasErrorCode.NO_CLASSIFICATIONS_FOUND_FOR_ENTITY, new String[]{entityGuid});
        }
        this.validateClassificationExists(traitNames, classificationName);
        AtlasVertex classificationVertex = GraphHelper.getClassificationVertex(entityVertex, classificationName);
        AtlasClassification classification = this.entityRetriever.toAtlasClassification(classificationVertex);
        if (classification == null) {
            throw new AtlasBaseException(AtlasErrorCode.CLASSIFICATION_NOT_FOUND, new String[]{classificationName});
        }
        if (GraphHelper.isPropagationEnabled(classificationVertex)) {
            if (this.taskManagement != null && this.DEFERRED_ACTION_ENABLED) {
                String classificationVertexId = classificationVertex.getIdForDisplay();
                boolean pendingTaskExists = this.taskManagement.getPendingTasks().stream().anyMatch(x -> this.classificationHasPendingTask((AtlasTask)x, classificationVertexId, entityGuid));
                if (pendingTaskExists) {
                    LOG.error("Another tag propagation is in progress for classification: {} and entity: {}. Please try again", (Object)classificationVertexId, (Object)entityGuid);
                    throw new AtlasBaseException(AtlasErrorCode.DELETE_TAG_PROPAGATION_NOT_ALLOWED, new String[]{classificationVertexId, entityGuid});
                }
                this.createAndQueueTask("CLASSIFICATION_PROPAGATION_DELETE", entityVertex, classificationVertexId, classificationName);
                entityVertices = new ArrayList();
            } else {
                entityVertices = this.deleteDelegate.getHandler().removeTagPropagation(classificationVertex);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Number of propagations to delete -> {}", (Object)entityVertices.size());
                }
            }
        } else {
            entityVertices = new ArrayList();
        }
        if (!entityVertices.contains(entityVertex)) {
            entityVertices.add(entityVertex);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Removing classification: [{}] from: [{}][{}] with edge label: [{}]", new Object[]{classificationName, GraphHelper.getTypeName((AtlasElement)entityVertex), entityGuid, "classifiedAs"});
        }
        AtlasEdge edge = GraphHelper.getClassificationEdge(entityVertex, classificationVertex);
        this.deleteDelegate.getHandler().deleteEdgeReference(edge, TypeCategory.CLASSIFICATION, false, true, entityVertex);
        traitNames.remove(classificationName);
        entityVertex.removePropertyValue(Constants.TRAIT_NAMES_PROPERTY_KEY, (Object)classificationName);
        entityVertex.removeProperty(Constants.CLASSIFICATION_NAMES_KEY);
        entityVertex.setProperty(Constants.CLASSIFICATION_NAMES_KEY, (Object)this.getClassificationNamesString(traitNames));
        GraphHelper.updateModificationMetadata(entityVertex);
        if (CollectionUtils.isNotEmpty(entityVertices)) {
            List<AtlasEntity> propagatedEntities = this.updateClassificationText(classification, entityVertices);
            this.entityChangeNotifier.onClassificationsDeletedFromEntities(propagatedEntities, Collections.singletonList(classification));
        }
        AtlasPerfTracer.log((AtlasPerfTracer)perf);
    }

    private boolean classificationHasPendingTask(AtlasTask task, String classificationVertexId, String entityGuid) {
        if (task.getParameters() == null || task.getParameters().get("classificationVertexId") == null || task.getParameters().get("entityGuid") == null) {
            return false;
        }
        return task.getParameters().get("classificationVertexId").equals(classificationVertexId) && task.getParameters().get("entityGuid").equals(entityGuid);
    }

    private AtlasEntity updateClassificationText(AtlasVertex vertex) throws AtlasBaseException {
        String guid = GraphHelper.getGuid(vertex);
        AtlasEntity entity = this.instanceConverter.getAndCacheEntity(guid, ENTITY_CHANGE_NOTIFY_IGNORE_RELATIONSHIP_ATTRIBUTES);
        vertex.setProperty(Constants.CLASSIFICATION_TEXT_KEY, (Object)this.fullTextMapperV2.getClassificationTextForEntity(entity));
        return entity;
    }

    public void updateClassificationTextAndNames(AtlasVertex vertex) throws AtlasBaseException {
        if (CollectionUtils.isEmpty((Collection)vertex.getPropertyValues(Constants.TRAIT_NAMES_PROPERTY_KEY, String.class)) && CollectionUtils.isEmpty((Collection)vertex.getPropertyValues(Constants.PROPAGATED_TRAIT_NAMES_PROPERTY_KEY, String.class))) {
            return;
        }
        String guid = GraphHelper.getGuid(vertex);
        AtlasEntity entity = this.instanceConverter.getAndCacheEntity(guid, ENTITY_CHANGE_NOTIFY_IGNORE_RELATIONSHIP_ATTRIBUTES);
        ArrayList<String> classificationNames = new ArrayList<String>();
        ArrayList<String> propagatedClassificationNames = new ArrayList<String>();
        for (AtlasClassification classification : entity.getClassifications()) {
            if (this.isPropagatedClassification(classification, guid)) {
                propagatedClassificationNames.add(classification.getTypeName());
                continue;
            }
            classificationNames.add(classification.getTypeName());
        }
        vertex.setProperty(Constants.CLASSIFICATION_NAMES_KEY, (Object)GraphHelper.getDelimitedClassificationNames(classificationNames));
        vertex.setProperty(Constants.PROPAGATED_CLASSIFICATION_NAMES_KEY, (Object)GraphHelper.getDelimitedClassificationNames(propagatedClassificationNames));
        vertex.setProperty(Constants.CLASSIFICATION_TEXT_KEY, (Object)this.fullTextMapperV2.getClassificationTextForEntity(entity));
    }

    private boolean isPropagatedClassification(AtlasClassification classification, String guid) {
        String classificationEntityGuid = classification.getEntityGuid();
        return StringUtils.isNotEmpty((CharSequence)classificationEntityGuid) && !StringUtils.equals((CharSequence)classificationEntityGuid, (CharSequence)guid);
    }

    private void addToClassificationNames(AtlasVertex entityVertex, String classificationName) {
        AtlasGraphUtilsV2.addEncodedProperty(entityVertex, Constants.TRAIT_NAMES_PROPERTY_KEY, (Object)classificationName);
        String delimitedClassificationNames = (String)entityVertex.getProperty(Constants.CLASSIFICATION_NAMES_KEY, String.class);
        delimitedClassificationNames = StringUtils.isEmpty((CharSequence)delimitedClassificationNames) ? CLASSIFICATION_NAME_DELIMITER + classificationName + CLASSIFICATION_NAME_DELIMITER : delimitedClassificationNames + classificationName + CLASSIFICATION_NAME_DELIMITER;
        entityVertex.setProperty(Constants.CLASSIFICATION_NAMES_KEY, (Object)delimitedClassificationNames);
    }

    private String getClassificationNamesString(List<String> traitNames) {
        String ret = StringUtils.join(traitNames, (String)CLASSIFICATION_NAME_DELIMITER);
        return StringUtils.isEmpty((CharSequence)ret) ? ret : CLASSIFICATION_NAME_DELIMITER + ret + CLASSIFICATION_NAME_DELIMITER;
    }

    public void updateClassifications(EntityMutationContext context, String guid, List<AtlasClassification> classifications) throws AtlasBaseException {
        if (CollectionUtils.isEmpty(classifications)) {
            throw new AtlasBaseException(AtlasErrorCode.INVALID_CLASSIFICATION_PARAMS, new String[]{"update", guid});
        }
        final AtlasVertex entityVertex = AtlasGraphUtilsV2.findByGuid(this.graph, guid);
        if (entityVertex == null) {
            throw new AtlasBaseException(AtlasErrorCode.INSTANCE_GUID_NOT_FOUND, new String[]{guid});
        }
        AtlasPerfTracer perf = null;
        if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
            perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)"EntityGraphMapper.updateClassifications");
        }
        String entityTypeName = AtlasGraphUtilsV2.getTypeName((AtlasElement)entityVertex);
        AtlasEntityType entityType = this.typeRegistry.getEntityTypeByName(entityTypeName);
        ArrayList<AtlasClassification> updatedClassifications = new ArrayList<AtlasClassification>();
        List<Object> entitiesToPropagateTo = new ArrayList();
        HashSet<AtlasVertex> notificationVertices = new HashSet<AtlasVertex>(){
            {
                this.add(entityVertex);
            }
        };
        HashMap addedPropagations = null;
        HashMap<AtlasClassification, List<AtlasVertex>> removedPropagations = new HashMap<AtlasClassification, List<AtlasVertex>>();
        for (AtlasClassification classification : classifications) {
            List updatedValidityPeriods;
            List currentValidityPeriods;
            AtlasClassification currentClassification;
            String classificationName = classification.getTypeName();
            String classificationEntityGuid = classification.getEntityGuid();
            if (StringUtils.isEmpty((CharSequence)classificationEntityGuid)) {
                classification.setEntityGuid(guid);
            }
            if (StringUtils.isNotEmpty((CharSequence)classificationEntityGuid) && !StringUtils.equalsIgnoreCase((CharSequence)guid, (CharSequence)classificationEntityGuid)) {
                throw new AtlasBaseException(AtlasErrorCode.CLASSIFICATION_UPDATE_FROM_PROPAGATED_ENTITY, new String[]{classificationName});
            }
            AtlasVertex classificationVertex = GraphHelper.getClassificationVertex(entityVertex, classificationName);
            if (classificationVertex == null) {
                throw new AtlasBaseException(AtlasErrorCode.CLASSIFICATION_NOT_ASSOCIATED_WITH_ENTITY, new String[]{classificationName});
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Updating classification {} for entity {}", (Object)classification, (Object)guid);
            }
            if ((currentClassification = this.entityRetriever.toAtlasClassification(classificationVertex)) == null) continue;
            this.validateAndNormalizeForUpdate(classification);
            boolean isClassificationUpdated = false;
            Map updatedAttributes = classification.getAttributes();
            if (MapUtils.isNotEmpty((Map)updatedAttributes)) {
                for (String attributeName : updatedAttributes.keySet()) {
                    currentClassification.setAttribute(attributeName, updatedAttributes.get(attributeName));
                }
                isClassificationUpdated = true;
            }
            if (!Objects.equals(currentValidityPeriods = currentClassification.getValidityPeriods(), updatedValidityPeriods = classification.getValidityPeriods())) {
                currentClassification.setValidityPeriods(updatedValidityPeriods);
                isClassificationUpdated = true;
            }
            Boolean currentRemovePropagations = currentClassification.getRemovePropagationsOnEntityDelete();
            Boolean updatedRemovePropagations = classification.getRemovePropagationsOnEntityDelete();
            if (updatedRemovePropagations != null && updatedRemovePropagations != currentRemovePropagations) {
                AtlasGraphUtilsV2.setEncodedProperty(classificationVertex, Constants.CLASSIFICATION_VERTEX_REMOVE_PROPAGATIONS_KEY, updatedRemovePropagations);
                isClassificationUpdated = true;
            }
            if (isClassificationUpdated) {
                List<AtlasVertex> propagatedEntityVertices = GraphHelper.getAllPropagatedEntityVertices(classificationVertex);
                notificationVertices.addAll(propagatedEntityVertices);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("updating vertex {} for trait {}", (Object)GraphHelper.string(classificationVertex), (Object)classificationName);
            }
            this.mapClassification(EntityMutations.EntityOperation.UPDATE, context, classification, entityType, entityVertex, classificationVertex);
            GraphHelper.updateModificationMetadata(entityVertex);
            Boolean currentTagPropagation = currentClassification.isPropagate();
            Boolean updatedTagPropagation = classification.isPropagate();
            if (updatedTagPropagation != null && this.taskManagement != null && this.DEFERRED_ACTION_ENABLED) {
                String propagationType = updatedTagPropagation != false ? "CLASSIFICATION_PROPAGATION_ADD" : "CLASSIFICATION_PROPAGATION_DELETE";
                this.createAndQueueTask(propagationType, entityVertex, classificationVertex.getIdForDisplay(), classificationName);
                updatedTagPropagation = null;
            }
            if (updatedTagPropagation != null && currentTagPropagation != updatedTagPropagation) {
                if (updatedTagPropagation.booleanValue()) {
                    if (CollectionUtils.isEmpty(entitiesToPropagateTo)) {
                        entitiesToPropagateTo = this.entityRetriever.getImpactedVerticesV2(entityVertex, null, classificationVertex.getIdForDisplay());
                    }
                    if (CollectionUtils.isNotEmpty(entitiesToPropagateTo)) {
                        List<AtlasVertex> entitiesPropagatedTo;
                        if (addedPropagations == null) {
                            addedPropagations = new HashMap(entitiesToPropagateTo.size());
                            for (AtlasVertex atlasVertex : entitiesToPropagateTo) {
                                addedPropagations.put(atlasVertex, new ArrayList());
                            }
                        }
                        if ((entitiesPropagatedTo = this.deleteDelegate.getHandler().addTagPropagation(classificationVertex, entitiesToPropagateTo)) != null) {
                            for (AtlasVertex entityPropagatedTo : entitiesPropagatedTo) {
                                ((List)addedPropagations.get(entityPropagatedTo)).add(classification);
                            }
                        }
                    }
                } else {
                    List<AtlasVertex> impactedVertices = this.deleteDelegate.getHandler().removeTagPropagation(classificationVertex);
                    if (CollectionUtils.isNotEmpty(impactedVertices)) {
                        removedPropagations.put(classification, impactedVertices);
                    }
                }
            }
            updatedClassifications.add(currentClassification);
        }
        if (CollectionUtils.isNotEmpty(entitiesToPropagateTo)) {
            notificationVertices.addAll(entitiesToPropagateTo);
        }
        for (AtlasVertex vertex : notificationVertices) {
            String entityGuid = GraphHelper.getGuid(vertex);
            AtlasEntity entity = this.instanceConverter.getAndCacheEntity(entityGuid, ENTITY_CHANGE_NOTIFY_IGNORE_RELATIONSHIP_ATTRIBUTES);
            if (!GraphHelper.isActive(entity)) continue;
            vertex.setProperty(Constants.CLASSIFICATION_TEXT_KEY, (Object)this.fullTextMapperV2.getClassificationTextForEntity(entity));
            this.entityChangeNotifier.onClassificationUpdatedToEntity(entity, updatedClassifications);
        }
        if (MapUtils.isNotEmpty(removedPropagations)) {
            for (AtlasClassification classification : removedPropagations.keySet()) {
                List propagatedVertices = (List)removedPropagations.get(classification);
                List<AtlasEntity> propagatedEntities = this.updateClassificationText(classification, propagatedVertices);
                this.entityChangeNotifier.onClassificationsDeletedFromEntities(propagatedEntities, Collections.singletonList(classification));
            }
        }
        AtlasPerfTracer.log((AtlasPerfTracer)perf);
    }

    private AtlasEdge mapClassification(EntityMutations.EntityOperation operation, EntityMutationContext context, AtlasClassification classification, AtlasEntityType entityType, AtlasVertex parentInstanceVertex, AtlasVertex traitInstanceVertex) throws AtlasBaseException {
        if (classification.getValidityPeriods() != null) {
            String strValidityPeriods = AtlasJson.toJson((Object)classification.getValidityPeriods());
            AtlasGraphUtilsV2.setEncodedProperty(traitInstanceVertex, Constants.CLASSIFICATION_VALIDITY_PERIODS_KEY, strValidityPeriods);
        }
        if (classification.isPropagate() != null) {
            AtlasGraphUtilsV2.setEncodedProperty(traitInstanceVertex, Constants.CLASSIFICATION_VERTEX_PROPAGATE_KEY, classification.isPropagate());
        }
        if (classification.getRemovePropagationsOnEntityDelete() != null) {
            AtlasGraphUtilsV2.setEncodedProperty(traitInstanceVertex, Constants.CLASSIFICATION_VERTEX_REMOVE_PROPAGATIONS_KEY, classification.getRemovePropagationsOnEntityDelete());
        }
        this.mapAttributes((AtlasStruct)classification, traitInstanceVertex, operation, context);
        AtlasEdge ret = GraphHelper.getClassificationEdge(parentInstanceVertex, traitInstanceVertex);
        if (ret == null) {
            ret = this.graphHelper.addClassificationEdge(parentInstanceVertex, traitInstanceVertex, false);
        }
        return ret;
    }

    public void deleteClassifications(String guid) throws AtlasBaseException {
        AtlasVertex instanceVertex = AtlasGraphUtilsV2.findByGuid(this.graph, guid);
        if (instanceVertex == null) {
            throw new AtlasBaseException(AtlasErrorCode.INSTANCE_GUID_NOT_FOUND, new String[]{guid});
        }
        List<String> traitNames = GraphHelper.getTraitNames(instanceVertex);
        if (CollectionUtils.isNotEmpty(traitNames)) {
            for (String traitName : traitNames) {
                this.deleteClassification(guid, traitName);
            }
        }
    }

    @GraphTransaction
    public List<String> deleteClassificationPropagation(String entityGuid, String classificationVertexId) throws AtlasBaseException {
        try {
            if (StringUtils.isEmpty((CharSequence)classificationVertexId)) {
                LOG.warn("deleteClassificationPropagation(classificationVertexId={}): classification vertex id is empty", (Object)classificationVertexId);
                return null;
            }
            AtlasVertex classificationVertex = this.graph.getVertex(classificationVertexId);
            if (classificationVertex == null) {
                LOG.warn("deleteClassificationPropagation(classificationVertexId={}): classification vertex not found", (Object)classificationVertexId);
                return null;
            }
            AtlasClassification classification = this.entityRetriever.toAtlasClassification(classificationVertex);
            List<AtlasVertex> entityVertices = this.deleteDelegate.getHandler().removeTagPropagation(classificationVertex);
            this.deleteDelegate.getHandler().deleteClassificationVertex(classificationVertex, true);
            if (CollectionUtils.isEmpty(entityVertices)) {
                return null;
            }
            List<String> impactedGuids = entityVertices.stream().map(x -> GraphHelper.getGuid(x)).collect(Collectors.toList());
            GraphTransactionInterceptor.lockObjectAndReleasePostCommit(impactedGuids);
            List<AtlasEntity> propagatedEntities = this.updateClassificationText(classification, entityVertices);
            this.entityChangeNotifier.onClassificationsDeletedFromEntities(propagatedEntities, Collections.singletonList(classification));
            return propagatedEntities.stream().map(x -> x.getGuid()).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw new AtlasBaseException((Throwable)e);
        }
    }

    @GraphTransaction
    public void updateTagPropagations(String relationshipEdgeId, AtlasRelationship relationship) throws AtlasBaseException {
        AtlasEdge relationshipEdge = this.graph.getEdge(relationshipEdgeId);
        this.deleteDelegate.getHandler().updateTagPropagations(relationshipEdge, relationship);
        this.entityChangeNotifier.notifyPropagatedEntities();
    }

    private void validateClassificationExists(List<String> existingClassifications, List<String> suppliedClassifications) throws AtlasBaseException {
        HashSet<String> existingNames = new HashSet<String>(existingClassifications);
        for (String classificationName : suppliedClassifications) {
            if (existingNames.contains(classificationName)) continue;
            throw new AtlasBaseException(AtlasErrorCode.CLASSIFICATION_NOT_ASSOCIATED_WITH_ENTITY, new String[]{classificationName});
        }
    }

    private void validateClassificationExists(List<String> existingClassifications, String suppliedClassificationName) throws AtlasBaseException {
        if (!existingClassifications.contains(suppliedClassificationName)) {
            throw new AtlasBaseException(AtlasErrorCode.CLASSIFICATION_NOT_ASSOCIATED_WITH_ENTITY, new String[]{suppliedClassificationName});
        }
    }

    private AtlasEdge getOrCreateRelationship(AtlasVertex end1Vertex, AtlasVertex end2Vertex, String relationshipName, Map<String, Object> relationshipAttributes) throws AtlasBaseException {
        return this.relationshipStore.getOrCreate(end1Vertex, end2Vertex, new AtlasRelationship(relationshipName, relationshipAttributes));
    }

    private void recordEntityUpdate(AtlasVertex vertex) throws AtlasBaseException {
        if (vertex != null) {
            RequestContext req = RequestContext.get();
            if (!req.isUpdatedEntity(GraphHelper.getGuid(vertex))) {
                GraphHelper.updateModificationMetadata(vertex);
                req.recordEntityUpdate(this.entityRetriever.toAtlasEntityHeader(vertex));
            }
        }
    }

    private String getIdFromInVertex(AtlasEdge edge) {
        return AtlasGraphUtilsV2.getIdFromVertex(edge.getInVertex());
    }

    private String getIdFromOutVertex(AtlasEdge edge) {
        return AtlasGraphUtilsV2.getIdFromVertex(edge.getOutVertex());
    }

    private String getIdFromBothVertex(AtlasEdge currentEdge, AtlasVertex parentEntityVertex) {
        String parentEntityId = AtlasGraphUtilsV2.getIdFromVertex(parentEntityVertex);
        String currentEntityId = AtlasGraphUtilsV2.getIdFromVertex(currentEdge.getInVertex());
        if (StringUtils.equals((CharSequence)currentEntityId, (CharSequence)parentEntityId)) {
            currentEntityId = this.getIdFromOutVertex(currentEdge);
        }
        return currentEntityId;
    }

    public void validateAndNormalizeForUpdate(AtlasClassification classification) throws AtlasBaseException {
        AtlasClassificationType type = this.typeRegistry.getClassificationTypeByName(classification.getTypeName());
        if (type == null) {
            throw new AtlasBaseException(AtlasErrorCode.CLASSIFICATION_NOT_FOUND, new String[]{classification.getTypeName()});
        }
        ArrayList messages = new ArrayList();
        type.validateValueForUpdate((Object)classification, classification.getTypeName(), messages);
        if (!messages.isEmpty()) {
            throw new AtlasBaseException(AtlasErrorCode.INVALID_PARAMETERS, messages);
        }
        type.getNormalizedValueForUpdate((Object)classification);
    }

    public static String getSoftRefFormattedValue(AtlasObjectId objectId) {
        return EntityGraphMapper.getSoftRefFormattedString(objectId.getTypeName(), objectId.getGuid());
    }

    private static String getSoftRefFormattedString(String typeName, String resolvedGuid) {
        return String.format(SOFT_REF_FORMAT, typeName, resolvedGuid);
    }

    public void importActivateEntity(AtlasVertex vertex, AtlasEntity entity) {
        AtlasGraphUtilsV2.setEncodedProperty(vertex, Constants.STATE_PROPERTY_KEY, AtlasEntity.Status.ACTIVE);
        if (MapUtils.isNotEmpty((Map)entity.getRelationshipAttributes())) {
            Set<String> relatedEntitiesGuids = this.getRelatedEntitiesGuids(entity);
            this.activateEntityRelationships(vertex, relatedEntitiesGuids);
        }
    }

    private void activateEntityRelationships(AtlasVertex vertex, Set<String> relatedEntitiesGuids) {
        for (AtlasEdge edge : vertex.getEdges(AtlasEdgeDirection.BOTH)) {
            String relatedEntityGuid;
            if (AtlasGraphUtilsV2.getState((AtlasElement)edge) != AtlasEntity.Status.DELETED || StringUtils.isEmpty((CharSequence)(relatedEntityGuid = Objects.equals(edge.getInVertex().getId(), vertex.getId()) ? AtlasGraphUtilsV2.getIdFromVertex(edge.getOutVertex()) : AtlasGraphUtilsV2.getIdFromVertex(edge.getInVertex()))) || !relatedEntitiesGuids.contains(relatedEntityGuid)) continue;
            edge.setProperty(Constants.STATE_PROPERTY_KEY, (Object)AtlasRelationship.Status.ACTIVE);
        }
    }

    private Set<String> getRelatedEntitiesGuids(AtlasEntity entity) {
        HashSet<String> relGuidsSet = new HashSet<String>();
        for (Object o : entity.getRelationshipAttributes().values()) {
            if (o instanceof AtlasObjectId) {
                relGuidsSet.add(((AtlasObjectId)o).getGuid());
                continue;
            }
            if (!(o instanceof List)) continue;
            for (Object id : (List)o) {
                if (!(id instanceof AtlasObjectId)) continue;
                relGuidsSet.add(((AtlasObjectId)id).getGuid());
            }
        }
        return relGuidsSet;
    }

    public static void validateCustomAttributes(AtlasEntity entity) throws AtlasBaseException {
        Map customAttributes = entity.getCustomAttributes();
        if (MapUtils.isNotEmpty((Map)customAttributes)) {
            for (Map.Entry entry : customAttributes.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                if (key.length() > CUSTOM_ATTRIBUTE_KEY_MAX_LENGTH) {
                    throw new AtlasBaseException(AtlasErrorCode.INVALID_CUSTOM_ATTRIBUTE_KEY_LENGTH, new String[]{key});
                }
                Matcher matcher = CUSTOM_ATTRIBUTE_KEY_REGEX.matcher(key);
                if (!matcher.matches()) {
                    throw new AtlasBaseException(AtlasErrorCode.INVALID_CUSTOM_ATTRIBUTE_KEY_CHARACTERS, new String[]{key});
                }
                if (StringUtils.isNotEmpty((CharSequence)CUSTOM_ATTRIBUTE_KEY_SPECIAL_PREFIX) && key.startsWith(CUSTOM_ATTRIBUTE_KEY_SPECIAL_PREFIX) || key.startsWith(CUSTOM_ATTRIBUTE_KEY_SPECIAL_PREFIX) || value.length() <= CUSTOM_ATTRIBUTE_VALUE_MAX_LENGTH) continue;
                throw new AtlasBaseException(AtlasErrorCode.INVALID_CUSTOM_ATTRIBUTE_VALUE, new String[]{value, String.valueOf(CUSTOM_ATTRIBUTE_VALUE_MAX_LENGTH)});
            }
        }
    }

    public static void validateLabels(Set<String> labels) throws AtlasBaseException {
        if (CollectionUtils.isNotEmpty(labels)) {
            for (String label : labels) {
                if (label.length() > AtlasConfiguration.LABEL_MAX_LENGTH.getInt()) {
                    throw new AtlasBaseException(AtlasErrorCode.INVALID_LABEL_LENGTH, new String[]{label, String.valueOf(AtlasConfiguration.LABEL_MAX_LENGTH.getInt())});
                }
                Matcher matcher = LABEL_REGEX.matcher(label);
                if (matcher.matches()) continue;
                throw new AtlasBaseException(AtlasErrorCode.INVALID_LABEL_CHARACTERS, new String[]{label});
            }
        }
    }

    private List<AtlasEntity> updateClassificationText(AtlasClassification classification, Collection<AtlasVertex> propagatedVertices) throws AtlasBaseException {
        ArrayList<AtlasEntity> propagatedEntities = new ArrayList<AtlasEntity>();
        if (CollectionUtils.isNotEmpty(propagatedVertices)) {
            for (AtlasVertex vertex : propagatedVertices) {
                AtlasEntity entity = this.instanceConverter.getAndCacheEntity(GraphHelper.getGuid(vertex), ENTITY_CHANGE_NOTIFY_IGNORE_RELATIONSHIP_ATTRIBUTES);
                if (!GraphHelper.isActive(entity)) continue;
                String classificationTextForEntity = this.fullTextMapperV2.getClassificationTextForEntity(entity);
                vertex.setProperty(Constants.CLASSIFICATION_TEXT_KEY, (Object)classificationTextForEntity);
                propagatedEntities.add(entity);
                LOG.info("updateClassificationText: {}: {}", (Object)classification.getTypeName(), (Object)classificationTextForEntity);
            }
        }
        return propagatedEntities;
    }

    private void updateLabels(AtlasVertex vertex, Set<String> labels) {
        if (CollectionUtils.isNotEmpty(labels)) {
            AtlasGraphUtilsV2.setEncodedProperty(vertex, Constants.LABELS_PROPERTY_KEY, this.getLabelString(labels));
        } else {
            vertex.removeProperty(Constants.LABELS_PROPERTY_KEY);
        }
    }

    private String getLabelString(Collection<String> labels) {
        String ret = null;
        if (!labels.isEmpty()) {
            ret = CLASSIFICATION_NAME_DELIMITER + String.join((CharSequence)CLASSIFICATION_NAME_DELIMITER, labels) + CLASSIFICATION_NAME_DELIMITER;
        }
        return ret;
    }

    private void addToUpdatedBusinessAttributes(Map<String, Map<String, Object>> updatedBusinessAttributes, AtlasBusinessMetadataType.AtlasBusinessAttribute bmAttribute, Object attrValue) {
        String bmName = bmAttribute.getDefinedInType().getTypeName();
        Map<String, Object> attributes = updatedBusinessAttributes.get(bmName);
        if (attributes == null) {
            attributes = new HashMap<String, Object>();
            updatedBusinessAttributes.put(bmName, attributes);
        }
        attributes.put(bmAttribute.getName(), attrValue);
    }

    private void createAndQueueTask(String taskType, AtlasVertex entityVertex, String classificationVertexId, String classificationName) {
        this.deleteDelegate.getHandler().createAndQueueTask(taskType, entityVertex, classificationVertexId, null, classificationName);
    }

    public void removePendingTaskFromEntity(String entityGuid, String taskGuid) throws EntityNotFoundException {
        if (StringUtils.isEmpty((CharSequence)entityGuid) || StringUtils.isEmpty((CharSequence)taskGuid)) {
            return;
        }
        AtlasVertex entityVertex = this.graphHelper.getVertexForGUID(entityGuid);
        if (entityVertex == null) {
            LOG.warn("Error fetching vertex: {}", (Object)entityVertex);
            return;
        }
        entityVertex.removePropertyValue(org.apache.atlas.type.Constants.PENDING_TASKS_PROPERTY_KEY, (Object)taskGuid);
    }

    public void removePendingTaskFromEdge(String edgeId, String taskGuid) throws AtlasBaseException {
        if (StringUtils.isEmpty((CharSequence)edgeId) || StringUtils.isEmpty((CharSequence)taskGuid)) {
            return;
        }
        AtlasEdge edge = this.graph.getEdge(edgeId);
        if (edge == null) {
            LOG.warn("Error fetching edge: {}", (Object)edgeId);
            return;
        }
        AtlasGraphUtilsV2.removeItemFromListProperty(edge, Constants.EDGE_PENDING_TASKS_PROPERTY_KEY, taskGuid);
    }
}

