/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.store.graph.v2;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import org.apache.atlas.ApplicationProperties;
import org.apache.atlas.AtlasErrorCode;
import org.apache.atlas.AtlasException;
import org.apache.atlas.RequestContext;
import org.apache.atlas.authorize.AtlasAuthorizationUtils;
import org.apache.atlas.authorize.AtlasPrivilege;
import org.apache.atlas.authorize.AtlasTypeAccessRequest;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.TypeCategory;
import org.apache.atlas.model.typedef.AtlasBaseTypeDef;
import org.apache.atlas.model.typedef.AtlasRelationshipDef;
import org.apache.atlas.model.typedef.AtlasRelationshipEndDef;
import org.apache.atlas.model.typedef.AtlasStructDef;
import org.apache.atlas.query.AtlasDSL;
import org.apache.atlas.repository.Constants;
import org.apache.atlas.repository.graphdb.AtlasEdge;
import org.apache.atlas.repository.graphdb.AtlasVertex;
import org.apache.atlas.repository.store.graph.v2.AtlasAbstractDefStoreV2;
import org.apache.atlas.repository.store.graph.v2.AtlasGraphUtilsV2;
import org.apache.atlas.repository.store.graph.v2.AtlasStructDefStoreV2;
import org.apache.atlas.repository.store.graph.v2.AtlasTypeDefGraphStoreV2;
import org.apache.atlas.type.AtlasRelationshipType;
import org.apache.atlas.type.AtlasStructType;
import org.apache.atlas.type.AtlasType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.atlas.typesystem.types.DataTypes;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtlasRelationshipDefStoreV2
extends AtlasAbstractDefStoreV2<AtlasRelationshipDef> {
    private static final Logger LOG = LoggerFactory.getLogger(AtlasRelationshipDefStoreV2.class);

    @Inject
    public AtlasRelationshipDefStoreV2(AtlasTypeDefGraphStoreV2 typeDefStore, AtlasTypeRegistry typeRegistry) {
        super(typeDefStore, typeRegistry);
    }

    @Override
    public AtlasVertex preCreate(AtlasRelationshipDef relationshipDef) throws AtlasBaseException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> AtlasRelationshipDefStoreV1.preCreate({})", (Object)relationshipDef);
        }
        this.validateType((AtlasBaseTypeDef)relationshipDef);
        AtlasType type = this.typeRegistry.getType(relationshipDef.getName());
        if (type.getTypeCategory() != TypeCategory.RELATIONSHIP) {
            throw new AtlasBaseException(AtlasErrorCode.TYPE_MATCH_FAILED, new String[]{relationshipDef.getName(), DataTypes.TypeCategory.RELATIONSHIP.name()});
        }
        this.verifyTypeReadAccess(relationshipDef);
        AtlasAuthorizationUtils.verifyAccess((AtlasTypeAccessRequest)new AtlasTypeAccessRequest(AtlasPrivilege.TYPE_CREATE, (AtlasBaseTypeDef)relationshipDef), (Object[])new Object[]{"create relationship-def ", relationshipDef.getName()});
        AtlasVertex relationshipDefVertex = this.typeDefStore.findTypeVertexByName(relationshipDef.getName());
        if (relationshipDefVertex != null) {
            throw new AtlasBaseException(AtlasErrorCode.TYPE_ALREADY_EXISTS, new String[]{relationshipDef.getName()});
        }
        relationshipDefVertex = this.typeDefStore.createTypeVertex((AtlasBaseTypeDef)relationshipDef);
        this.updateVertexPreCreate(relationshipDef, (AtlasRelationshipType)type, relationshipDefVertex);
        AtlasRelationshipEndDef endDef1 = relationshipDef.getEndDef1();
        AtlasRelationshipEndDef endDef2 = relationshipDef.getEndDef2();
        String type1 = endDef1.getType();
        String type2 = endDef2.getType();
        String name1 = endDef1.getName();
        String name2 = endDef2.getName();
        AtlasVertex end1TypeVertex = this.typeDefStore.findTypeVertexByName(type1);
        AtlasVertex end2TypeVertex = this.typeDefStore.findTypeVertexByName(type2);
        if (end1TypeVertex == null) {
            throw new AtlasBaseException(AtlasErrorCode.RELATIONSHIPDEF_END_TYPE_NAME_NOT_FOUND, new String[]{relationshipDef.getName(), type1});
        }
        if (end2TypeVertex == null) {
            throw new AtlasBaseException(AtlasErrorCode.RELATIONSHIPDEF_END_TYPE_NAME_NOT_FOUND, new String[]{relationshipDef.getName(), type2});
        }
        AtlasEdge edge1 = this.typeDefStore.getOrCreateEdge(relationshipDefVertex, end1TypeVertex, "__type..relationshipType");
        if (type1.equals(type2) && name1.equals(name2)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("AtlasRelationshipDefStoreV1.preCreate({}): created relationshipDef vertex {}, and one edge as {}, because end1 and end2 have the same type and name", new Object[]{relationshipDef, relationshipDefVertex, edge1});
            }
        } else {
            AtlasEdge edge2 = this.typeDefStore.getOrCreateEdge(relationshipDefVertex, end2TypeVertex, "__type..relationshipType");
            if (LOG.isDebugEnabled()) {
                LOG.debug("AtlasRelationshipDefStoreV1.preCreate({}): created relationshipDef vertex {}, edge1 as {}, edge2 as {} ", new Object[]{relationshipDef, relationshipDefVertex, edge1, edge2});
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== AtlasRelationshipDefStoreV1.preCreate({}): {}", (Object)relationshipDef, (Object)relationshipDefVertex);
        }
        return relationshipDefVertex;
    }

    @Override
    public AtlasRelationshipDef create(AtlasRelationshipDef relationshipDef, AtlasVertex preCreateResult) throws AtlasBaseException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> AtlasRelationshipDefStoreV1.create({}, {})", (Object)relationshipDef, (Object)preCreateResult);
        }
        AtlasVertex vertex = preCreateResult == null ? this.preCreate(relationshipDef) : preCreateResult;
        AtlasRelationshipDef ret = this.toRelationshipDef(vertex);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== AtlasRelationshipDefStoreV1.create({}, {}): {}", new Object[]{relationshipDef, preCreateResult, ret});
        }
        return ret;
    }

    @Override
    public List<AtlasRelationshipDef> getAll() throws AtlasBaseException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> AtlasRelationshipDefStoreV1.getAll()");
        }
        ArrayList<AtlasRelationshipDef> ret = new ArrayList<AtlasRelationshipDef>();
        Iterator<AtlasVertex> vertices = this.typeDefStore.findTypeVerticesByCategory(DataTypes.TypeCategory.RELATIONSHIP);
        while (vertices.hasNext()) {
            ret.add(this.toRelationshipDef(vertices.next()));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== AtlasRelationshipDefStoreV1.getAll(): count={}", (Object)ret.size());
        }
        return ret;
    }

    @Override
    public AtlasRelationshipDef getByName(String name) throws AtlasBaseException {
        AtlasVertex vertex;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> AtlasRelationshipDefStoreV1.getByName({})", (Object)name);
        }
        if ((vertex = this.typeDefStore.findTypeVertexByNameAndCategory(name, DataTypes.TypeCategory.RELATIONSHIP)) == null) {
            throw new AtlasBaseException(AtlasErrorCode.TYPE_NAME_NOT_FOUND, new String[]{name});
        }
        vertex.getProperty(Constants.TYPE_CATEGORY_PROPERTY_KEY, DataTypes.TypeCategory.class);
        AtlasRelationshipDef ret = this.toRelationshipDef(vertex);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== AtlasRelationshipDefStoreV1.getByName({}): {}", (Object)name, (Object)ret);
        }
        return ret;
    }

    @Override
    public AtlasRelationshipDef getByGuid(String guid) throws AtlasBaseException {
        AtlasVertex vertex;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> AtlasRelationshipDefStoreV1.getByGuid({})", (Object)guid);
        }
        if ((vertex = this.typeDefStore.findTypeVertexByGuidAndCategory(guid, DataTypes.TypeCategory.RELATIONSHIP)) == null) {
            throw new AtlasBaseException(AtlasErrorCode.TYPE_GUID_NOT_FOUND, new String[]{guid});
        }
        AtlasRelationshipDef ret = this.toRelationshipDef(vertex);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== AtlasRelationshipDefStoreV1.getByGuid({}): {}", (Object)guid, (Object)ret);
        }
        return ret;
    }

    @Override
    public AtlasRelationshipDef update(AtlasRelationshipDef relationshipDef) throws AtlasBaseException {
        AtlasRelationshipDef ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> AtlasRelationshipDefStoreV1.update({})", (Object)relationshipDef);
        }
        this.verifyTypeReadAccess(relationshipDef);
        this.validateType((AtlasBaseTypeDef)relationshipDef);
        AtlasRelationshipDef atlasRelationshipDef = ret = StringUtils.isNotBlank((String)relationshipDef.getGuid()) ? this.updateByGuid(relationshipDef.getGuid(), relationshipDef) : this.updateByName(relationshipDef.getName(), relationshipDef);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== AtlasRelationshipDefStoreV1.update({}): {}", (Object)relationshipDef, (Object)ret);
        }
        return ret;
    }

    @Override
    public AtlasRelationshipDef updateByName(String name, AtlasRelationshipDef relationshipDef) throws AtlasBaseException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> AtlasRelationshipDefStoreV1.updateByName({}, {})", (Object)name, (Object)relationshipDef);
        }
        AtlasRelationshipDef existingDef = this.typeRegistry.getRelationshipDefByName(name);
        AtlasAuthorizationUtils.verifyAccess((AtlasTypeAccessRequest)new AtlasTypeAccessRequest(AtlasPrivilege.TYPE_UPDATE, (AtlasBaseTypeDef)existingDef), (Object[])new Object[]{"update relationship-def ", name});
        this.validateType((AtlasBaseTypeDef)relationshipDef);
        AtlasType type = this.typeRegistry.getType(relationshipDef.getName());
        if (type.getTypeCategory() != TypeCategory.RELATIONSHIP) {
            throw new AtlasBaseException(AtlasErrorCode.TYPE_MATCH_FAILED, new String[]{relationshipDef.getName(), DataTypes.TypeCategory.RELATIONSHIP.name()});
        }
        AtlasVertex vertex = this.typeDefStore.findTypeVertexByNameAndCategory(name, DataTypes.TypeCategory.RELATIONSHIP);
        if (vertex == null) {
            throw new AtlasBaseException(AtlasErrorCode.TYPE_NAME_NOT_FOUND, new String[]{name});
        }
        this.preUpdateCheck(relationshipDef, (AtlasRelationshipType)type, vertex);
        AtlasRelationshipDef ret = this.toRelationshipDef(vertex);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== AtlasRelationshipDefStoreV1.updateByName({}, {}): {}", new Object[]{name, relationshipDef, ret});
        }
        return ret;
    }

    @Override
    public AtlasRelationshipDef updateByGuid(String guid, AtlasRelationshipDef relationshipDef) throws AtlasBaseException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> AtlasRelationshipDefStoreV1.updateByGuid({})", (Object)guid);
        }
        AtlasRelationshipDef existingDef = this.typeRegistry.getRelationshipDefByGuid(guid);
        AtlasAuthorizationUtils.verifyAccess((AtlasTypeAccessRequest)new AtlasTypeAccessRequest(AtlasPrivilege.TYPE_UPDATE, (AtlasBaseTypeDef)existingDef), (Object[])new Object[]{"update relationship-Def ", existingDef != null ? existingDef.getName() : guid});
        this.validateType((AtlasBaseTypeDef)relationshipDef);
        AtlasType type = this.typeRegistry.getTypeByGuid(guid);
        if (type.getTypeCategory() != TypeCategory.RELATIONSHIP) {
            throw new AtlasBaseException(AtlasErrorCode.TYPE_MATCH_FAILED, new String[]{relationshipDef.getName(), DataTypes.TypeCategory.RELATIONSHIP.name()});
        }
        AtlasVertex vertex = this.typeDefStore.findTypeVertexByGuidAndCategory(guid, DataTypes.TypeCategory.RELATIONSHIP);
        if (vertex == null) {
            throw new AtlasBaseException(AtlasErrorCode.TYPE_GUID_NOT_FOUND, new String[]{guid});
        }
        this.preUpdateCheck(relationshipDef, (AtlasRelationshipType)type, vertex);
        AtlasRelationshipDef ret = this.toRelationshipDef(vertex);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== AtlasRelationshipDefStoreV1.updateByGuid({}): {}", (Object)guid, (Object)ret);
        }
        return ret;
    }

    @Override
    public AtlasVertex preDeleteByName(String name) throws AtlasBaseException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> AtlasRelationshipDefStoreV1.preDeleteByName({})", (Object)name);
        }
        AtlasRelationshipDef existingDef = this.typeRegistry.getRelationshipDefByName(name);
        AtlasAuthorizationUtils.verifyAccess((AtlasTypeAccessRequest)new AtlasTypeAccessRequest(AtlasPrivilege.TYPE_DELETE, (AtlasBaseTypeDef)existingDef), (Object[])new Object[]{"delete relationship-def ", name});
        AtlasVertex ret = this.typeDefStore.findTypeVertexByNameAndCategory(name, DataTypes.TypeCategory.RELATIONSHIP);
        if (ret == null) {
            throw new AtlasBaseException(AtlasErrorCode.TYPE_NAME_NOT_FOUND, new String[]{name});
        }
        if (AtlasGraphUtilsV2.relationshipTypeHasInstanceEdges(name)) {
            throw new AtlasBaseException(AtlasErrorCode.TYPE_HAS_REFERENCES, new String[]{name});
        }
        this.typeDefStore.deleteTypeVertexOutEdges(ret);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== AtlasRelationshipDefStoreV1.preDeleteByName({}): {}", (Object)name, (Object)ret);
        }
        return ret;
    }

    @Override
    public AtlasVertex preDeleteByGuid(String guid) throws AtlasBaseException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> AtlasRelationshipDefStoreV1.preDeleteByGuid({})", (Object)guid);
        }
        AtlasRelationshipDef existingDef = this.typeRegistry.getRelationshipDefByGuid(guid);
        AtlasAuthorizationUtils.verifyAccess((AtlasTypeAccessRequest)new AtlasTypeAccessRequest(AtlasPrivilege.TYPE_DELETE, (AtlasBaseTypeDef)existingDef), (Object[])new Object[]{"delete relationship-def ", existingDef != null ? existingDef.getName() : guid});
        AtlasVertex ret = this.typeDefStore.findTypeVertexByGuidAndCategory(guid, DataTypes.TypeCategory.RELATIONSHIP);
        if (ret == null) {
            throw new AtlasBaseException(AtlasErrorCode.TYPE_GUID_NOT_FOUND, new String[]{guid});
        }
        String typeName = AtlasGraphUtilsV2.getEncodedProperty(ret, Constants.TYPENAME_PROPERTY_KEY, String.class);
        if (AtlasGraphUtilsV2.relationshipTypeHasInstanceEdges(typeName)) {
            throw new AtlasBaseException(AtlasErrorCode.TYPE_HAS_REFERENCES, new String[]{typeName});
        }
        this.typeDefStore.deleteTypeVertexOutEdges(ret);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== AtlasRelationshipDefStoreV1.preDeleteByGuid({}): {}", (Object)guid, (Object)ret);
        }
        return ret;
    }

    private void updateVertexPreCreate(AtlasRelationshipDef relationshipDef, AtlasRelationshipType relationshipType, AtlasVertex vertex) throws AtlasBaseException {
        boolean allowReservedKeywords;
        AtlasRelationshipEndDef end1 = relationshipDef.getEndDef1();
        AtlasRelationshipEndDef end2 = relationshipDef.getEndDef2();
        try {
            allowReservedKeywords = ApplicationProperties.get().getBoolean("atlas.types.allowReservedKeywords", true);
        }
        catch (AtlasException e) {
            throw new AtlasBaseException((Throwable)e);
        }
        if (!allowReservedKeywords) {
            if (AtlasDSL.Parser.isKeyword(end1.getName())) {
                throw new AtlasBaseException(AtlasErrorCode.RELATIONSHIPDEF_END1_NAME_INVALID, new String[]{end1.getName()});
            }
            if (AtlasDSL.Parser.isKeyword(end2.getName())) {
                throw new AtlasBaseException(AtlasErrorCode.RELATIONSHIPDEF_END2_NAME_INVALID, new String[]{end2.getName()});
            }
        }
        AtlasStructDefStoreV2.updateVertexPreCreate((AtlasStructDef)relationshipDef, (AtlasStructType)relationshipType, vertex, this.typeDefStore);
        AtlasRelationshipDefStoreV2.setVertexPropertiesFromRelationshipDef(relationshipDef, vertex);
    }

    private void preUpdateCheck(AtlasRelationshipDef newRelationshipDef, AtlasRelationshipType relationshipType, AtlasVertex vertex) throws AtlasBaseException {
        AtlasRelationshipDef existingRelationshipDef = this.toRelationshipDef(vertex);
        AtlasRelationshipDefStoreV2.preUpdateCheck(newRelationshipDef, existingRelationshipDef);
        AtlasStructDefStoreV2.updateVertexPreUpdate((AtlasStructDef)newRelationshipDef, (AtlasStructType)relationshipType, vertex, this.typeDefStore);
        AtlasRelationshipDefStoreV2.setVertexPropertiesFromRelationshipDef(newRelationshipDef, vertex);
    }

    public static void preUpdateCheck(AtlasRelationshipDef newRelationshipDef, AtlasRelationshipDef existingRelationshipDef) throws AtlasBaseException {
        AtlasRelationshipEndDef newEndToCompareWith;
        AtlasRelationshipDef.RelationshipCategory newRelationshipCategory;
        String newName;
        String existingName = existingRelationshipDef.getName();
        if (!existingName.equals(newName = newRelationshipDef.getName())) {
            throw new AtlasBaseException(AtlasErrorCode.RELATIONSHIPDEF_INVALID_NAME_UPDATE, new String[]{newRelationshipDef.getGuid(), existingName, newName});
        }
        AtlasRelationshipDef.RelationshipCategory existingRelationshipCategory = existingRelationshipDef.getRelationshipCategory();
        if (!existingRelationshipCategory.equals((Object)(newRelationshipCategory = newRelationshipDef.getRelationshipCategory()))) {
            if (!RequestContext.get().isInTypePatching()) {
                throw new AtlasBaseException(AtlasErrorCode.RELATIONSHIPDEF_INVALID_CATEGORY_UPDATE, new String[]{newRelationshipDef.getName(), newRelationshipCategory.name(), existingRelationshipCategory.name()});
            }
            LOG.warn("RELATIONSHIP UPDATE: relationship category from {} to {} for {}", new Object[]{existingRelationshipCategory.name(), newRelationshipCategory.name(), newRelationshipDef.getName()});
        }
        AtlasRelationshipEndDef existingEnd1 = existingRelationshipDef.getEndDef1();
        AtlasRelationshipEndDef existingEnd2 = existingRelationshipDef.getEndDef2();
        AtlasRelationshipEndDef newEnd1 = newRelationshipDef.getEndDef1();
        AtlasRelationshipEndDef newEnd2 = newRelationshipDef.getEndDef2();
        boolean endsSwaped = false;
        if (!AtlasRelationshipDefStoreV2.isValidUpdate(existingEnd1, newEnd1)) {
            if (RequestContext.get().isInTypePatching() && AtlasRelationshipDefStoreV2.isValidUpdate(existingEnd1, newEnd2)) {
                endsSwaped = true;
            } else {
                throw new AtlasBaseException(AtlasErrorCode.RELATIONSHIPDEF_INVALID_END1_UPDATE, new String[]{newRelationshipDef.getName(), newEnd1.toString(), existingEnd1.toString()});
            }
        }
        AtlasRelationshipEndDef atlasRelationshipEndDef = newEndToCompareWith = endsSwaped ? newEnd1 : newEnd2;
        if (!AtlasRelationshipDefStoreV2.isValidUpdate(existingEnd2, newEndToCompareWith)) {
            throw new AtlasBaseException(AtlasErrorCode.RELATIONSHIPDEF_INVALID_END2_UPDATE, new String[]{newRelationshipDef.getName(), newEndToCompareWith.toString(), existingEnd2.toString()});
        }
    }

    public static void setVertexPropertiesFromRelationshipDef(AtlasRelationshipDef relationshipDef, AtlasVertex vertex) {
        vertex.setProperty("endDef1", (Object)AtlasType.toJson((Object)relationshipDef.getEndDef1()));
        vertex.setProperty("endDef2", (Object)AtlasType.toJson((Object)relationshipDef.getEndDef2()));
        String relationshipCategory = AtlasRelationshipDef.RelationshipCategory.ASSOCIATION.name();
        if (relationshipDef.getRelationshipCategory() != null) {
            relationshipCategory = relationshipDef.getRelationshipCategory().name();
        }
        vertex.setProperty("relationshipCategory", (Object)relationshipCategory);
        if (relationshipDef.getRelationshipLabel() == null) {
            vertex.removeProperty("relationshipLabel");
        } else {
            vertex.setProperty("relationshipLabel", (Object)relationshipDef.getRelationshipLabel());
        }
        if (relationshipDef.getPropagateTags() == null) {
            vertex.setProperty(Constants.RELATIONSHIPTYPE_TAG_PROPAGATION_KEY, (Object)AtlasRelationshipDef.PropagateTags.NONE.name());
        } else {
            vertex.setProperty(Constants.RELATIONSHIPTYPE_TAG_PROPAGATION_KEY, (Object)relationshipDef.getPropagateTags().name());
        }
    }

    private AtlasRelationshipDef toRelationshipDef(AtlasVertex vertex) throws AtlasBaseException {
        AtlasRelationshipDef ret = null;
        if (vertex != null && this.typeDefStore.isTypeVertex(vertex, DataTypes.TypeCategory.RELATIONSHIP)) {
            String name = (String)vertex.getProperty(Constants.TYPENAME_PROPERTY_KEY, String.class);
            String description = (String)vertex.getProperty(Constants.TYPEDESCRIPTION_PROPERTY_KEY, String.class);
            String version = (String)vertex.getProperty(Constants.TYPEVERSION_PROPERTY_KEY, String.class);
            String label = (String)vertex.getProperty("relationshipLabel", String.class);
            String end1Str = (String)vertex.getProperty("endDef1", String.class);
            String end2Str = (String)vertex.getProperty("endDef2", String.class);
            String relationStr = (String)vertex.getProperty("relationshipCategory", String.class);
            String propagateStr = (String)vertex.getProperty(Constants.RELATIONSHIPTYPE_TAG_PROPAGATION_KEY, String.class);
            AtlasRelationshipEndDef endDef1 = (AtlasRelationshipEndDef)AtlasType.fromJson((String)end1Str, AtlasRelationshipEndDef.class);
            AtlasRelationshipEndDef endDef2 = (AtlasRelationshipEndDef)AtlasType.fromJson((String)end2Str, AtlasRelationshipEndDef.class);
            AtlasRelationshipDef.RelationshipCategory relationshipCategory = null;
            for (AtlasRelationshipDef.RelationshipCategory value : AtlasRelationshipDef.RelationshipCategory.values()) {
                if (!value.name().equals(relationStr)) continue;
                relationshipCategory = value;
            }
            AtlasRelationshipDef.PropagateTags propagateTags = null;
            for (AtlasRelationshipDef.PropagateTags value : AtlasRelationshipDef.PropagateTags.values()) {
                if (!value.name().equals(propagateStr)) continue;
                propagateTags = value;
            }
            ret = new AtlasRelationshipDef(name, description, version, relationshipCategory, propagateTags, endDef1, endDef2);
            ret.setRelationshipLabel(label);
            AtlasStructDefStoreV2.toStructDef(vertex, (AtlasStructDef)ret, this.typeDefStore);
        }
        return ret;
    }

    private static boolean isValidUpdate(AtlasRelationshipEndDef currentDef, AtlasRelationshipEndDef updatedDef) {
        return Objects.equals(currentDef.getType(), updatedDef.getType()) && Objects.equals(currentDef.getName(), updatedDef.getName()) && Objects.equals(currentDef.getIsContainer(), updatedDef.getIsContainer()) && Objects.equals(currentDef.getCardinality(), updatedDef.getCardinality());
    }

    private void verifyTypeReadAccess(AtlasRelationshipDef relationshipDef) throws AtlasBaseException {
        this.verifyTypeReadAccess(relationshipDef.getEndDef1().getType());
        this.verifyTypeReadAccess(relationshipDef.getEndDef2().getType());
    }
}

