/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.store.graph.v2;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.atlas.ApplicationProperties;
import org.apache.atlas.AtlasErrorCode;
import org.apache.atlas.GraphTransactionInterceptor;
import org.apache.atlas.RequestContext;
import org.apache.atlas.SortOrder;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.TypeCategory;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.typedef.AtlasBaseTypeDef;
import org.apache.atlas.model.typedef.AtlasEnumDef;
import org.apache.atlas.repository.Constants;
import org.apache.atlas.repository.graph.AtlasGraphProvider;
import org.apache.atlas.repository.graph.GraphHelper;
import org.apache.atlas.repository.graphdb.AtlasEdge;
import org.apache.atlas.repository.graphdb.AtlasElement;
import org.apache.atlas.repository.graphdb.AtlasGraph;
import org.apache.atlas.repository.graphdb.AtlasGraphQuery;
import org.apache.atlas.repository.graphdb.AtlasIndexQuery;
import org.apache.atlas.repository.graphdb.AtlasVertex;
import org.apache.atlas.type.AtlasEntityType;
import org.apache.atlas.type.AtlasEnumType;
import org.apache.atlas.type.AtlasStructType;
import org.apache.atlas.type.AtlasType;
import org.apache.atlas.utils.AtlasPerfMetrics;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtlasGraphUtilsV2 {
    private static final Logger LOG = LoggerFactory.getLogger(AtlasGraphUtilsV2.class);
    public static final String PROPERTY_PREFIX = "__type.";
    public static final String SUPERTYPE_EDGE_LABEL = "__type..supertype";
    public static final String ENTITYTYPE_EDGE_LABEL = "__type..entitytype";
    public static final String RELATIONSHIPTYPE_EDGE_LABEL = "__type..relationshipType";
    public static final String VERTEX_TYPE = "typeSystem";
    private static boolean USE_INDEX_QUERY_TO_FIND_ENTITY_BY_UNIQUE_ATTRIBUTES = false;
    private static boolean USE_UNIQUE_INDEX_PROPERTY_TO_FIND_ENTITY = true;
    private static String INDEX_SEARCH_PREFIX;

    public static String getTypeDefPropertyKey(AtlasBaseTypeDef typeDef) {
        return AtlasGraphUtilsV2.getTypeDefPropertyKey(typeDef.getName());
    }

    public static String getTypeDefPropertyKey(AtlasBaseTypeDef typeDef, String child) {
        return AtlasGraphUtilsV2.getTypeDefPropertyKey(typeDef.getName(), child);
    }

    public static String getTypeDefPropertyKey(String typeName) {
        return PROPERTY_PREFIX + typeName;
    }

    public static String getTypeDefPropertyKey(String typeName, String child) {
        return PROPERTY_PREFIX + typeName + "." + child;
    }

    public static String getIdFromVertex(AtlasVertex vertex) {
        return (String)vertex.getProperty(Constants.GUID_PROPERTY_KEY, String.class);
    }

    public static String getIdFromEdge(AtlasEdge edge) {
        return (String)edge.getProperty(Constants.GUID_PROPERTY_KEY, String.class);
    }

    public static String getTypeName(AtlasElement element) {
        if (element instanceof AtlasEdge) {
            return (String)element.getProperty(Constants.RELATIONSHIP_TYPE_PROPERTY_KEY, String.class);
        }
        return (String)element.getProperty(Constants.ENTITY_TYPE_PROPERTY_KEY, String.class);
    }

    public static String getEdgeLabel(String fromNode, String toNode) {
        return "__type.edge." + fromNode + "." + toNode;
    }

    public static String getEdgeLabel(String property) {
        return "__" + property;
    }

    public static String getQualifiedAttributePropertyKey(AtlasStructType fromType, String attributeName) throws AtlasBaseException {
        switch (fromType.getTypeCategory()) {
            case ENTITY: 
            case STRUCT: 
            case CLASSIFICATION: {
                return fromType.getQualifiedAttributePropertyKey(attributeName);
            }
        }
        throw new AtlasBaseException(AtlasErrorCode.UNKNOWN_TYPE, new String[]{fromType.getTypeCategory().name()});
    }

    public static boolean isEntityVertex(AtlasVertex vertex) {
        return StringUtils.isNotEmpty((String)AtlasGraphUtilsV2.getIdFromVertex(vertex)) && StringUtils.isNotEmpty((String)AtlasGraphUtilsV2.getTypeName((AtlasElement)vertex));
    }

    public static boolean isTypeVertex(AtlasVertex vertex) {
        return vertex.getProperty(Constants.TYPENAME_PROPERTY_KEY, String.class) != null;
    }

    public static boolean isReference(AtlasType type) {
        return AtlasGraphUtilsV2.isReference(type.getTypeCategory());
    }

    public static boolean isReference(TypeCategory typeCategory) {
        return typeCategory == TypeCategory.STRUCT || typeCategory == TypeCategory.ENTITY || typeCategory == TypeCategory.OBJECT_ID_TYPE;
    }

    public static String encodePropertyKey(String key) {
        return AtlasStructType.AtlasAttribute.encodePropertyKey((String)key);
    }

    public static String decodePropertyKey(String key) {
        return AtlasStructType.AtlasAttribute.decodePropertyKey((String)key);
    }

    public static AtlasVertex addProperty(AtlasVertex vertex, String propertyName, Object value) {
        return AtlasGraphUtilsV2.addProperty(vertex, propertyName, value, false);
    }

    public static AtlasVertex addEncodedProperty(AtlasVertex vertex, String propertyName, Object value) {
        return AtlasGraphUtilsV2.addProperty(vertex, propertyName, value, true);
    }

    public static AtlasEdge addEncodedProperty(AtlasEdge edge, String propertyName, String value) {
        ArrayList<String> listPropertyValues = edge.getListProperty(propertyName);
        if (listPropertyValues == null) {
            listPropertyValues = new ArrayList<String>();
        }
        listPropertyValues.add(value);
        edge.removeProperty(propertyName);
        edge.setListProperty(propertyName, listPropertyValues);
        return edge;
    }

    public static AtlasVertex addProperty(AtlasVertex vertex, String propertyName, Object value, boolean isEncoded) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> addProperty({}, {}, {})", new Object[]{AtlasGraphUtilsV2.toString(vertex), propertyName, value});
        }
        if (!isEncoded) {
            propertyName = AtlasGraphUtilsV2.encodePropertyKey(propertyName);
        }
        vertex.addProperty(propertyName, value);
        return vertex;
    }

    public static <T extends AtlasElement> void setProperty(T element, String propertyName, Object value) {
        AtlasGraphUtilsV2.setProperty(element, propertyName, value, false);
    }

    public static <T extends AtlasElement> void setEncodedProperty(T element, String propertyName, Object value) {
        AtlasGraphUtilsV2.setProperty(element, propertyName, value, true);
    }

    public static <T extends AtlasElement> void setProperty(T element, String propertyName, Object value, boolean isEncoded) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> setProperty({}, {}, {})", new Object[]{AtlasGraphUtilsV2.toString(element), propertyName, value});
        }
        if (!isEncoded) {
            propertyName = AtlasGraphUtilsV2.encodePropertyKey(propertyName);
        }
        Object existingValue = element.getProperty(propertyName, Object.class);
        if (value == null) {
            if (existingValue != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Removing property {} from {}", (Object)propertyName, (Object)AtlasGraphUtilsV2.toString(element));
                }
                element.removeProperty(propertyName);
            }
        } else if (!value.equals(existingValue)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Setting property {} in {}", (Object)propertyName, (Object)AtlasGraphUtilsV2.toString(element));
            }
            if (value instanceof Date) {
                Long encodedValue = ((Date)value).getTime();
                element.setProperty(propertyName, (Object)encodedValue);
            } else {
                element.setProperty(propertyName, value);
            }
        }
    }

    public static <T extends AtlasElement, O> O getProperty(T element, String propertyName, Class<O> returnType) {
        return AtlasGraphUtilsV2.getProperty(element, propertyName, returnType, false);
    }

    public static <T extends AtlasElement, O> O getEncodedProperty(T element, String propertyName, Class<O> returnType) {
        return AtlasGraphUtilsV2.getProperty(element, propertyName, returnType, true);
    }

    public static <T extends AtlasElement, O> O getProperty(T element, String propertyName, Class<O> returnType, boolean isEncoded) {
        if (!isEncoded) {
            propertyName = AtlasGraphUtilsV2.encodePropertyKey(propertyName);
        }
        Object property = element.getProperty(propertyName, returnType);
        if (LOG.isDebugEnabled()) {
            LOG.debug("getProperty({}, {}) ==> {}", new Object[]{AtlasGraphUtilsV2.toString(element), propertyName, returnType.cast(property)});
        }
        return returnType.cast(property);
    }

    public static AtlasVertex getVertexByUniqueAttributes(AtlasEntityType entityType, Map<String, Object> attrValues) throws AtlasBaseException {
        return AtlasGraphUtilsV2.getVertexByUniqueAttributes(AtlasGraphProvider.getGraphInstance(), entityType, attrValues);
    }

    public static AtlasVertex getVertexByUniqueAttributes(AtlasGraph graph, AtlasEntityType entityType, Map<String, Object> attrValues) throws AtlasBaseException {
        AtlasVertex vertex = AtlasGraphUtilsV2.findByUniqueAttributes(graph, entityType, attrValues);
        if (vertex == null) {
            throw new AtlasBaseException(AtlasErrorCode.INSTANCE_BY_UNIQUE_ATTRIBUTE_NOT_FOUND, new String[]{entityType.getTypeName(), attrValues.toString()});
        }
        return vertex;
    }

    public static String getGuidByUniqueAttributes(AtlasEntityType entityType, Map<String, Object> attrValues) throws AtlasBaseException {
        AtlasVertex vertexByUniqueAttributes = AtlasGraphUtilsV2.getVertexByUniqueAttributes(AtlasGraphProvider.getGraphInstance(), entityType, attrValues);
        return AtlasGraphUtilsV2.getIdFromVertex(vertexByUniqueAttributes);
    }

    public static String getGuidByUniqueAttributes(AtlasGraph graph, AtlasEntityType entityType, Map<String, Object> attrValues) throws AtlasBaseException {
        AtlasVertex vertexByUniqueAttributes = AtlasGraphUtilsV2.getVertexByUniqueAttributes(graph, entityType, attrValues);
        return AtlasGraphUtilsV2.getIdFromVertex(vertexByUniqueAttributes);
    }

    public static AtlasVertex findByUniqueAttributes(AtlasEntityType entityType, Map<String, Object> attrValues) {
        return AtlasGraphUtilsV2.findByUniqueAttributes(AtlasGraphProvider.getGraphInstance(), entityType, attrValues);
    }

    public static AtlasVertex findByUniqueAttributes(AtlasGraph graph, AtlasEntityType entityType, Map<String, Object> attrValues) {
        AtlasPerfMetrics.MetricRecorder metric = RequestContext.get().startMetricRecord("findByUniqueAttributes");
        AtlasVertex vertex = null;
        Map uniqueAttributes = entityType.getUniqAttributes();
        if (MapUtils.isNotEmpty((Map)uniqueAttributes) && MapUtils.isNotEmpty(attrValues)) {
            Map<String, Object> uniqAttrValues = AtlasGraphUtilsV2.populateUniqueAttributesMap(uniqueAttributes, attrValues);
            Map<String, Object> attrNameValues = AtlasGraphUtilsV2.populateAttributesMap(uniqueAttributes, attrValues);
            String typeName = entityType.getTypeName();
            Set entitySubTypes = entityType.getAllSubTypes();
            if (USE_UNIQUE_INDEX_PROPERTY_TO_FIND_ENTITY && MapUtils.isNotEmpty(uniqAttrValues)) {
                vertex = AtlasGraphUtilsV2.findByTypeAndUniquePropertyName(graph, typeName, uniqAttrValues);
                if (vertex == null && !entitySubTypes.isEmpty()) {
                    vertex = AtlasGraphUtilsV2.findBySuperTypeAndUniquePropertyName(graph, typeName, uniqAttrValues);
                }
            } else {
                vertex = AtlasGraphUtilsV2.findByTypeAndPropertyName(graph, typeName, attrNameValues);
                if (vertex == null && !entitySubTypes.isEmpty()) {
                    vertex = AtlasGraphUtilsV2.findBySuperTypeAndPropertyName(graph, typeName, attrNameValues);
                }
            }
        }
        RequestContext.get().endMetricRecord(metric);
        return vertex;
    }

    public static String findFirstDeletedDuringSpooledByQualifiedName(String qualifiedName, long timestamp) {
        return AtlasGraphUtilsV2.findFirstDeletedDuringSpooledByQualifiedName(AtlasGraphProvider.getGraphInstance(), qualifiedName, timestamp);
    }

    public static String findFirstDeletedDuringSpooledByQualifiedName(AtlasGraph graph, String qualifiedName, long timestamp) {
        AtlasPerfMetrics.MetricRecorder metric = RequestContext.get().startMetricRecord("findDeletedDuringSpooledByQualifiedName");
        AtlasGraphQuery query = graph.query().has(Constants.STATE_PROPERTY_KEY, (Object)AtlasEntity.Status.DELETED.name()).has(Constants.ENTITY_DELETED_TIMESTAMP_PROPERTY_KEY, (AtlasGraphQuery.QueryOperator)AtlasGraphQuery.ComparisionOperator.GREATER_THAN, (Object)timestamp).has("Referenceable.qualifiedName", (Object)qualifiedName).orderBy(Constants.ENTITY_DELETED_TIMESTAMP_PROPERTY_KEY, AtlasGraphQuery.SortOrder.ASC);
        Iterator iterator = query.vertices().iterator();
        String ret = iterator.hasNext() ? GraphHelper.getGuid((AtlasVertex)iterator.next()) : null;
        RequestContext.get().endMetricRecord(metric);
        return ret;
    }

    public static AtlasVertex findByGuid(String guid) {
        return AtlasGraphUtilsV2.findByGuid(AtlasGraphProvider.getGraphInstance(), guid);
    }

    public static AtlasVertex findByGuid(AtlasGraph graph, String guid) {
        AtlasPerfMetrics.MetricRecorder metric = RequestContext.get().startMetricRecord("findByGuid");
        AtlasVertex ret = GraphTransactionInterceptor.getVertexFromCache(guid);
        if (ret == null) {
            AtlasGraphQuery query = graph.query().has(Constants.GUID_PROPERTY_KEY, (Object)guid);
            Iterator results = query.vertices().iterator();
            AtlasVertex atlasVertex = ret = results.hasNext() ? (AtlasVertex)results.next() : null;
            if (ret != null) {
                GraphTransactionInterceptor.addToVertexCache(guid, ret);
            }
        }
        RequestContext.get().endMetricRecord(metric);
        return ret;
    }

    public static AtlasVertex findDeletedByGuid(AtlasGraph graph, String guid) {
        AtlasVertex ret = GraphTransactionInterceptor.getVertexFromCache(guid);
        if (ret == null) {
            AtlasGraphQuery query = graph.query().has(Constants.GUID_PROPERTY_KEY, (Object)guid).has(Constants.STATE_PROPERTY_KEY, (Object)AtlasEntity.Status.DELETED.name());
            Iterator results = query.vertices().iterator();
            AtlasVertex atlasVertex = ret = results.hasNext() ? (AtlasVertex)results.next() : null;
            if (ret != null) {
                GraphTransactionInterceptor.addToVertexCache(guid, ret);
            }
        }
        return ret;
    }

    public static String getTypeNameFromGuid(AtlasGraph graph, String guid) {
        String ret = null;
        if (StringUtils.isNotEmpty((String)guid)) {
            AtlasVertex vertex = AtlasGraphUtilsV2.findByGuid(graph, guid);
            ret = vertex != null ? AtlasGraphUtilsV2.getTypeName((AtlasElement)vertex) : null;
        }
        return ret;
    }

    public static boolean typeHasInstanceVertex(String typeName) throws AtlasBaseException {
        return AtlasGraphUtilsV2.typeHasInstanceVertex(AtlasGraphProvider.getGraphInstance(), typeName);
    }

    public static boolean typeHasInstanceVertex(AtlasGraph graph, String typeName) throws AtlasBaseException {
        boolean hasInstanceVertex;
        AtlasGraphQuery query = graph.query().has("__typeName", (AtlasGraphQuery.QueryOperator)AtlasGraphQuery.ComparisionOperator.EQUAL, (Object)typeName);
        Iterator results = query.vertices().iterator();
        boolean bl = hasInstanceVertex = results != null && results.hasNext();
        if (LOG.isDebugEnabled()) {
            LOG.debug("typeName {} has instance vertex {}", (Object)typeName, (Object)hasInstanceVertex);
        }
        return hasInstanceVertex;
    }

    public static AtlasVertex findByTypeAndUniquePropertyName(String typeName, String propertyName, Object attrVal) {
        return AtlasGraphUtilsV2.findByTypeAndUniquePropertyName(AtlasGraphProvider.getGraphInstance(), typeName, propertyName, attrVal);
    }

    public static AtlasVertex findByTypeAndUniquePropertyName(AtlasGraph graph, String typeName, String propertyName, Object attrVal) {
        AtlasPerfMetrics.MetricRecorder metric = RequestContext.get().startMetricRecord("findByTypeAndUniquePropertyName");
        AtlasGraphQuery query = graph.query().has(Constants.ENTITY_TYPE_PROPERTY_KEY, (Object)typeName).has(propertyName, attrVal);
        Iterator results = query.vertices().iterator();
        AtlasVertex vertex = results.hasNext() ? (AtlasVertex)results.next() : null;
        RequestContext.get().endMetricRecord(metric);
        return vertex;
    }

    private static Map<String, Object> populateUniqueAttributesMap(Map<String, AtlasStructType.AtlasAttribute> uniqueAttributes, Map<String, Object> attrValues) {
        return AtlasGraphUtilsV2.populateAttributesMap(uniqueAttributes, attrValues, true);
    }

    private static Map<String, Object> populateAttributesMap(Map<String, AtlasStructType.AtlasAttribute> uniqueAttributes, Map<String, Object> attrValues) {
        return AtlasGraphUtilsV2.populateAttributesMap(uniqueAttributes, attrValues, false);
    }

    private static Map<String, Object> populateAttributesMap(Map<String, AtlasStructType.AtlasAttribute> uniqueAttributes, Map<String, Object> attrValues, boolean isUnique) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        for (AtlasStructType.AtlasAttribute attribute : uniqueAttributes.values()) {
            String attrName = isUnique ? attribute.getVertexUniquePropertyName() : attribute.getVertexPropertyName();
            Object attrValue = attrValues.get(attribute.getName());
            if (attrName == null || attrValue == null) continue;
            ret.put(attrName, attrValue);
        }
        return ret;
    }

    public static AtlasVertex findByTypeAndUniquePropertyName(AtlasGraph graph, String typeName, Map<String, Object> attributeValues) {
        return AtlasGraphUtilsV2.findByTypeAndUniquePropertyName(graph, typeName, attributeValues, false);
    }

    public static AtlasVertex findBySuperTypeAndUniquePropertyName(AtlasGraph graph, String typeName, Map<String, Object> attributeValues) {
        return AtlasGraphUtilsV2.findByTypeAndUniquePropertyName(graph, typeName, attributeValues, true);
    }

    public static AtlasVertex findByTypeAndUniquePropertyName(AtlasGraph graph, String typeName, Map<String, Object> attributeValues, boolean isSuperType) {
        String metricName = isSuperType ? "findBySuperTypeAndUniquePropertyName" : "findByTypeAndUniquePropertyName";
        AtlasPerfMetrics.MetricRecorder metric = RequestContext.get().startMetricRecord(metricName);
        String typePropertyKey = isSuperType ? Constants.SUPER_TYPES_PROPERTY_KEY : Constants.ENTITY_TYPE_PROPERTY_KEY;
        AtlasGraphQuery query = graph.query().has(typePropertyKey, (Object)typeName);
        for (Map.Entry<String, Object> entry : attributeValues.entrySet()) {
            String attrName = entry.getKey();
            Object attrValue = entry.getValue();
            if (attrName == null || attrValue == null) continue;
            query.has(attrName, attrValue);
        }
        Iterator results = query.vertices().iterator();
        AtlasVertex vertex = results.hasNext() ? (AtlasVertex)results.next() : null;
        RequestContext.get().endMetricRecord(metric);
        return vertex;
    }

    public static AtlasVertex findByTypeAndPropertyName(AtlasGraph graph, String typeName, Map<String, Object> attributeValues) {
        return AtlasGraphUtilsV2.findByTypeAndPropertyName(graph, typeName, attributeValues, false);
    }

    public static AtlasVertex findBySuperTypeAndPropertyName(AtlasGraph graph, String typeName, Map<String, Object> attributeValues) {
        return AtlasGraphUtilsV2.findByTypeAndPropertyName(graph, typeName, attributeValues, true);
    }

    public static AtlasVertex findByTypeAndPropertyName(AtlasGraph graph, String typeName, Map<String, Object> attributeValues, boolean isSuperType) {
        String metricName = isSuperType ? "findBySuperTypeAndPropertyName" : "findByTypeAndPropertyName";
        AtlasPerfMetrics.MetricRecorder metric = RequestContext.get().startMetricRecord(metricName);
        String typePropertyKey = isSuperType ? Constants.SUPER_TYPES_PROPERTY_KEY : Constants.ENTITY_TYPE_PROPERTY_KEY;
        AtlasGraphQuery query = graph.query().has(typePropertyKey, (Object)typeName).has(Constants.STATE_PROPERTY_KEY, (Object)AtlasEntity.Status.ACTIVE.name());
        for (Map.Entry<String, Object> entry : attributeValues.entrySet()) {
            String attrName = entry.getKey();
            Object attrValue = entry.getValue();
            if (attrName == null || attrValue == null) continue;
            query.has(attrName, attrValue);
        }
        Iterator results = query.vertices().iterator();
        AtlasVertex vertex = results.hasNext() ? (AtlasVertex)results.next() : null;
        RequestContext.get().endMetricRecord(metric);
        return vertex;
    }

    public static List<String> findEntityGUIDsByType(String typename, SortOrder sortOrder) {
        return AtlasGraphUtilsV2.findEntityGUIDsByType(AtlasGraphProvider.getGraphInstance(), typename, sortOrder);
    }

    public static List<String> findEntityGUIDsByType(AtlasGraph graph, String typename, SortOrder sortOrder) {
        AtlasGraphQuery query = graph.query().has(Constants.ENTITY_TYPE_PROPERTY_KEY, (Object)typename);
        if (sortOrder != null) {
            AtlasGraphQuery.SortOrder qrySortOrder = sortOrder == SortOrder.ASCENDING ? AtlasGraphQuery.SortOrder.ASC : AtlasGraphQuery.SortOrder.DESC;
            query.orderBy("Referenceable.qualifiedName", qrySortOrder);
        }
        Iterator results = query.vertices().iterator();
        ArrayList<String> ret = new ArrayList<String>();
        if (!results.hasNext()) {
            return Collections.emptyList();
        }
        while (results.hasNext()) {
            ret.add(AtlasGraphUtilsV2.getIdFromVertex((AtlasVertex)results.next()));
        }
        return ret;
    }

    public static List<String> findEntityGUIDsByType(AtlasGraph graph, String typename) {
        return AtlasGraphUtilsV2.findEntityGUIDsByType(graph, typename, null);
    }

    public static Iterator<AtlasVertex> findActiveEntityVerticesByType(AtlasGraph graph, String typename) {
        AtlasGraphQuery query = graph.query().has(Constants.ENTITY_TYPE_PROPERTY_KEY, (Object)typename).has(Constants.STATE_PROPERTY_KEY, (Object)AtlasEntity.Status.ACTIVE.name());
        return query.vertices().iterator();
    }

    public static boolean relationshipTypeHasInstanceEdges(String typeName) throws AtlasBaseException {
        return AtlasGraphUtilsV2.relationshipTypeHasInstanceEdges(AtlasGraphProvider.getGraphInstance(), typeName);
    }

    public static boolean relationshipTypeHasInstanceEdges(AtlasGraph graph, String typeName) throws AtlasBaseException {
        boolean hasInstanceEdges;
        AtlasGraphQuery query = graph.query().has("__typeName", (AtlasGraphQuery.QueryOperator)AtlasGraphQuery.ComparisionOperator.EQUAL, (Object)typeName);
        Iterator results = query.edges().iterator();
        boolean bl = hasInstanceEdges = results != null && results.hasNext();
        if (LOG.isDebugEnabled()) {
            LOG.debug("relationshipType {} has instance edges {}", (Object)typeName, (Object)hasInstanceEdges);
        }
        return hasInstanceEdges;
    }

    private static String toString(AtlasElement element) {
        if (element instanceof AtlasVertex) {
            return AtlasGraphUtilsV2.toString((AtlasVertex)element);
        }
        if (element instanceof AtlasEdge) {
            return AtlasGraphUtilsV2.toString((AtlasEdge)element);
        }
        return element.toString();
    }

    public static String toString(AtlasVertex vertex) {
        if (vertex == null) {
            return "vertex[null]";
        }
        if (LOG.isDebugEnabled()) {
            return AtlasGraphUtilsV2.getVertexDetails(vertex);
        }
        return String.format("vertex[id=%s]", vertex.getId().toString());
    }

    public static String toString(AtlasEdge edge) {
        if (edge == null) {
            return "edge[null]";
        }
        if (LOG.isDebugEnabled()) {
            return AtlasGraphUtilsV2.getEdgeDetails(edge);
        }
        return String.format("edge[id=%s]", edge.getId().toString());
    }

    public static String getVertexDetails(AtlasVertex vertex) {
        return String.format("vertex[id=%s type=%s guid=%s]", vertex.getId().toString(), AtlasGraphUtilsV2.getTypeName((AtlasElement)vertex), AtlasGraphUtilsV2.getIdFromVertex(vertex));
    }

    public static String getEdgeDetails(AtlasEdge edge) {
        return String.format("edge[id=%s label=%s from %s -> to %s]", edge.getId(), edge.getLabel(), AtlasGraphUtilsV2.toString(edge.getOutVertex()), AtlasGraphUtilsV2.toString(edge.getInVertex()));
    }

    public static AtlasEntity.Status getState(AtlasElement element) {
        String state = AtlasGraphUtilsV2.getStateAsString(element);
        return state == null ? null : AtlasEntity.Status.valueOf((String)state);
    }

    public static String getStateAsString(AtlasElement element) {
        return (String)element.getProperty(Constants.STATE_PROPERTY_KEY, String.class);
    }

    private static AtlasIndexQuery getIndexQuery(AtlasGraph graph, AtlasEntityType entityType, String propertyName, String value) {
        StringBuilder sb = new StringBuilder();
        sb.append(INDEX_SEARCH_PREFIX + "\"").append("__typeName").append("\":").append(entityType.getTypeAndAllSubTypesQryStr()).append(" AND ").append(INDEX_SEARCH_PREFIX + "\"").append(propertyName).append("\":").append(AtlasStructType.AtlasAttribute.escapeIndexQueryValue((String)value)).append(" AND ").append(INDEX_SEARCH_PREFIX + "\"").append(Constants.STATE_PROPERTY_KEY).append("\":ACTIVE");
        return graph.indexQuery("vertex_index", sb.toString());
    }

    public static String getIndexSearchPrefix() {
        return INDEX_SEARCH_PREFIX;
    }

    public static List<String> getClassificationNames(AtlasVertex entityVertex) {
        return AtlasGraphUtilsV2.getClassificationNamesHelper(entityVertex, Constants.CLASSIFICATION_NAMES_KEY);
    }

    public static List<String> getPropagatedClassificationNames(AtlasVertex entityVertex) {
        return AtlasGraphUtilsV2.getClassificationNamesHelper(entityVertex, Constants.PROPAGATED_CLASSIFICATION_NAMES_KEY);
    }

    private static List<String> getClassificationNamesHelper(AtlasVertex entityVertex, String propertyKey) {
        List<String> classificationNames = null;
        String classificationNamesString = (String)entityVertex.getProperty(propertyKey, String.class);
        if (StringUtils.isNotEmpty((String)classificationNamesString)) {
            classificationNames = Arrays.asList(StringUtils.split((String)classificationNamesString, (String)"\\|"));
        }
        return classificationNames;
    }

    public static List<Date> dateParser(String[] arr, List failedTermMsgList, int lineIndex) {
        ArrayList<Date> ret = new ArrayList<Date>();
        for (String s : arr) {
            try {
                SimpleDateFormat formatter = new SimpleDateFormat("MM/dd/yyyy");
                Date date = formatter.parse(s);
                ret.add(date);
            }
            catch (Exception e) {
                LOG.error("Provided value " + s + " is not of Date type at line #" + lineIndex);
                failedTermMsgList.add("Provided value " + s + " is not of Date type at line #" + lineIndex);
            }
        }
        return ret;
    }

    public static List<Boolean> booleanParser(String[] arr, List failedTermMsgList, int lineIndex) {
        ArrayList<Boolean> ret = new ArrayList<Boolean>();
        for (String s : arr) {
            try {
                ret.add(Boolean.parseBoolean(s));
            }
            catch (Exception e) {
                LOG.error("Provided value " + s + " is not of Boolean type at line #" + lineIndex);
                failedTermMsgList.add("Provided value " + s + " is not of Boolean type at line #" + lineIndex);
            }
        }
        return ret;
    }

    public static List<Double> doubleParser(String[] arr, List failedTermMsgList, int lineIndex) {
        ArrayList<Double> ret = new ArrayList<Double>();
        for (String s : arr) {
            try {
                ret.add(Double.parseDouble(s));
            }
            catch (Exception e) {
                LOG.error("Provided value " + s + " is not of Double type at line #" + lineIndex);
                failedTermMsgList.add("Provided value " + s + " is not of Double type at line #" + lineIndex);
            }
        }
        return ret;
    }

    public static List<Short> shortParser(String[] arr, List failedTermMsgList, int lineIndex) {
        ArrayList<Short> ret = new ArrayList<Short>();
        for (String s : arr) {
            try {
                ret.add(Short.parseShort(s));
            }
            catch (Exception e) {
                LOG.error("Provided value " + s + " is not of Short type at line #" + lineIndex);
                failedTermMsgList.add("Provided value " + s + " is not of Short type at line #" + lineIndex);
            }
        }
        return ret;
    }

    public static List<Long> longParser(String[] arr, List failedTermMsgList, int lineIndex) {
        ArrayList<Long> ret = new ArrayList<Long>();
        for (String s : arr) {
            try {
                ret.add(Long.parseLong(s));
            }
            catch (Exception e) {
                LOG.error("Provided value " + s + " is not of Long type at line #" + lineIndex);
                failedTermMsgList.add("Provided value " + s + " is not of Long type at line #" + lineIndex);
            }
        }
        return ret;
    }

    public static List<Integer> intParser(String[] arr, List failedTermMsgList, int lineIndex) {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        for (String s : arr) {
            try {
                ret.add(Integer.parseInt(s));
            }
            catch (Exception e) {
                LOG.error("Provided value " + s + " is not of Integer type at line #" + lineIndex);
                failedTermMsgList.add("Provided value " + s + " is Integer of Long type at line #" + lineIndex);
            }
        }
        return ret;
    }

    public static List<Float> floatParser(String[] arr, List failedTermMsgList, int lineIndex) {
        ArrayList<Float> ret = new ArrayList<Float>();
        for (String s : arr) {
            try {
                ret.add(Float.valueOf(Float.parseFloat(s)));
            }
            catch (Exception e) {
                LOG.error("Provided value " + s + " is Float of Long type at line #" + lineIndex);
                failedTermMsgList.add("Provided value " + s + " is Float of Long type at line #" + lineIndex);
            }
        }
        return ret;
    }

    public static List assignEnumValues(String bmAttributeValues, AtlasEnumType enumType, List<String> failedTermMsgList, int lineIndex) {
        String[] arr;
        ArrayList<String> ret = new ArrayList<String>();
        for (String s : arr = bmAttributeValues.split("\\|")) {
            AtlasEnumDef.AtlasEnumElementDef atlasEnumDef = enumType.getEnumElementDef(s);
            if (atlasEnumDef == null) {
                LOG.error("Provided value " + s + " is Enumeration of Long type at line #" + lineIndex);
                failedTermMsgList.add("Provided value " + s + " is Enumeration of Long type at line #" + lineIndex);
                continue;
            }
            ret.add(s);
        }
        return ret;
    }

    public static void addItemToListProperty(AtlasEdge edge, String property, String value) {
        List list = AtlasGraphUtilsV2.getListFromProperty(edge, property);
        list.add(value);
        edge.setListProperty(property, list);
    }

    public static void removeItemFromListProperty(AtlasEdge edge, String property, String value) {
        List list = AtlasGraphUtilsV2.getListFromProperty(edge, property);
        list.remove(value);
        if (CollectionUtils.isEmpty((Collection)list)) {
            edge.removeProperty(property);
        } else {
            edge.setListProperty(property, list);
        }
    }

    private static List getListFromProperty(AtlasEdge edge, String property) {
        List list = edge.getListProperty(property);
        return CollectionUtils.isEmpty((Collection)list) ? new ArrayList() : list;
    }

    static {
        try {
            Configuration conf = ApplicationProperties.get();
            USE_INDEX_QUERY_TO_FIND_ENTITY_BY_UNIQUE_ATTRIBUTES = conf.getBoolean("atlas.use.index.query.to.find.entity.by.unique.attributes", USE_INDEX_QUERY_TO_FIND_ENTITY_BY_UNIQUE_ATTRIBUTES);
            USE_UNIQUE_INDEX_PROPERTY_TO_FIND_ENTITY = conf.getBoolean("atlas.unique.index.property.to.find.entity", USE_UNIQUE_INDEX_PROPERTY_TO_FIND_ENTITY);
            INDEX_SEARCH_PREFIX = conf.getString("atlas.graph.index.search.vertex.prefix", "$v$");
        }
        catch (Exception excp) {
            LOG.error("Error reading configuration", (Throwable)excp);
        }
        finally {
            LOG.info("atlas.use.index.query.to.find.entity.by.unique.attributes=" + USE_INDEX_QUERY_TO_FIND_ENTITY_BY_UNIQUE_ATTRIBUTES);
        }
    }
}

