/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.patches;

import org.apache.atlas.AtlasConfiguration;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.patches.AtlasPatch;
import org.apache.atlas.repository.graphdb.AtlasGraph;
import org.apache.atlas.repository.patches.AtlasPatchHandler;
import org.apache.atlas.repository.patches.PatchContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateCompositeIndexStatusPatch
extends AtlasPatchHandler {
    private static final Logger LOG = LoggerFactory.getLogger(UpdateCompositeIndexStatusPatch.class);
    private static final String PATCH_ID = "JAVA_PATCH_0000_010";
    private static final String PATCH_DESCRIPTION = "updates schema status of composite indexes which are in REGISTERED to ENABLED.";
    private final PatchContext context;

    public UpdateCompositeIndexStatusPatch(PatchContext context) {
        super(context.getPatchRegistry(), PATCH_ID, PATCH_DESCRIPTION);
        this.context = context;
    }

    @Override
    public void apply() throws AtlasBaseException {
        if (!AtlasConfiguration.UPDATE_COMPOSITE_INDEX_STATUS.getBoolean()) {
            LOG.info("UpdateCompositeIndexStatusPatch: Skipped, since not enabled!");
            return;
        }
        AtlasGraph graph = this.context.getGraph();
        try {
            LOG.info("UpdateCompositeIndexStatusPatch: Starting...");
            graph.getManagementSystem().updateSchemaStatus();
        }
        finally {
            LOG.info("UpdateCompositeIndexStatusPatch: Done!");
        }
        this.setStatus(AtlasPatch.PatchStatus.UNKNOWN);
        LOG.info("UpdateCompositeIndexStatusPatch.apply(): patchId={}, status={}", (Object)this.getPatchId(), (Object)this.getStatus());
    }
}

