/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.patches;

import java.util.Collections;
import java.util.Set;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.patches.AtlasPatch;
import org.apache.atlas.pc.WorkItemManager;
import org.apache.atlas.repository.Constants;
import org.apache.atlas.repository.graphdb.AtlasGraph;
import org.apache.atlas.repository.graphdb.AtlasVertex;
import org.apache.atlas.repository.patches.AtlasPatchHandler;
import org.apache.atlas.repository.patches.ConcurrentPatchProcessor;
import org.apache.atlas.repository.patches.PatchContext;
import org.apache.atlas.repository.store.graph.v2.AtlasGraphUtilsV2;
import org.apache.atlas.type.AtlasEntityType;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SuperTypesUpdatePatch
extends AtlasPatchHandler {
    private static final Logger LOG = LoggerFactory.getLogger(SuperTypesUpdatePatch.class);
    private static final String PATCH_ID = "JAVA_PATCH_0000_007";
    private static final String PATCH_DESCRIPTION = "Update supertypes for all existing entities for given typeName";
    private final PatchContext context;
    private final String typeName;

    public SuperTypesUpdatePatch(PatchContext context, String typeDefPatchId, String typeName) {
        super(context.getPatchRegistry(), "JAVA_PATCH_0000_007_" + typeDefPatchId, PATCH_DESCRIPTION);
        this.context = context;
        this.typeName = typeName;
    }

    @Override
    public void apply() throws AtlasBaseException {
        LOG.info("==> SuperTypesUpdatePatch.apply(): patchId={}", (Object)this.getPatchId());
        SuperTypesUpdatePatchProcessor patchProcessor = new SuperTypesUpdatePatchProcessor(this.context, this.typeName);
        patchProcessor.apply();
        this.setStatus(AtlasPatch.PatchStatus.APPLIED);
        LOG.info("<== SuperTypesUpdatePatch.apply(): patchId={}, status={}", (Object)this.getPatchId(), (Object)this.getStatus());
    }

    public static class SuperTypesUpdatePatchProcessor
    extends ConcurrentPatchProcessor {
        private final String typeName;
        private final Set<String> typeAndAllSubTypes;

        public SuperTypesUpdatePatchProcessor(PatchContext context, String typeName) {
            super(context);
            AtlasEntityType entityType = this.getTypeRegistry().getEntityTypeByName(typeName);
            this.typeName = typeName;
            this.typeAndAllSubTypes = entityType != null ? entityType.getTypeAndAllSubTypes() : Collections.emptySet();
        }

        @Override
        public void submitVerticesToUpdate(WorkItemManager manager) {
            if (CollectionUtils.isNotEmpty(this.typeAndAllSubTypes)) {
                LOG.info("Entity types to be updated with supertypes :{}", (Object)this.typeAndAllSubTypes.size());
                for (String typeName : this.typeAndAllSubTypes) {
                    LOG.info("finding entities of type {}", (Object)typeName);
                    AtlasGraph graph = this.getGraph();
                    Iterable vertexIds = graph.query().has(Constants.ENTITY_TYPE_PROPERTY_KEY, (Object)typeName).vertexIds();
                    int count = 0;
                    for (Object vertexId : vertexIds) {
                        manager.checkProduce(vertexId);
                        ++count;
                    }
                    LOG.info("found {} entities of type {}", (Object)count, (Object)typeName);
                }
            }
        }

        @Override
        protected void processVertexItem(Long vertexId, AtlasVertex vertex, String typeName, AtlasEntityType entityType) {
            Set allSuperTypes;
            if (LOG.isDebugEnabled()) {
                LOG.debug("processVertexItem(typeName={}, vertexId={})", (Object)typeName, (Object)vertexId);
            }
            if ((allSuperTypes = entityType.getAllSuperTypes()) != null) {
                vertex.removeProperty(Constants.SUPER_TYPES_PROPERTY_KEY);
                for (String superType : allSuperTypes) {
                    AtlasGraphUtilsV2.addEncodedProperty(vertex, Constants.SUPER_TYPES_PROPERTY_KEY, (Object)superType);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Updated superTypes for entity of typeName={}, vertexId={}): Done!", (Object)typeName, vertex.getId());
                }
            }
        }

        @Override
        protected void prepareForExecution() {
        }
    }
}

