/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.patches;

import org.apache.atlas.AtlasConfiguration;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.patches.AtlasPatch;
import org.apache.atlas.pc.WorkItemManager;
import org.apache.atlas.repository.Constants;
import org.apache.atlas.repository.graphdb.AtlasEdge;
import org.apache.atlas.repository.graphdb.AtlasGraph;
import org.apache.atlas.repository.patches.AtlasPatchHandler;
import org.apache.atlas.repository.patches.EdgePatchProcessor;
import org.apache.atlas.repository.patches.PatchContext;
import org.apache.atlas.type.AtlasRelationshipType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RelationshipTypeNamePatch
extends AtlasPatchHandler {
    private static final Logger LOG = LoggerFactory.getLogger(RelationshipTypeNamePatch.class);
    private static final String PATCH_ID = "JAVA_PATCH_0000_0011";
    private static final String PATCH_DESCRIPTION = "Populates Relationship typeName as like of Entity TypeName for all Edges.";
    private final PatchContext context;

    public RelationshipTypeNamePatch(PatchContext context) {
        super(context.getPatchRegistry(), PATCH_ID, PATCH_DESCRIPTION);
        this.context = context;
    }

    @Override
    public void apply() throws AtlasBaseException {
        if (!AtlasConfiguration.RELATIONSHIP_SEARCH_ENABLED.getBoolean()) {
            LOG.info("RelationshipTypeNamePatch: Skipped, since not enabled!");
            return;
        }
        LOG.info("RelationshipTypeNamePatch: Starting...");
        RelationshipTypeNamePatchProcessor patchProcessor = new RelationshipTypeNamePatchProcessor(this.context);
        patchProcessor.apply();
        this.setStatus(AtlasPatch.PatchStatus.APPLIED);
        LOG.info("EdgePatchProcessor.apply(): patchId={}, status={}", (Object)this.getPatchId(), (Object)this.getStatus());
    }

    public static class RelationshipTypeNamePatchProcessor
    extends EdgePatchProcessor {
        public RelationshipTypeNamePatchProcessor(PatchContext context) {
            super(context);
        }

        @Override
        protected void prepareForExecution() {
        }

        @Override
        protected void submitEdgesToUpdate(WorkItemManager manager) {
            AtlasGraph graph = this.getGraph();
            Iterable iterable = graph.getEdges();
            int count = 0;
            for (AtlasEdge edge : iterable) {
                if (edge.getProperty(Constants.ENTITY_TYPE_PROPERTY_KEY, String.class) == null) continue;
                String edgeId = edge.getId().toString();
                manager.checkProduce((Object)edgeId);
                ++count;
            }
            LOG.info("found {} edges with typeName != null", (Object)count);
        }

        @Override
        protected void processEdgesItem(String edgeId, AtlasEdge edge, String typeName, AtlasRelationshipType type) {
            edge.setProperty(Constants.RELATIONSHIP_TYPE_PROPERTY_KEY, (Object)typeName);
            if (LOG.isDebugEnabled()) {
                LOG.debug("processItem(typeName={}, edgeId={}): Done!", (Object)typeName, (Object)edgeId);
            }
        }
    }
}

