/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.patches;

import org.apache.atlas.AtlasConfiguration;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.patches.AtlasPatch;
import org.apache.atlas.pc.WorkItemManager;
import org.apache.atlas.repository.Constants;
import org.apache.atlas.repository.graphdb.AtlasGraph;
import org.apache.atlas.repository.graphdb.AtlasVertex;
import org.apache.atlas.repository.patches.AtlasPatchHandler;
import org.apache.atlas.repository.patches.ConcurrentPatchProcessor;
import org.apache.atlas.repository.patches.PatchContext;
import org.apache.atlas.repository.store.graph.v2.AtlasGraphUtilsV2;
import org.apache.atlas.type.AtlasEntityType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessImpalaNamePatch
extends AtlasPatchHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ProcessImpalaNamePatch.class);
    private static final String PATCH_ID = "JAVA_PATCH_0000_012";
    private static final String PATCH_DESCRIPTION = "Set name to qualifiedName";
    private final PatchContext context;

    public ProcessImpalaNamePatch(PatchContext context) {
        super(context.getPatchRegistry(), PATCH_ID, PATCH_DESCRIPTION);
        this.context = context;
    }

    @Override
    public void apply() throws AtlasBaseException {
        if (!AtlasConfiguration.PROCESS_IMPALA_NAME_UPDATE_PATCH.getBoolean()) {
            LOG.info("ProcessImpalaNamePatch: Skipped, since not enabled!");
            return;
        }
        ProcessImpalaNamePatchProcessor patchProcessor = new ProcessImpalaNamePatchProcessor(this.context);
        patchProcessor.apply();
        this.setStatus(AtlasPatch.PatchStatus.APPLIED);
        LOG.info("ProcessImpalaNamePatch.apply(): patchId={}, status={}", (Object)this.getPatchId(), (Object)this.getStatus());
    }

    public static class ProcessImpalaNamePatchProcessor
    extends ConcurrentPatchProcessor {
        private static final String TYPE_NAME_IMPALA_PROCESS = "impala_process";
        private static final String TYPE_NAME_IMPALA_PROCESS_EXECUTION = "impala_process_execution";
        private static final String ATTR_NAME_QUALIFIED_NAME = "qualifiedName";
        private static final String ATTR_NAME_NAME = "name";
        private static final String[] processTypes = new String[]{"impala_process", "impala_process_execution"};

        public ProcessImpalaNamePatchProcessor(PatchContext context) {
            super(context);
        }

        @Override
        protected void prepareForExecution() {
        }

        @Override
        public void submitVerticesToUpdate(WorkItemManager manager) {
            AtlasGraph graph = this.getGraph();
            for (String typeName : processTypes) {
                LOG.info("finding entities of type {}", (Object)typeName);
                Iterable iterable = graph.query().has(Constants.ENTITY_TYPE_PROPERTY_KEY, (Object)typeName).vertexIds();
                int count = 0;
                for (Object vertexId : iterable) {
                    manager.checkProduce(vertexId);
                    ++count;
                }
                LOG.info("found {} entities of type {}", (Object)count, (Object)typeName);
            }
        }

        @Override
        protected void processVertexItem(Long vertexId, AtlasVertex vertex, String typeName, AtlasEntityType entityType) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("processItem(typeName={}, vertexId={})", (Object)typeName, (Object)vertexId);
            }
            try {
                String qualifiedName = AtlasGraphUtilsV2.getProperty(vertex, entityType.getVertexPropertyName(ATTR_NAME_QUALIFIED_NAME), String.class);
                AtlasGraphUtilsV2.setEncodedProperty(vertex, entityType.getVertexPropertyName(ATTR_NAME_NAME), qualifiedName);
            }
            catch (AtlasBaseException e) {
                LOG.error("Error updating: {}", (Object)vertexId);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("processItem(typeName={}, vertexId={}): Done!", (Object)typeName, (Object)vertexId);
            }
        }
    }
}

