/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.patches;

import org.apache.atlas.repository.graph.GraphBackedSearchIndexer;
import org.apache.atlas.repository.graphdb.AtlasGraph;
import org.apache.atlas.repository.patches.AtlasPatchRegistry;
import org.apache.atlas.repository.store.graph.v2.EntityGraphMapper;
import org.apache.atlas.type.AtlasTypeRegistry;

public class PatchContext {
    private final AtlasGraph graph;
    private final AtlasTypeRegistry typeRegistry;
    private final GraphBackedSearchIndexer indexer;
    private final AtlasPatchRegistry patchRegistry;
    private final EntityGraphMapper entityGraphMapper;

    public PatchContext(AtlasGraph graph, AtlasTypeRegistry typeRegistry, GraphBackedSearchIndexer indexer, EntityGraphMapper entityGraphMapper) {
        this.graph = graph;
        this.typeRegistry = typeRegistry;
        this.indexer = indexer;
        this.patchRegistry = new AtlasPatchRegistry(this.graph);
        this.entityGraphMapper = entityGraphMapper;
    }

    public AtlasGraph getGraph() {
        return this.graph;
    }

    public AtlasTypeRegistry getTypeRegistry() {
        return this.typeRegistry;
    }

    public GraphBackedSearchIndexer getIndexer() {
        return this.indexer;
    }

    public AtlasPatchRegistry getPatchRegistry() {
        return this.patchRegistry;
    }

    public EntityGraphMapper getEntityGraphMapper() {
        return this.entityGraphMapper;
    }
}

