/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.patches;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.atlas.ApplicationProperties;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.pc.WorkItemBuilder;
import org.apache.atlas.pc.WorkItemConsumer;
import org.apache.atlas.pc.WorkItemManager;
import org.apache.atlas.repository.graph.GraphBackedSearchIndexer;
import org.apache.atlas.repository.graphdb.AtlasElement;
import org.apache.atlas.repository.graphdb.AtlasGraph;
import org.apache.atlas.repository.graphdb.AtlasVertex;
import org.apache.atlas.repository.patches.PatchContext;
import org.apache.atlas.repository.store.graph.v2.AtlasGraphUtilsV2;
import org.apache.atlas.repository.store.graph.v2.EntityGraphMapper;
import org.apache.atlas.type.AtlasEntityType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.commons.configuration.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ConcurrentPatchProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(ConcurrentPatchProcessor.class);
    private static final String NUM_WORKERS_PROPERTY = "atlas.patch.numWorkers";
    private static final String BATCH_SIZE_PROPERTY = "atlas.patch.batchSize";
    private static final String ATLAS_SOLR_SHARDS = "ATLAS_SOLR_SHARDS";
    private static final String WORKER_NAME_PREFIX = "patchWorkItem";
    public static final int NUM_WORKERS;
    public static final int BATCH_SIZE;
    private final EntityGraphMapper entityGraphMapper;
    private final AtlasGraph graph;
    private final GraphBackedSearchIndexer indexer;
    private final AtlasTypeRegistry typeRegistry;

    public ConcurrentPatchProcessor(PatchContext context) {
        this.graph = context.getGraph();
        this.indexer = context.getIndexer();
        this.typeRegistry = context.getTypeRegistry();
        this.entityGraphMapper = context.getEntityGraphMapper();
    }

    public EntityGraphMapper getEntityGraphMapper() {
        return this.entityGraphMapper;
    }

    public AtlasGraph getGraph() {
        return this.graph;
    }

    public GraphBackedSearchIndexer getIndexer() {
        return this.indexer;
    }

    public AtlasTypeRegistry getTypeRegistry() {
        return this.typeRegistry;
    }

    public void apply() throws AtlasBaseException {
        this.prepareForExecution();
        this.execute();
    }

    protected abstract void prepareForExecution() throws AtlasBaseException;

    protected abstract void submitVerticesToUpdate(WorkItemManager var1);

    protected abstract void processVertexItem(Long var1, AtlasVertex var2, String var3, AtlasEntityType var4) throws AtlasBaseException;

    private void execute() {
        WorkItemManager manager = new WorkItemManager((WorkItemBuilder)new ConsumerBuilder(this.graph, this.typeRegistry, this), WORKER_NAME_PREFIX, BATCH_SIZE, NUM_WORKERS, false);
        try {
            this.submitVerticesToUpdate(manager);
            manager.drain();
        }
        finally {
            try {
                manager.shutdown();
            }
            catch (InterruptedException e) {
                LOG.error("ConcurrentPatchProcessor.execute(): interrupted during WorkItemManager shutdown.", (Throwable)e);
            }
        }
    }

    static {
        int numWorkers = 3;
        int batchSize = 300;
        try {
            Configuration config = ApplicationProperties.get();
            numWorkers = config.getInt(NUM_WORKERS_PROPERTY, config.getInt(ATLAS_SOLR_SHARDS, 1) * 3);
            batchSize = config.getInt(BATCH_SIZE_PROPERTY, 300);
            LOG.info("ConcurrentPatchProcessor: {}={}, {}={}", new Object[]{NUM_WORKERS_PROPERTY, numWorkers, BATCH_SIZE_PROPERTY, batchSize});
        }
        catch (Exception e) {
            LOG.error("Error retrieving configuration.", (Throwable)e);
        }
        NUM_WORKERS = numWorkers;
        BATCH_SIZE = batchSize;
    }

    private static class ConsumerBuilder
    implements WorkItemBuilder<Consumer, Long> {
        private final AtlasTypeRegistry typeRegistry;
        private final AtlasGraph graph;
        private final ConcurrentPatchProcessor patchItemProcessor;

        public ConsumerBuilder(AtlasGraph graph, AtlasTypeRegistry typeRegistry, ConcurrentPatchProcessor patchItemProcessor) {
            this.graph = graph;
            this.typeRegistry = typeRegistry;
            this.patchItemProcessor = patchItemProcessor;
        }

        public Consumer build(BlockingQueue<Long> queue) {
            return new Consumer(this.graph, this.typeRegistry, queue, this.patchItemProcessor);
        }
    }

    private static class Consumer
    extends WorkItemConsumer<Long> {
        private int MAX_COMMIT_RETRY_COUNT = 3;
        private final AtlasGraph graph;
        private final AtlasTypeRegistry typeRegistry;
        private final AtomicLong counter;
        private final ConcurrentPatchProcessor individualItemProcessor;

        public Consumer(AtlasGraph graph, AtlasTypeRegistry typeRegistry, BlockingQueue<Long> queue, ConcurrentPatchProcessor individualItemProcessor) {
            super(queue);
            this.graph = graph;
            this.typeRegistry = typeRegistry;
            this.counter = new AtomicLong(0L);
            this.individualItemProcessor = individualItemProcessor;
        }

        protected void doCommit() {
            if (this.counter.get() % (long)BATCH_SIZE == 0L) {
                LOG.info("Processed: {}", (Object)this.counter.get());
                this.attemptCommit();
            }
        }

        protected void commitDirty() {
            this.attemptCommit();
            LOG.info("Total: Commit: {}", (Object)this.counter.get());
            super.commitDirty();
        }

        private void attemptCommit() {
            for (int retryCount = 1; retryCount <= this.MAX_COMMIT_RETRY_COUNT; ++retryCount) {
                try {
                    this.graph.commit();
                    break;
                }
                catch (Exception ex) {
                    LOG.error("Commit exception: ", (Object)retryCount, (Object)ex);
                    try {
                        Thread.currentThread();
                        Thread.sleep(300 * retryCount);
                    }
                    catch (InterruptedException e) {
                        LOG.error("Commit exception: Pause: Interrputed!", (Throwable)e);
                    }
                    continue;
                }
            }
        }

        protected void processItem(Long vertexId) {
            this.counter.incrementAndGet();
            AtlasVertex vertex = this.graph.getVertex(Long.toString(vertexId));
            if (vertex == null) {
                LOG.warn("processItem(vertexId={}): AtlasVertex not found!", (Object)vertexId);
                return;
            }
            if (AtlasGraphUtilsV2.isTypeVertex(vertex)) {
                return;
            }
            String typeName = AtlasGraphUtilsV2.getTypeName((AtlasElement)vertex);
            AtlasEntityType entityType = this.typeRegistry.getEntityTypeByName(typeName);
            if (entityType == null) {
                return;
            }
            try {
                this.individualItemProcessor.processVertexItem(vertexId, vertex, typeName, entityType);
                this.doCommit();
            }
            catch (AtlasBaseException e) {
                LOG.error("Error processing: {}", (Object)vertexId, (Object)e);
            }
        }
    }
}

