/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.ogm.metrics;

import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.metrics.AtlasMetrics;
import org.apache.atlas.model.metrics.AtlasMetricsStat;
import org.apache.atlas.repository.impexp.AuditsWriter;
import org.apache.atlas.repository.ogm.AbstractDataTransferObject;
import org.apache.atlas.type.AtlasType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AtlasMetricsStatDTO
extends AbstractDataTransferObject<AtlasMetricsStat> {
    private static final Logger LOG = LoggerFactory.getLogger(AtlasMetricsStatDTO.class);
    public static final String METRICS_ENTITY_TYPE_NAME = "__AtlasMetricsStat";
    public static final String METRICS_ID_PROPERTY = "metricsId";
    private static final String METRICS_PROPERTY = "metrics";
    private static final String COLLECTION_TIME_PROPERTY = "collectionTime";
    private static final String TIME_TO_LIVE_PROPERTY = "timeToLiveMillis";
    private static final String UNIQUE_NAME_PROPERTY = "uniqueName";

    @Inject
    public AtlasMetricsStatDTO(AtlasTypeRegistry typeRegistry) {
        super(typeRegistry, AtlasMetricsStat.class, METRICS_ENTITY_TYPE_NAME);
    }

    @Override
    public AtlasMetricsStat from(AtlasEntity entity) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> AtlasMetricsStatDTO.from({})", (Object)entity);
        }
        AtlasMetricsStat metricsStat = null;
        String jsonMetrics = (String)entity.getAttribute(METRICS_PROPERTY);
        if (StringUtils.isNotEmpty((String)jsonMetrics)) {
            metricsStat = new AtlasMetricsStat((AtlasMetrics)AtlasType.fromJson((String)jsonMetrics, AtlasMetrics.class));
        }
        if (metricsStat == null) {
            LOG.error("MetricStat cannot be created without metric info. Null has been returned.");
        } else {
            metricsStat.setGuid(entity.getGuid());
            metricsStat.setMetricsId((String)entity.getAttribute(METRICS_ID_PROPERTY));
            metricsStat.setCollectionTime(((Long)entity.getAttribute(COLLECTION_TIME_PROPERTY)).longValue());
            metricsStat.setTimeToLiveMillis(((Long)entity.getAttribute(TIME_TO_LIVE_PROPERTY)).longValue());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== AtlasMetricsStatDTO.from() : {}", (Object)metricsStat);
        }
        return metricsStat;
    }

    @Override
    public AtlasMetricsStat from(AtlasEntity.AtlasEntityWithExtInfo entityWithExtInfo) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> AtlasMetricsStatDTO.from({})", (Object)entityWithExtInfo);
        }
        AtlasMetricsStat ret = this.from(entityWithExtInfo.getEntity());
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== AtlasMetricsStatDTO.from() : {}", (Object)ret);
        }
        return ret;
    }

    @Override
    public AtlasEntity toEntity(AtlasMetricsStat obj) throws AtlasBaseException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> AtlasMetricsStatDTO.toEntity({})", (Object)obj);
        }
        AtlasEntity entity = this.getDefaultAtlasEntity(obj);
        entity.setAttribute(METRICS_ID_PROPERTY, (Object)this.getUniqueValue(obj));
        if (obj.getMetrics() != null) {
            entity.setAttribute(METRICS_PROPERTY, (Object)AtlasType.toJson((Object)obj.getMetrics()));
        }
        entity.setAttribute(COLLECTION_TIME_PROPERTY, (Object)obj.getCollectionTime());
        entity.setAttribute(TIME_TO_LIVE_PROPERTY, (Object)obj.getTimeToLiveMillis());
        entity.setAttribute(UNIQUE_NAME_PROPERTY, (Object)this.getUniqueValue(obj));
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== AtlasMetricsStatDTO.toEntity() : {}", (Object)entity);
        }
        return entity;
    }

    @Override
    public AtlasEntity.AtlasEntityWithExtInfo toEntityWithExtInfo(AtlasMetricsStat obj) throws AtlasBaseException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> AtlasMetricsStatDTO.toEntityWithExtInfo({})", (Object)obj);
        }
        AtlasEntity.AtlasEntityWithExtInfo ret = new AtlasEntity.AtlasEntityWithExtInfo(this.toEntity(obj));
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== AtlasMetricsStatDTO.toEntityWithExtInfo() : {}", (Object)ret);
        }
        return ret;
    }

    @Override
    public Map<String, Object> getUniqueAttributes(AtlasMetricsStat obj) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ret.put(METRICS_ID_PROPERTY, this.getUniqueValue(obj));
        return ret;
    }

    private String getUniqueValue(AtlasMetricsStat obj) {
        return "atlas_metrics_" + obj.getCollectionTime() + "@" + AuditsWriter.getCurrentClusterName();
    }
}

