/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.ogm.glossary;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.glossary.AtlasGlossary;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.AtlasRelatedObjectId;
import org.apache.atlas.repository.ogm.glossary.AbstractGlossaryDTO;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AtlasGlossaryDTO
extends AbstractGlossaryDTO<AtlasGlossary> {
    private static final Logger LOG = LoggerFactory.getLogger(AtlasGlossaryDTO.class);

    @Inject
    public AtlasGlossaryDTO(AtlasTypeRegistry typeRegistry) {
        super(typeRegistry, AtlasGlossary.class);
    }

    @Override
    public AtlasGlossary from(AtlasEntity entity) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> AtlasGlossaryDTO.from()", (Object)entity);
        }
        Objects.requireNonNull(entity, "entity");
        AtlasGlossary ret = new AtlasGlossary();
        ret.setGuid(entity.getGuid());
        ret.setQualifiedName((String)entity.getAttribute("qualifiedName"));
        ret.setName((String)entity.getAttribute("name"));
        ret.setShortDescription((String)entity.getAttribute("shortDescription"));
        ret.setLongDescription((String)entity.getAttribute("longDescription"));
        ret.setLanguage((String)entity.getAttribute("language"));
        ret.setUsage((String)entity.getAttribute("usage"));
        ret.setAdditionalAttributes((Map)entity.getAttribute("additionalAttributes"));
        Object categoriesAttr = entity.getRelationshipAttribute("categories");
        Object termsAttr = entity.getRelationshipAttribute("terms");
        if (Objects.nonNull(categoriesAttr)) {
            LOG.debug("Processing categories");
            if (categoriesAttr instanceof Collection) {
                for (Object o : (Collection)categoriesAttr) {
                    if (!(o instanceof AtlasRelatedObjectId)) continue;
                    ret.addCategory(this.constructRelatedCategoryId((AtlasRelatedObjectId)o));
                }
            }
        }
        if (Objects.nonNull(termsAttr)) {
            LOG.debug("Processing terms");
            if (termsAttr instanceof Collection) {
                for (Object o : (Collection)termsAttr) {
                    if (!(o instanceof AtlasRelatedObjectId)) continue;
                    ret.addTerm(this.constructRelatedTermId((AtlasRelatedObjectId)o));
                }
            }
        }
        return ret;
    }

    @Override
    public AtlasGlossary from(AtlasEntity.AtlasEntityWithExtInfo entityWithExtInfo) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> AtlasGlossaryDTO.from()", (Object)entityWithExtInfo);
        }
        Objects.requireNonNull(entityWithExtInfo, "entity");
        AtlasGlossary ret = this.from(entityWithExtInfo.getEntity());
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== AtlasGlossaryDTO.from() : {}", (Object)ret);
        }
        return ret;
    }

    @Override
    public AtlasEntity toEntity(AtlasGlossary obj) throws AtlasBaseException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> AtlasGlossaryDTO.toEntity()", (Object)obj);
        }
        Objects.requireNonNull(obj, "atlasGlossary");
        Objects.requireNonNull(obj.getQualifiedName(), "atlasGlossary qualifiedName must be specified");
        AtlasEntity ret = this.getDefaultAtlasEntity(obj);
        ret.setAttribute("qualifiedName", (Object)obj.getQualifiedName());
        ret.setAttribute("name", (Object)obj.getName());
        ret.setAttribute("shortDescription", (Object)obj.getShortDescription());
        ret.setAttribute("longDescription", (Object)obj.getLongDescription());
        ret.setAttribute("language", (Object)obj.getLanguage());
        ret.setAttribute("usage", (Object)obj.getUsage());
        ret.setAttribute("additionalAttributes", (Object)obj.getAdditionalAttributes());
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== AtlasGlossaryDTO.toEntity() : {}", (Object)ret);
        }
        return ret;
    }

    @Override
    public AtlasEntity.AtlasEntityWithExtInfo toEntityWithExtInfo(AtlasGlossary obj) throws AtlasBaseException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> AtlasGlossaryDTO.toEntityWithExtInfo()", (Object)obj);
        }
        Objects.requireNonNull(obj, "atlasGlossary");
        AtlasEntity entity = this.toEntity(obj);
        AtlasEntity.AtlasEntityWithExtInfo ret = new AtlasEntity.AtlasEntityWithExtInfo(entity);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== AtlasGlossaryDTO.toEntityWithExtInfo() : {}", (Object)ret);
        }
        return ret;
    }

    @Override
    public Map<String, Object> getUniqueAttributes(AtlasGlossary obj) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ret.put("qualifiedName", obj.getQualifiedName());
        return ret;
    }
}

