/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.ogm;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.impexp.ExportImportAuditEntry;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.repository.ogm.AbstractDataTransferObject;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.springframework.stereotype.Component;

@Component
public class ExportImportAuditEntryDTO
extends AbstractDataTransferObject<ExportImportAuditEntry> {
    public static final String PROPERTY_USER_NAME = "userName";
    public static final String PROPERTY_OPERATION = "operation";
    public static final String PROPERTY_OPERATION_PARAMS = "operationParams";
    public static final String PROPERTY_START_TIME = "operationStartTime";
    public static final String PROPERTY_END_TIME = "operationEndTime";
    public static final String PROPERTY_RESULT_SUMMARY = "resultSummary";
    public static final String PROPERTY_SOURCE_SERVER_NAME = "sourceServerName";
    public static final String PROPERTY_TARGET_SERVER_NAME = "targetServerName";
    private static final Set<String> ATTRIBUTE_NAMES = new HashSet<String>(Arrays.asList("userName", "operation", "operationParams", "operationStartTime", "operationEndTime", "resultSummary", "sourceServerName", "targetServerName"));

    @Inject
    public ExportImportAuditEntryDTO(AtlasTypeRegistry typeRegistry) {
        super(typeRegistry, ExportImportAuditEntry.class, "__" + ExportImportAuditEntry.class.getSimpleName());
    }

    public static Set<String> getAttributes() {
        return ATTRIBUTE_NAMES;
    }

    public static ExportImportAuditEntry from(String guid, Map<String, Object> attributes) {
        ExportImportAuditEntry entry = new ExportImportAuditEntry();
        entry.setGuid(guid);
        entry.setUserName((String)attributes.get(PROPERTY_USER_NAME));
        entry.setOperation((String)attributes.get(PROPERTY_OPERATION));
        entry.setOperationParams((String)attributes.get(PROPERTY_OPERATION_PARAMS));
        entry.setStartTime(((Long)attributes.get(PROPERTY_START_TIME)).longValue());
        entry.setEndTime(((Long)attributes.get(PROPERTY_END_TIME)).longValue());
        entry.setSourceServerName((String)attributes.get(PROPERTY_SOURCE_SERVER_NAME));
        entry.setTargetServerName((String)attributes.get(PROPERTY_TARGET_SERVER_NAME));
        entry.setResultSummary((String)attributes.get(PROPERTY_RESULT_SUMMARY));
        return entry;
    }

    @Override
    public ExportImportAuditEntry from(AtlasEntity entity) {
        return ExportImportAuditEntryDTO.from(entity.getGuid(), entity.getAttributes());
    }

    @Override
    public ExportImportAuditEntry from(AtlasEntity.AtlasEntityWithExtInfo entityWithExtInfo) {
        return this.from(entityWithExtInfo.getEntity());
    }

    @Override
    public AtlasEntity toEntity(ExportImportAuditEntry obj) {
        AtlasEntity entity = this.getDefaultAtlasEntity(obj);
        entity.setAttribute(PROPERTY_USER_NAME, (Object)obj.getUserName());
        entity.setAttribute(PROPERTY_OPERATION, (Object)obj.getOperation());
        entity.setAttribute(PROPERTY_OPERATION_PARAMS, (Object)obj.getOperationParams());
        entity.setAttribute(PROPERTY_START_TIME, (Object)obj.getStartTime());
        entity.setAttribute(PROPERTY_END_TIME, (Object)obj.getEndTime());
        entity.setAttribute(PROPERTY_SOURCE_SERVER_NAME, (Object)obj.getSourceServerName());
        entity.setAttribute(PROPERTY_TARGET_SERVER_NAME, (Object)obj.getTargetServerName());
        entity.setAttribute(PROPERTY_RESULT_SUMMARY, (Object)obj.getResultSummary());
        return entity;
    }

    @Override
    public AtlasEntity.AtlasEntityWithExtInfo toEntityWithExtInfo(ExportImportAuditEntry obj) throws AtlasBaseException {
        return new AtlasEntity.AtlasEntityWithExtInfo(this.toEntity(obj));
    }

    @Override
    public Map<String, Object> getUniqueAttributes(ExportImportAuditEntry obj) {
        return null;
    }
}

