/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.ogm;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.apache.atlas.model.impexp.AtlasServer;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.repository.ogm.AbstractDataTransferObject;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.springframework.stereotype.Component;

@Component
public class AtlasServerDTO
extends AbstractDataTransferObject<AtlasServer> {
    private final String PROPERTY_NAME = "name";
    private final String PROPERTY_DISPLAY_NAME = "displayName";
    private final String PROPERTY_FULL_NAME = "fullName";
    private final String PROPERTY_ADDITIONAL_INFO = "additionalInfo";
    private final String PROPERTY_URLS = "urls";

    @Inject
    public AtlasServerDTO(AtlasTypeRegistry typeRegistry) {
        super(typeRegistry, AtlasServer.class, AtlasServer.class.getSimpleName());
    }

    @Override
    public AtlasServer from(AtlasEntity entity) {
        AtlasServer cluster = new AtlasServer();
        this.setGuid(cluster, entity);
        cluster.setName((String)entity.getAttribute("name"));
        cluster.setFullName((String)entity.getAttribute("fullName"));
        cluster.setDisplayName((String)entity.getAttribute("displayName"));
        cluster.setAdditionalInfo((Map)entity.getAttribute("additionalInfo"));
        cluster.setUrls((List)entity.getAttribute("urls"));
        return cluster;
    }

    @Override
    public AtlasServer from(AtlasEntity.AtlasEntityWithExtInfo entityWithExtInfo) {
        return this.from(entityWithExtInfo.getEntity());
    }

    @Override
    public AtlasEntity toEntity(AtlasServer obj) {
        AtlasEntity entity = this.getDefaultAtlasEntity(obj);
        entity.setAttribute("name", (Object)obj.getName());
        entity.setAttribute("displayName", (Object)obj.getDisplayName());
        entity.setAttribute("fullName", (Object)obj.getFullName());
        entity.setAttribute("additionalInfo", (Object)obj.getAdditionalInfo());
        entity.setAttribute("urls", (Object)obj.getUrls());
        return entity;
    }

    @Override
    public AtlasEntity.AtlasEntityWithExtInfo toEntityWithExtInfo(AtlasServer obj) {
        return new AtlasEntity.AtlasEntityWithExtInfo(this.toEntity(obj));
    }

    @Override
    public Map<String, Object> getUniqueAttributes(final AtlasServer obj) {
        return new HashMap<String, Object>(){
            {
                this.put("fullName", obj.getFullName());
            }
        };
    }
}

