/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.migration;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileWatcher {
    private static final Logger LOG = LoggerFactory.getLogger(FileWatcher.class);
    private static final int MAX_TIMES_PAUSE = 10;
    private static final int PAUSE_INTERVAL = 5000;
    private int checkIncrement = 1;
    private final File fileToWatch;

    public FileWatcher(String filePath) {
        this.fileToWatch = new File(filePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws IOException {
        if (this.existsAndReadyCheck()) {
            return;
        }
        WatchService watcher = FileSystems.getDefault().newWatchService();
        Path pathToWatch = FileSystems.getDefault().getPath(this.fileToWatch.getParent(), new String[0]);
        this.register(watcher, pathToWatch);
        try {
            LOG.info(String.format("Migration File Watcher: Watching: %s", this.fileToWatch.toString()));
            this.startWatching(watcher);
        }
        catch (InterruptedException ex) {
            LOG.error("Migration File Watcher: Interrupted!");
        }
        finally {
            watcher.close();
        }
    }

    private void startWatching(WatchService watcher) throws InterruptedException {
        while (true) {
            WatchKey watchKey;
            if ((watchKey = watcher.take()) == null) {
                continue;
            }
            for (WatchEvent<?> event : watchKey.pollEvents()) {
                if (!this.checkIfFileAvailableAndReady(event)) continue;
                return;
            }
            watchKey.reset();
        }
    }

    private void register(WatchService watcher, Path path) throws IOException {
        try {
            path.register(watcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY);
        }
        catch (IOException e) {
            LOG.error("Migration File Watcher: Error while registering event {}!", (Object)path);
            throw e;
        }
    }

    private boolean checkIfFileAvailableAndReady(WatchEvent event) {
        WatchEvent watchEvent = event;
        Path path = (Path)watchEvent.context();
        if (!path.toString().equals(this.fileToWatch.getName())) {
            return false;
        }
        return this.existsAndReadyCheck();
    }

    private boolean existsAndReadyCheck() {
        boolean ret;
        boolean bl = ret = this.fileToWatch.exists() && this.fileToWatch.canRead();
        if (ret) {
            try {
                return this.isReadyForUse(this.fileToWatch);
            }
            catch (InterruptedException e) {
                LOG.error("Migration File Watcher: Interrupted {}!", (Object)this.fileToWatch);
                return false;
            }
        }
        LOG.info(String.format("Migration File Watcher: File does not exist!: %s", this.fileToWatch.getAbsolutePath()));
        return ret;
    }

    private boolean isReadyForUse(File file) throws InterruptedException {
        Long fileSizeBefore = file.length();
        Thread.sleep(this.getCheckInterval());
        Long fileSizeAfter = file.length();
        boolean ret = fileSizeBefore.equals(fileSizeAfter);
        if (ret) {
            LOG.info(String.format("Migration File Watcher: %s: File is ready for use!", file.getAbsolutePath()));
        } else {
            this.incrementCheckCounter();
            LOG.info(String.format("Migration File Watcher: File is being written: Pause: %,d secs: New size: %,d.", this.getCheckInterval() / 1000, fileSizeAfter));
        }
        return ret;
    }

    private int getCheckInterval() {
        return 5000 * this.checkIncrement;
    }

    private int incrementCheckCounter() {
        if (this.checkIncrement > 10) {
            this.checkIncrement = 1;
        }
        return 5000 * this.checkIncrement++;
    }
}

