/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.migration;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import org.apache.atlas.model.migration.MigrationImportStatus;
import org.apache.atlas.repository.Constants;
import org.apache.atlas.repository.graph.AtlasGraphProvider;
import org.apache.atlas.repository.graphdb.AtlasGraph;
import org.apache.atlas.repository.graphdb.AtlasVertex;
import org.apache.atlas.repository.store.graph.v2.AtlasGraphUtilsV2;
import org.apache.atlas.type.AtlasStructType;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataMigrationStatusService {
    private static final Logger LOG = LoggerFactory.getLogger(DataMigrationStatusService.class);
    private final MigrationStatusVertexManagement migrationStatusVertexManagement;
    private MigrationImportStatus status;

    public DataMigrationStatusService() {
        this.migrationStatusVertexManagement = new MigrationStatusVertexManagement(AtlasGraphProvider.getGraphInstance());
    }

    public DataMigrationStatusService(AtlasGraph graph) {
        this.migrationStatusVertexManagement = new MigrationStatusVertexManagement(graph);
    }

    public void init(String fileToImport) {
        try {
            this.status = new MigrationImportStatus(fileToImport, DigestUtils.md5Hex((InputStream)new FileInputStream(fileToImport)));
        }
        catch (IOException e) {
            LOG.error("Not able to create Migration status", (Throwable)e);
        }
        if (!this.migrationStatusVertexManagement.exists(fileToImport)) {
            return;
        }
        this.getCreate(fileToImport);
    }

    public MigrationImportStatus getCreate(String fileName) {
        MigrationImportStatus create = null;
        try {
            create = this.getCreate(new MigrationImportStatus(fileName, DigestUtils.md5Hex((InputStream)new FileInputStream(fileName))));
        }
        catch (IOException e) {
            LOG.error("Exception occurred while creating migration import", (Throwable)e);
        }
        return create;
    }

    public MigrationImportStatus getCreate(MigrationImportStatus status) {
        try {
            this.status = this.migrationStatusVertexManagement.createOrUpdate(status);
        }
        catch (Exception ex) {
            LOG.error("DataMigrationStatusService: Setting status: {}: Resulted in error!", (Object)status.getFileHash(), (Object)ex);
        }
        return this.status;
    }

    public MigrationImportStatus getStatus() {
        if (this.status != null && this.migrationStatusVertexManagement.exists(this.status.getFileHash())) {
            return this.getCreate(this.status);
        }
        return this.status;
    }

    public MigrationImportStatus getByName(String name) {
        return this.migrationStatusVertexManagement.findByName(name);
    }

    public void delete() {
        if (this.status == null) {
            return;
        }
        MigrationImportStatus status = this.getByName(this.status.getFileHash());
        this.migrationStatusVertexManagement.delete(status.getFileHash());
        this.status = null;
    }

    public void savePosition(Long position) {
        this.status.setCurrentIndex(position.longValue());
        this.migrationStatusVertexManagement.updateVertexPartialPosition(this.status);
    }

    public void setStatus(String status) {
        this.status.setOperationStatus(status);
        this.migrationStatusVertexManagement.updateVertexPartialStatus(this.status);
    }

    private static class MigrationStatusVertexManagement {
        public static final String PROPERTY_KEY_START_TIME = AtlasStructType.AtlasAttribute.encodePropertyKey((String)"__migration.startTime");
        public static final String PROPERTY_KEY_SIZE = AtlasStructType.AtlasAttribute.encodePropertyKey((String)"__migration.size");
        public static final String PROPERTY_KEY_POSITION = AtlasStructType.AtlasAttribute.encodePropertyKey((String)"__migration.position");
        public static final String PROPERTY_KEY_STATUS = AtlasStructType.AtlasAttribute.encodePropertyKey((String)"__migration.status");
        private AtlasGraph graph;
        private AtlasVertex vertex;

        public MigrationStatusVertexManagement(AtlasGraph graph) {
            this.graph = graph;
        }

        public MigrationImportStatus createOrUpdate(MigrationImportStatus status) {
            this.vertex = this.findByNameInternal(status.getFileHash());
            if (this.vertex == null) {
                this.vertex = this.graph.addVertex();
                LOG.info("MigrationStatusVertexManagement: Vertex created!");
                this.updateVertex(this.vertex, status);
            }
            return MigrationStatusVertexManagement.to(this.vertex);
        }

        public boolean exists(String name) {
            return this.findByNameInternal(name) != null;
        }

        public MigrationImportStatus findByName(String name) {
            if (this.vertex != null) {
                return MigrationStatusVertexManagement.to(this.vertex);
            }
            AtlasVertex v = this.findByNameInternal(name);
            if (v == null) {
                return null;
            }
            this.vertex = v;
            LOG.info("MigrationImportStatus: Vertex found!");
            return MigrationStatusVertexManagement.to(v);
        }

        public void delete(String name) {
            try {
                AtlasVertex vertex = this.findByNameInternal(name);
                this.graph.removeVertex(vertex);
                this.vertex = null;
            }
            finally {
                this.graph.commit();
            }
        }

        private AtlasVertex findByNameInternal(String name) {
            try {
                AtlasVertex atlasVertex = AtlasGraphUtilsV2.findByGuid(this.graph, name);
                return atlasVertex;
            }
            catch (Exception e) {
                LOG.error("MigrationStatusVertexManagement.findByNameInternal: Failed!", (Throwable)e);
            }
            finally {
                this.graph.commit();
            }
            return null;
        }

        public void updateVertexPartialPosition(MigrationImportStatus status) {
            try {
                AtlasGraphUtilsV2.setEncodedProperty(this.vertex, PROPERTY_KEY_POSITION, status.getCurrentIndex());
            }
            catch (Exception e) {
                LOG.warn("Error updating status. Please rely on log messages.", (Throwable)e);
            }
            finally {
                this.graph.commit();
            }
        }

        public void updateVertexPartialStatus(MigrationImportStatus status) {
            try {
                AtlasGraphUtilsV2.setEncodedProperty(this.vertex, PROPERTY_KEY_STATUS, status.getOperationStatus());
            }
            catch (Exception e) {
                LOG.warn("Error updating status. Please rely on log messages.", (Throwable)e);
            }
            finally {
                this.graph.commit();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateVertex(AtlasVertex vertex, MigrationImportStatus status) {
            try {
                AtlasGraphUtilsV2.setEncodedProperty(vertex, Constants.GUID_PROPERTY_KEY, status.getFileHash());
                AtlasGraphUtilsV2.setEncodedProperty(vertex, PROPERTY_KEY_START_TIME, status.getStartTime() != null ? status.getStartTime().getTime() : System.currentTimeMillis());
                AtlasGraphUtilsV2.setEncodedProperty(vertex, PROPERTY_KEY_SIZE, status.getTotalCount());
                AtlasGraphUtilsV2.setEncodedProperty(vertex, PROPERTY_KEY_POSITION, status.getCurrentIndex());
                AtlasGraphUtilsV2.setEncodedProperty(vertex, PROPERTY_KEY_STATUS, status.getOperationStatus());
            }
            catch (Exception ex) {
                LOG.error("Error updating MigrationImportStatus vertex. Status may not be persisted correctly.", (Throwable)ex);
            }
            finally {
                this.graph.commit();
            }
        }

        private static MigrationImportStatus to(AtlasVertex vertex) {
            MigrationImportStatus ret = new MigrationImportStatus();
            try {
                Long position;
                Long size;
                ret.setFileHash(AtlasGraphUtilsV2.getEncodedProperty(vertex, Constants.GUID_PROPERTY_KEY, String.class));
                Long dateValue = AtlasGraphUtilsV2.getEncodedProperty(vertex, PROPERTY_KEY_START_TIME, Long.class);
                if (dateValue != null) {
                    ret.setStartTime(new Date(dateValue));
                }
                if ((size = AtlasGraphUtilsV2.getEncodedProperty(vertex, PROPERTY_KEY_SIZE, Long.class)) != null) {
                    ret.setTotalCount(size.longValue());
                }
                if ((position = AtlasGraphUtilsV2.getEncodedProperty(vertex, PROPERTY_KEY_POSITION, Long.class)) != null) {
                    ret.setCurrentIndex(position.longValue());
                }
                ret.setOperationStatus(AtlasGraphUtilsV2.getEncodedProperty(vertex, PROPERTY_KEY_STATUS, String.class));
            }
            catch (Exception ex) {
                LOG.error("Error converting to MigrationImportStatus. Will proceed with default values.", (Throwable)ex);
            }
            return ret;
        }
    }
}

