/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.impexp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.apache.atlas.authorize.AtlasAuthorizationUtils;
import org.apache.atlas.discovery.AtlasDiscoveryService;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.discovery.AtlasSearchResult;
import org.apache.atlas.model.discovery.SearchParameters;
import org.apache.atlas.model.impexp.AtlasExportRequest;
import org.apache.atlas.model.impexp.AtlasImportRequest;
import org.apache.atlas.model.instance.AtlasEntityHeader;
import org.apache.atlas.model.instance.AtlasObjectId;
import org.apache.atlas.repository.impexp.AuditsWriter;
import org.apache.atlas.repository.store.graph.AtlasEntityStore;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class TableReplicationRequestProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(TableReplicationRequestProcessor.class);
    private static final String QUERY_DB_NAME_EQUALS = "qualifiedName startsWith '%s'";
    private static final String ATTR_NAME_KEY = "name";
    private static final String TYPE_HIVE_TABLE = "hive_table";
    private static final String ATTR_QUALIFIED_NAME_KEY = "qualifiedName";
    private static final String REPLICATED_TAG_NAME = "%s_replicated";
    private long startTstamp;
    private long endTstamp;
    private AuditsWriter auditsWriter;
    private AtlasEntityStore entityStore;
    private AtlasTypeRegistry typeRegistry;
    private AtlasDiscoveryService discoveryService;

    @Inject
    public TableReplicationRequestProcessor(AuditsWriter auditsWriter, AtlasEntityStore entityStore, AtlasDiscoveryService atlasDiscoveryService, AtlasTypeRegistry typeRegistry) {
        this.auditsWriter = auditsWriter;
        this.entityStore = entityStore;
        this.typeRegistry = typeRegistry;
        this.discoveryService = atlasDiscoveryService;
    }

    public void process(AtlasExportRequest exportRequest, AtlasImportRequest importRequest) throws AtlasBaseException {
        this.startTstamp = System.currentTimeMillis();
        LOG.info("process: deleting entities with type hive_table which are not imported.");
        String sourceCluster = importRequest.getOptionKeyReplicatedFrom();
        List<String> qualifiedNames = this.getQualifiedNamesFromRequest(exportRequest);
        List<String> safeGUIDs = this.getEntitiesFromQualifiedNames(qualifiedNames);
        String dbName = this.getDbName(safeGUIDs.get(0));
        Set<String> guidsToDelete = this.getGuidsToDelete(dbName, safeGUIDs, sourceCluster);
        this.deleteTables(sourceCluster, guidsToDelete);
    }

    private List<String> getQualifiedNamesFromRequest(AtlasExportRequest exportRequest) {
        ArrayList<String> qualifiedNames = new ArrayList<String>();
        for (AtlasObjectId objectId : exportRequest.getItemsToExport()) {
            qualifiedNames.add(objectId.getUniqueAttributes().get(ATTR_QUALIFIED_NAME_KEY).toString());
        }
        return qualifiedNames;
    }

    private List<String> getEntitiesFromQualifiedNames(List<String> qualifiedNames) throws AtlasBaseException {
        ArrayList<String> safeGUIDs = new ArrayList<String>();
        for (String qualifiedName : qualifiedNames) {
            String guid = this.getGuidByUniqueAttributes(Collections.singletonMap(ATTR_QUALIFIED_NAME_KEY, qualifiedName));
            safeGUIDs.add(guid);
        }
        return safeGUIDs;
    }

    private String getGuidByUniqueAttributes(Map<String, Object> uniqueAttributes) throws AtlasBaseException {
        return this.entityStore.getGuidByUniqueAttributes(this.typeRegistry.getEntityTypeByName(TYPE_HIVE_TABLE), uniqueAttributes);
    }

    private String getDbName(String tableGuid) throws AtlasBaseException {
        String dbGuid = AuditsWriter.ReplKeyGuidFinder.get(this.typeRegistry, this.entityStore, tableGuid);
        return (String)this.entityStore.getById(dbGuid).getEntity().getAttribute(ATTR_NAME_KEY);
    }

    private Set<String> getGuidsToDelete(String dbName, List<String> excludeGUIDs, String sourceCluster) throws AtlasBaseException {
        SearchParameters parameters = this.getSearchParameters(dbName, sourceCluster);
        HashSet<String> unsafeGUIDs = new HashSet<String>();
        int max = 10000;
        int fetchedSize = 0;
        int i = 0;
        parameters.setLimit(10000);
        while (fetchedSize == 10000 * i) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("i={}, fetchedSize={}, unsafeGUIDs.size()={}", new Object[]{i, fetchedSize, unsafeGUIDs.size()});
            }
            int offset = 10000 * i;
            parameters.setOffset(offset);
            AtlasSearchResult searchResult = this.discoveryService.searchWithParameters(parameters);
            if (CollectionUtils.isEmpty((Collection)searchResult.getEntities())) break;
            if (LOG.isDebugEnabled()) {
                LOG.debug("getGuidsToDelete: {}", (Object)searchResult.getApproximateCount());
            }
            String classificationName = String.format(REPLICATED_TAG_NAME, sourceCluster);
            for (AtlasEntityHeader entityHeader : searchResult.getEntities()) {
                String guid;
                if (!entityHeader.getClassificationNames().contains(classificationName) || excludeGUIDs.contains(guid = entityHeader.getGuid())) continue;
                unsafeGUIDs.add(guid);
            }
            fetchedSize = searchResult.getEntities().size();
            ++i;
        }
        return unsafeGUIDs;
    }

    private SearchParameters getSearchParameters(String dbName, String sourceCluster) {
        String query = String.format(QUERY_DB_NAME_EQUALS, dbName);
        SearchParameters parameters = new SearchParameters();
        parameters.setExcludeDeletedEntities(false);
        parameters.setTypeName(TYPE_HIVE_TABLE);
        parameters.setExcludeDeletedEntities(true);
        parameters.setAttributes((Set)new HashSet<String>(){
            {
                this.add("replicatedFrom");
            }
        });
        parameters.setQuery(query);
        return parameters;
    }

    private void deleteTables(String sourceCluster, Set<String> guidsToDelete) throws AtlasBaseException {
        if (!CollectionUtils.isEmpty(guidsToDelete)) {
            this.entityStore.deleteByIds(new ArrayList<String>(guidsToDelete));
            this.endTstamp = System.currentTimeMillis();
            this.createAuditEntry(sourceCluster, guidsToDelete);
        }
    }

    private void createAuditEntry(String sourceCluster, Set<String> guidsToDelete) throws AtlasBaseException {
        this.auditsWriter.write(AtlasAuthorizationUtils.getCurrentUserName(), sourceCluster, this.startTstamp, this.endTstamp, guidsToDelete);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Deleted entities => {}", guidsToDelete);
        }
    }
}

