/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.impexp;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.apache.atlas.RequestContext;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.glossary.GlossaryService;
import org.apache.atlas.model.impexp.AtlasExportRequest;
import org.apache.atlas.model.impexp.AtlasExportResult;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.AtlasObjectId;
import org.apache.atlas.model.typedef.AtlasBusinessMetadataDef;
import org.apache.atlas.model.typedef.AtlasClassificationDef;
import org.apache.atlas.model.typedef.AtlasEntityDef;
import org.apache.atlas.model.typedef.AtlasEnumDef;
import org.apache.atlas.model.typedef.AtlasRelationshipDef;
import org.apache.atlas.model.typedef.AtlasStructDef;
import org.apache.atlas.model.typedef.AtlasTypesDef;
import org.apache.atlas.repository.graphdb.AtlasGraph;
import org.apache.atlas.repository.impexp.AuditsWriter;
import org.apache.atlas.repository.impexp.EntitiesExtractor;
import org.apache.atlas.repository.impexp.ExportTypeProcessor;
import org.apache.atlas.repository.impexp.HdfsPathEntityCreator;
import org.apache.atlas.repository.impexp.StartEntityFetchByExportRequest;
import org.apache.atlas.repository.impexp.ZipSink;
import org.apache.atlas.repository.store.graph.v2.EntityGraphRetriever;
import org.apache.atlas.repository.util.UniqueList;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.atlas.util.AtlasGremlinQueryProvider;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ExportService {
    private static final Logger LOG = LoggerFactory.getLogger(ExportService.class);
    private final AtlasTypeRegistry typeRegistry;
    private final StartEntityFetchByExportRequest startEntityFetchByExportRequest;
    private final EntitiesExtractor entitiesExtractor;
    private AuditsWriter auditsWriter;
    private final EntityGraphRetriever entityGraphRetriever;
    private ExportTypeProcessor exportTypeProcessor;
    private final HdfsPathEntityCreator hdfsPathEntityCreator;
    private final GlossaryService glossaryService;

    @Inject
    public ExportService(AtlasTypeRegistry typeRegistry, AtlasGraph graph, AuditsWriter auditsWriter, HdfsPathEntityCreator hdfsPathEntityCreator, GlossaryService glossaryService) {
        this.typeRegistry = typeRegistry;
        this.entityGraphRetriever = new EntityGraphRetriever(graph, this.typeRegistry);
        this.auditsWriter = auditsWriter;
        this.hdfsPathEntityCreator = hdfsPathEntityCreator;
        this.glossaryService = glossaryService;
        this.startEntityFetchByExportRequest = new StartEntityFetchByExportRequest(graph, typeRegistry, AtlasGremlinQueryProvider.INSTANCE);
        this.entitiesExtractor = new EntitiesExtractor(graph, typeRegistry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AtlasExportResult run(ZipSink exportSink, AtlasExportRequest request, String userName, String hostName, String requestingIP) throws AtlasBaseException {
        long startTime = System.currentTimeMillis();
        AtlasExportResult result = new AtlasExportResult(request, userName, requestingIP, hostName, startTime, this.getCurrentChangeMarker());
        ExportContext context = new ExportContext(result, exportSink);
        this.exportTypeProcessor = new ExportTypeProcessor(this.typeRegistry, this.glossaryService);
        try {
            LOG.info("==> export(user={}, from={})", (Object)userName, (Object)requestingIP);
            AtlasExportResult.OperationStatus[] statuses = this.processItems(request, context);
            this.processTypesDef(context);
            long endTime = System.currentTimeMillis();
            this.updateSinkWithOperationMetrics(userName, context, statuses, startTime, endTime);
            this.entitiesExtractor.close();
        }
        catch (Exception ex) {
            try {
                LOG.error("Operation failed: ", (Throwable)ex);
                this.entitiesExtractor.close();
            }
            catch (Throwable throwable) {
                this.entitiesExtractor.close();
                LOG.info("<== export(user={}, from={}): status {}: changeMarker: {}", new Object[]{userName, requestingIP, context.result.getOperationStatus(), context.result.getChangeMarker()});
                context.clear();
                result.clear();
                throw throwable;
            }
            LOG.info("<== export(user={}, from={}): status {}: changeMarker: {}", new Object[]{userName, requestingIP, context.result.getOperationStatus(), context.result.getChangeMarker()});
            context.clear();
            result.clear();
        }
        LOG.info("<== export(user={}, from={}): status {}: changeMarker: {}", new Object[]{userName, requestingIP, context.result.getOperationStatus(), context.result.getChangeMarker()});
        context.clear();
        result.clear();
        return context.result;
    }

    private long getCurrentChangeMarker() {
        return RequestContext.earliestActiveRequestTime();
    }

    private void updateSinkWithOperationMetrics(String userName, ExportContext context, AtlasExportResult.OperationStatus[] statuses, long startTime, long endTime) throws AtlasBaseException {
        int duration = this.getOperationDuration(startTime, endTime);
        context.result.setSourceClusterName(AuditsWriter.getCurrentClusterName());
        context.sink.setExportOrder(context.entityCreationOrder.getList());
        context.sink.setTypesDef(context.result.getData().getTypesDef());
        context.result.setOperationStatus(this.getOverallOperationStatus(statuses));
        context.result.incrementMeticsCounter("duration", duration);
        this.auditsWriter.write(userName, context.result, startTime, endTime, context.entityCreationOrder.getList());
        context.result.setData(null);
        context.sink.setResult(context.result);
    }

    private int getOperationDuration(long startTime, long endTime) {
        return (int)(endTime - startTime);
    }

    private void processTypesDef(ExportContext context) {
        AtlasTypesDef typesDef = context.result.getData().getTypesDef();
        for (String entityType : context.entityTypes) {
            AtlasEntityDef entityDef = this.typeRegistry.getEntityDefByName(entityType);
            typesDef.getEntityDefs().add(entityDef);
        }
        for (String classificationType : context.classificationTypes) {
            AtlasClassificationDef classificationDef = this.typeRegistry.getClassificationDefByName(classificationType);
            typesDef.getClassificationDefs().add(classificationDef);
        }
        for (String structType : context.structTypes) {
            AtlasStructDef structDef = this.typeRegistry.getStructDefByName(structType);
            typesDef.getStructDefs().add(structDef);
        }
        for (String enumType : context.enumTypes) {
            AtlasEnumDef enumDef = this.typeRegistry.getEnumDefByName(enumType);
            typesDef.getEnumDefs().add(enumDef);
        }
        for (String relationshipType : context.relationshipTypes) {
            AtlasRelationshipDef relationshipDef = this.typeRegistry.getRelationshipDefByName(relationshipType);
            typesDef.getRelationshipDefs().add(relationshipDef);
        }
        for (String bm : context.businessMetadataTypes) {
            AtlasBusinessMetadataDef bmDef = this.typeRegistry.getBusinessMetadataDefByName(bm);
            typesDef.getBusinessMetadataDefs().add(bmDef);
        }
    }

    private AtlasExportResult.OperationStatus[] processItems(AtlasExportRequest request, ExportContext context) {
        AtlasExportResult.OperationStatus[] statuses = new AtlasExportResult.OperationStatus[request.getItemsToExport().size()];
        List itemsToExport = request.getItemsToExport();
        for (int i = 0; i < itemsToExport.size(); ++i) {
            AtlasObjectId item = (AtlasObjectId)itemsToExport.get(i);
            statuses[i] = this.processObjectId(item, context);
        }
        return statuses;
    }

    @VisibleForTesting
    AtlasExportResult.OperationStatus getOverallOperationStatus(AtlasExportResult.OperationStatus ... statuses) {
        AtlasExportResult.OperationStatus overall = statuses.length == 0 ? AtlasExportResult.OperationStatus.FAIL : statuses[0];
        for (AtlasExportResult.OperationStatus s : statuses) {
            if (overall == s) continue;
            overall = AtlasExportResult.OperationStatus.PARTIAL_SUCCESS;
        }
        return overall;
    }

    private AtlasExportResult.OperationStatus processObjectId(AtlasObjectId item, ExportContext context) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> processObjectId({})", (Object)item);
        }
        try {
            List<String> entityGuids = this.getStartingEntity(item, context);
            if (entityGuids.size() == 0) {
                return AtlasExportResult.OperationStatus.FAIL;
            }
            this.entitiesExtractor.setExtractor(this.typeRegistry.getEntityDefByName(item.getTypeName()));
            for (String guid : entityGuids) {
                this.processEntityGuid(guid, context);
            }
            while (!context.guidsToProcess.isEmpty()) {
                while (!context.guidsToProcess.isEmpty()) {
                    String guid = context.guidsToProcess.remove(0);
                    this.processEntityGuid(guid, context);
                }
                if (!context.lineageToProcess.isEmpty()) {
                    context.guidsToProcess.addAll(context.lineageToProcess);
                    context.lineageProcessed.addAll(context.lineageToProcess.getList());
                    context.lineageToProcess.clear();
                }
                context.isSkipConnectedFetch = false;
            }
        }
        catch (AtlasBaseException excp) {
            LOG.error("Fetching entity failed for: {}", (Object)item, (Object)excp);
            return AtlasExportResult.OperationStatus.FAIL;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== processObjectId({})", (Object)item);
        }
        return AtlasExportResult.OperationStatus.SUCCESS;
    }

    private List<String> getStartingEntity(AtlasObjectId item, ExportContext context) throws AtlasBaseException {
        if (item.getTypeName().equalsIgnoreCase("hdfs_path")) {
            this.hdfsPathEntityCreator.getCreateEntity(item);
        }
        return this.startEntityFetchByExportRequest.get(context.result.getRequest(), item);
    }

    private void processEntityGuid(String guid, ExportContext context) throws AtlasBaseException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> processEntityGuid({})", (Object)guid);
        }
        if (context.guidsProcessed.contains(guid)) {
            return;
        }
        AtlasEntity.AtlasEntityWithExtInfo entityWithExtInfo = this.entityGraphRetriever.toAtlasEntityWithExtInfo(guid);
        this.processEntity(entityWithExtInfo, context);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== processEntityGuid({})", (Object)guid);
        }
    }

    public void processEntity(AtlasEntity.AtlasEntityWithExtInfo entityWithExtInfo, ExportContext context) throws AtlasBaseException {
        this.exportTypeProcessor.addTypes(entityWithExtInfo.getEntity(), context);
        if (MapUtils.isNotEmpty(context.termsGlossary)) {
            this.addGlossaryEntities(context);
        }
        this.addEntity(entityWithExtInfo, context);
        context.guidsProcessed.add(entityWithExtInfo.getEntity().getGuid());
        this.entitiesExtractor.get(entityWithExtInfo.getEntity(), context);
        if (entityWithExtInfo.getReferredEntities() != null) {
            for (AtlasEntity e : entityWithExtInfo.getReferredEntities().values()) {
                this.exportTypeProcessor.addTypes(e, context);
                this.entitiesExtractor.get(e, context);
            }
            context.guidsProcessed.addAll(entityWithExtInfo.getReferredEntities().keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addGlossaryEntities(ExportContext context) {
        try {
            for (String termGuid : context.termsGlossary.keySet()) {
                try {
                    String glossaryGuid = context.termsGlossary.get(termGuid);
                    if (!context.sink.hasEntity(glossaryGuid)) {
                        AtlasEntity glossary = this.entityGraphRetriever.toAtlasEntity(glossaryGuid);
                        this.addEntity(new AtlasEntity.AtlasEntityWithExtInfo(glossary), context);
                    }
                    if (context.sink.hasEntity(termGuid)) continue;
                    AtlasEntity term = this.entityGraphRetriever.toAtlasEntity(termGuid);
                    this.addEntity(new AtlasEntity.AtlasEntityWithExtInfo(term), context);
                }
                catch (AtlasBaseException exception) {
                    LOG.error("Error fetching Glossary for term: {}", (Object)termGuid);
                }
            }
        }
        finally {
            context.clearTerms();
        }
    }

    private void addEntity(AtlasEntity.AtlasEntityWithExtInfo entityWithExtInfo, ExportContext context) throws AtlasBaseException {
        if (context.sink.hasEntity(entityWithExtInfo.getEntity().getGuid())) {
            return;
        }
        if (context.doesTimestampQualify(entityWithExtInfo.getEntity())) {
            context.addToSink(entityWithExtInfo);
            context.result.incrementMeticsCounter(String.format("entity:%s", entityWithExtInfo.getEntity().getTypeName()));
            if (entityWithExtInfo.getReferredEntities() != null) {
                for (AtlasEntity e : entityWithExtInfo.getReferredEntities().values()) {
                    context.result.incrementMeticsCounter(String.format("entity:%s", e.getTypeName()));
                }
            }
            context.result.incrementMeticsCounter("entity:withExtInfo");
        } else {
            List<AtlasEntity> entities = context.getEntitiesWithModifiedTimestamp(entityWithExtInfo);
            for (AtlasEntity e : entities) {
                context.addToSink(new AtlasEntity.AtlasEntityWithExtInfo(e));
                context.result.incrementMeticsCounter(String.format("entity:%s", e.getTypeName()));
            }
        }
        context.reportProgress();
    }

    static class ExportContext {
        private static final int REPORTING_THREASHOLD = 1000;
        private static final String ATLAS_TYPE_HIVE_DB = "hive_db";
        private static final String ATLAS_TYPE_HIVE_TABLE = "hive_table";
        final UniqueList<String> entityCreationOrder = new UniqueList();
        final Set<String> guidsProcessed = new HashSet<String>();
        final UniqueList<String> guidsToProcess = new UniqueList();
        final UniqueList<String> lineageToProcess = new UniqueList();
        final Set<String> lineageProcessed = new HashSet<String>();
        final Map<String, TraversalDirection> guidDirection = new HashMap<String, TraversalDirection>();
        final Set<String> entityTypes = new HashSet<String>();
        final Set<String> classificationTypes = new HashSet<String>();
        final Set<String> structTypes = new HashSet<String>();
        final Set<String> enumTypes = new HashSet<String>();
        final Set<String> relationshipTypes = new HashSet<String>();
        final Set<String> businessMetadataTypes = new HashSet<String>();
        final Map<String, String> termsGlossary = new HashMap<String, String>();
        final AtlasExportResult result;
        private final ZipSink sink;
        final ExportFetchType fetchType;
        final boolean skipLineage;
        final long changeMarker;
        boolean isSkipConnectedFetch;
        private final boolean isHiveDBIncremental;
        private final boolean isHiveTableIncremental;
        private int progressReportCount = 0;

        ExportContext(AtlasExportResult result, ZipSink sink) {
            this.result = result;
            this.sink = sink;
            this.fetchType = ExportFetchType.from(result.getRequest().getFetchTypeOptionValue());
            this.skipLineage = result.getRequest().getSkipLineageOptionValue();
            this.changeMarker = result.getRequest().getChangeTokenFromOptions();
            this.isHiveDBIncremental = this.checkHiveDBIncrementalSkipLineage(result.getRequest());
            this.isHiveTableIncremental = this.checkHiveTableIncremental(result.getRequest());
            this.isSkipConnectedFetch = false;
        }

        private boolean checkHiveDBIncrementalSkipLineage(AtlasExportRequest request) {
            if (CollectionUtils.isEmpty((Collection)request.getItemsToExport())) {
                return false;
            }
            return ((AtlasObjectId)request.getItemsToExport().get(0)).getTypeName().equalsIgnoreCase(ATLAS_TYPE_HIVE_DB) && request.getFetchTypeOptionValue().equalsIgnoreCase("incremental") && request.getSkipLineageOptionValue();
        }

        private boolean checkHiveTableIncremental(AtlasExportRequest request) {
            if (CollectionUtils.isEmpty((Collection)request.getItemsToExport())) {
                return false;
            }
            return ((AtlasObjectId)request.getItemsToExport().get(0)).getTypeName().equalsIgnoreCase(ATLAS_TYPE_HIVE_TABLE) && request.getFetchTypeOptionValue().equalsIgnoreCase("incremental");
        }

        public List<AtlasEntity> getEntitiesWithModifiedTimestamp(AtlasEntity.AtlasEntityWithExtInfo entityWithExtInfo) {
            if (this.fetchType != ExportFetchType.INCREMENTAL) {
                return new ArrayList<AtlasEntity>();
            }
            ArrayList<AtlasEntity> ret = new ArrayList<AtlasEntity>();
            if (this.doesTimestampQualify(entityWithExtInfo.getEntity())) {
                ret.add(entityWithExtInfo.getEntity());
                return ret;
            }
            if (entityWithExtInfo.getReferredEntities() != null) {
                for (AtlasEntity entity : entityWithExtInfo.getReferredEntities().values()) {
                    if (!this.doesTimestampQualify(entity)) continue;
                    ret.add(entity);
                }
            }
            return ret;
        }

        public void clear() {
            this.guidsToProcess.clear();
            this.guidsProcessed.clear();
            this.guidDirection.clear();
        }

        public void addToBeProcessed(boolean isSuperTypeProcess, String guid, TraversalDirection direction) {
            if (isSuperTypeProcess) {
                this.lineageToProcess.add(guid);
            } else {
                this.guidsToProcess.add(guid);
            }
            this.guidDirection.put(guid, direction);
        }

        public void reportProgress() {
            if (this.guidsProcessed.size() - this.progressReportCount > 1000) {
                this.progressReportCount = this.guidsProcessed.size();
                LOG.info("export(): in progress.. number of entities exported: {}", (Object)this.guidsProcessed.size());
            }
        }

        public boolean doesTimestampQualify(AtlasEntity entity) {
            if (this.fetchType != ExportFetchType.INCREMENTAL) {
                return true;
            }
            return this.changeMarker <= entity.getUpdateTime().getTime();
        }

        public boolean getSkipLineage() {
            return this.skipLineage;
        }

        public void addToSink(AtlasEntity.AtlasEntityWithExtInfo entityWithExtInfo) throws AtlasBaseException {
            this.addToEntityCreationOrder(entityWithExtInfo.getEntity().getGuid());
            this.sink.add(entityWithExtInfo);
        }

        public boolean isHiveDBIncrementalSkipLineage() {
            return this.isHiveDBIncremental;
        }

        public boolean isHiveTableIncrementalSkipLineage() {
            return this.isHiveTableIncremental;
        }

        public boolean isHiveTableIncremental() {
            return this.isHiveTableIncremental;
        }

        public void addToEntityCreationOrder(String guid) {
            this.entityCreationOrder.add(guid);
        }

        public void clearTerms() {
            this.termsGlossary.clear();
        }
    }

    public static enum ExportFetchType {
        FULL("full"),
        CONNECTED("connected"),
        INCREMENTAL("incremental");

        final String str;

        private ExportFetchType(String s) {
            this.str = s;
        }

        public static final ExportFetchType from(String s) {
            for (ExportFetchType b : ExportFetchType.values()) {
                if (!b.str.equalsIgnoreCase(s)) continue;
                return b;
            }
            return FULL;
        }
    }

    public static enum TraversalDirection {
        UNKNOWN,
        INWARD,
        OUTWARD,
        BOTH;

    }
}

