/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.audit;

import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.inject.Singleton;
import org.apache.atlas.AtlasException;
import org.apache.atlas.EntityAuditEvent;
import org.apache.atlas.annotation.ConditionalOnAtlasProperty;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.audit.EntityAuditEventV2;
import org.apache.atlas.repository.Constants;
import org.apache.atlas.repository.audit.EntityAuditRepository;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Component;

@Singleton
@Component
@ConditionalOnAtlasProperty(property="atlas.EntityAuditRepository.impl")
public class InMemoryEntityAuditRepository
implements EntityAuditRepository {
    private TreeMap<String, EntityAuditEvent> auditEvents = new TreeMap();
    private TreeMap<String, EntityAuditEventV2> auditEventsV2 = new TreeMap();

    @Override
    public void putEventsV1(EntityAuditEvent ... events) throws AtlasException {
        this.putEventsV1(Arrays.asList(events));
    }

    @Override
    public synchronized void putEventsV1(List<EntityAuditEvent> events) throws AtlasException {
        for (EntityAuditEvent event : events) {
            String rowKey = event.getEntityId() + (Long.MAX_VALUE - event.getTimestamp());
            event.setEventKey(rowKey);
            this.auditEvents.put(rowKey, event);
        }
    }

    @Override
    public synchronized List<EntityAuditEvent> listEventsV1(String entityId, String startKey, short maxResults) {
        ArrayList<EntityAuditEvent> events = new ArrayList<EntityAuditEvent>();
        String myStartKey = startKey;
        if (myStartKey == null) {
            myStartKey = entityId;
        }
        SortedMap<String, EntityAuditEvent> subMap = this.auditEvents.tailMap(myStartKey);
        for (EntityAuditEvent event : subMap.values()) {
            if (events.size() >= maxResults || !event.getEntityId().equals(entityId)) continue;
            events.add(event);
        }
        return events;
    }

    @Override
    public long repositoryMaxSize() {
        return -1L;
    }

    @Override
    public List<String> getAuditExcludeAttributes(String entityType) {
        return null;
    }

    @Override
    public void putEventsV2(EntityAuditEventV2 ... events) {
        this.putEventsV2(Arrays.asList(events));
    }

    @Override
    public void putEventsV2(List<EntityAuditEventV2> events) {
        for (EntityAuditEventV2 event : events) {
            String rowKey = event.getEntityId() + (Long.MAX_VALUE - event.getTimestamp());
            event.setEventKey(rowKey);
            this.auditEventsV2.put(rowKey, event);
        }
    }

    @Override
    public List<EntityAuditEventV2> listEventsV2(String entityId, EntityAuditEventV2.EntityAuditActionV2 auditAction, String sortByColumn, boolean sortOrderDesc, int offset, short limit) throws AtlasBaseException {
        return this.listEventsV2(entityId, auditAction, sortByColumn, sortOrderDesc, 0, offset, limit, true, true);
    }

    private List<EntityAuditEventV2> listEventsV2(String entityId, EntityAuditEventV2.EntityAuditActionV2 auditAction, String sortByColumn, boolean sortOrderDesc, int ttlInDays, int offset, short limit, boolean allowMaxResults, boolean createEventsAgeoutAllowed) throws AtlasBaseException {
        ArrayList<EntityAuditEventV2> events = new ArrayList<EntityAuditEventV2>();
        SortedMap<String, EntityAuditEventV2> subMap = this.auditEventsV2.tailMap(entityId);
        for (EntityAuditEventV2 event : subMap.values()) {
            if (!event.getEntityId().equals(entityId) || auditAction != null && event.getAction() != auditAction || event.getAction() == EntityAuditEventV2.EntityAuditActionV2.ENTITY_CREATE && !createEventsAgeoutAllowed) continue;
            events.add(event);
        }
        if (allowMaxResults && limit == -1) {
            limit = (short)events.size();
        }
        EntityAuditEventV2.sortEvents(events, (String)sortByColumn, (boolean)sortOrderDesc);
        int fromIndex = Math.min(events.size(), offset);
        int endIndex = Math.min(events.size(), offset + limit);
        List<EntityAuditEventV2> possibleExpiredEvents = events.subList(0, fromIndex);
        events = new ArrayList(events.subList(fromIndex, endIndex));
        if (CollectionUtils.isNotEmpty(possibleExpiredEvents) && ttlInDays > 0) {
            LocalDateTime now = LocalDateTime.now();
            long ttlTimestamp = Timestamp.valueOf(now.minusDays(ttlInDays)).getTime();
            possibleExpiredEvents.removeIf(e -> auditAction != null && e.getAction() != auditAction || e.getTimestamp() > ttlTimestamp);
            if (CollectionUtils.isNotEmpty(possibleExpiredEvents)) {
                events.addAll(possibleExpiredEvents);
            }
        }
        return events;
    }

    @Override
    public List<EntityAuditEventV2> deleteEventsV2(String entityId, Set<EntityAuditEventV2.EntityAuditActionV2> entityAuditActions, short auditCount, int ttlInDays, boolean createEventsAgeoutAllowed, Constants.AtlasAuditAgingType auditAgingType) throws AtlasBaseException, AtlasException {
        List<EntityAuditEventV2> events = new ArrayList<EntityAuditEventV2>();
        if (CollectionUtils.isEmpty(entityAuditActions)) {
            events = this.listEventsV2(entityId, null, "timestamp", true, ttlInDays, auditCount, (short)-1, true, createEventsAgeoutAllowed);
        } else {
            for (EntityAuditEventV2.EntityAuditActionV2 auditAction : entityAuditActions) {
                List<EntityAuditEventV2> eventsByAction = this.listEventsV2(entityId, auditAction, "timestamp", true, ttlInDays, auditCount, (short)-1, true, createEventsAgeoutAllowed);
                if (!CollectionUtils.isNotEmpty(eventsByAction)) continue;
                events.addAll(eventsByAction);
            }
        }
        return events;
    }

    @Override
    public List<EntityAuditEventV2> listEventsV2(String entityId, EntityAuditEventV2.EntityAuditActionV2 auditAction, String startKey, short maxResults) {
        ArrayList<EntityAuditEventV2> events = new ArrayList<EntityAuditEventV2>();
        String myStartKey = startKey;
        if (myStartKey == null) {
            myStartKey = entityId;
        }
        SortedMap<String, EntityAuditEventV2> subMap = this.auditEventsV2.tailMap(myStartKey);
        for (EntityAuditEventV2 event : subMap.values()) {
            if (events.size() >= maxResults || !event.getEntityId().equals(entityId)) continue;
            events.add(event);
        }
        return events;
    }

    @Override
    public Set<String> getEntitiesWithTagChanges(long fromTimestamp, long toTimestamp) throws AtlasBaseException {
        HashSet<String> events = new HashSet<String>();
        for (EntityAuditEventV2 event : this.auditEventsV2.values()) {
            long timestamp = event.getTimestamp();
            if (timestamp <= fromTimestamp || timestamp > toTimestamp) continue;
            events.add(event.getEntityId());
        }
        return events;
    }

    @Override
    public List<Object> listEvents(String entityId, String startKey, short maxResults) {
        List<EntityAuditEventV2> events = this.listEventsV2(entityId, null, startKey, maxResults);
        if (CollectionUtils.isEmpty(events)) {
            events = this.listEventsV1(entityId, startKey, maxResults);
        }
        return events;
    }
}

