/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.audit;

import com.google.common.annotations.VisibleForTesting;
import java.io.Closeable;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Consumer;
import javax.inject.Singleton;
import org.apache.atlas.ApplicationProperties;
import org.apache.atlas.AtlasConfiguration;
import org.apache.atlas.AtlasException;
import org.apache.atlas.EntityAuditEvent;
import org.apache.atlas.RequestContext;
import org.apache.atlas.annotation.ConditionalOnAtlasProperty;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.ha.HAConfiguration;
import org.apache.atlas.listener.ActiveStateChangeHandler;
import org.apache.atlas.model.audit.EntityAuditEventV2;
import org.apache.atlas.repository.Constants;
import org.apache.atlas.repository.audit.AbstractStorageBasedAuditRepository;
import org.apache.atlas.utils.AtlasPerfMetrics;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.filter.BinaryComparator;
import org.apache.hadoop.hbase.filter.BinaryPrefixComparator;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.MultiRowRangeFilter;
import org.apache.hadoop.hbase.filter.PageFilter;
import org.apache.hadoop.hbase.filter.SingleColumnValueFilter;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.util.Bytes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Singleton
@Component
@ConditionalOnAtlasProperty(property="atlas.EntityAuditRepository.impl", isDefault=true)
@Order(value=0)
public class HBaseBasedAuditRepository
extends AbstractStorageBasedAuditRepository {
    private static final Logger LOG = LoggerFactory.getLogger(HBaseBasedAuditRepository.class);
    public static final String CONFIG_PREFIX = "atlas.audit";
    public static final String CONFIG_TABLE_NAME = "atlas.audit.hbase.tablename";
    public static final String DEFAULT_TABLE_NAME = "ATLAS_ENTITY_AUDIT_EVENTS";
    public static final String CONFIG_COMPRESSION_ALGORITHM = "atlas.audit.hbase.compression-algorithm";
    public static final String CONFIG_PERSIST_ENTITY_DEFINITION = "atlas.audit.persistEntityDefinition";
    public static final byte[] COLUMN_FAMILY = Bytes.toBytes((String)"dt");
    public static final byte[] COLUMN_ACTION = Bytes.toBytes((String)"a");
    public static final byte[] COLUMN_DETAIL = Bytes.toBytes((String)"d");
    public static final byte[] COLUMN_USER = Bytes.toBytes((String)"u");
    public static final byte[] COLUMN_DEFINITION = Bytes.toBytes((String)"f");
    private static final String HBASE_STORE_COMPRESSION_PROPERTY = "atlas.graph.storage.hbase.compression-algorithm";
    private static final String AUDIT_REPOSITORY_MAX_SIZE_PROPERTY = "atlas.hbase.client.keyvalue.maxsize";
    private static final String AUDIT_EXCLUDE_ATTRIBUTE_PROPERTY = "atlas.audit.hbase.entity";
    private static final String FIELD_SEPARATOR = ":";
    private static final long ATLAS_HBASE_KEYVALUE_DEFAULT_SIZE = 0x100000L;
    private static org.apache.commons.configuration.Configuration APPLICATION_PROPERTIES = null;
    private static final int DEFAULT_CACHING = 200;
    private static boolean persistEntityDefinition;
    private Map<String, List<String>> auditExcludedAttributesCache = new HashMap<String, List<String>>();
    private TableName tableName;
    private String compressionType;
    private Connection connection;

    @Override
    public void putEventsV1(EntityAuditEvent ... events) throws AtlasException {
        this.putEventsV1(Arrays.asList(events));
    }

    @Override
    public void putEventsV1(List<EntityAuditEvent> events) throws AtlasException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Putting {} events", (Object)events.size());
        }
        Table table = null;
        try {
            table = this.connection.getTable(this.tableName);
            ArrayList<Put> puts = new ArrayList<Put>(events.size());
            for (int index = 0; index < events.size(); ++index) {
                EntityAuditEvent event = events.get(index);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Adding entity audit event {}", (Object)event);
                }
                Put put = new Put(this.getKey(event.getEntityId(), event.getTimestamp(), index));
                this.addColumn(put, COLUMN_ACTION, event.getAction());
                this.addColumn(put, COLUMN_USER, event.getUser());
                this.addColumn(put, COLUMN_DETAIL, event.getDetails());
                if (persistEntityDefinition) {
                    this.addColumn(put, COLUMN_DEFINITION, event.getEntityDefinitionString());
                }
                puts.add(put);
            }
            table.put(puts);
        }
        catch (IOException e) {
            try {
                throw new AtlasException((Throwable)e);
            }
            catch (Throwable throwable) {
                this.close((Closeable)table);
                throw throwable;
            }
        }
        this.close((Closeable)table);
    }

    @Override
    public void putEventsV2(EntityAuditEventV2 ... events) throws AtlasBaseException {
        this.putEventsV2(Arrays.asList(events));
    }

    @Override
    public void putEventsV2(List<EntityAuditEventV2> events) throws AtlasBaseException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Putting {} events", (Object)events.size());
        }
        Table table = null;
        try {
            table = this.connection.getTable(this.tableName);
            ArrayList<Put> puts = new ArrayList<Put>(events.size());
            for (int index = 0; index < events.size(); ++index) {
                EntityAuditEventV2 event = events.get(index);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Adding entity audit event {}", (Object)event);
                }
                Put put = new Put(this.getKey(event.getEntityId(), event.getTimestamp(), index));
                this.addColumn(put, COLUMN_ACTION, event.getAction());
                this.addColumn(put, COLUMN_USER, event.getUser());
                this.addColumn(put, COLUMN_DETAIL, event.getDetails());
                if (persistEntityDefinition) {
                    this.addColumn(put, COLUMN_DEFINITION, event.getEntityDefinitionString());
                }
                puts.add(put);
            }
            table.put(puts);
        }
        catch (IOException e) {
            throw new AtlasBaseException((Throwable)e);
        }
        finally {
            try {
                this.close((Closeable)table);
            }
            catch (AtlasException e) {
                throw new AtlasBaseException((Throwable)e);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<EntityAuditEventV2> listEventsV2(String entityId, EntityAuditEventV2.EntityAuditActionV2 auditAction, String startKey, short maxResultCount) throws AtlasBaseException {
        ArrayList<EntityAuditEventV2> arrayList;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Listing events for entity id {}, operation {}, starting key{}, maximum result count {}", new Object[]{entityId, auditAction, startKey, maxResultCount});
        }
        AtlasPerfMetrics.MetricRecorder metric = RequestContext.get().startMetricRecord("listSortedEventsV2");
        Table table = null;
        ResultScanner scanner = null;
        try {
            Result result;
            table = this.connection.getTable(this.tableName);
            Scan scan = new Scan().setReversed(true).setCaching(200).setSmall(true);
            if (maxResultCount > -1) {
                scan.setFilter((Filter)new PageFilter((long)maxResultCount));
            }
            if (auditAction != null) {
                SingleColumnValueFilter filterAction = new SingleColumnValueFilter(COLUMN_FAMILY, COLUMN_ACTION, CompareFilter.CompareOp.EQUAL, (ByteArrayComparable)new BinaryComparator(Bytes.toBytes((String)auditAction.toString())));
                scan.setFilter((Filter)filterAction);
            }
            if (StringUtils.isNotBlank((String)entityId)) {
                scan.setStopRow(Bytes.toBytes((String)entityId));
            }
            if (StringUtils.isEmpty((String)startKey)) {
                byte[] entityBytes = this.getKey(entityId, Long.MAX_VALUE, Integer.MAX_VALUE);
                scan = scan.setStartRow(entityBytes);
            } else {
                scan = scan.setStartRow(Bytes.toBytes((String)startKey));
            }
            scanner = table.getScanner(scan);
            ArrayList<EntityAuditEventV2> events = new ArrayList<EntityAuditEventV2>();
            while ((result = scanner.next()) != null && (maxResultCount == -1 || events.size() < maxResultCount)) {
                String colDef;
                EntityAuditEventV2 event = this.fromKeyV2(result.getRow());
                if (StringUtils.isNotBlank((String)entityId) && !event.getEntityId().equals(entityId)) continue;
                event.setUser(this.getResultString(result, COLUMN_USER));
                event.setAction(EntityAuditEventV2.EntityAuditActionV2.fromString((String)this.getResultString(result, COLUMN_ACTION)));
                event.setDetails(this.getResultString(result, COLUMN_DETAIL));
                if (persistEntityDefinition && (colDef = this.getResultString(result, COLUMN_DEFINITION)) != null) {
                    event.setEntityDefinition(colDef);
                }
                events.add(event);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Got events for entity id {}, operation {}, starting key{}, maximum result count {}, #records returned {}", new Object[]{entityId, auditAction.toString(), startKey, maxResultCount, events.size()});
            }
            arrayList = events;
        }
        catch (IOException e) {
            try {
                throw new AtlasBaseException((Throwable)e);
            }
            catch (Throwable throwable) {
                try {
                    this.close((Closeable)scanner);
                    this.close((Closeable)table);
                    RequestContext.get().endMetricRecord(metric);
                    throw throwable;
                }
                catch (AtlasException e2) {
                    throw new AtlasBaseException((Throwable)e2);
                }
            }
        }
        try {
            this.close((Closeable)scanner);
            this.close((Closeable)table);
            RequestContext.get().endMetricRecord(metric);
            return arrayList;
        }
        catch (AtlasException e) {
            throw new AtlasBaseException((Throwable)e);
        }
    }

    @Override
    public List<EntityAuditEventV2> listEventsV2(String entityId, EntityAuditEventV2.EntityAuditActionV2 auditAction, String sortByColumn, boolean sortOrderDesc, int offset, short limit) throws AtlasBaseException {
        return this.listEventsV2(entityId, auditAction, sortByColumn, sortOrderDesc, offset, limit, false, true, false, null);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private List<EntityAuditEventV2> listEventsV2(String entityId, EntityAuditEventV2.EntityAuditActionV2 auditAction, String sortByColumn, boolean sortOrderDesc, int offset, short limit, boolean isAgeoutTransaction, boolean createEventsAgeoutAllowed, boolean allowAgeoutByAuditCount, List<EntityAuditEventV2> eventsToKeep) throws AtlasBaseException {
        if (HBaseBasedAuditRepository.LOG.isDebugEnabled()) {
            HBaseBasedAuditRepository.LOG.debug("==> HBaseBasedAuditRepository.listEventsV2(entityId={}, auditAction={}, sortByColumn={}, sortOrderDesc={}, offset={}, limit={})", new Object[]{entityId, auditAction, sortByColumn, sortOrderDesc, offset, limit});
        }
        metric = RequestContext.get().startMetricRecord("listEventsV2");
        if (sortByColumn == null) {
            sortByColumn = "timestamp";
        }
        if (offset < 0) {
            offset = 0;
        }
        if (!isAgeoutTransaction && limit < 0) {
            limit = (short)100;
        }
        try {
            block41: {
                block38: {
                    block39: {
                        table = this.connection.getTable(this.tableName);
                        scan = new Scan().setReversed(true).setCaching(200).setSmall(true).setStopRow(Bytes.toBytes((String)entityId)).setStartRow(this.getKey(entityId, 0x7FFFFFFFFFFFFFFFL, 0x7FFFFFFF)).addColumn(HBaseBasedAuditRepository.COLUMN_FAMILY, HBaseBasedAuditRepository.COLUMN_ACTION).addColumn(HBaseBasedAuditRepository.COLUMN_FAMILY, HBaseBasedAuditRepository.COLUMN_USER);
                        filterList = new FilterList(new Filter[0]);
                        if (auditAction != null) {
                            filterAction = new SingleColumnValueFilter(HBaseBasedAuditRepository.COLUMN_FAMILY, HBaseBasedAuditRepository.COLUMN_ACTION, CompareFilter.CompareOp.EQUAL, (ByteArrayComparable)new BinaryComparator(Bytes.toBytes((String)auditAction.toString())));
                            filterList.addFilter((Filter)filterAction);
                        }
                        if (!createEventsAgeoutAllowed) {
                            createEventFilterList = new FilterList(FilterList.Operator.MUST_PASS_ALL);
                            filterByCreateActionType = new SingleColumnValueFilter(HBaseBasedAuditRepository.COLUMN_FAMILY, HBaseBasedAuditRepository.COLUMN_ACTION, CompareFilter.CompareOp.NOT_EQUAL, (ByteArrayComparable)new BinaryComparator(Bytes.toBytes((String)EntityAuditEventV2.EntityAuditActionV2.ENTITY_CREATE.toString())));
                            filterByImportCreateActionType = new SingleColumnValueFilter(HBaseBasedAuditRepository.COLUMN_FAMILY, HBaseBasedAuditRepository.COLUMN_ACTION, CompareFilter.CompareOp.NOT_EQUAL, (ByteArrayComparable)new BinaryComparator(Bytes.toBytes((String)EntityAuditEventV2.EntityAuditActionV2.ENTITY_IMPORT_CREATE.toString())));
                            createEventFilterList.addFilter((Filter)filterByCreateActionType);
                            createEventFilterList.addFilter((Filter)filterByImportCreateActionType);
                            filterList.addFilter((Filter)createEventFilterList);
                        }
                        scan.setFilter((Filter)filterList);
                        events = new ArrayList<EntityAuditEventV2>();
                        scanner = table.getScanner(scan);
                        try {
                            result = scanner.next();
                            while (result != null) {
                                event /* !! */  = this.fromKeyV2(result.getRow());
                                event /* !! */ .setUser(this.getResultString(result, HBaseBasedAuditRepository.COLUMN_USER));
                                event /* !! */ .setAction(EntityAuditEventV2.EntityAuditActionV2.fromString((String)this.getResultString(result, HBaseBasedAuditRepository.COLUMN_ACTION)));
                                events.add(event /* !! */ );
                                result = scanner.next();
                            }
                        }
                        finally {
                            if (scanner != null) {
                                scanner.close();
                            }
                        }
                        EntityAuditEventV2.sortEvents(events, (String)sortByColumn, (boolean)sortOrderDesc);
                        fromIndex = Math.min(events.size(), offset);
                        endIndex = events.size();
                        if (limit > 0) {
                            endIndex = Math.min(events.size(), offset + limit);
                        }
                        if (!isAgeoutTransaction) ** GOTO lbl63
                        if (allowAgeoutByAuditCount) break block38;
                        eventsToKeep.addAll(events);
                        event /* !! */  = Collections.emptyList();
                        if (table == null) break block39;
                        table.close();
                    }
                    return event /* !! */ ;
                }
                try {
                    eventsToKeep.addAll(events.subList(0, fromIndex));
lbl63:
                    // 2 sources

                    if ((events = events.subList(fromIndex, endIndex)).size() > 0) {
                        ranges = new ArrayList<E>();
                        events.forEach((Consumer<EntityAuditEventV2>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$listEventsV2$0(java.util.List org.apache.atlas.model.audit.EntityAuditEventV2 ), (Lorg/apache/atlas/model/audit/EntityAuditEventV2;)V)(ranges));
                        scan = new Scan().setReversed(true).setCaching(200).setSmall(true).setStopRow(Bytes.toBytes((String)entityId)).setStartRow(this.getKey(entityId, 0x7FFFFFFFFFFFFFFFL, 0x7FFFFFFF)).setFilter((Filter)new MultiRowRangeFilter(ranges));
                        scanner = table.getScanner(scan);
                        try {
                            events = new ArrayList<E>();
                            result = scanner.next();
                            while (result != null) {
                                event = this.fromKeyV2(result.getRow());
                                event.setUser(this.getResultString(result, HBaseBasedAuditRepository.COLUMN_USER));
                                event.setAction(EntityAuditEventV2.EntityAuditActionV2.fromString((String)this.getResultString(result, HBaseBasedAuditRepository.COLUMN_ACTION)));
                                event.setDetails(this.getResultString(result, HBaseBasedAuditRepository.COLUMN_DETAIL));
                                if (HBaseBasedAuditRepository.persistEntityDefinition && (colDef = this.getResultString(result, HBaseBasedAuditRepository.COLUMN_DEFINITION)) != null) {
                                    event.setEntityDefinition(colDef);
                                }
                                events.add(event);
                                result = scanner.next();
                            }
                        }
                        finally {
                            if (scanner != null) {
                                scanner.close();
                            }
                        }
                        EntityAuditEventV2.sortEvents(events, (String)sortByColumn, (boolean)sortOrderDesc);
                    }
                    if (HBaseBasedAuditRepository.LOG.isDebugEnabled()) {
                        HBaseBasedAuditRepository.LOG.debug("<== HBaseBasedAuditRepository.listEventsV2(entityId={}, auditAction={}, sortByColumn={}, sortOrderDesc={}, offset={}, limit={}): #records returned {}", new Object[]{entityId, auditAction, sortByColumn, sortOrderDesc, offset, limit, events.size()});
                    }
                    var18_24 = events;
                    if (table == null) break block41;
                }
                catch (Throwable var13_15) {
                    try {
                        if (table != null) {
                            try {
                                table.close();
                            }
                            catch (Throwable var14_17) {
                                var13_15.addSuppressed(var14_17);
                            }
                        }
                        throw var13_15;
                    }
                    catch (IOException e) {
                        throw new AtlasBaseException((Throwable)e);
                    }
                }
                table.close();
            }
            return var18_24;
        }
        finally {
            RequestContext.get().endMetricRecord(metric);
        }
    }

    @Override
    public List<Object> listEvents(String entityId, String startKey, short maxResults) throws AtlasBaseException {
        List<EntityAuditEventV2> ret = this.listEventsV2(entityId, null, startKey, maxResults);
        try {
            if (CollectionUtils.isEmpty(ret)) {
                ret = this.listEventsV1(entityId, startKey, maxResults);
            }
        }
        catch (AtlasException e) {
            throw new AtlasBaseException((Throwable)e);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<EntityAuditEventV2> deleteEventsV2(String entityId, Set<EntityAuditEventV2.EntityAuditActionV2> entityAuditActions, short allowedAuditCount, int ttlInDays, boolean createEventsAgeoutAllowed, Constants.AtlasAuditAgingType auditAgingType) throws AtlasBaseException, AtlasException {
        String SORT_BY_COLUMN = "timestamp";
        boolean SORT_ORDER_DESC = true;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> HBaseBasedAuditRepository.deleteEventsV2(entityId={}, auditActions={}, sortByColumn={}, sortOrderDesc={}, offset={}, limit={})", new Object[]{entityId, Arrays.toString(entityAuditActions.toArray()), "timestamp", true, allowedAuditCount, -1});
        }
        AtlasPerfMetrics.MetricRecorder metric = RequestContext.get().startMetricRecord("deleteEventsV2");
        Table table = null;
        ArrayList<EntityAuditEventV2> eventsEligibleForAgeout = new ArrayList<EntityAuditEventV2>();
        try {
            boolean allowAgeoutByAuditCount;
            table = this.connection.getTable(this.tableName);
            List<Object> eventsToKeep = new ArrayList<EntityAuditEventV2>();
            boolean bl = allowAgeoutByAuditCount = allowedAuditCount > 0 || auditAgingType == Constants.AtlasAuditAgingType.SWEEP;
            if (CollectionUtils.isEmpty(entityAuditActions)) {
                eventsEligibleForAgeout.addAll(this.listEventsV2(entityId, null, "timestamp", true, allowedAuditCount, (short)-1, true, createEventsAgeoutAllowed, allowAgeoutByAuditCount, eventsToKeep));
            } else {
                for (EntityAuditEventV2.EntityAuditActionV2 eachAuditAction : entityAuditActions) {
                    List<EntityAuditEventV2> eventsByEachAuditAction = this.listEventsV2(entityId, eachAuditAction, "timestamp", true, allowedAuditCount, (short)-1, true, createEventsAgeoutAllowed, allowAgeoutByAuditCount, eventsToKeep);
                    if (!CollectionUtils.isNotEmpty(eventsByEachAuditAction)) continue;
                    eventsEligibleForAgeout.addAll(eventsByEachAuditAction);
                }
            }
            if (CollectionUtils.isNotEmpty(eventsToKeep)) {
                if (allowAgeoutByAuditCount && (auditAgingType == Constants.AtlasAuditAgingType.DEFAULT || CollectionUtils.isEmpty(entityAuditActions))) {
                    LOG.debug("Aging out audit events by audit count for entity: {}", (Object)entityId);
                    EntityAuditEventV2.sortEvents(eventsToKeep, (String)"timestamp", (boolean)true);
                    if (allowedAuditCount < eventsToKeep.size()) {
                        eventsEligibleForAgeout.addAll(eventsToKeep.subList(allowedAuditCount, eventsToKeep.size()));
                        eventsToKeep = eventsToKeep.subList(0, allowedAuditCount);
                    }
                }
                LocalDateTime now = LocalDateTime.now();
                boolean isTTLTestAutomation = AtlasConfiguration.ATLAS_AUDIT_AGING_TTL_TEST_AUTOMATION.getBoolean();
                if (ttlInDays > 0) {
                    LOG.debug("Aging out audit events by TTL for entity: {}", (Object)entityId);
                    long ttlTimestamp = Timestamp.valueOf(isTTLTestAutomation ? now.minusMinutes(ttlInDays) : now.minusDays(ttlInDays)).getTime();
                    eventsToKeep.forEach(e -> {
                        if (e.getTimestamp() < ttlTimestamp) {
                            eventsEligibleForAgeout.add((EntityAuditEventV2)e);
                        }
                    });
                }
            }
            ArrayList<Delete> eventsToDelete = new ArrayList<Delete>();
            for (EntityAuditEventV2 event : eventsEligibleForAgeout) {
                Delete delete = new Delete(Bytes.toBytes((String)event.getEventKey()));
                eventsToDelete.add(delete);
            }
            if (CollectionUtils.isNotEmpty(eventsToDelete)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Deleting events from table:{} are {}", (Object)this.tableName, (Object)Arrays.toString(eventsToDelete.toArray()));
                }
                table.delete(eventsToDelete);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("<== HBaseBasedAuditRepository.deleteEventsV2(entityId={}, auditAction={}, sortByColumn={}, sortOrderDesc={}, offset={}, limit={}): ", new Object[]{entityId, Arrays.toString(entityAuditActions.toArray()), "timestamp", true, allowedAuditCount, -1});
            }
        }
        catch (IOException e2) {
            LOG.error("Failed deleting audit events for guid:{}", (Object)entityId);
        }
        finally {
            RequestContext.get().endMetricRecord(metric);
            this.close((Closeable)table);
        }
        return eventsEligibleForAgeout;
    }

    private <T> void addColumn(Put put, byte[] columnName, T columnValue) {
        if (columnValue != null && !columnValue.toString().isEmpty()) {
            put.addColumn(COLUMN_FAMILY, columnName, Bytes.toBytes((String)columnValue.toString()));
        }
    }

    private byte[] getKey(String id, Long ts) {
        assert (id != null) : "entity id can't be null";
        assert (ts != null) : "timestamp can't be null";
        String keyStr = id + FIELD_SEPARATOR + ts;
        return Bytes.toBytes((String)keyStr);
    }

    @Override
    public List<EntityAuditEvent> listEventsV1(String entityId, String startKey, short n) throws AtlasException {
        ArrayList<EntityAuditEvent> arrayList;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Listing events for entity id {}, starting timestamp {}, #records {}", new Object[]{entityId, startKey, n});
        }
        Table table = null;
        ResultScanner scanner = null;
        try {
            Result result;
            table = this.connection.getTable(this.tableName);
            Scan scan = new Scan().setReversed(true).setFilter((Filter)new PageFilter((long)n)).setStopRow(Bytes.toBytes((String)entityId)).setCaching((int)n).setSmall(true);
            if (StringUtils.isEmpty((String)startKey)) {
                byte[] entityBytes = this.getKey(entityId, Long.MAX_VALUE, Integer.MAX_VALUE);
                scan = scan.setStartRow(entityBytes);
            } else {
                scan = scan.setStartRow(Bytes.toBytes((String)startKey));
            }
            scanner = table.getScanner(scan);
            ArrayList<EntityAuditEvent> events = new ArrayList<EntityAuditEvent>();
            while ((result = scanner.next()) != null && events.size() < n) {
                String colDef;
                EntityAuditEvent event = this.fromKey(result.getRow());
                if (!event.getEntityId().equals(entityId)) continue;
                event.setUser(this.getResultString(result, COLUMN_USER));
                event.setAction(EntityAuditEvent.EntityAuditAction.fromString((String)this.getResultString(result, COLUMN_ACTION)));
                event.setDetails(this.getResultString(result, COLUMN_DETAIL));
                if (persistEntityDefinition && (colDef = this.getResultString(result, COLUMN_DEFINITION)) != null) {
                    event.setEntityDefinition(colDef);
                }
                events.add(event);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Got events for entity id {}, starting timestamp {}, #records {}", new Object[]{entityId, startKey, events.size()});
            }
            arrayList = events;
        }
        catch (IOException e) {
            try {
                throw new AtlasException((Throwable)e);
            }
            catch (Throwable throwable) {
                this.close((Closeable)scanner);
                this.close((Closeable)table);
                throw throwable;
            }
        }
        this.close((Closeable)scanner);
        this.close((Closeable)table);
        return arrayList;
    }

    @Override
    public long repositoryMaxSize() {
        this.initApplicationProperties();
        long ret = APPLICATION_PROPERTIES == null ? 0x100000L : APPLICATION_PROPERTIES.getLong(AUDIT_REPOSITORY_MAX_SIZE_PROPERTY, 0x100000L);
        return ret;
    }

    @Override
    public List<String> getAuditExcludeAttributes(String entityType) {
        List<String> ret = null;
        this.initApplicationProperties();
        if (this.auditExcludedAttributesCache.containsKey(entityType)) {
            ret = this.auditExcludedAttributesCache.get(entityType);
        } else if (APPLICATION_PROPERTIES != null) {
            String[] excludeAttributes = APPLICATION_PROPERTIES.getStringArray("atlas.audit.hbase.entity." + entityType + ".attributes.exclude");
            if (excludeAttributes != null) {
                ret = Arrays.asList(excludeAttributes);
            }
            this.auditExcludedAttributesCache.put(entityType, ret);
        }
        return ret;
    }

    private String getResultString(Result result, byte[] columnName) {
        byte[] rawValue = result.getValue(COLUMN_FAMILY, columnName);
        if (rawValue != null) {
            return Bytes.toString((byte[])rawValue);
        }
        return null;
    }

    private EntityAuditEvent fromKey(byte[] keyBytes) {
        String key = Bytes.toString((byte[])keyBytes);
        EntityAuditEvent event = new EntityAuditEvent();
        if (StringUtils.isNotEmpty((String)key)) {
            String[] parts = key.split(FIELD_SEPARATOR);
            event.setEntityId(parts[0]);
            event.setTimestamp(Long.valueOf(parts[1]).longValue());
            event.setEventKey(key);
        }
        return event;
    }

    private EntityAuditEventV2 fromKeyV2(byte[] keyBytes) {
        String key = Bytes.toString((byte[])keyBytes);
        EntityAuditEventV2 event = new EntityAuditEventV2();
        if (StringUtils.isNotEmpty((String)key)) {
            String[] parts = key.split(FIELD_SEPARATOR);
            event.setEntityId(parts[0]);
            event.setTimestamp(Long.valueOf(parts[1]).longValue());
            event.setEventKey(key);
        }
        return event;
    }

    private void close(Closeable closeable) throws AtlasException {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                throw new AtlasException((Throwable)e);
            }
        }
    }

    public static Configuration getHBaseConfiguration(org.apache.commons.configuration.Configuration atlasConf) throws AtlasException {
        Properties properties = ApplicationProperties.getSubsetAsProperties((org.apache.commons.configuration.Configuration)atlasConf, (String)CONFIG_PREFIX);
        Configuration hbaseConf = HBaseConfiguration.create();
        for (String key : properties.stringPropertyNames()) {
            String value = properties.getProperty(key);
            LOG.info("adding HBase configuration: {}={}", (Object)key, (Object)value);
            hbaseConf.set(key, value);
        }
        return hbaseConf;
    }

    private void createTableIfNotExists() throws AtlasException {
        Admin admin = null;
        try {
            admin = this.connection.getAdmin();
            LOG.info("Checking if table {} exists", (Object)this.tableName.getNameAsString());
            if (!admin.tableExists(this.tableName)) {
                LOG.info("Creating table {}", (Object)this.tableName.getNameAsString());
                HTableDescriptor tableDescriptor = new HTableDescriptor(this.tableName);
                HColumnDescriptor columnFamily = new HColumnDescriptor(COLUMN_FAMILY);
                columnFamily.setMaxVersions(1);
                columnFamily.setDataBlockEncoding(DataBlockEncoding.FAST_DIFF);
                columnFamily.setCompressionType(Compression.Algorithm.valueOf((String)this.compressionType));
                columnFamily.setBloomFilterType(BloomType.ROW);
                tableDescriptor.addFamily(columnFamily);
                admin.createTable((TableDescriptor)tableDescriptor);
            } else {
                LOG.info("Table {} exists", (Object)this.tableName.getNameAsString());
            }
        }
        catch (IOException e) {
            throw new AtlasException((Throwable)e);
        }
        finally {
            this.close((Closeable)admin);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Set<String> getEntitiesWithTagChanges(long fromTimestamp, long toTimestamp) throws AtlasBaseException {
        HashSet<String> hashSet;
        String classificationUpdatesAction = "CLASSIFICATION_";
        if (LOG.isDebugEnabled()) {
            LOG.debug("Listing events for fromTimestamp {}, toTimestamp {}, action {}", (Object)fromTimestamp, (Object)toTimestamp);
        }
        Table table = null;
        ResultScanner scanner = null;
        try {
            Result result;
            HashSet<String> guids = new HashSet<String>();
            table = this.connection.getTable(this.tableName);
            byte[] filterValue = Bytes.toBytes((String)"CLASSIFICATION_");
            BinaryPrefixComparator binaryPrefixComparator = new BinaryPrefixComparator(filterValue);
            SingleColumnValueFilter filter = new SingleColumnValueFilter(COLUMN_FAMILY, COLUMN_ACTION, CompareFilter.CompareOp.EQUAL, (ByteArrayComparable)binaryPrefixComparator);
            Scan scan = new Scan().setFilter((Filter)filter).setTimeRange(fromTimestamp, toTimestamp);
            scanner = table.getScanner(scan);
            while ((result = scanner.next()) != null) {
                EntityAuditEvent event = this.fromKey(result.getRow());
                if (event == null) continue;
                guids.add(event.getEntityId());
            }
            hashSet = guids;
        }
        catch (IOException e) {
            try {
                throw new AtlasBaseException((Throwable)e);
            }
            catch (Throwable throwable) {
                try {
                    this.close((Closeable)scanner);
                    this.close((Closeable)table);
                    throw throwable;
                }
                catch (AtlasException e2) {
                    throw new AtlasBaseException((Throwable)e2);
                }
            }
        }
        try {
            this.close((Closeable)scanner);
            this.close((Closeable)table);
            return hashSet;
        }
        catch (AtlasException e) {
            throw new AtlasBaseException((Throwable)e);
        }
    }

    public void start() throws AtlasException {
        org.apache.commons.configuration.Configuration configuration = ApplicationProperties.get();
        this.startInternal(configuration, HBaseBasedAuditRepository.getHBaseConfiguration(configuration));
    }

    @VisibleForTesting
    void startInternal(org.apache.commons.configuration.Configuration atlasConf, Configuration hbaseConf) throws AtlasException {
        String tableNameStr = atlasConf.getString(CONFIG_TABLE_NAME, DEFAULT_TABLE_NAME);
        this.tableName = TableName.valueOf((String)tableNameStr);
        this.compressionType = atlasConf.getString(CONFIG_COMPRESSION_ALGORITHM, atlasConf.getString(HBASE_STORE_COMPRESSION_PROPERTY, "GZ"));
        try {
            this.connection = this.createConnection(hbaseConf);
        }
        catch (IOException e) {
            throw new AtlasException((Throwable)e);
        }
        if (!HAConfiguration.isHAEnabled((org.apache.commons.configuration.Configuration)atlasConf)) {
            LOG.info("HA is disabled. Hence creating table on startup.");
            this.createTableIfNotExists();
        }
    }

    @VisibleForTesting
    protected Connection createConnection(Configuration hbaseConf) throws IOException {
        return ConnectionFactory.createConnection((Configuration)hbaseConf);
    }

    public void stop() throws AtlasException {
        this.close((Closeable)this.connection);
    }

    @Override
    public void instanceIsActive() throws AtlasException {
        LOG.info("Reacting to active: Creating HBase table for Audit if required.");
        this.createTableIfNotExists();
    }

    @Override
    public void instanceIsPassive() {
        LOG.info("Reacting to passive: No action for now.");
    }

    @Override
    public int getHandlerOrder() {
        return ActiveStateChangeHandler.HandlerOrder.AUDIT_REPOSITORY.getOrder();
    }

    private static /* synthetic */ void lambda$listEventsV2$0(List ranges, EntityAuditEventV2 e) {
        ranges.add(new MultiRowRangeFilter.RowRange(e.getEventKey(), true, e.getEventKey(), true));
    }

    static {
        try {
            persistEntityDefinition = ApplicationProperties.get().getBoolean(CONFIG_PERSIST_ENTITY_DEFINITION, false);
        }
        catch (AtlasException e) {
            throw new RuntimeException(e);
        }
    }
}

