/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.audit;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.apache.atlas.ApplicationProperties;
import org.apache.atlas.AtlasConfiguration;
import org.apache.atlas.AtlasException;
import org.apache.atlas.discovery.AtlasDiscoveryService;
import org.apache.atlas.model.audit.AuditReductionCriteria;
import org.apache.atlas.model.audit.EntityAuditEventV2;
import org.apache.atlas.model.tasks.AtlasTask;
import org.apache.atlas.repository.Constants;
import org.apache.atlas.repository.graphdb.AtlasGraph;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.SchedulingConfigurer;
import org.springframework.scheduling.config.IntervalTask;
import org.springframework.scheduling.config.ScheduledTaskRegistrar;
import org.springframework.stereotype.Component;

@Component
public class AtlasAuditReductionService
implements SchedulingConfigurer {
    private static final Logger LOG = LoggerFactory.getLogger(AtlasAuditReductionService.class);
    private final AtlasGraph graph;
    private final AtlasDiscoveryService discoveryService;
    private final AtlasTypeRegistry typeRegistry;
    private static final String VALUE_DELIMITER = ",";
    private static final String ATLAS_AUDIT_SWEEP_OUT_ENTITY_TYPES = "atlas.audit.sweep.out.entity.types";
    private static final String ATLAS_AUDIT_SWEEP_OUT_ACTION_TYPES = "atlas.audit.sweep.out.action.types";
    private static final String ATLAS_AUDIT_CUSTOM_AGEOUT_ENTITY_TYPES = "atlas.audit.custom.ageout.entity.types";
    private static final String ATLAS_AUDIT_CUSTOM_AGEOUT_ACTION_TYPES = "atlas.audit.custom.ageout.action.types";
    private static final String ATLAS_AUDIT_AGING_SCHEDULER_INITIAL_DELAY = "atlas.audit.aging.scheduler.initial.delay.in.min";
    private static final int MIN_TTL_TO_MAINTAIN = AtlasConfiguration.MIN_TTL_TO_MAINTAIN.getInt();
    private static final int MIN_AUDIT_COUNT_TO_MAINTAIN = AtlasConfiguration.MIN_AUDIT_COUNT_TO_MAINTAIN.getInt();
    private Configuration atlasConfiguration;
    private AuditReductionCriteria ageoutCriteriaByConfig;
    private List<Map<String, Object>> ageoutTypeCriteriaMap;

    @Inject
    public AtlasAuditReductionService(Configuration config, AtlasGraph graph, AtlasDiscoveryService discoveryService, AtlasTypeRegistry typeRegistry) {
        this.atlasConfiguration = config;
        this.graph = graph;
        this.discoveryService = discoveryService;
        this.typeRegistry = typeRegistry;
    }

    public List<AtlasTask> startAuditAgingByConfig() {
        List<AtlasTask> tasks = null;
        try {
            if (this.ageoutCriteriaByConfig == null) {
                this.ageoutCriteriaByConfig = this.convertConfigToAuditReductionCriteria();
                LOG.info("Audit aging is enabled by configuration");
            }
            LOG.info("Audit aging is triggered with configuration: {}", (Object)this.ageoutCriteriaByConfig.toString());
            if (this.ageoutTypeCriteriaMap == null) {
                this.ageoutTypeCriteriaMap = this.buildAgeoutCriteriaForAllAgingTypes(this.ageoutCriteriaByConfig);
            }
            tasks = this.startAuditAgingByCriteria(this.ageoutTypeCriteriaMap);
        }
        catch (Exception e) {
            LOG.error("Error while aging out audits by configuration: ", (Throwable)e);
        }
        return tasks;
    }

    public List<AtlasTask> startAuditAgingByCriteria(List<Map<String, Object>> ageoutTypeCriteriaMap) {
        if (CollectionUtils.isEmpty(ageoutTypeCriteriaMap)) {
            return null;
        }
        ArrayList<AtlasTask> tasks = new ArrayList<AtlasTask>();
        try {
            for (Map<String, Object> eachCriteria : ageoutTypeCriteriaMap) {
                AtlasTask auditAgingTask = this.discoveryService.createAndQueueAuditReductionTask(eachCriteria, "AUDIT_REDUCTION_ENTITY_RETRIEVAL");
                if (auditAgingTask == null) continue;
                tasks.add(auditAgingTask);
            }
        }
        catch (Exception e) {
            LOG.error("Error while aging out audits by criteria: ", (Throwable)e);
        }
        return tasks;
    }

    private AuditReductionCriteria convertConfigToAuditReductionCriteria() {
        boolean auditAgingEnabled = AtlasConfiguration.ATLAS_AUDIT_AGING_ENABLED.getBoolean();
        boolean createAuditsAgeoutAllowed = AtlasConfiguration.ATLAS_AUDIT_CREATE_EVENTS_AGEOUT_ALLOWED.getBoolean();
        boolean subTypesIncluded = AtlasConfiguration.ATLAS_AUDIT_AGING_SUBTYPES_INCLUDED.getBoolean();
        boolean ignoreDefaultAgeoutTTL = AtlasConfiguration.ATLAS_AUDIT_DEFAULT_AGEOUT_IGNORE_TTL.getBoolean();
        int defaultAgeoutTTLConfigured = AtlasConfiguration.ATLAS_AUDIT_DEFAULT_AGEOUT_TTL.getInt();
        int defaultAgeoutAuditCountConfigured = AtlasConfiguration.ATLAS_AUDIT_DEFAULT_AGEOUT_COUNT.getInt();
        int customAgeoutTTLConfigured = AtlasConfiguration.ATLAS_AUDIT_CUSTOM_AGEOUT_TTL.getInt();
        int customAgeoutAuditCountConfigured = AtlasConfiguration.ATLAS_AUDIT_CUSTOM_AGEOUT_COUNT.getInt();
        boolean defaultAgeoutEnabled = AtlasConfiguration.ATLAS_AUDIT_DEFAULT_AGEOUT_ENABLED.getBoolean();
        int defaultAgeoutTTL = this.getGuaranteedMinValueOf(AtlasConfiguration.ATLAS_AUDIT_DEFAULT_AGEOUT_TTL, defaultAgeoutTTLConfigured, MIN_TTL_TO_MAINTAIN);
        int defaultAgeoutAuditCount = defaultAgeoutAuditCountConfigured <= 0 ? defaultAgeoutAuditCountConfigured : this.getGuaranteedMinValueOf(AtlasConfiguration.ATLAS_AUDIT_DEFAULT_AGEOUT_COUNT, defaultAgeoutAuditCountConfigured, MIN_AUDIT_COUNT_TO_MAINTAIN);
        int customAgeoutTTL = customAgeoutTTLConfigured <= 0 ? customAgeoutTTLConfigured : this.getGuaranteedMinValueOf(AtlasConfiguration.ATLAS_AUDIT_CUSTOM_AGEOUT_TTL, customAgeoutTTLConfigured, MIN_TTL_TO_MAINTAIN);
        int customAgeoutAuditCount = customAgeoutAuditCountConfigured <= 0 ? customAgeoutAuditCountConfigured : this.getGuaranteedMinValueOf(AtlasConfiguration.ATLAS_AUDIT_CUSTOM_AGEOUT_COUNT, customAgeoutAuditCountConfigured, MIN_AUDIT_COUNT_TO_MAINTAIN);
        String customAgeoutEntityTypes = this.getStringOf(ATLAS_AUDIT_CUSTOM_AGEOUT_ENTITY_TYPES);
        String customAgeoutActionTypes = this.getStringOf(ATLAS_AUDIT_CUSTOM_AGEOUT_ACTION_TYPES);
        AuditReductionCriteria auditReductionCriteria = new AuditReductionCriteria();
        auditReductionCriteria.setAuditAgingEnabled(auditAgingEnabled);
        auditReductionCriteria.setCreateEventsAgeoutAllowed(createAuditsAgeoutAllowed);
        auditReductionCriteria.setSubTypesIncluded(subTypesIncluded);
        auditReductionCriteria.setIgnoreDefaultAgeoutTTL(ignoreDefaultAgeoutTTL);
        auditReductionCriteria.setDefaultAgeoutEnabled(defaultAgeoutEnabled);
        auditReductionCriteria.setDefaultAgeoutTTLInDays(defaultAgeoutTTL);
        auditReductionCriteria.setDefaultAgeoutAuditCount(defaultAgeoutAuditCount);
        auditReductionCriteria.setCustomAgeoutTTLInDays(customAgeoutTTL);
        auditReductionCriteria.setCustomAgeoutAuditCount(customAgeoutAuditCount);
        auditReductionCriteria.setCustomAgeoutEntityTypes(customAgeoutEntityTypes);
        auditReductionCriteria.setCustomAgeoutActionTypes(customAgeoutActionTypes);
        boolean isSweepOutEnabled = AtlasConfiguration.ATLAS_AUDIT_SWEEP_OUT.getBoolean();
        auditReductionCriteria.setAuditSweepoutEnabled(isSweepOutEnabled);
        if (isSweepOutEnabled) {
            String sweepoutEntityTypes = this.getStringOf(ATLAS_AUDIT_SWEEP_OUT_ENTITY_TYPES);
            String sweepoutActionTypes = this.getStringOf(ATLAS_AUDIT_SWEEP_OUT_ACTION_TYPES);
            auditReductionCriteria.setSweepoutEntityTypes(sweepoutEntityTypes);
            auditReductionCriteria.setSweepoutActionTypes(sweepoutActionTypes);
        }
        return auditReductionCriteria;
    }

    public List<Map<String, Object>> buildAgeoutCriteriaForAllAgingTypes(AuditReductionCriteria auditReductionCriteria) {
        boolean isSweepOutEnabled;
        if (auditReductionCriteria == null || !auditReductionCriteria.isAuditAgingEnabled()) {
            return null;
        }
        ArrayList<Map<String, Object>> auditAgeoutCriteriaByType = new ArrayList<Map<String, Object>>();
        HashSet<String> defaultAgeoutEntityTypesToExclude = new HashSet<String>();
        Set<String> defaultAgeoutActionTypes = Arrays.stream(EntityAuditEventV2.EntityAuditActionV2.values()).map(x -> x.toString()).collect(Collectors.toSet());
        boolean createEventsAgeoutAllowed = auditReductionCriteria.isCreateEventsAgeoutAllowed();
        boolean subTypesIncluded = auditReductionCriteria.isSubTypesIncluded();
        boolean ignoreDefaultAgeoutTTL = auditReductionCriteria.ignoreDefaultAgeoutTTL();
        boolean defaultAgeoutEnabled = auditReductionCriteria.isDefaultAgeoutEnabled();
        int defaultAgeoutTTL = ignoreDefaultAgeoutTTL ? 0 : this.getGuaranteedMinValueOf(AtlasConfiguration.ATLAS_AUDIT_DEFAULT_AGEOUT_TTL, auditReductionCriteria.getDefaultAgeoutTTLInDays(), MIN_TTL_TO_MAINTAIN);
        int defaultAgeoutAuditCount = auditReductionCriteria.getDefaultAgeoutAuditCount() <= 0 ? auditReductionCriteria.getDefaultAgeoutAuditCount() : this.getGuaranteedMinValueOf(AtlasConfiguration.ATLAS_AUDIT_DEFAULT_AGEOUT_COUNT, auditReductionCriteria.getDefaultAgeoutAuditCount(), MIN_AUDIT_COUNT_TO_MAINTAIN);
        int customAgeoutTTL = auditReductionCriteria.getCustomAgeoutTTLInDays() <= 0 ? auditReductionCriteria.getCustomAgeoutTTLInDays() : this.getGuaranteedMinValueOf(AtlasConfiguration.ATLAS_AUDIT_CUSTOM_AGEOUT_TTL, auditReductionCriteria.getCustomAgeoutTTLInDays(), MIN_TTL_TO_MAINTAIN);
        int customAgeoutAuditCount = auditReductionCriteria.getCustomAgeoutAuditCount() <= 0 ? auditReductionCriteria.getCustomAgeoutAuditCount() : this.getGuaranteedMinValueOf(AtlasConfiguration.ATLAS_AUDIT_CUSTOM_AGEOUT_COUNT, auditReductionCriteria.getCustomAgeoutAuditCount(), MIN_AUDIT_COUNT_TO_MAINTAIN);
        Set<String> customAgeoutEntityTypes = this.getUniqueListOf(auditReductionCriteria.getCustomAgeoutEntityTypes());
        Set<String> customAgeoutActionTypes = this.getValidActionTypes(Constants.AtlasAuditAgingType.CUSTOM, this.getUniqueListOf(auditReductionCriteria.getCustomAgeoutActionTypes()));
        defaultAgeoutEntityTypesToExclude.addAll(customAgeoutEntityTypes);
        if (CollectionUtils.isEmpty(customAgeoutEntityTypes)) {
            defaultAgeoutActionTypes.removeAll(customAgeoutActionTypes);
        }
        if (isSweepOutEnabled = auditReductionCriteria.isAuditSweepoutEnabled()) {
            Set<String> sweepOutEntityTypes = this.getUniqueListOf(auditReductionCriteria.getSweepoutEntityTypes());
            Set<String> sweepOutActionTypes = this.getValidActionTypes(Constants.AtlasAuditAgingType.SWEEP, this.getUniqueListOf(auditReductionCriteria.getSweepoutActionTypes()));
            if (CollectionUtils.isNotEmpty(sweepOutEntityTypes) || CollectionUtils.isNotEmpty(sweepOutActionTypes)) {
                Map<String, Object> sweepAgeoutCriteria = this.getAgeoutCriteriaMap(Constants.AtlasAuditAgingType.SWEEP, 0, 0, sweepOutEntityTypes, sweepOutActionTypes, createEventsAgeoutAllowed, subTypesIncluded);
                auditAgeoutCriteriaByType.add(sweepAgeoutCriteria);
            } else {
                LOG.error("Sweepout of audits is skipped.At least one of two properties: entity types/action types should be configured.");
            }
            defaultAgeoutEntityTypesToExclude.addAll(sweepOutEntityTypes);
            customAgeoutEntityTypes.removeAll(sweepOutEntityTypes);
            if (CollectionUtils.isEmpty(sweepOutEntityTypes)) {
                defaultAgeoutActionTypes.removeAll(sweepOutActionTypes);
                customAgeoutActionTypes.removeAll(sweepOutActionTypes);
            }
        }
        if ((customAgeoutTTL > 0 || customAgeoutAuditCount > 0) && (CollectionUtils.isNotEmpty(customAgeoutEntityTypes) || CollectionUtils.isNotEmpty(customAgeoutActionTypes))) {
            Map<String, Object> customAgeoutCriteria = this.getAgeoutCriteriaMap(Constants.AtlasAuditAgingType.CUSTOM, customAgeoutTTL, customAgeoutAuditCount, customAgeoutEntityTypes, customAgeoutActionTypes, createEventsAgeoutAllowed, subTypesIncluded);
            auditAgeoutCriteriaByType.add(customAgeoutCriteria);
        } else if (customAgeoutTTL > 0 || customAgeoutAuditCount > 0 || !CollectionUtils.isEmpty(customAgeoutEntityTypes) || !CollectionUtils.isEmpty(customAgeoutActionTypes)) {
            if (customAgeoutTTL <= 0 && customAgeoutAuditCount <= 0) {
                LOG.error("Custom Audit aging is skipped.At least one of two properties: TTL/Audit Count should be configured.");
            } else {
                LOG.error("Custom Audit aging is skipped.At least one of two properties: entity types/action types should be configured.");
            }
        }
        if (defaultAgeoutEnabled) {
            if (ignoreDefaultAgeoutTTL) {
                LOG.info("'{}' config property or 'ignoreDefaultAgeoutTTL' property in API configured as: {}, Default audit aging will be done by audit count only", (Object)AtlasConfiguration.ATLAS_AUDIT_DEFAULT_AGEOUT_IGNORE_TTL.getPropertyName(), (Object)ignoreDefaultAgeoutTTL);
            }
            if (defaultAgeoutActionTypes.size() == EntityAuditEventV2.EntityAuditActionV2.values().length) {
                defaultAgeoutActionTypes.clear();
            }
            if (!ignoreDefaultAgeoutTTL || defaultAgeoutAuditCount > 0) {
                Map<String, Object> defaultAgeoutCriteria = this.getAgeoutCriteriaMap(Constants.AtlasAuditAgingType.DEFAULT, defaultAgeoutTTL, defaultAgeoutAuditCount, defaultAgeoutEntityTypesToExclude, defaultAgeoutActionTypes, createEventsAgeoutAllowed, subTypesIncluded);
                auditAgeoutCriteriaByType.add(defaultAgeoutCriteria);
            } else {
                LOG.error("Default Audit aging is skipped. Valid audit count should be configured when TTL criteria is ignored.");
            }
        }
        return auditAgeoutCriteriaByType;
    }

    private Map<String, Object> getAgeoutCriteriaMap(Constants.AtlasAuditAgingType agingOption, int ttl, int minCount, Set<String> entityTypes, Set<String> actionTypes, boolean createEventsAgeoutAllowed, boolean subTypesIncluded) {
        HashMap<String, Object> auditAgingOptions = new HashMap<String, Object>();
        auditAgingOptions.put("auditAgingType", agingOption);
        auditAgingOptions.put("ttl", ttl);
        auditAgingOptions.put("auditCount", minCount);
        auditAgingOptions.put("entityTypes", entityTypes);
        auditAgingOptions.put("actionTypes", actionTypes);
        auditAgingOptions.put("createEventsAgeoutAllowed", createEventsAgeoutAllowed);
        auditAgingOptions.put("subTypesIncluded", subTypesIncluded);
        return auditAgingOptions;
    }

    private int getGuaranteedMinValueOf(AtlasConfiguration configuration, int configuredValue, int minValueToMaintain) {
        if (configuredValue < minValueToMaintain) {
            LOG.info("Minimum value for '{}' should be {}", (Object)configuration.getPropertyName(), (Object)minValueToMaintain);
        }
        return configuredValue < minValueToMaintain ? minValueToMaintain : configuredValue;
    }

    private String getStringOf(String configProperty) {
        String configuredValue = null;
        if (StringUtils.isNotEmpty((String)configProperty)) {
            configuredValue = String.join((CharSequence)VALUE_DELIMITER, this.atlasConfiguration.getList(configProperty));
        }
        return configuredValue;
    }

    private Set<String> getUniqueListOf(String value) {
        Set<Object> configuredValues = null;
        if (StringUtils.isNotEmpty((String)value)) {
            configuredValues = Stream.of(value.split(VALUE_DELIMITER)).map(String::trim).collect(Collectors.toSet());
        }
        return configuredValues == null ? new HashSet() : configuredValues;
    }

    private Set<String> getValidActionTypes(Constants.AtlasAuditAgingType auditAgingType, Set<String> actionTypes) {
        if (CollectionUtils.isEmpty(actionTypes)) {
            return Collections.emptySet();
        }
        Set allActionTypes = Arrays.stream(EntityAuditEventV2.EntityAuditActionV2.values()).map(x -> x.toString()).collect(Collectors.toSet());
        HashSet<String> entityAuditActions = new HashSet<String>();
        HashSet<String> invalidActionTypes = new HashSet<String>();
        for (String actionType : actionTypes) {
            String actionTypeToMatch = actionType.contains("*") ? actionType.replace("*", "") : actionType;
            Set matchedActionTypes = actionTypeToMatch.startsWith("*") ? allActionTypes.stream().filter(x -> x.contains(actionTypeToMatch)).collect(Collectors.toSet()) : allActionTypes.stream().filter(x -> x.startsWith(actionTypeToMatch)).collect(Collectors.toSet());
            if (CollectionUtils.isEmpty(matchedActionTypes)) {
                invalidActionTypes.add(actionType);
                continue;
            }
            entityAuditActions.addAll(matchedActionTypes);
        }
        if (CollectionUtils.isNotEmpty(actionTypes) && CollectionUtils.isEmpty(entityAuditActions)) {
            throw new IllegalArgumentException("No enum constant " + EntityAuditEventV2.EntityAuditActionV2.class.getCanonicalName() + "." + String.join((CharSequence)VALUE_DELIMITER, invalidActionTypes));
        }
        LOG.info("Action type name(s) {} provided for aging type-{}", (Object)String.join((CharSequence)VALUE_DELIMITER, entityAuditActions), (Object)auditAgingType);
        if (CollectionUtils.isNotEmpty(invalidActionTypes)) {
            LOG.warn("Invalid action type name(s) {} provided for aging type-{}", (Object)String.join((CharSequence)VALUE_DELIMITER, invalidActionTypes), (Object)auditAgingType);
        }
        return entityAuditActions;
    }

    public void configureTasks(ScheduledTaskRegistrar taskRegistrar) {
        if (!AtlasConfiguration.ATLAS_AUDIT_AGING_ENABLED.getBoolean()) {
            LOG.warn("Audit aging is not enabled");
            return;
        }
        IntervalTask task = new IntervalTask(new Runnable(){

            @Override
            public void run() {
                AtlasAuditReductionService.this.startAuditAgingByConfig();
            }
        }, this.getAuditAgingFrequencyInMillis(), this.getAuditAgingInitialDelayInMillis());
        taskRegistrar.addFixedRateTask(task);
    }

    private long getAuditAgingFrequencyInMillis() {
        int frequencyInDays = this.getGuaranteedMinValueOf(AtlasConfiguration.ATLAS_AUDIT_AGING_SCHEDULER_FREQUENCY, AtlasConfiguration.ATLAS_AUDIT_AGING_SCHEDULER_FREQUENCY.getInt(), 1);
        return (long)frequencyInDays * 86400000L;
    }

    private long getAuditAgingInitialDelayInMillis() {
        int initialDelayInMins = 1;
        try {
            initialDelayInMins = ApplicationProperties.get().getInt(ATLAS_AUDIT_AGING_SCHEDULER_INITIAL_DELAY, 1);
        }
        catch (AtlasException ex) {
            LOG.error("Error while fetching application properties", (Throwable)ex);
        }
        return (long)(initialDelayInMins < 1 ? 1 : initialDelayInMins) * 60000L;
    }
}

