/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.query.executors;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.atlas.AtlasConfiguration;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.discovery.AtlasSearchResult;
import org.apache.atlas.query.AtlasDSL;
import org.apache.atlas.query.GremlinQuery;
import org.apache.atlas.query.QueryParams;
import org.apache.atlas.query.executors.DSLQueryExecutor;
import org.apache.atlas.query.executors.GremlinClauseToTraversalTranslator;
import org.apache.atlas.query.executors.SelectClauseProjections;
import org.apache.atlas.repository.graphdb.AtlasGraph;
import org.apache.atlas.repository.graphdb.AtlasGraphTraversal;
import org.apache.atlas.repository.graphdb.AtlasVertex;
import org.apache.atlas.repository.store.graph.v2.EntityGraphRetriever;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.atlas.utils.LruCache;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TraversalBasedExecutor
implements DSLQueryExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(TraversalBasedExecutor.class);
    private static final String DSL_KEYWORD_LIMIT = "limit";
    private static final String DSL_KEYWORD_OFFSET = "offset";
    private static final String DEFAULT_LIMIT_OFFSET_TEMPLATE = " limit %d offset %d";
    private static final Translator translator = AtlasConfiguration.DSL_CACHED_TRANSLATOR.getBoolean() ? new CachedTranslator() : new Translator();
    private final AtlasTypeRegistry typeRegistry;
    private final AtlasGraph graph;
    private final EntityGraphRetriever entityRetriever;

    public TraversalBasedExecutor(AtlasTypeRegistry typeRegistry, AtlasGraph graph, EntityGraphRetriever entityRetriever) {
        this.typeRegistry = typeRegistry;
        this.graph = graph;
        this.entityRetriever = entityRetriever;
    }

    @Override
    public AtlasSearchResult execute(String dslQuery, int limit, int offset) throws AtlasBaseException {
        List resultList;
        AtlasSearchResult ret = new AtlasSearchResult(dslQuery, AtlasSearchResult.AtlasQueryType.DSL);
        GremlinQuery gremlinQuery = this.toTraversal(dslQuery, limit, offset);
        AtlasGraphTraversal graphTraversal = gremlinQuery.getTraversal();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Executing DSL: query={}, gremlinQuery={}", (Object)dslQuery, (Object)graphTraversal.toString());
        }
        return CollectionUtils.isNotEmpty((Collection)(resultList = graphTraversal.getAtlasVertexList())) ? this.getSearchResult(ret, gremlinQuery, resultList) : this.getSearchResult(ret, gremlinQuery, graphTraversal.getAtlasVertexMap());
    }

    private AtlasSearchResult getSearchResult(AtlasSearchResult ret, GremlinQuery gremlinQuery, List<AtlasVertex> resultList) throws AtlasBaseException {
        return gremlinQuery.hasValidSelectClause() ? SelectClauseProjections.usingList(gremlinQuery, this.entityRetriever, resultList) : this.processVertices(ret, resultList);
    }

    private AtlasSearchResult getSearchResult(AtlasSearchResult ret, GremlinQuery gremlinQuery, Map<String, Collection<AtlasVertex>> resultMap) throws AtlasBaseException {
        if (MapUtils.isEmpty(resultMap)) {
            return ret;
        }
        if (gremlinQuery.hasValidSelectClause()) {
            return SelectClauseProjections.usingMap(gremlinQuery, this.entityRetriever, resultMap);
        }
        for (Collection<AtlasVertex> vertices : resultMap.values()) {
            this.processVertices(ret, vertices);
        }
        return ret;
    }

    private AtlasSearchResult processVertices(AtlasSearchResult ret, Collection<AtlasVertex> vertices) throws AtlasBaseException {
        for (AtlasVertex vertex : vertices) {
            if (vertex == null) continue;
            ret.addEntity(this.entityRetriever.toAtlasEntityHeaderWithClassifications(vertex));
        }
        return ret;
    }

    private GremlinQuery toTraversal(String query, int limit, int offset) throws AtlasBaseException {
        GremlinQuery gremlinQuery = translator.translate(this.typeRegistry, query, limit, offset);
        AtlasGraphTraversal result = GremlinClauseToTraversalTranslator.run(this.graph, gremlinQuery.getClauses());
        gremlinQuery.setResult(result);
        return gremlinQuery;
    }

    private static class Translator {
        public GremlinQuery translate(AtlasTypeRegistry typeRegistry, String query, int limit, int offset) throws AtlasBaseException {
            QueryParams params = QueryParams.getNormalizedParams(limit, offset);
            query = this.getStringWithLimitOffset(query, params);
            AtlasDSL.Translator dslTranslator = new AtlasDSL.Translator(query, typeRegistry, params.offset(), params.limit());
            GremlinQuery gremlinQuery = dslTranslator.translate();
            return gremlinQuery;
        }

        private String getStringWithLimitOffset(String query, QueryParams params) {
            if (!query.contains(TraversalBasedExecutor.DSL_KEYWORD_LIMIT) && !query.contains(TraversalBasedExecutor.DSL_KEYWORD_OFFSET)) {
                query = query + String.format(TraversalBasedExecutor.DEFAULT_LIMIT_OFFSET_TEMPLATE, params.limit(), params.offset());
            }
            return query;
        }
    }

    private static class CachedTranslator
    extends Translator {
        private static final int DSLQUERY_CACHE_SIZE = 100;
        private final Map<String, GremlinQuery> cachedQuery = new LruCache(100, 100000);

        @Override
        public GremlinQuery translate(AtlasTypeRegistry typeRegistry, String query, int limit, int offset) throws AtlasBaseException {
            String key = String.format("%s-%s-%s", query, limit, offset);
            if (!this.cachedQuery.containsKey(key)) {
                GremlinQuery gremlinQuery = super.translate(typeRegistry, query, limit, offset);
                this.cachedQuery.put(key, gremlinQuery);
            }
            return this.cachedQuery.get(key);
        }
    }
}

