/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.entitytransform;

import java.util.Arrays;
import java.util.List;
import org.apache.atlas.entitytransform.AtlasEntityTransformer;
import org.apache.atlas.entitytransform.BaseEntityHandler;
import org.apache.atlas.entitytransform.EntityAttribute;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.commons.lang.StringUtils;

public class HiveStorageDescriptorEntityHandler
extends BaseEntityHandler {
    static final List<String> CUSTOM_TRANSFORM_ATTRIBUTES = Arrays.asList("hive_db.name", "hive_table.name", "hive_db.clusterName", "hive_storagedesc.location");

    public HiveStorageDescriptorEntityHandler(List<AtlasEntityTransformer> transformers) {
        super(transformers);
    }

    @Override
    public BaseEntityHandler.AtlasTransformableEntity getTransformableEntity(AtlasEntity entity) {
        return this.isHiveStorageDescEntity(entity) ? new HiveStorageDescriptorEntity(entity) : null;
    }

    private boolean isHiveStorageDescEntity(AtlasEntity entity) {
        return StringUtils.equals((String)entity.getTypeName(), (String)"hive_storagedesc");
    }

    public static class HiveStorageDescriptorEntity
    extends BaseEntityHandler.AtlasTransformableEntity {
        private String databaseName;
        private String tableName;
        private String clusterName;
        private String location;
        private boolean isCustomAttributeUpdated = false;

        public HiveStorageDescriptorEntity(AtlasEntity entity) {
            super(entity);
            this.location = (String)entity.getAttribute("location");
            String qualifiedName = (String)entity.getAttribute("qualifiedName");
            if (qualifiedName != null) {
                int idx;
                int databaseSeparatorIdx = qualifiedName.indexOf(46);
                int clusterSeparatorIdx = qualifiedName.lastIndexOf(64);
                String clusterNameWithSuffix = clusterSeparatorIdx != -1 ? qualifiedName.substring(clusterSeparatorIdx + 1) : "";
                this.databaseName = databaseSeparatorIdx != -1 ? qualifiedName.substring(0, databaseSeparatorIdx) : "";
                String string = this.tableName = databaseSeparatorIdx != -1 && clusterSeparatorIdx != -1 ? qualifiedName.substring(databaseSeparatorIdx + 1, clusterSeparatorIdx) : "";
                this.clusterName = StringUtils.isNotEmpty((String)clusterNameWithSuffix) ? ((idx = clusterNameWithSuffix.lastIndexOf("_storage")) != -1 ? clusterNameWithSuffix.substring(0, idx) : "") : "";
            } else {
                this.databaseName = "";
                this.tableName = "";
                this.clusterName = "";
            }
        }

        @Override
        public Object getAttribute(EntityAttribute attribute) {
            switch (attribute.getAttributeKey()) {
                case "hive_db.name": {
                    return this.databaseName;
                }
                case "hive_table.name": {
                    return this.tableName;
                }
                case "hive_db.clusterName": {
                    return this.clusterName;
                }
                case "hive_storagedesc.location": {
                    return this.location;
                }
            }
            return super.getAttribute(attribute);
        }

        @Override
        public void setAttribute(EntityAttribute attribute, String attributeValue) {
            switch (attribute.getAttributeKey()) {
                case "hive_db.name": {
                    this.databaseName = attributeValue;
                    this.isCustomAttributeUpdated = true;
                    break;
                }
                case "hive_table.name": {
                    this.tableName = attributeValue;
                    this.isCustomAttributeUpdated = true;
                    break;
                }
                case "hive_db.clusterName": {
                    this.clusterName = attributeValue;
                    this.isCustomAttributeUpdated = true;
                    break;
                }
                case "hive_storagedesc.location": {
                    this.location = attributeValue;
                    break;
                }
                default: {
                    super.setAttribute(attribute, attributeValue);
                }
            }
        }

        @Override
        public void transformComplete() {
            if (this.isCustomAttributeUpdated) {
                this.entity.setAttribute("location", (Object)this.toLocation());
                this.entity.setAttribute("qualifiedName", (Object)this.toQualifiedName());
            }
        }

        private String toLocation() {
            int lastPathIndex = this.location != null ? this.location.lastIndexOf(47) : -1;
            return lastPathIndex != -1 ? this.location.substring(0, lastPathIndex) + '/' + this.tableName : this.location;
        }

        private String toQualifiedName() {
            return String.format("%s.%s@%s_storage", this.databaseName, this.tableName, this.clusterName);
        }
    }
}

