/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.entitytransform;

import java.util.Arrays;
import java.util.List;
import org.apache.atlas.entitytransform.AtlasEntityTransformer;
import org.apache.atlas.entitytransform.BaseEntityHandler;
import org.apache.atlas.entitytransform.EntityAttribute;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.commons.lang.StringUtils;

public class HiveDatabaseEntityHandler
extends BaseEntityHandler {
    static final List<String> CUSTOM_TRANSFORM_ATTRIBUTES = Arrays.asList("hive_db.name", "hive_db.clusterName");

    public HiveDatabaseEntityHandler(List<AtlasEntityTransformer> transformers) {
        super(transformers);
    }

    @Override
    public BaseEntityHandler.AtlasTransformableEntity getTransformableEntity(AtlasEntity entity) {
        return this.isHiveDatabaseEntity(entity) ? new HiveDatabaseEntity(entity) : null;
    }

    private boolean isHiveDatabaseEntity(AtlasEntity entity) {
        return StringUtils.equals((String)entity.getTypeName(), (String)"hive_db");
    }

    private static class HiveDatabaseEntity
    extends BaseEntityHandler.AtlasTransformableEntity {
        private String databaseName;
        private String clusterName;
        private boolean isCustomAttributeUpdated = false;

        public HiveDatabaseEntity(AtlasEntity entity) {
            super(entity);
            int clusterSeparatorIdx;
            this.databaseName = (String)entity.getAttribute("name");
            String qualifiedName = (String)entity.getAttribute("qualifiedName");
            this.clusterName = qualifiedName != null ? ((clusterSeparatorIdx = qualifiedName.lastIndexOf(64)) != -1 ? qualifiedName.substring(clusterSeparatorIdx + 1) : "") : "";
        }

        @Override
        public Object getAttribute(EntityAttribute attribute) {
            switch (attribute.getAttributeKey()) {
                case "hive_db.name": {
                    return this.databaseName;
                }
                case "hive_db.clusterName": {
                    return this.clusterName;
                }
            }
            return super.getAttribute(attribute);
        }

        @Override
        public void setAttribute(EntityAttribute attribute, String attributeValue) {
            switch (attribute.getAttributeKey()) {
                case "hive_db.name": {
                    this.databaseName = attributeValue;
                    this.isCustomAttributeUpdated = true;
                    break;
                }
                case "hive_db.clusterName": {
                    this.clusterName = attributeValue;
                    this.isCustomAttributeUpdated = true;
                    break;
                }
                default: {
                    super.setAttribute(attribute, attributeValue);
                }
            }
        }

        @Override
        public void transformComplete() {
            if (this.isCustomAttributeUpdated) {
                this.entity.setAttribute("name", (Object)this.databaseName);
                this.entity.setAttribute("clusterName", (Object)this.clusterName);
                this.entity.setAttribute("qualifiedName", (Object)this.toQualifiedName());
            }
        }

        private String toQualifiedName() {
            return String.format("%s@%s", this.databaseName, this.clusterName);
        }
    }
}

