/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.discovery;

import com.google.common.annotations.VisibleForTesting;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.atlas.ApplicationProperties;
import org.apache.atlas.AtlasException;
import org.apache.atlas.SortOrder;
import org.apache.atlas.discovery.GraphIndexQueryBuilder;
import org.apache.atlas.discovery.SearchContext;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.discovery.SearchParameters;
import org.apache.atlas.model.typedef.AtlasStructDef;
import org.apache.atlas.repository.Constants;
import org.apache.atlas.repository.graph.GraphHelper;
import org.apache.atlas.repository.graphdb.AtlasEdge;
import org.apache.atlas.repository.graphdb.AtlasGraphQuery;
import org.apache.atlas.repository.graphdb.AtlasIndexQuery;
import org.apache.atlas.repository.graphdb.AtlasVertex;
import org.apache.atlas.repository.store.graph.v2.AtlasGraphUtilsV2;
import org.apache.atlas.type.AtlasArrayType;
import org.apache.atlas.type.AtlasClassificationType;
import org.apache.atlas.type.AtlasEntityType;
import org.apache.atlas.type.AtlasEnumType;
import org.apache.atlas.type.AtlasRelationshipType;
import org.apache.atlas.type.AtlasStructType;
import org.apache.atlas.type.AtlasType;
import org.apache.atlas.util.AtlasGremlinQueryProvider;
import org.apache.atlas.util.SearchPredicateUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.PredicateUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.tinkerpop.gremlin.process.traversal.Order;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SearchProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(SearchProcessor.class);
    public static final Pattern STRAY_AND_PATTERN = Pattern.compile("(AND\\s+)+\\)");
    public static final Pattern STRAY_OR_PATTERN = Pattern.compile("(OR\\s+)+\\)");
    public static final Pattern STRAY_ELIPSIS_PATTERN = Pattern.compile("(\\(\\s*)\\)");
    public static final int MAX_RESULT_SIZE = SearchProcessor.getApplicationProperty("atlas.graph.index.search.max-result-set-size", 150);
    public static final int MAX_QUERY_STR_LENGTH_TYPES = SearchProcessor.getApplicationProperty("atlas.graph.index.search.types.max-query-str-length", 512);
    public static final int MAX_QUERY_STR_LENGTH_TAGS = SearchProcessor.getApplicationProperty("atlas.graph.index.search.tags.max-query-str-length", 512);
    public static final String INDEX_SEARCH_PREFIX = AtlasGraphUtilsV2.getIndexSearchPrefix();
    public static final String AND_STR = " AND ";
    public static final String EMPTY_STRING = "";
    public static final String SPACE_STRING = " ";
    public static final String BRACE_OPEN_STR = "(";
    public static final String BRACE_CLOSE_STR = ")";
    public static final String ALL_TYPE_QUERY = "[* TO *]";
    public static final char CUSTOM_ATTR_SEPARATOR = '=';
    public static final String CUSTOM_ATTR_SEARCH_FORMAT = "\"\\\"%s\\\":\\\"%s\\\"\"";
    public static final String CUSTOM_ATTR_SEARCH_FORMAT_GRAPH = "\"%s\":\"%s\"";
    private static final Map<SearchParameters.Operator, String> OPERATOR_MAP = new HashMap<SearchParameters.Operator, String>();
    private static final Map<SearchParameters.Operator, SearchPredicateUtil.ElementAttributePredicateGenerator> OPERATOR_PREDICATE_MAP = new HashMap<SearchParameters.Operator, SearchPredicateUtil.ElementAttributePredicateGenerator>();
    protected final SearchContext context;
    protected SearchProcessor nextProcessor;
    protected Predicate inMemoryPredicate;
    protected GraphIndexQueryBuilder graphIndexQueryBuilder;
    protected Integer nextOffset;

    protected SearchProcessor(SearchContext context) {
        this.context = context;
        this.graphIndexQueryBuilder = new GraphIndexQueryBuilder(context);
    }

    public void addProcessor(SearchProcessor processor) {
        if (this.nextProcessor == null) {
            this.nextProcessor = processor;
        } else {
            this.nextProcessor.addProcessor(processor);
        }
    }

    public String getNextMarker() {
        return SearchContext.MarkerUtil.getNextEncMarker(this.context.getSearchParameters(), this.nextOffset);
    }

    public abstract List<AtlasVertex> execute();

    public abstract long getResultCount();

    protected boolean isEntityRootType() {
        if (CollectionUtils.isNotEmpty(this.context.getEntityTypes())) {
            return this.context.getEntityTypes().iterator().next() == SearchContext.MATCH_ALL_ENTITY_TYPES;
        }
        return false;
    }

    protected boolean isClassificationRootType() {
        if (CollectionUtils.isNotEmpty(this.context.getClassificationTypes())) {
            return this.context.getClassificationTypes().iterator().next() == SearchContext.MATCH_ALL_CLASSIFICATION_TYPES;
        }
        return false;
    }

    protected boolean isSystemAttribute(String attrName) {
        return AtlasEntityType.getEntityRoot().hasAttribute(attrName) || AtlasClassificationType.getClassificationRoot().hasAttribute(attrName);
    }

    protected boolean isPipeSeparatedSystemAttribute(String attrName) {
        return StringUtils.equals((String)attrName, (String)Constants.CLASSIFICATION_NAMES_KEY) || StringUtils.equals((String)attrName, (String)Constants.PROPAGATED_CLASSIFICATION_NAMES_KEY) || StringUtils.equals((String)attrName, (String)Constants.LABELS_PROPERTY_KEY) || StringUtils.equals((String)attrName, (String)Constants.CUSTOM_ATTRIBUTES_PROPERTY_KEY);
    }

    protected int collectResultVertices(List<AtlasVertex> ret, int startIdx, int limit, int resultIdx, Map<Integer, AtlasVertex> offsetEntityVertexMap, Integer marker) {
        int lastOffset = resultIdx;
        for (Map.Entry<Integer, AtlasVertex> offsetToEntity : offsetEntityVertexMap.entrySet()) {
            if (++resultIdx <= startIdx) continue;
            lastOffset = offsetToEntity.getKey();
            ret.add(offsetToEntity.getValue());
            if (ret.size() != limit) continue;
            break;
        }
        return marker == null ? resultIdx : lastOffset;
    }

    protected int collectResultEdges(List<AtlasEdge> ret, int startIdx, int limit, int resultIdx, Map<Integer, AtlasEdge> offsetEdgeMap, Integer marker) {
        int lastOffset = resultIdx;
        for (Map.Entry<Integer, AtlasEdge> offsetToEdge : offsetEdgeMap.entrySet()) {
            if (++resultIdx <= startIdx) continue;
            lastOffset = offsetToEdge.getKey();
            ret.add(offsetToEdge.getValue());
            if (ret.size() != limit) continue;
            break;
        }
        return marker == null ? resultIdx : lastOffset;
    }

    public LinkedHashMap<Integer, AtlasVertex> filter(LinkedHashMap<Integer, AtlasVertex> offsetEntityVertexMap) {
        if (this.nextProcessor != null && MapUtils.isNotEmpty(offsetEntityVertexMap)) {
            return this.nextProcessor.filter(offsetEntityVertexMap);
        }
        return offsetEntityVertexMap;
    }

    public LinkedHashMap<Integer, AtlasVertex> filter(LinkedHashMap<Integer, AtlasVertex> offsetEntityVertexMap, Predicate predicate) {
        if (predicate != null) {
            offsetEntityVertexMap = offsetEntityVertexMap.entrySet().stream().filter((? super T x) -> predicate.evaluate(x.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (x, y) -> y, LinkedHashMap::new));
        }
        return offsetEntityVertexMap;
    }

    protected Predicate buildTraitPredict(Set<AtlasClassificationType> classificationTypes) {
        Predicate traitPredicate;
        AtlasClassificationType classificationType = null;
        if (CollectionUtils.isNotEmpty(classificationTypes)) {
            classificationType = classificationTypes.iterator().next();
        }
        if (classificationType == SearchContext.MATCH_ALL_CLASSIFICATION_TYPES) {
            traitPredicate = PredicateUtils.orPredicate((Predicate)SearchPredicateUtil.getNotEmptyPredicateGenerator().generatePredicate(Constants.TRAIT_NAMES_PROPERTY_KEY, null, List.class), (Predicate)SearchPredicateUtil.getNotEmptyPredicateGenerator().generatePredicate(Constants.PROPAGATED_TRAIT_NAMES_PROPERTY_KEY, null, List.class));
        } else if (classificationType == SearchContext.MATCH_ALL_NOT_CLASSIFIED) {
            traitPredicate = PredicateUtils.andPredicate((Predicate)SearchPredicateUtil.getIsNullOrEmptyPredicateGenerator().generatePredicate(Constants.TRAIT_NAMES_PROPERTY_KEY, null, List.class), (Predicate)SearchPredicateUtil.getIsNullOrEmptyPredicateGenerator().generatePredicate(Constants.PROPAGATED_TRAIT_NAMES_PROPERTY_KEY, null, List.class));
        } else if (this.context.isWildCardSearch()) {
            Set<String> classificationNames = this.context.getClassificationNames();
            ArrayList predicates = new ArrayList();
            classificationNames.forEach(classificationName -> {
                String regexString = SearchProcessor.getRegexString("\\|" + classificationName + "\\|");
                predicates.add(SearchPredicateUtil.getRegexPredicateGenerator().generatePredicate(Constants.CLASSIFICATION_NAMES_KEY, regexString, String.class));
                predicates.add(SearchPredicateUtil.getRegexPredicateGenerator().generatePredicate(Constants.PROPAGATED_CLASSIFICATION_NAMES_KEY, regexString, String.class));
            });
            traitPredicate = PredicateUtils.anyPredicate(predicates);
        } else {
            traitPredicate = PredicateUtils.orPredicate((Predicate)SearchPredicateUtil.getContainsAnyPredicateGenerator().generatePredicate(Constants.TRAIT_NAMES_PROPERTY_KEY, this.context.getClassificationTypeNames(), List.class), (Predicate)SearchPredicateUtil.getContainsAnyPredicateGenerator().generatePredicate(Constants.PROPAGATED_TRAIT_NAMES_PROPERTY_KEY, this.context.getClassificationTypeNames(), List.class));
        }
        return traitPredicate;
    }

    protected void processSearchAttributes(Set<? extends AtlasStructType> structTypes, SearchParameters.FilterCriteria filterCriteria, Set<String> indexFiltered, Set<String> graphFiltered, Set<String> allAttributes) {
        block18: {
            block17: {
                if (CollectionUtils.isEmpty(structTypes) || filterCriteria == null) {
                    return;
                }
                SearchParameters.FilterCriteria.Condition filterCondition = filterCriteria.getCondition();
                List criterion = filterCriteria.getCriterion();
                if (filterCondition == null || !CollectionUtils.isNotEmpty((Collection)criterion)) break block17;
                for (SearchParameters.FilterCriteria criteria : criterion) {
                    this.processSearchAttributes(structTypes, criteria, indexFiltered, graphFiltered, allAttributes);
                }
                break block18;
            }
            if (!StringUtils.isNotEmpty((String)filterCriteria.getAttributeName())) break block18;
            String attributeName = filterCriteria.getAttributeName();
            if (StringUtils.equals((String)attributeName, (String)Constants.IS_INCOMPLETE_PROPERTY_KEY)) {
                String attributeValue = filterCriteria.getAttributeValue();
                switch (filterCriteria.getOperator()) {
                    case EQ: {
                        if (attributeValue == null || StringUtils.equals((String)attributeValue, (String)"0") || StringUtils.equalsIgnoreCase((String)attributeValue, (String)"false")) {
                            filterCriteria.setOperator(SearchParameters.Operator.IS_NULL);
                            break;
                        }
                        filterCriteria.setOperator(SearchParameters.Operator.EQ);
                        filterCriteria.setAttributeValue(Constants.INCOMPLETE_ENTITY_VALUE.toString());
                        break;
                    }
                    case NEQ: {
                        if (attributeValue == null || StringUtils.equals((String)attributeValue, (String)"0") || StringUtils.equalsIgnoreCase((String)attributeValue, (String)"false")) {
                            filterCriteria.setOperator(SearchParameters.Operator.EQ);
                            filterCriteria.setAttributeValue(Constants.INCOMPLETE_ENTITY_VALUE.toString());
                            break;
                        }
                        filterCriteria.setOperator(SearchParameters.Operator.IS_NULL);
                        break;
                    }
                    case NOT_NULL: {
                        filterCriteria.setOperator(SearchParameters.Operator.EQ);
                        filterCriteria.setAttributeValue(Constants.INCOMPLETE_ENTITY_VALUE.toString());
                    }
                }
            }
            try {
                for (AtlasStructType atlasStructType : structTypes) {
                    String qualifiedName = atlasStructType.getVertexPropertyName(attributeName);
                    if (this.isIndexSearchable(filterCriteria, atlasStructType)) {
                        indexFiltered.add(qualifiedName);
                    } else {
                        LOG.warn("not using index-search for attribute '{}'; might cause poor performance", (Object)atlasStructType.getVertexPropertyName(attributeName));
                        graphFiltered.add(qualifiedName);
                    }
                    if (atlasStructType instanceof AtlasEntityType && !this.isSystemAttribute(attributeName)) {
                        this.context.getEntityAttributes().add(attributeName);
                    }
                    if (atlasStructType instanceof AtlasRelationshipType) {
                        this.context.getRelationAttributes().add(attributeName);
                    }
                    allAttributes.add(qualifiedName);
                }
            }
            catch (AtlasBaseException e) {
                LOG.warn(e.getMessage());
            }
        }
    }

    protected boolean canApplyIndexFilter(Set<? extends AtlasStructType> structTypes, SearchParameters.FilterCriteria filterCriteria, boolean insideOrCondition) {
        if (!this.context.hasAttributeFilter(filterCriteria)) {
            return true;
        }
        boolean ret = true;
        SearchParameters.FilterCriteria.Condition filterCondition = filterCriteria.getCondition();
        List criterion = filterCriteria.getCriterion();
        Set<String> indexedKeys = this.context.getIndexedKeys();
        if (filterCondition != null && CollectionUtils.isNotEmpty((Collection)criterion)) {
            SearchParameters.FilterCriteria filterCriteria2;
            insideOrCondition = insideOrCondition || filterCondition == SearchParameters.FilterCriteria.Condition.OR;
            Iterator iterator = criterion.iterator();
            while (iterator.hasNext() && (ret = this.canApplyIndexFilter(structTypes, filterCriteria2 = (SearchParameters.FilterCriteria)iterator.next(), insideOrCondition))) {
            }
        } else if (StringUtils.isNotEmpty((String)filterCriteria.getAttributeName())) {
            try {
                for (AtlasStructType atlasStructType : structTypes) {
                    if (!insideOrCondition || this.isIndexSearchable(filterCriteria, atlasStructType)) continue;
                    ret = false;
                    break;
                }
            }
            catch (AtlasBaseException e) {
                LOG.warn(e.getMessage());
            }
        }
        return ret;
    }

    protected LinkedHashMap<Integer, AtlasVertex> filterWhiteSpaceClassification(LinkedHashMap<Integer, AtlasVertex> offsetEntityVertexMap) {
        if (offsetEntityVertexMap != null) {
            Iterator<Map.Entry<Integer, AtlasVertex>> it = offsetEntityVertexMap.entrySet().iterator();
            Set<String> typeAndSubTypes = this.context.getClassificationTypeNames();
            while (it.hasNext()) {
                List<String> propagatedClassificationNames;
                AtlasVertex entityVertex = it.next().getValue();
                List<String> classificationNames = AtlasGraphUtilsV2.getClassificationNames(entityVertex);
                if (CollectionUtils.isNotEmpty(classificationNames) && (typeAndSubTypes.isEmpty() || CollectionUtils.containsAny(classificationNames, typeAndSubTypes)) || CollectionUtils.isNotEmpty(propagatedClassificationNames = AtlasGraphUtilsV2.getPropagatedClassificationNames(entityVertex)) && (typeAndSubTypes.isEmpty() || CollectionUtils.containsAny(propagatedClassificationNames, typeAndSubTypes))) continue;
                it.remove();
            }
        }
        return offsetEntityVertexMap;
    }

    protected void constructFilterQuery(StringBuilder indexQuery, Set<? extends AtlasStructType> structTypes, SearchParameters.FilterCriteria filterCriteria, Set<String> indexAttributes) {
        if (filterCriteria != null) {
            String filterQuery;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Processing Filters");
            }
            if (StringUtils.isNotEmpty((String)(filterQuery = this.toIndexQuery(structTypes, filterCriteria, indexAttributes, 0)))) {
                if (indexQuery.length() > 0) {
                    indexQuery.append(AND_STR);
                }
                indexQuery.append(filterQuery);
            }
        }
    }

    protected Predicate constructInMemoryPredicate(Set<? extends AtlasStructType> structTypes, SearchParameters.FilterCriteria filterCriteria, Set<String> indexAttributes) {
        Predicate ret = null;
        if (filterCriteria != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Processing Filters");
            }
            ret = this.toInMemoryPredicate(structTypes, filterCriteria, indexAttributes);
        }
        return ret;
    }

    protected void constructGremlinFilterQuery(StringBuilder gremlinQuery, Map<String, Object> queryBindings, AtlasStructType structType, SearchParameters.FilterCriteria filterCriteria) {
        if (filterCriteria != null) {
            SearchParameters.FilterCriteria.Condition condition = filterCriteria.getCondition();
            if (condition != null) {
                StringBuilder orQuery = new StringBuilder();
                List criterion = filterCriteria.getCriterion();
                for (int i = 0; i < criterion.size(); ++i) {
                    SearchParameters.FilterCriteria criteria = (SearchParameters.FilterCriteria)criterion.get(i);
                    if (condition == SearchParameters.FilterCriteria.Condition.OR) {
                        StringBuilder nestedOrQuery = new StringBuilder("_()");
                        this.constructGremlinFilterQuery(nestedOrQuery, queryBindings, structType, criteria);
                        orQuery.append(i == 0 ? EMPTY_STRING : ",").append((CharSequence)nestedOrQuery);
                        continue;
                    }
                    this.constructGremlinFilterQuery(gremlinQuery, queryBindings, structType, criteria);
                }
                if (condition == SearchParameters.FilterCriteria.Condition.OR) {
                    gremlinQuery.append(".or(").append((CharSequence)orQuery).append(BRACE_CLOSE_STR);
                }
            } else {
                String attributeName = filterCriteria.getAttributeName();
                AtlasStructType.AtlasAttribute attribute = structType.getAttribute(attributeName);
                if (attribute != null) {
                    SearchParameters.Operator operator = filterCriteria.getOperator();
                    String attributeValue = filterCriteria.getAttributeValue();
                    gremlinQuery.append(this.toGremlinComparisonQuery(attribute, operator, attributeValue, queryBindings));
                } else {
                    LOG.warn("Ignoring unknown attribute {}.{}", (Object)structType.getTypeName(), (Object)attributeName);
                }
            }
        }
    }

    private boolean isIndexSearchable(SearchParameters.FilterCriteria filterCriteria, AtlasStructType structType) throws AtlasBaseException {
        String attributeName = filterCriteria.getAttributeName();
        String attributeValue = filterCriteria.getAttributeValue();
        AtlasType attributeType = structType.getAttributeType(attributeName);
        String typeName = attributeType.getTypeName();
        String qualifiedName = structType.getVertexPropertyName(attributeName);
        Set<String> indexedKeys = this.context.getIndexedKeys();
        Set<String> edgeIndexedKeys = this.context.getEdgeIndexKeys();
        boolean ret = indexedKeys != null && indexedKeys.contains(qualifiedName) || edgeIndexedKeys != null && edgeIndexedKeys.contains(qualifiedName);
        SearchParameters.Operator operator = filterCriteria.getOperator();
        AtlasStructDef.AtlasAttributeDef.IndexType indexType = structType.getAttributeDef(attributeName).getIndexType();
        if (ret && "string".equals(typeName)) {
            if (operator == SearchParameters.Operator.NEQ || operator == SearchParameters.Operator.NOT_CONTAINS) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} operator found for string attribute {}, deferring to in-memory or graph query (might cause poor performance)", (Object)operator, (Object)qualifiedName);
                }
                ret = false;
            } else if (operator == SearchParameters.Operator.CONTAINS && AtlasStructType.AtlasAttribute.hastokenizeChar((String)attributeValue) && indexType == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} operator found for string (TEXT) attribute {} and special characters found in filter value {}, deferring to in-memory or graph query (might cause poor performance)", new Object[]{operator, qualifiedName, attributeValue});
                }
                ret = false;
            }
        }
        if (LOG.isDebugEnabled() && !ret) {
            LOG.debug("Not using index query for: attribute='{}', operator='{}', value='{}'", new Object[]{qualifiedName, operator, attributeValue});
        }
        return ret;
    }

    private String toIndexQuery(Set<? extends AtlasStructType> structTypes, SearchParameters.FilterCriteria criteria, Set<String> indexAttributes, int level) {
        return this.toIndexQuery(structTypes, criteria, indexAttributes, new StringBuilder(), level);
    }

    private String toIndexQuery(Set<? extends AtlasStructType> structTypes, SearchParameters.FilterCriteria criteria, Set<String> indexAttributes, StringBuilder sb, int level) {
        HashSet<String> filterAttributes = new HashSet<String>();
        filterAttributes.addAll(indexAttributes);
        SearchParameters.FilterCriteria.Condition condition = criteria.getCondition();
        if (condition != null && CollectionUtils.isNotEmpty((Collection)criteria.getCriterion())) {
            boolean needSurroundingBraces;
            StringBuilder nestedExpression = new StringBuilder();
            for (SearchParameters.FilterCriteria filterCriteria : criteria.getCriterion()) {
                String nestedQuery = this.toIndexQuery(structTypes, filterCriteria, filterAttributes, level + 1);
                if (!StringUtils.isNotEmpty((String)nestedQuery)) continue;
                if (nestedExpression.length() > 0) {
                    nestedExpression.append(SPACE_STRING).append(condition).append(SPACE_STRING);
                }
                nestedExpression.append(nestedQuery);
            }
            boolean bl = needSurroundingBraces = level != 0 || condition == SearchParameters.FilterCriteria.Condition.OR && criteria.getCriterion().size() > 1;
            if (nestedExpression.length() > 0) {
                return sb.append(needSurroundingBraces ? BRACE_OPEN_STR : EMPTY_STRING).append((CharSequence)nestedExpression).append(needSurroundingBraces ? BRACE_CLOSE_STR : EMPTY_STRING).toString();
            }
            return EMPTY_STRING;
        }
        if (StringUtils.isNotEmpty((String)criteria.getAttributeName())) {
            try {
                if (criteria.getOperator() == SearchParameters.Operator.TIME_RANGE) {
                    criteria = this.processDateRange(criteria);
                }
                ArrayList<String> orExpQuery = new ArrayList<String>();
                for (AtlasStructType atlasStructType : structTypes) {
                    String name = atlasStructType.getVertexPropertyName(criteria.getAttributeName());
                    if (!filterAttributes.contains(name)) continue;
                    String nestedQuery = this.toIndexExpression(atlasStructType, criteria.getAttributeName(), criteria.getOperator(), criteria.getAttributeValue());
                    orExpQuery.add(nestedQuery);
                    filterAttributes.remove(name);
                }
                if (CollectionUtils.isNotEmpty(orExpQuery)) {
                    if (orExpQuery.size() > 1) {
                        String orExpStr = StringUtils.join(orExpQuery, (String)(SPACE_STRING + SearchParameters.FilterCriteria.Condition.OR.name() + SPACE_STRING));
                        return "( " + orExpStr + SPACE_STRING + BRACE_CLOSE_STR;
                    }
                    return (String)orExpQuery.iterator().next();
                }
                return EMPTY_STRING;
            }
            catch (AtlasBaseException e) {
                LOG.warn(e.getMessage());
            }
        }
        return EMPTY_STRING;
    }

    private Predicate toInMemoryPredicate(Set<? extends AtlasStructType> structTypes, SearchParameters.FilterCriteria criteria, Set<String> indexAttributes) {
        HashSet<String> filterAttributes = new HashSet<String>();
        filterAttributes.addAll(indexAttributes);
        if (criteria.getCondition() != null && CollectionUtils.isNotEmpty((Collection)criteria.getCriterion())) {
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            for (SearchParameters.FilterCriteria filterCriteria : criteria.getCriterion()) {
                Predicate predicate = this.toInMemoryPredicate(structTypes, filterCriteria, filterAttributes);
                if (predicate == null) continue;
                predicates.add(predicate);
            }
            if (CollectionUtils.isNotEmpty(predicates)) {
                if (criteria.getCondition() == SearchParameters.FilterCriteria.Condition.AND) {
                    return PredicateUtils.allPredicate(predicates);
                }
                return PredicateUtils.anyPredicate(predicates);
            }
        } else if (StringUtils.isNotEmpty((String)criteria.getAttributeName())) {
            try {
                ArrayList<Predicate> predicates = new ArrayList<Predicate>();
                for (AtlasStructType atlasStructType : structTypes) {
                    String name = atlasStructType.getVertexPropertyName(criteria.getAttributeName());
                    if (!filterAttributes.contains(name)) continue;
                    String attrName = criteria.getAttributeName();
                    String attrValue = criteria.getAttributeValue();
                    SearchParameters.Operator operator = criteria.getOperator();
                    if (operator == SearchParameters.Operator.TIME_RANGE) {
                        SearchParameters.FilterCriteria processedRangeCriteria = this.processDateRange(criteria);
                        attrValue = processedRangeCriteria.getAttributeValue();
                    }
                    if (this.isPipeSeparatedSystemAttribute(attrName)) {
                        SearchParameters.FilterCriteria processedCriteria = this.processPipeSeperatedSystemAttribute(attrName, operator, attrValue);
                        attrValue = processedCriteria.getAttributeValue();
                        operator = processedCriteria.getOperator();
                    }
                    predicates.add(this.toInMemoryPredicate(atlasStructType, attrName, operator, attrValue));
                    filterAttributes.remove(name);
                }
                if (CollectionUtils.isNotEmpty(predicates)) {
                    if (predicates.size() > 1) {
                        return PredicateUtils.anyPredicate(predicates);
                    }
                    return (Predicate)predicates.iterator().next();
                }
            }
            catch (AtlasBaseException e) {
                LOG.warn(e.getMessage());
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @VisibleForTesting
    public SearchParameters.FilterCriteria processDateRange(SearchParameters.FilterCriteria criteria) {
        SearchParameters.FilterCriteria ret;
        String attrVal;
        SearchParameters.Operator op;
        String attrName;
        block35: {
            LocalDateTime endTime;
            LocalDateTime startTime;
            block36: {
                attrName = criteria.getAttributeName();
                op = criteria.getOperator();
                attrVal = criteria.getAttributeValue();
                ret = new SearchParameters.FilterCriteria();
                LocalDateTime now = LocalDateTime.now();
                switch (attrVal) {
                    case "LAST_7_DAYS": {
                        startTime = now.minusDays(6L).withHour(0).withMinute(0).withSecond(0).withNano(0);
                        endTime = startTime.plusDays(7L).minusNanos(1L);
                        break;
                    }
                    case "LAST_30_DAYS": {
                        startTime = now.minusDays(29L).withHour(0).withMinute(0).withSecond(0).withNano(0);
                        endTime = startTime.plusDays(30L).minusNanos(1L);
                        break;
                    }
                    case "LAST_MONTH": {
                        startTime = now.minusMonths(1L).withDayOfMonth(1).withHour(0).withMinute(0).withSecond(0).withNano(0);
                        endTime = startTime.plusMonths(1L).minusNanos(1L);
                        break;
                    }
                    case "THIS_MONTH": {
                        startTime = now.withDayOfMonth(1).withHour(0).withMinute(0).withSecond(0).withNano(0);
                        endTime = startTime.plusMonths(1L).minusNanos(1L);
                        break;
                    }
                    case "TODAY": {
                        startTime = now.withHour(0).withMinute(0).withSecond(0).withNano(0);
                        endTime = startTime.plusDays(1L).minusNanos(1L);
                        break;
                    }
                    case "YESTERDAY": {
                        startTime = now.minusDays(1L).withHour(0).withMinute(0).withSecond(0).withNano(0);
                        endTime = startTime.plusDays(1L).minusNanos(1L);
                        break;
                    }
                    case "THIS_YEAR": {
                        startTime = now.withDayOfYear(1).withDayOfMonth(1).withHour(0).withMinute(0).withSecond(0).withNano(0);
                        endTime = startTime.plusYears(1L).minusNanos(1L);
                        break;
                    }
                    case "LAST_YEAR": {
                        startTime = now.minusYears(1L).withDayOfYear(1).withHour(0).withMinute(0).withSecond(0).withNano(0);
                        endTime = startTime.plusYears(1L).minusNanos(1L);
                        break;
                    }
                    case "THIS_QUARTER": {
                        startTime = now.minusMonths(1L).withDayOfMonth(1).withHour(0).withMinute(0).withSecond(0).withNano(0);
                        endTime = startTime.plusMonths(3L).minusNanos(1L);
                        break;
                    }
                    case "LAST_QUARTER": {
                        startTime = now.minusMonths(4L).withDayOfMonth(1).withHour(0).withMinute(0).withSecond(0).withNano(0);
                        endTime = startTime.plusMonths(3L).minusNanos(1L);
                        break;
                    }
                    case "LAST_3_MONTHS": {
                        startTime = now.minusMonths(3L).withDayOfMonth(1).withHour(0).withMinute(0).withSecond(0).withNano(0);
                        endTime = startTime.plusMonths(3L).minusNanos(1L);
                        break;
                    }
                    case "LAST_6_MONTHS": {
                        startTime = now.minusMonths(6L).withDayOfMonth(1).withHour(0).withMinute(0).withSecond(0).withNano(0);
                        endTime = startTime.plusMonths(6L).minusNanos(1L);
                        break;
                    }
                    case "LAST_12_MONTHS": {
                        startTime = now.minusMonths(12L).withDayOfMonth(1).withHour(0).withMinute(0).withSecond(0).withNano(0);
                        endTime = startTime.plusMonths(12L).minusNanos(1L);
                        break;
                    }
                    default: {
                        startTime = null;
                        endTime = null;
                    }
                }
                if (startTime != null && endTime != null) break block36;
                String[] rangeAttr = attrVal.split(",");
                boolean numeric = true;
                if (rangeAttr.length != 2) {
                    LOG.error("Separator invalid");
                    break block35;
                } else {
                    try {
                        Long parsestartTime = Long.parseLong(String.valueOf(rangeAttr[0]));
                        Long l = Long.parseLong(String.valueOf(rangeAttr[1]));
                    }
                    catch (NumberFormatException e) {
                        numeric = false;
                        if (!numeric) {
                            LOG.error("Attributes passed need to be LONG");
                        }
                        break block35;
                    }
                }
            }
            attrVal = Timestamp.valueOf(startTime).getTime() + "," + Timestamp.valueOf(endTime).getTime();
        }
        ret.setAttributeName(attrName);
        ret.setOperator(op);
        ret.setAttributeValue(attrVal);
        return ret;
    }

    private SearchParameters.FilterCriteria processPipeSeperatedSystemAttribute(String attrName, SearchParameters.Operator op, String attrVal) {
        SearchParameters.FilterCriteria ret = new SearchParameters.FilterCriteria();
        if (op != null && attrVal != null) {
            switch (op) {
                case STARTS_WITH: {
                    attrVal = "|" + attrVal;
                    op = SearchParameters.Operator.CONTAINS;
                    break;
                }
                case ENDS_WITH: {
                    attrVal = attrVal + "|";
                    op = SearchParameters.Operator.CONTAINS;
                    break;
                }
                case EQ: {
                    attrVal = GraphHelper.getDelimitedClassificationNames(Collections.singleton(attrVal));
                    op = SearchParameters.Operator.CONTAINS;
                    break;
                }
                case NEQ: {
                    attrVal = GraphHelper.getDelimitedClassificationNames(Collections.singleton(attrVal));
                    op = SearchParameters.Operator.NOT_CONTAINS;
                    break;
                }
                case CONTAINS: 
                case NOT_CONTAINS: {
                    if (!attrName.equals(Constants.CUSTOM_ATTRIBUTES_PROPERTY_KEY)) break;
                    attrVal = this.getCustomAttributeIndexQueryValue(attrVal, true);
                }
            }
        }
        ret.setAttributeName(attrName);
        ret.setOperator(op);
        ret.setAttributeValue(attrVal);
        return ret;
    }

    private String toIndexExpression(AtlasStructType type, String attrName, SearchParameters.Operator op, String attrVal) throws AtlasBaseException {
        String ret = EMPTY_STRING;
        try {
            if (OPERATOR_MAP.get(op) != null) {
                String rangeStart = EMPTY_STRING;
                String rangeEnd = EMPTY_STRING;
                String qualifiedName = type.getVertexPropertyName(attrName);
                if (op == SearchParameters.Operator.TIME_RANGE) {
                    String[] parts = attrVal.split(",");
                    if (parts.length == 2) {
                        rangeStart = parts[0];
                        rangeEnd = parts[1];
                        String rangeStartIndexQueryValue = AtlasStructType.AtlasAttribute.escapeIndexQueryValue((String)rangeStart);
                        String rangeEndIndexQueryValue = AtlasStructType.AtlasAttribute.escapeIndexQueryValue((String)rangeEnd);
                        ret = String.format(OPERATOR_MAP.get(op), qualifiedName, rangeStartIndexQueryValue, rangeEndIndexQueryValue);
                    }
                } else {
                    String escapeIndexQueryValue;
                    boolean replaceWildcardChar = false;
                    AtlasStructDef.AtlasAttributeDef def = type.getAttributeDef(attrName);
                    if (!this.isPipeSeparatedSystemAttribute(attrName) && (op == SearchParameters.Operator.CONTAINS || op == SearchParameters.Operator.STARTS_WITH || op == SearchParameters.Operator.ENDS_WITH) && def.getTypeName().equalsIgnoreCase("string")) {
                        if (def.getIndexType() == null && AtlasStructType.AtlasAttribute.hastokenizeChar((String)attrVal)) {
                            replaceWildcardChar = true;
                        }
                        escapeIndexQueryValue = AtlasStructType.AtlasAttribute.escapeIndexQueryValue((String)attrVal, (boolean)false, (boolean)false);
                    } else {
                        escapeIndexQueryValue = AtlasStructType.AtlasAttribute.escapeIndexQueryValue((String)attrVal);
                    }
                    String operatorStr = OPERATOR_MAP.get(op);
                    if (replaceWildcardChar) {
                        operatorStr = operatorStr.replace("*", EMPTY_STRING);
                    }
                    ret = attrName.equals(Constants.CUSTOM_ATTRIBUTES_PROPERTY_KEY) && op == SearchParameters.Operator.CONTAINS ? String.format(operatorStr, qualifiedName, this.getCustomAttributeIndexQueryValue(escapeIndexQueryValue, false)) : String.format(operatorStr, qualifiedName, escapeIndexQueryValue);
                }
            }
        }
        catch (AtlasBaseException ex) {
            LOG.warn(ex.getMessage());
        }
        return ret;
    }

    private String getCustomAttributeIndexQueryValue(String attrValue, boolean forGraphQuery) {
        String ret = null;
        if (StringUtils.isNotEmpty((String)attrValue)) {
            String value;
            int separatorIdx = attrValue.indexOf(61);
            String key = separatorIdx != -1 ? attrValue.substring(0, separatorIdx) : null;
            String string = value = key != null ? attrValue.substring(separatorIdx + 1) : null;
            ret = key != null && value != null ? (forGraphQuery ? String.format(CUSTOM_ATTR_SEARCH_FORMAT_GRAPH, key, value) : String.format(CUSTOM_ATTR_SEARCH_FORMAT, key, value)) : attrValue;
        }
        return ret;
    }

    private Predicate toInMemoryPredicate(AtlasStructType type, String attrName, SearchParameters.Operator op, String attrVal) {
        Predicate ret = null;
        AtlasStructType.AtlasAttribute attribute = type.getAttribute(attrName);
        SearchPredicateUtil.ElementAttributePredicateGenerator predicate = OPERATOR_PREDICATE_MAP.get(op);
        if (attribute != null && predicate != null) {
            Object attrValue;
            Class attrClass;
            AtlasType attrType = attribute.getAttributeType();
            Long attrValue2 = null;
            switch (attrType.getTypeName()) {
                case "string": {
                    attrClass = String.class;
                    attrValue = attrVal;
                    break;
                }
                case "short": {
                    attrClass = Short.class;
                    attrValue = StringUtils.isEmpty((String)attrVal) ? null : Short.valueOf(Short.parseShort(attrVal));
                    break;
                }
                case "int": {
                    attrClass = Integer.class;
                    attrValue = StringUtils.isEmpty((String)attrVal) ? null : Integer.valueOf(Integer.parseInt(attrVal));
                    break;
                }
                case "biginteger": {
                    attrClass = BigInteger.class;
                    attrValue = StringUtils.isEmpty((String)attrVal) ? null : new BigInteger(attrVal);
                    break;
                }
                case "boolean": {
                    attrClass = Boolean.class;
                    attrValue = StringUtils.isEmpty((String)attrVal) ? null : Boolean.valueOf(Boolean.parseBoolean(attrVal));
                    break;
                }
                case "byte": {
                    attrClass = Byte.class;
                    attrValue = StringUtils.isEmpty((String)attrVal) ? null : Byte.valueOf(Byte.parseByte(attrVal));
                    break;
                }
                case "long": 
                case "date": {
                    String[] parts;
                    attrClass = Long.class;
                    String rangeStart = EMPTY_STRING;
                    String rangeEnd = EMPTY_STRING;
                    if (op == SearchParameters.Operator.TIME_RANGE && (parts = attrVal.split(",")).length == 2) {
                        rangeStart = parts[0];
                        rangeEnd = parts[1];
                    }
                    if (StringUtils.isNotEmpty((String)rangeStart) && StringUtils.isNotEmpty((String)rangeEnd)) {
                        attrValue = Long.parseLong(rangeStart);
                        attrValue2 = Long.parseLong(rangeEnd);
                        break;
                    }
                    attrValue = StringUtils.isEmpty((String)attrVal) ? null : Long.valueOf(Long.parseLong(attrVal));
                    break;
                }
                case "float": {
                    attrClass = Float.class;
                    attrValue = StringUtils.isEmpty((String)attrVal) ? null : Float.valueOf(Float.parseFloat(attrVal));
                    break;
                }
                case "double": {
                    attrClass = Double.class;
                    attrValue = StringUtils.isEmpty((String)attrVal) ? null : Double.valueOf(Double.parseDouble(attrVal));
                    break;
                }
                case "bigdecimal": {
                    attrClass = BigDecimal.class;
                    attrValue = StringUtils.isEmpty((String)attrVal) ? null : new BigDecimal(attrVal);
                    break;
                }
                default: {
                    attrClass = attrType instanceof AtlasEnumType ? String.class : (attrType instanceof AtlasArrayType ? List.class : Object.class);
                    attrValue = attrVal;
                }
            }
            String vertexPropertyName = attribute.getVertexPropertyName();
            ret = attrValue != null && attrValue2 != null ? predicate.generatePredicate(StringUtils.isEmpty((String)vertexPropertyName) ? attribute.getQualifiedName() : vertexPropertyName, attrValue, attrValue2, attrClass) : predicate.generatePredicate(StringUtils.isEmpty((String)vertexPropertyName) ? attribute.getQualifiedName() : vertexPropertyName, attrValue, attrClass);
        }
        return ret;
    }

    protected AtlasGraphQuery toGraphFilterQuery(Set<? extends AtlasStructType> structTypes, SearchParameters.FilterCriteria criteria, Set<String> graphAttributes, AtlasGraphQuery query) {
        HashSet<String> filterAttributes = new HashSet<String>();
        filterAttributes.addAll(graphAttributes);
        if (criteria != null) {
            if (criteria.getCondition() != null) {
                if (criteria.getCondition() == SearchParameters.FilterCriteria.Condition.AND) {
                    for (SearchParameters.FilterCriteria filterCriteria : criteria.getCriterion()) {
                        AtlasGraphQuery atlasGraphQuery = this.toGraphFilterQuery(structTypes, filterCriteria, filterAttributes, this.context.getGraph().query());
                        query.addConditionsFrom(atlasGraphQuery);
                    }
                } else {
                    LinkedList<AtlasGraphQuery> orConditions = new LinkedList<AtlasGraphQuery>();
                    for (SearchParameters.FilterCriteria filterCriteria : criteria.getCriterion()) {
                        AtlasGraphQuery nestedQuery = this.toGraphFilterQuery(structTypes, filterCriteria, filterAttributes, this.context.getGraph().query());
                        orConditions.add(this.context.getGraph().query().createChildQuery().addConditionsFrom(nestedQuery));
                    }
                    if (!orConditions.isEmpty()) {
                        query.or(orConditions);
                    }
                }
            } else if (StringUtils.isNotEmpty((String)criteria.getAttributeName())) {
                try {
                    ArrayList<AtlasGraphQuery> queries = new ArrayList<AtlasGraphQuery>();
                    for (AtlasStructType atlasStructType : structTypes) {
                        String qualifiedName = atlasStructType.getVertexPropertyName(criteria.getAttributeName());
                        if (!filterAttributes.contains(qualifiedName)) continue;
                        String attrName = criteria.getAttributeName();
                        String attrValue = criteria.getAttributeValue();
                        SearchParameters.Operator operator = criteria.getOperator();
                        if (this.isPipeSeparatedSystemAttribute(attrName)) {
                            SearchParameters.FilterCriteria processedCriteria = this.processPipeSeperatedSystemAttribute(attrName, operator, attrValue);
                            attrValue = processedCriteria.getAttributeValue();
                            operator = processedCriteria.getOperator();
                        }
                        AtlasGraphQuery innerQry = this.context.getGraph().query().createChildQuery();
                        switch (operator) {
                            case LT: {
                                innerQry.has(qualifiedName, (AtlasGraphQuery.QueryOperator)AtlasGraphQuery.ComparisionOperator.LESS_THAN, (Object)attrValue);
                                break;
                            }
                            case LTE: {
                                innerQry.has(qualifiedName, (AtlasGraphQuery.QueryOperator)AtlasGraphQuery.ComparisionOperator.LESS_THAN_EQUAL, (Object)attrValue);
                                break;
                            }
                            case GT: {
                                innerQry.has(qualifiedName, (AtlasGraphQuery.QueryOperator)AtlasGraphQuery.ComparisionOperator.GREATER_THAN, (Object)attrValue);
                                break;
                            }
                            case GTE: {
                                innerQry.has(qualifiedName, (AtlasGraphQuery.QueryOperator)AtlasGraphQuery.ComparisionOperator.GREATER_THAN_EQUAL, (Object)attrValue);
                                break;
                            }
                            case EQ: {
                                innerQry.has(qualifiedName, (AtlasGraphQuery.QueryOperator)AtlasGraphQuery.ComparisionOperator.EQUAL, (Object)attrValue);
                                break;
                            }
                            case NEQ: {
                                innerQry.has(qualifiedName, (AtlasGraphQuery.QueryOperator)AtlasGraphQuery.ComparisionOperator.NOT_EQUAL, (Object)attrValue);
                                break;
                            }
                            case LIKE: {
                                innerQry.has(qualifiedName, (AtlasGraphQuery.QueryOperator)AtlasGraphQuery.MatchingOperator.REGEX, (Object)attrValue);
                                break;
                            }
                            case CONTAINS: {
                                innerQry.has(qualifiedName, (AtlasGraphQuery.QueryOperator)AtlasGraphQuery.MatchingOperator.REGEX, (Object)SearchProcessor.getContainsRegex(attrValue));
                                break;
                            }
                            case STARTS_WITH: {
                                innerQry.has(qualifiedName, (AtlasGraphQuery.QueryOperator)AtlasGraphQuery.MatchingOperator.PREFIX, (Object)attrValue);
                                break;
                            }
                            case ENDS_WITH: {
                                innerQry.has(qualifiedName, (AtlasGraphQuery.QueryOperator)AtlasGraphQuery.MatchingOperator.REGEX, (Object)SearchProcessor.getSuffixRegex(attrValue));
                                break;
                            }
                            case IS_NULL: {
                                innerQry.has(qualifiedName, (AtlasGraphQuery.QueryOperator)AtlasGraphQuery.ComparisionOperator.EQUAL, null);
                                break;
                            }
                            case NOT_NULL: {
                                innerQry.has(qualifiedName, (AtlasGraphQuery.QueryOperator)AtlasGraphQuery.ComparisionOperator.NOT_EQUAL, null);
                                break;
                            }
                            case NOT_CONTAINS: {
                                break;
                            }
                            default: {
                                LOG.warn("{}: unsupported operator. Ignored", (Object)operator);
                            }
                        }
                        queries.add(this.context.getGraph().query().createChildQuery().addConditionsFrom(innerQry));
                        filterAttributes.remove(qualifiedName);
                    }
                    if (CollectionUtils.isNotEmpty(queries)) {
                        if (queries.size() > 1) {
                            return this.context.getGraph().query().createChildQuery().or(queries);
                        }
                        return (AtlasGraphQuery)queries.iterator().next();
                    }
                }
                catch (AtlasBaseException e) {
                    LOG.warn(e.getMessage());
                }
            }
        }
        return query;
    }

    private String toGremlinComparisonQuery(AtlasStructType.AtlasAttribute attribute, SearchParameters.Operator operator, String attrValue, Map<String, Object> queryBindings) {
        String bindName = "__bind_" + queryBindings.size();
        Object bindValue = attribute.getAttributeType().getNormalizedValue((Object)attrValue);
        AtlasGremlinQueryProvider queryProvider = AtlasGremlinQueryProvider.INSTANCE;
        String queryTemplate = null;
        switch (operator) {
            case LT: {
                queryTemplate = queryProvider.getQuery(AtlasGremlinQueryProvider.AtlasGremlinQuery.COMPARE_LT);
                break;
            }
            case GT: {
                queryTemplate = queryProvider.getQuery(AtlasGremlinQueryProvider.AtlasGremlinQuery.COMPARE_GT);
                break;
            }
            case LTE: {
                queryTemplate = queryProvider.getQuery(AtlasGremlinQueryProvider.AtlasGremlinQuery.COMPARE_LTE);
                break;
            }
            case GTE: {
                queryTemplate = queryProvider.getQuery(AtlasGremlinQueryProvider.AtlasGremlinQuery.COMPARE_GTE);
                break;
            }
            case EQ: {
                queryTemplate = queryProvider.getQuery(AtlasGremlinQueryProvider.AtlasGremlinQuery.COMPARE_EQ);
                break;
            }
            case NEQ: {
                queryTemplate = queryProvider.getQuery(AtlasGremlinQueryProvider.AtlasGremlinQuery.COMPARE_NEQ);
                break;
            }
            case LIKE: {
                queryTemplate = queryProvider.getQuery(AtlasGremlinQueryProvider.AtlasGremlinQuery.COMPARE_MATCHES);
                break;
            }
            case STARTS_WITH: {
                queryTemplate = queryProvider.getQuery(AtlasGremlinQueryProvider.AtlasGremlinQuery.COMPARE_STARTS_WITH);
                break;
            }
            case ENDS_WITH: {
                queryTemplate = queryProvider.getQuery(AtlasGremlinQueryProvider.AtlasGremlinQuery.COMPARE_ENDS_WITH);
                break;
            }
            case CONTAINS: {
                queryTemplate = queryProvider.getQuery(AtlasGremlinQueryProvider.AtlasGremlinQuery.COMPARE_CONTAINS);
                break;
            }
            case IS_NULL: {
                queryTemplate = queryProvider.getQuery(AtlasGremlinQueryProvider.AtlasGremlinQuery.COMPARE_IS_NULL);
                break;
            }
            case NOT_NULL: {
                queryTemplate = queryProvider.getQuery(AtlasGremlinQueryProvider.AtlasGremlinQuery.COMPARE_NOT_NULL);
            }
        }
        if (org.apache.commons.lang3.StringUtils.isNotEmpty(queryTemplate)) {
            if (bindValue instanceof Date) {
                bindValue = ((Date)bindValue).getTime();
            }
            queryBindings.put(bindName, bindValue);
            return String.format(queryTemplate, attribute.getQualifiedName(), bindName);
        }
        return EMPTY_STRING;
    }

    private static String getContainsRegex(String attributeValue) {
        return ".*" + SearchProcessor.escapeRegExChars(attributeValue) + ".*";
    }

    private static String getRegexString(String value) {
        return ".*" + value.replace("*", ".*") + ".*";
    }

    private static String getSuffixRegex(String attributeValue) {
        return ".*" + SearchProcessor.escapeRegExChars(attributeValue);
    }

    private static String escapeRegExChars(String val) {
        StringBuilder escapedVal = new StringBuilder();
        for (int i = 0; i < val.length(); ++i) {
            char c = val.charAt(i);
            if (SearchProcessor.isRegExSpecialChar(c)) {
                escapedVal.append('\\');
            }
            escapedVal.append(c);
        }
        return escapedVal.toString();
    }

    private static boolean isRegExSpecialChar(char c) {
        switch (c) {
            case '$': 
            case '(': 
            case '*': 
            case '+': 
            case '/': 
            case '?': 
            case '[': 
            case '^': 
            case '{': 
            case '|': {
                return true;
            }
        }
        return false;
    }

    private static boolean hasIndexQuerySpecialChar(String attributeValue) {
        if (attributeValue == null) {
            return false;
        }
        for (int i = 0; i < attributeValue.length(); ++i) {
            if (!SearchProcessor.isIndexQuerySpecialChar(attributeValue.charAt(i))) continue;
            return true;
        }
        return false;
    }

    private static boolean isIndexQuerySpecialChar(char c) {
        switch (c) {
            case '#': 
            case '$': 
            case '%': 
            case '=': 
            case '@': {
                return true;
            }
        }
        return false;
    }

    protected Collection<AtlasVertex> getVerticesFromIndexQueryResult(Iterator<AtlasIndexQuery.Result> idxQueryResult, Collection<AtlasVertex> vertices) {
        if (idxQueryResult != null) {
            while (idxQueryResult.hasNext()) {
                AtlasVertex vertex = idxQueryResult.next().getVertex();
                vertices.add(vertex);
            }
        }
        return vertices;
    }

    protected LinkedHashMap<Integer, AtlasVertex> getVerticesFromIndexQueryResult(Iterator<AtlasIndexQuery.Result> idxQueryResult, LinkedHashMap<Integer, AtlasVertex> offsetEntityVertexMap, int qryOffset) {
        if (idxQueryResult != null) {
            while (idxQueryResult.hasNext()) {
                AtlasVertex vertex = idxQueryResult.next().getVertex();
                offsetEntityVertexMap.put(qryOffset++, vertex);
            }
        }
        return offsetEntityVertexMap;
    }

    protected LinkedHashMap<Integer, AtlasEdge> getEdgesFromIndexQueryResult(Iterator<AtlasIndexQuery.Result> idxQueryResult, LinkedHashMap<Integer, AtlasEdge> offsetEdgeMap, int qryOffset) {
        if (idxQueryResult != null) {
            while (idxQueryResult.hasNext()) {
                AtlasEdge edge = idxQueryResult.next().getEdge();
                offsetEdgeMap.put(qryOffset++, edge);
            }
        }
        return offsetEdgeMap;
    }

    protected Collection<AtlasVertex> getVertices(Iterator<AtlasVertex> iterator, Collection<AtlasVertex> vertices) {
        if (iterator != null) {
            while (iterator.hasNext()) {
                AtlasVertex vertex = iterator.next();
                vertices.add(vertex);
            }
        }
        return vertices;
    }

    protected LinkedHashMap<Integer, AtlasVertex> getVertices(Iterator<AtlasVertex> iterator, LinkedHashMap<Integer, AtlasVertex> offsetEntityVertexMap, int qryOffset) {
        if (iterator != null) {
            while (iterator.hasNext()) {
                AtlasVertex vertex = iterator.next();
                offsetEntityVertexMap.put(qryOffset++, vertex);
            }
        }
        return offsetEntityVertexMap;
    }

    protected LinkedHashMap<Integer, AtlasEdge> getEdges(Iterator<AtlasEdge> iterator, LinkedHashMap<Integer, AtlasEdge> offsetEdgeMap, int qryOffset) {
        if (iterator != null) {
            while (iterator.hasNext()) {
                AtlasEdge edge = iterator.next();
                offsetEdgeMap.put(qryOffset++, edge);
            }
        }
        return offsetEdgeMap;
    }

    protected Set<String> getGuids(List<AtlasVertex> vertices) {
        HashSet<String> ret = new HashSet<String>();
        if (vertices != null) {
            for (AtlasVertex vertex : vertices) {
                String guid = AtlasGraphUtilsV2.getIdFromVertex(vertex);
                if (!StringUtils.isNotEmpty((String)guid)) continue;
                ret.add(guid);
            }
        }
        return ret;
    }

    private static int getApplicationProperty(String propertyName, int defaultValue) {
        try {
            return ApplicationProperties.get().getInt(propertyName, defaultValue);
        }
        catch (AtlasException atlasException) {
            return defaultValue;
        }
    }

    private static String getSortByAttribute(SearchContext context) {
        String sortBy;
        AtlasEntityType entityType;
        AtlasStructType.AtlasAttribute sortByAttribute;
        if (CollectionUtils.isNotEmpty(context.getEntityTypes()) && (sortByAttribute = (entityType = context.getEntityTypes().iterator().next()).getAttribute(sortBy = context.getSearchParameters().getSortBy())) != null) {
            return sortByAttribute.getVertexPropertyName();
        }
        return null;
    }

    private static Order getSortOrderAttribute(SearchContext context) {
        SortOrder sortOrder = context.getSearchParameters().getSortOrder();
        if (sortOrder == null) {
            sortOrder = SortOrder.ASCENDING;
        }
        return sortOrder == SortOrder.ASCENDING ? Order.asc : Order.desc;
    }

    protected static Iterator<AtlasIndexQuery.Result> executeIndexQuery(SearchContext context, AtlasIndexQuery indexQuery, int qryOffset, int limit) {
        String sortBy = SearchProcessor.getSortByAttribute(context);
        if (sortBy != null && !sortBy.isEmpty()) {
            Order sortOrder = SearchProcessor.getSortOrderAttribute(context);
            return indexQuery.vertices(qryOffset, limit, sortBy, sortOrder);
        }
        return indexQuery.vertices(qryOffset, limit);
    }

    protected static Iterator<AtlasIndexQuery.Result> executeIndexQueryForEdge(SearchContext context, AtlasIndexQuery indexQuery, int qryOffset, int limit) {
        AtlasRelationshipType relationshipType = context.getRelationshipTypes().iterator().next();
        AtlasStructType.AtlasAttribute sortByAttribute = relationshipType.getAttribute(context.getSearchParameters().getSortBy());
        if (sortByAttribute != null && StringUtils.isNotEmpty((String)sortByAttribute.getVertexPropertyName())) {
            Order sortOrder = SearchProcessor.getSortOrderAttribute(context);
            return indexQuery.edges(qryOffset, limit, sortByAttribute.getVertexPropertyName(), sortOrder);
        }
        return indexQuery.edges(qryOffset, limit);
    }

    static {
        OPERATOR_MAP.put(SearchParameters.Operator.LT, INDEX_SEARCH_PREFIX + "\"%s\": [* TO %s}");
        OPERATOR_PREDICATE_MAP.put(SearchParameters.Operator.LT, SearchPredicateUtil.getLTPredicateGenerator());
        OPERATOR_MAP.put(SearchParameters.Operator.GT, INDEX_SEARCH_PREFIX + "\"%s\": {%s TO *]");
        OPERATOR_PREDICATE_MAP.put(SearchParameters.Operator.GT, SearchPredicateUtil.getGTPredicateGenerator());
        OPERATOR_MAP.put(SearchParameters.Operator.LTE, INDEX_SEARCH_PREFIX + "\"%s\": [* TO %s]");
        OPERATOR_PREDICATE_MAP.put(SearchParameters.Operator.LTE, SearchPredicateUtil.getLTEPredicateGenerator());
        OPERATOR_MAP.put(SearchParameters.Operator.GTE, INDEX_SEARCH_PREFIX + "\"%s\": [%s TO *]");
        OPERATOR_PREDICATE_MAP.put(SearchParameters.Operator.GTE, SearchPredicateUtil.getGTEPredicateGenerator());
        OPERATOR_MAP.put(SearchParameters.Operator.EQ, INDEX_SEARCH_PREFIX + "\"%s\": %s");
        OPERATOR_PREDICATE_MAP.put(SearchParameters.Operator.EQ, SearchPredicateUtil.getEQPredicateGenerator());
        OPERATOR_MAP.put(SearchParameters.Operator.NEQ, "(*:* -" + INDEX_SEARCH_PREFIX + "\"%s\": %s)");
        OPERATOR_PREDICATE_MAP.put(SearchParameters.Operator.NEQ, SearchPredicateUtil.getNEQPredicateGenerator());
        OPERATOR_MAP.put(SearchParameters.Operator.IN, INDEX_SEARCH_PREFIX + "\"%s\": (%s)");
        OPERATOR_PREDICATE_MAP.put(SearchParameters.Operator.IN, SearchPredicateUtil.getINPredicateGenerator());
        OPERATOR_MAP.put(SearchParameters.Operator.LIKE, INDEX_SEARCH_PREFIX + "\"%s\": (%s)");
        OPERATOR_PREDICATE_MAP.put(SearchParameters.Operator.LIKE, SearchPredicateUtil.getLIKEPredicateGenerator());
        OPERATOR_MAP.put(SearchParameters.Operator.STARTS_WITH, INDEX_SEARCH_PREFIX + "\"%s\": (%s*)");
        OPERATOR_PREDICATE_MAP.put(SearchParameters.Operator.STARTS_WITH, SearchPredicateUtil.getStartsWithPredicateGenerator());
        OPERATOR_MAP.put(SearchParameters.Operator.ENDS_WITH, INDEX_SEARCH_PREFIX + "\"%s\": (*%s)");
        OPERATOR_PREDICATE_MAP.put(SearchParameters.Operator.ENDS_WITH, SearchPredicateUtil.getEndsWithPredicateGenerator());
        OPERATOR_MAP.put(SearchParameters.Operator.CONTAINS, INDEX_SEARCH_PREFIX + "\"%s\": (*%s*)");
        OPERATOR_PREDICATE_MAP.put(SearchParameters.Operator.CONTAINS, SearchPredicateUtil.getContainsPredicateGenerator());
        OPERATOR_PREDICATE_MAP.put(SearchParameters.Operator.NOT_CONTAINS, SearchPredicateUtil.getNotContainsPredicateGenerator());
        OPERATOR_MAP.put(SearchParameters.Operator.IS_NULL, "(*:* NOT " + INDEX_SEARCH_PREFIX + "\"%s\":[* TO *])");
        OPERATOR_PREDICATE_MAP.put(SearchParameters.Operator.IS_NULL, SearchPredicateUtil.getIsNullPredicateGenerator());
        OPERATOR_MAP.put(SearchParameters.Operator.NOT_NULL, INDEX_SEARCH_PREFIX + "\"%s\":[* TO *]");
        OPERATOR_PREDICATE_MAP.put(SearchParameters.Operator.NOT_NULL, SearchPredicateUtil.getNotNullPredicateGenerator());
        OPERATOR_MAP.put(SearchParameters.Operator.NOT_EMPTY, INDEX_SEARCH_PREFIX + "\"%s\":[* TO *]");
        OPERATOR_PREDICATE_MAP.put(SearchParameters.Operator.NOT_EMPTY, SearchPredicateUtil.getNotEmptyPredicateGenerator());
        OPERATOR_MAP.put(SearchParameters.Operator.TIME_RANGE, INDEX_SEARCH_PREFIX + "\"%s\": [%s TO %s]");
        OPERATOR_PREDICATE_MAP.put(SearchParameters.Operator.TIME_RANGE, SearchPredicateUtil.getInRangePredicateGenerator());
    }
}

