/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.discovery;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.atlas.SortOrder;
import org.apache.atlas.discovery.SearchContext;
import org.apache.atlas.discovery.SearchProcessor;
import org.apache.atlas.model.discovery.SearchParameters;
import org.apache.atlas.repository.Constants;
import org.apache.atlas.repository.graphdb.AtlasEdge;
import org.apache.atlas.repository.graphdb.AtlasGraphQuery;
import org.apache.atlas.repository.graphdb.AtlasIndexQuery;
import org.apache.atlas.repository.graphdb.AtlasVertex;
import org.apache.atlas.type.AtlasRelationshipType;
import org.apache.atlas.type.AtlasStructType;
import org.apache.atlas.type.AtlasType;
import org.apache.atlas.util.SearchPredicateUtil;
import org.apache.atlas.utils.AtlasPerfTracer;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.PredicateUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RelationshipSearchProcessor
extends SearchProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(RelationshipSearchProcessor.class);
    private static final Logger PERF_LOG = AtlasPerfTracer.getPerfLogger((String)"RelationshipSearchProcessor");
    private final AtlasIndexQuery indexQuery;
    private final AtlasGraphQuery graphQuery;

    RelationshipSearchProcessor(SearchContext context, Set<String> indexedKeys) {
        super(context);
        context.setEdgeIndexKeys(indexedKeys);
        Set<AtlasRelationshipType> types = context.getRelationshipTypes();
        SearchParameters.FilterCriteria filterCriteria = context.getSearchParameters().getRelationshipFilters();
        HashSet<String> indexAttributes = new HashSet<String>();
        HashSet<String> graphAttributes = new HashSet<String>();
        HashSet<String> allAttributes = new HashSet<String>();
        Set typeNames = CollectionUtils.isNotEmpty(types) ? types.stream().map(AtlasType::getTypeName).collect(Collectors.toSet()) : null;
        String typeAndSubTypesQryStr = AtlasStructType.AtlasAttribute.escapeIndexQueryValue(typeNames, (boolean)true);
        Predicate typeNamePredicate = SearchPredicateUtil.generateIsRelationshipEdgePredicate(context.getTypeRegistry());
        String sortBy = context.getSearchParameters().getSortBy();
        SortOrder sortOrder = context.getSearchParameters().getSortOrder();
        this.inMemoryPredicate = typeNamePredicate;
        this.processSearchAttributes(types, filterCriteria, indexAttributes, graphAttributes, allAttributes);
        boolean typeSearchByIndex = typeAndSubTypesQryStr.length() <= MAX_QUERY_STR_LENGTH_TYPES;
        boolean attrSearchByIndex = CollectionUtils.isNotEmpty(indexAttributes) && this.canApplyIndexFilter(types, filterCriteria, false);
        StringBuilder indexQuery = new StringBuilder();
        if (typeSearchByIndex) {
            this.graphIndexQueryBuilder.addTypeAndSubTypesQueryFilterEdges(indexQuery, typeAndSubTypesQryStr);
        }
        if (attrSearchByIndex) {
            this.constructFilterQuery(indexQuery, types, filterCriteria, indexAttributes);
            Predicate attributePredicate = this.constructInMemoryPredicate(types, filterCriteria, indexAttributes);
            if (attributePredicate != null) {
                this.inMemoryPredicate = PredicateUtils.andPredicate((Predicate)this.inMemoryPredicate, (Predicate)attributePredicate);
            }
        } else {
            graphAttributes.addAll(indexAttributes);
        }
        if (indexQuery.length() > 0) {
            String indexQueryString = STRAY_AND_PATTERN.matcher(indexQuery).replaceAll(")");
            indexQueryString = STRAY_OR_PATTERN.matcher(indexQueryString).replaceAll(")");
            indexQueryString = STRAY_ELIPSIS_PATTERN.matcher(indexQueryString).replaceAll("");
            this.indexQuery = context.getGraph().indexQuery("edge_index", indexQueryString);
        } else {
            this.indexQuery = null;
        }
        if (CollectionUtils.isNotEmpty(graphAttributes) || !typeSearchByIndex) {
            AtlasRelationshipType relationshipType;
            AtlasStructType.AtlasAttribute sortByAttribute;
            AtlasGraphQuery query = context.getGraph().query();
            if (!typeSearchByIndex) {
                query.in(Constants.RELATIONSHIP_TYPE_PROPERTY_KEY, types);
            }
            this.graphQuery = this.toGraphFilterQuery(types, filterCriteria, graphAttributes, query);
            Predicate attributePredicate = this.constructInMemoryPredicate(types, filterCriteria, graphAttributes);
            if (attributePredicate != null) {
                this.inMemoryPredicate = PredicateUtils.andPredicate((Predicate)this.inMemoryPredicate, (Predicate)attributePredicate);
            }
            if (StringUtils.isNotEmpty((String)sortBy) && (sortByAttribute = (relationshipType = types.iterator().next()).getAttribute(sortBy)) != null && StringUtils.isNotEmpty((String)sortByAttribute.getVertexPropertyName())) {
                AtlasGraphQuery.SortOrder qrySortOrder = sortOrder == SortOrder.ASCENDING ? AtlasGraphQuery.SortOrder.ASC : AtlasGraphQuery.SortOrder.DESC;
                this.graphQuery.orderBy(sortByAttribute.getVertexPropertyName(), qrySortOrder);
            }
        } else {
            this.graphQuery = null;
        }
    }

    @Override
    public List<AtlasVertex> execute() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AtlasEdge> executeEdges() {
        ArrayList<AtlasEdge> ret = new ArrayList<AtlasEdge>();
        AtlasPerfTracer perf = null;
        if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
            perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)("RelationshipSearchProcessor.execute(" + this.context + ")"));
        }
        try {
            int startIdx;
            int limit = this.context.getSearchParameters().getLimit();
            Integer marker = this.context.getMarker();
            int n = startIdx = marker != null ? marker.intValue() : this.context.getSearchParameters().getOffset();
            int qryOffset = marker != null ? marker : (this.graphQuery != null && this.indexQuery != null ? 0 : startIdx);
            int resultIdx = qryOffset;
            LinkedHashMap offsetEdgeMap = new LinkedHashMap();
            while (ret.size() < limit) {
                offsetEdgeMap.clear();
                if (this.context.terminateSearch()) {
                    LOG.warn("query terminated: {}", (Object)this.context.getSearchParameters());
                    break;
                }
                if (this.indexQuery != null) {
                    Iterator<AtlasIndexQuery.Result> idxQueryResult = RelationshipSearchProcessor.executeIndexQueryForEdge(this.context, this.indexQuery, qryOffset, limit);
                    offsetEdgeMap = this.getEdgesFromIndexQueryResult(idxQueryResult, offsetEdgeMap, qryOffset);
                } else {
                    Iterator<AtlasEdge> queryResult = this.graphQuery.edges(qryOffset, limit).iterator();
                    offsetEdgeMap = this.getEdges(queryResult, offsetEdgeMap, qryOffset);
                }
                boolean isLastResultPage = offsetEdgeMap.size() < limit;
                offsetEdgeMap = offsetEdgeMap.entrySet().stream().filter((? super T x) -> this.inMemoryPredicate.evaluate(x.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (x, y) -> y, LinkedHashMap::new));
                resultIdx = this.collectResultEdges(ret, startIdx, limit, resultIdx, offsetEdgeMap, marker);
                if (isLastResultPage) {
                    resultIdx = -2;
                    break;
                }
                qryOffset += limit;
            }
            if (marker != null) {
                this.nextOffset = resultIdx + 1;
            }
        }
        catch (Throwable throwable) {
            AtlasPerfTracer.log(perf);
            throw throwable;
        }
        AtlasPerfTracer.log((AtlasPerfTracer)perf);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RelationshipSearchProcessor.execute({}): ret.size()={}", (Object)this.context, (Object)ret.size());
        }
        return ret;
    }

    @Override
    public long getResultCount() {
        if (this.indexQuery != null) {
            return this.indexQuery.edgeTotals();
        }
        return -1L;
    }
}

