/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.discovery;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.apache.atlas.ApplicationProperties;
import org.apache.atlas.AtlasConfiguration;
import org.apache.atlas.AtlasErrorCode;
import org.apache.atlas.AtlasException;
import org.apache.atlas.RequestContext;
import org.apache.atlas.SortOrder;
import org.apache.atlas.annotation.GraphTransaction;
import org.apache.atlas.authorize.AtlasAuthorizationUtils;
import org.apache.atlas.authorize.AtlasSearchResultScrubRequest;
import org.apache.atlas.discovery.AtlasDiscoveryService;
import org.apache.atlas.discovery.RelationshipSearchProcessor;
import org.apache.atlas.discovery.SearchAggregatorImpl;
import org.apache.atlas.discovery.SearchContext;
import org.apache.atlas.discovery.SuggestionsProvider;
import org.apache.atlas.discovery.SuggestionsProviderImpl;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.discovery.AtlasAggregationEntry;
import org.apache.atlas.model.discovery.AtlasQuickSearchResult;
import org.apache.atlas.model.discovery.AtlasSearchResult;
import org.apache.atlas.model.discovery.AtlasSearchResultDownloadStatus;
import org.apache.atlas.model.discovery.AtlasSuggestionsResult;
import org.apache.atlas.model.discovery.QuickSearchParameters;
import org.apache.atlas.model.discovery.RelationshipSearchParameters;
import org.apache.atlas.model.discovery.SearchParameters;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.AtlasEntityHeader;
import org.apache.atlas.model.instance.AtlasObjectId;
import org.apache.atlas.model.instance.AtlasRelationshipHeader;
import org.apache.atlas.model.profile.AtlasUserSavedSearch;
import org.apache.atlas.model.tasks.AtlasTask;
import org.apache.atlas.query.QueryParams;
import org.apache.atlas.query.executors.DSLQueryExecutor;
import org.apache.atlas.query.executors.ScriptEngineBasedExecutor;
import org.apache.atlas.query.executors.TraversalBasedExecutor;
import org.apache.atlas.repository.Constants;
import org.apache.atlas.repository.graph.GraphBackedSearchIndexer;
import org.apache.atlas.repository.graph.GraphHelper;
import org.apache.atlas.repository.graphdb.AtlasEdge;
import org.apache.atlas.repository.graphdb.AtlasEdgeDirection;
import org.apache.atlas.repository.graphdb.AtlasElement;
import org.apache.atlas.repository.graphdb.AtlasGraph;
import org.apache.atlas.repository.graphdb.AtlasIndexQuery;
import org.apache.atlas.repository.graphdb.AtlasVertex;
import org.apache.atlas.repository.store.graph.v2.AtlasGraphUtilsV2;
import org.apache.atlas.repository.store.graph.v2.EntityGraphRetriever;
import org.apache.atlas.repository.store.graph.v2.tasks.AuditReductionTaskFactory;
import org.apache.atlas.repository.store.graph.v2.tasks.searchdownload.SearchResultDownloadTask;
import org.apache.atlas.repository.store.graph.v2.tasks.searchdownload.SearchResultDownloadTaskFactory;
import org.apache.atlas.repository.userprofile.UserProfileService;
import org.apache.atlas.tasks.TaskManagement;
import org.apache.atlas.type.AtlasArrayType;
import org.apache.atlas.type.AtlasBuiltInTypes;
import org.apache.atlas.type.AtlasClassificationType;
import org.apache.atlas.type.AtlasEntityType;
import org.apache.atlas.type.AtlasStructType;
import org.apache.atlas.type.AtlasType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.atlas.util.AtlasGremlinQueryProvider;
import org.apache.atlas.util.SearchPredicateUtil;
import org.apache.atlas.util.SearchTracker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections4.IteratorUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.tinkerpop.gremlin.process.traversal.Order;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class EntityDiscoveryService
implements AtlasDiscoveryService {
    private static final Logger LOG = LoggerFactory.getLogger(EntityDiscoveryService.class);
    private static final String DEFAULT_SORT_ATTRIBUTE_NAME = "name";
    private final AtlasGraph graph;
    private final EntityGraphRetriever entityRetriever;
    private final AtlasGremlinQueryProvider gremlinQueryProvider;
    private final AtlasTypeRegistry typeRegistry;
    private final GraphBackedSearchIndexer indexer;
    private final SearchTracker searchTracker;
    private final int maxResultSetSize;
    private final int maxTypesLengthInIdxQuery;
    private final int maxTagsLengthInIdxQuery;
    private final String indexSearchPrefix;
    private final UserProfileService userProfileService;
    private final SuggestionsProvider suggestionsProvider;
    private final DSLQueryExecutor dslQueryExecutor;
    private final TaskManagement taskManagement;

    @Inject
    EntityDiscoveryService(AtlasTypeRegistry typeRegistry, AtlasGraph graph, GraphBackedSearchIndexer indexer, SearchTracker searchTracker, UserProfileService userProfileService, TaskManagement taskManagement) throws AtlasException {
        this.graph = graph;
        this.entityRetriever = new EntityGraphRetriever(this.graph, typeRegistry);
        this.indexer = indexer;
        this.searchTracker = searchTracker;
        this.gremlinQueryProvider = AtlasGremlinQueryProvider.INSTANCE;
        this.typeRegistry = typeRegistry;
        this.maxResultSetSize = ApplicationProperties.get().getInt("atlas.graph.index.search.max-result-set-size", 150);
        this.maxTypesLengthInIdxQuery = ApplicationProperties.get().getInt("atlas.graph.index.search.types.max-query-str-length", 512);
        this.maxTagsLengthInIdxQuery = ApplicationProperties.get().getInt("atlas.graph.index.search.tags.max-query-str-length", 512);
        this.indexSearchPrefix = AtlasGraphUtilsV2.getIndexSearchPrefix();
        this.userProfileService = userProfileService;
        this.suggestionsProvider = new SuggestionsProviderImpl(graph, typeRegistry);
        this.dslQueryExecutor = AtlasConfiguration.DSL_EXECUTOR_TRAVERSAL.getBoolean() ? new TraversalBasedExecutor(typeRegistry, graph, this.entityRetriever) : new ScriptEngineBasedExecutor(typeRegistry, graph, this.entityRetriever);
        this.taskManagement = taskManagement;
        LOG.info("DSL Executor: {}", (Object)this.dslQueryExecutor.getClass().getSimpleName());
    }

    @Override
    @GraphTransaction
    public AtlasSearchResult searchUsingDslQuery(String dslQuery, int limit, int offset) throws AtlasBaseException {
        AtlasSearchResult ret = this.dslQueryExecutor.execute(dslQuery, limit, offset);
        this.scrubSearchResults(ret);
        return ret;
    }

    @Override
    @GraphTransaction
    public AtlasSearchResult searchUsingFullTextQuery(String fullTextQuery, boolean excludeDeletedEntities, int limit, int offset) throws AtlasBaseException {
        AtlasSearchResult ret = new AtlasSearchResult(fullTextQuery, AtlasSearchResult.AtlasQueryType.FULL_TEXT);
        QueryParams params = QueryParams.getNormalizedParams(limit, offset);
        AtlasIndexQuery idxQuery = this.toAtlasIndexQuery(fullTextQuery);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Executing Full text query: {}", (Object)fullTextQuery);
        }
        ret.setFullTextResult(this.getIndexQueryResults(idxQuery, params, excludeDeletedEntities));
        ret.setApproximateCount(idxQuery.vertexTotals().longValue());
        this.scrubSearchResults(ret);
        return ret;
    }

    @Override
    @GraphTransaction
    public AtlasSearchResult searchUsingBasicQuery(String query, String typeName, String classification, String attrName, String attrValuePrefix, boolean excludeDeletedEntities, int limit, int offset) throws AtlasBaseException {
        AtlasSearchResult ret;
        block33: {
            ret = new AtlasSearchResult(AtlasSearchResult.AtlasQueryType.BASIC);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Executing basic search query: {} with type: {} and classification: {}", new Object[]{query, typeName, classification});
            }
            QueryParams params = QueryParams.getNormalizedParams(limit, offset);
            Set typeNames = null;
            Set classificationNames = null;
            String attrQualifiedName = null;
            if (StringUtils.isNotEmpty((String)typeName)) {
                AtlasEntityType entityType = this.typeRegistry.getEntityTypeByName(typeName);
                if (entityType == null) {
                    throw new AtlasBaseException(AtlasErrorCode.UNKNOWN_TYPENAME, new String[]{typeName});
                }
                typeNames = entityType.getTypeAndAllSubTypes();
                ret.setType(typeName);
            }
            if (StringUtils.isNotEmpty((String)classification)) {
                AtlasClassificationType classificationType = this.typeRegistry.getClassificationTypeByName(classification);
                if (classificationType == null) {
                    throw new AtlasBaseException(AtlasErrorCode.CLASSIFICATION_NOT_FOUND, new String[]{classification});
                }
                classificationNames = classificationType.getTypeAndAllSubTypes();
                ret.setClassification(classification);
            }
            boolean isAttributeSearch = StringUtils.isNotEmpty((String)attrName) || StringUtils.isNotEmpty((String)attrValuePrefix);
            boolean isGuidPrefixSearch = false;
            if (isAttributeSearch) {
                AtlasEntityType entityType = this.typeRegistry.getEntityTypeByName(typeName);
                ret.setQueryType(AtlasSearchResult.AtlasQueryType.ATTRIBUTE);
                if (entityType != null) {
                    AtlasStructType.AtlasAttribute attribute = null;
                    if (StringUtils.isNotEmpty((String)attrName)) {
                        attribute = entityType.getAttribute(attrName);
                        if (attribute == null) {
                            throw new AtlasBaseException(AtlasErrorCode.UNKNOWN_ATTRIBUTE, new String[]{attrName, typeName});
                        }
                    } else {
                        ArrayList<String> defaultAttrNames = new ArrayList<String>(Arrays.asList("qualifiedName", DEFAULT_SORT_ATTRIBUTE_NAME));
                        Iterator iter = defaultAttrNames.iterator();
                        while (iter.hasNext() && attribute == null) {
                            attrName = (String)iter.next();
                            attribute = entityType.getAttribute(attrName);
                        }
                    }
                    if (attribute == null) {
                        isGuidPrefixSearch = true;
                        query = null;
                    } else {
                        attrQualifiedName = attribute.getQualifiedName();
                        String attrQuery = String.format("%s AND (%s *)", attrName, attrValuePrefix.replaceAll("\\.", " "));
                        String string = query = StringUtils.isEmpty((String)query) ? attrQuery : String.format("(%s) AND (%s)", query, attrQuery);
                    }
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Executing attribute search attrName: {} and attrValue: {}", (Object)attrName, (Object)attrValuePrefix);
                }
            }
            if (StringUtils.isNotEmpty((String)query)) {
                String idxQuery = this.getQueryForFullTextSearch(query, typeName, classification);
                int startIdx = params.offset();
                int resultSize = params.limit();
                int resultIdx = 0;
                int indexQueryOffset = 0;
                while (true) {
                    AtlasIndexQuery qry = this.graph.indexQuery("fulltext_index", idxQuery, indexQueryOffset);
                    Iterator qryResult = qry.vertices();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("indexQuery: query=" + idxQuery + "; offset=" + indexQueryOffset);
                    }
                    if (qryResult.hasNext()) {
                        while (qryResult.hasNext()) {
                            String vertexAttrValue;
                            List<String> traitNames;
                            AtlasVertex vertex = ((AtlasIndexQuery.Result)qryResult.next()).getVertex();
                            String vertexTypeName = GraphHelper.getTypeName((AtlasElement)vertex);
                            if (StringUtils.isEmpty((String)vertexTypeName) || StringUtils.isEmpty((String)GraphHelper.getGuid(vertex)) || typeNames != null && !typeNames.contains(vertexTypeName) || classificationNames != null && (CollectionUtils.isEmpty(traitNames = GraphHelper.getTraitNames(vertex)) || !CollectionUtils.containsAny((Collection)classificationNames, traitNames)) || isAttributeSearch && StringUtils.isNotEmpty((String)(vertexAttrValue = (String)vertex.getProperty(attrQualifiedName, String.class))) && !vertexAttrValue.startsWith(attrValuePrefix) || this.skipDeletedEntities(excludeDeletedEntities, vertex) || ++resultIdx <= startIdx) continue;
                            AtlasEntityHeader header = this.entityRetriever.toAtlasEntityHeader(vertex);
                            ret.addEntity(header);
                            if (ret.getEntities().size() != resultSize) continue;
                            break;
                        }
                        if (ret.getApproximateCount() < 0L) {
                            ret.setApproximateCount(qry.vertexTotals().longValue());
                        }
                        if (ret.getEntities() == null || ret.getEntities().size() != resultSize) {
                            indexQueryOffset += this.getMaxResultSetSize();
                            continue;
                        }
                    }
                    break block33;
                    break;
                }
            }
            HashMap<String, Object> bindings = new HashMap<String, Object>();
            String basicQuery = "g.V()";
            if (classificationNames != null) {
                bindings.put("traitNames", classificationNames);
                basicQuery = basicQuery + this.gremlinQueryProvider.getQuery(AtlasGremlinQueryProvider.AtlasGremlinQuery.BASIC_SEARCH_CLASSIFICATION_FILTER);
            }
            if (typeNames != null) {
                bindings.put("typeNames", typeNames);
                basicQuery = basicQuery + this.gremlinQueryProvider.getQuery(AtlasGremlinQueryProvider.AtlasGremlinQuery.BASIC_SEARCH_TYPE_FILTER);
            }
            if (excludeDeletedEntities) {
                bindings.put("state", AtlasEntity.Status.ACTIVE.toString());
                basicQuery = basicQuery + this.gremlinQueryProvider.getQuery(AtlasGremlinQueryProvider.AtlasGremlinQuery.BASIC_SEARCH_STATE_FILTER);
            }
            if (isGuidPrefixSearch) {
                bindings.put("guid", attrValuePrefix + ".*");
                basicQuery = basicQuery + this.gremlinQueryProvider.getQuery(AtlasGremlinQueryProvider.AtlasGremlinQuery.GUID_PREFIX_FILTER);
            }
            bindings.put("startIdx", params.offset());
            bindings.put("endIdx", params.offset() + params.limit());
            basicQuery = basicQuery + this.gremlinQueryProvider.getQuery(AtlasGremlinQueryProvider.AtlasGremlinQuery.TO_RANGE_LIST);
            ScriptEngine scriptEngine = this.graph.getGremlinScriptEngine();
            try {
                List queryResult;
                Object firstElement;
                Object result = this.graph.executeGremlinScript(scriptEngine, bindings, basicQuery, false);
                if (result instanceof List && CollectionUtils.isNotEmpty((Collection)((List)result)) && (firstElement = (queryResult = (List)result).get(0)) instanceof AtlasVertex) {
                    for (Object element : queryResult) {
                        if (element instanceof AtlasVertex) {
                            ret.addEntity(this.entityRetriever.toAtlasEntityHeader((AtlasVertex)element));
                            continue;
                        }
                        LOG.warn("searchUsingBasicQuery({}): expected an AtlasVertex; found unexpected entry in result {}", (Object)basicQuery, element);
                    }
                }
            }
            catch (ScriptException e) {
                throw new AtlasBaseException(AtlasErrorCode.DISCOVERY_QUERY_FAILED, new String[]{basicQuery});
            }
            finally {
                this.graph.releaseGremlinScriptEngine(scriptEngine);
            }
        }
        this.scrubSearchResults(ret);
        return ret;
    }

    @Override
    @GraphTransaction
    public AtlasQuickSearchResult quickSearch(QuickSearchParameters quickSearchParameters) throws AtlasBaseException {
        String query = quickSearchParameters.getQuery();
        if (StringUtils.isNotEmpty((String)query) && !AtlasStructType.AtlasAttribute.hastokenizeChar((String)query)) {
            query = query + "*";
        }
        quickSearchParameters.setQuery(query);
        SearchContext searchContext = new SearchContext(EntityDiscoveryService.createSearchParameters(quickSearchParameters), this.typeRegistry, this.graph, this.indexer.getVertexIndexKeys());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Generating the search results for the query {} .", (Object)searchContext.getSearchParameters().getQuery());
        }
        AtlasSearchResult searchResult = this.searchWithSearchContext(searchContext);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Generating the aggregated metrics for the query {} .", (Object)searchContext.getSearchParameters().getQuery());
        }
        Set<String> aggregationFields = this.getAggregationFields();
        Set<AtlasStructType.AtlasAttribute> aggregationAttributes = this.getAggregationAtlasAttributes();
        SearchAggregatorImpl searchAggregator = new SearchAggregatorImpl(searchContext);
        Map<String, List<AtlasAggregationEntry>> aggregatedMetrics = searchAggregator.getAggregatedMetrics(aggregationFields, aggregationAttributes);
        AtlasQuickSearchResult ret = new AtlasQuickSearchResult(searchResult, aggregatedMetrics);
        return ret;
    }

    @Override
    @GraphTransaction
    public AtlasSuggestionsResult getSuggestions(String prefixString, String fieldName) {
        return this.suggestionsProvider.getSuggestions(prefixString, fieldName);
    }

    @Override
    @GraphTransaction
    public AtlasSearchResult searchWithParameters(SearchParameters searchParameters) throws AtlasBaseException {
        String modifiedString;
        String query = searchParameters.getQuery();
        if (StringUtils.isNotEmpty((String)query) && AtlasStructType.AtlasAttribute.hastokenizeChar((String)(modifiedString = StringUtils.strip((String)query, (String)"*")))) {
            searchParameters.setQuery(modifiedString);
        }
        return this.searchWithSearchContext(new SearchContext(searchParameters, this.typeRegistry, this.graph, this.indexer.getVertexIndexKeys()));
    }

    @Override
    @GraphTransaction
    public Set<String> searchGUIDsWithParameters(Constants.AtlasAuditAgingType auditAgingType, Set<String> entityTypes, SearchParameters searchParameters) throws AtlasBaseException {
        return this.searchEntityGUIDs(auditAgingType, entityTypes, new SearchContext(searchParameters, this.typeRegistry, this.graph, this.indexer.getVertexIndexKeys()));
    }

    @Override
    @GraphTransaction
    public void createAndQueueSearchResultDownloadTask(Map<String, Object> taskParams) throws AtlasBaseException {
        List<AtlasTask> pendingTasks = this.taskManagement.getPendingTasksByType("SEARCH_RESULT_DOWNLOAD");
        if (CollectionUtils.isNotEmpty(pendingTasks) && pendingTasks.size() > SearchResultDownloadTaskFactory.MAX_PENDING_TASKS_ALLOWED) {
            throw new AtlasBaseException(AtlasErrorCode.PENDING_TASKS_ALREADY_IN_PROGRESS, new String[]{String.valueOf(pendingTasks.size())});
        }
        AtlasTask task = this.taskManagement.createTask("SEARCH_RESULT_DOWNLOAD", RequestContext.getCurrentUser(), taskParams);
        RequestContext.get().queueTask(task);
    }

    @Override
    public AtlasSearchResultDownloadStatus getSearchResultDownloadStatus() throws IOException {
        File[] currentUserFiles;
        List<AtlasTask> pendingTasks = this.taskManagement.getPendingTasksByType("SEARCH_RESULT_DOWNLOAD");
        List currentUserPendingTasks = pendingTasks.stream().filter(task -> task.getCreatedBy().equals(RequestContext.getCurrentUser())).collect(Collectors.toList());
        ArrayList<AtlasSearchResultDownloadStatus.AtlasSearchDownloadRecord> searchDownloadRecords = new ArrayList<AtlasSearchResultDownloadStatus.AtlasSearchDownloadRecord>();
        for (AtlasTask pendingTask : currentUserPendingTasks) {
            String fileName = (String)pendingTask.getParameters().get("csv_file_Name");
            AtlasSearchResultDownloadStatus.AtlasSearchDownloadRecord searchDownloadRecord = new AtlasSearchResultDownloadStatus.AtlasSearchDownloadRecord(pendingTask.getStatus(), fileName, pendingTask.getCreatedBy(), pendingTask.getCreatedTime(), pendingTask.getStartTime());
            searchDownloadRecords.add(searchDownloadRecord);
        }
        File fileDir = new File(SearchResultDownloadTask.DOWNLOAD_DIR_PATH, RequestContext.getCurrentUser());
        if (fileDir.exists() && (currentUserFiles = fileDir.listFiles()) != null) {
            for (File file : currentUserFiles) {
                BasicFileAttributes attr = Files.readAttributes(file.toPath(), BasicFileAttributes.class, new LinkOption[0]);
                Date createdTime = new Date(attr.creationTime().toMillis());
                AtlasSearchResultDownloadStatus.AtlasSearchDownloadRecord searchDownloadRecord = new AtlasSearchResultDownloadStatus.AtlasSearchDownloadRecord(AtlasTask.Status.COMPLETE, file.getName(), RequestContext.getCurrentUser(), createdTime);
                searchDownloadRecords.add(searchDownloadRecord);
            }
        }
        AtlasSearchResultDownloadStatus result = new AtlasSearchResultDownloadStatus();
        result.setSearchDownloadRecords(searchDownloadRecords);
        return result;
    }

    @Override
    @GraphTransaction
    public AtlasTask createAndQueueAuditReductionTask(Map<String, Object> taskParams, String taskType) throws AtlasBaseException {
        List<AtlasTask> pendingTasks = this.taskManagement.getPendingTasksByType(taskType);
        if (CollectionUtils.isNotEmpty(pendingTasks) && pendingTasks.size() > AuditReductionTaskFactory.MAX_PENDING_TASKS_ALLOWED) {
            throw new AtlasBaseException(AtlasErrorCode.PENDING_TASKS_ALREADY_IN_PROGRESS, new String[]{String.valueOf(pendingTasks.size())});
        }
        AtlasTask task = this.taskManagement.createTask(taskType, RequestContext.getCurrentUser(), taskParams);
        RequestContext.get().queueTask(task);
        return task;
    }

    @Override
    @GraphTransaction
    public AtlasSearchResult searchRelationsWithParameters(RelationshipSearchParameters searchParameters) throws AtlasBaseException {
        SearchContext searchContext = new SearchContext(EntityDiscoveryService.createSearchParameters(searchParameters), this.typeRegistry, this.graph, null);
        return this.searchRelationsWithSearchContext(searchContext);
    }

    private AtlasSearchResult searchRelationsWithSearchContext(SearchContext searchContext) throws AtlasBaseException {
        SearchParameters searchParameters = searchContext.getSearchParameters();
        AtlasSearchResult ret = new AtlasSearchResult(searchParameters);
        QueryParams params = QueryParams.getNormalizedParams(searchParameters.getLimit(), searchParameters.getOffset());
        searchParameters.setLimit(params.limit());
        searchParameters.setOffset(params.offset());
        if (!searchContext.needRelationshipProcessor()) {
            return ret;
        }
        RelationshipSearchProcessor rsp = new RelationshipSearchProcessor(searchContext, this.indexer.getEdgeIndexKeys());
        List<AtlasEdge> edges = rsp.executeEdges();
        ret.setApproximateCount(rsp.getResultCount());
        String nextMarker = rsp.getNextMarker();
        if (StringUtils.isNotEmpty((String)nextMarker)) {
            ret.setNextMarker(nextMarker);
        }
        for (AtlasEdge edge : edges) {
            AtlasRelationshipHeader relation = this.entityRetriever.mapEdgeToAtlasRelationshipHeader(edge);
            ret.addRelation(relation);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> searchEntityGUIDs(Constants.AtlasAuditAgingType auditAgingType, Set<String> entityTypes, SearchContext searchContext) throws AtlasBaseException {
        SearchParameters searchParameters = searchContext.getSearchParameters();
        QueryParams params = QueryParams.getNormalizedParams(searchParameters.getLimit(), searchParameters.getOffset());
        String searchID = this.searchTracker.add(searchContext);
        searchParameters.setLimit(params.limit());
        searchParameters.setOffset(params.offset());
        HashSet<String> guids = new HashSet<String>();
        try {
            List<AtlasVertex> resultList = searchContext.getSearchProcessor().execute();
            do {
                for (AtlasVertex atlasVertex : resultList) {
                    if (atlasVertex == null || !this.checkVertexMatchesSearchCriteria(atlasVertex, auditAgingType, entityTypes)) continue;
                    guids.add((String)atlasVertex.getProperty(Constants.GUID_PROPERTY_KEY, String.class));
                }
                searchParameters.setOffset(searchParameters.getOffset() + searchParameters.getLimit());
            } while (CollectionUtils.isNotEmpty(resultList = searchContext.getSearchProcessor().execute()));
            LOG.info("Total {} entities are eligible for Audit aging", (Object)guids.size());
        }
        catch (Throwable t) {
            LOG.error("Error while retrieving eligible entities for audit aging");
        }
        finally {
            this.searchTracker.remove(searchID);
        }
        return guids;
    }

    private boolean checkVertexMatchesSearchCriteria(AtlasVertex vertex, Constants.AtlasAuditAgingType auditAgingType, Set<String> entityTypes) {
        if (CollectionUtils.isEmpty(entityTypes)) {
            return true;
        }
        String typeName = (String)vertex.getProperty(Constants.ENTITY_TYPE_PROPERTY_KEY, String.class);
        boolean typeNameMatchesCriteria = entityTypes.contains(typeName);
        return auditAgingType == Constants.AtlasAuditAgingType.DEFAULT ? !typeNameMatchesCriteria : typeNameMatchesCriteria;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AtlasSearchResult searchWithSearchContext(SearchContext searchContext) throws AtlasBaseException {
        SearchParameters searchParameters = searchContext.getSearchParameters();
        AtlasSearchResult ret = new AtlasSearchResult(searchParameters);
        QueryParams params = QueryParams.getNormalizedParams(searchParameters.getLimit(), searchParameters.getOffset());
        String searchID = this.searchTracker.add(searchContext);
        searchParameters.setLimit(params.limit());
        searchParameters.setOffset(params.offset());
        try {
            List<AtlasVertex> resultList = searchContext.getSearchProcessor().execute();
            ret.setApproximateCount(searchContext.getSearchProcessor().getResultCount());
            String nextMarker = searchContext.getSearchProcessor().getNextMarker();
            if (StringUtils.isNotEmpty((String)nextMarker)) {
                ret.setNextMarker(nextMarker);
            }
            Set attributes = searchParameters.getAttributes();
            if (searchContext.excludeHeaderAttributes()) {
                AtlasSearchResult.AttributeSearchResult attributeSearchResult = new AtlasSearchResult.AttributeSearchResult();
                attributeSearchResult.setName(new ArrayList(attributes));
                ArrayList values = new ArrayList();
                for (AtlasVertex vertex : resultList) {
                    ArrayList<Object> row = new ArrayList<Object>();
                    for (String attrName : attributes) {
                        AtlasEntityType entityType = searchContext.getEntityTypes().iterator().next();
                        AtlasStructType.AtlasAttribute attribute = entityType.getAttribute(attrName);
                        Object value = vertex.getProperty(attribute.getVertexPropertyName(), Object.class);
                        row.add(value != null ? value : "");
                    }
                    values.add(row);
                }
                attributeSearchResult.setValues(new ArrayList(values));
                ret.setAttributes(attributeSearchResult);
                AtlasSearchResult atlasSearchResult = ret;
                return atlasSearchResult;
            }
            HashSet<String> resultAttributes = new HashSet<String>();
            HashSet<String> entityAttributes = new HashSet<String>();
            if (CollectionUtils.isNotEmpty((Collection)searchParameters.getAttributes())) {
                resultAttributes.addAll(searchParameters.getAttributes());
            }
            if (CollectionUtils.isNotEmpty(searchContext.getEntityAttributes())) {
                resultAttributes.addAll(searchContext.getEntityAttributes());
            }
            if (CollectionUtils.isNotEmpty(searchContext.getEntityTypes())) {
                AtlasEntityType entityType = searchContext.getEntityTypes().iterator().next();
                for (String resultAttribute : resultAttributes) {
                    AtlasStructType.AtlasAttribute attribute = entityType.getAttribute(resultAttribute);
                    if (attribute == null) {
                        attribute = entityType.getRelationshipAttribute(resultAttribute, null);
                    }
                    if (attribute == null) continue;
                    AtlasType attributeType = attribute.getAttributeType();
                    if (attributeType instanceof AtlasArrayType) {
                        attributeType = ((AtlasArrayType)attributeType).getElementType();
                    }
                    if (!(attributeType instanceof AtlasEntityType) && !(attributeType instanceof AtlasBuiltInTypes.AtlasObjectIdType)) continue;
                    entityAttributes.add(resultAttribute);
                }
            }
            for (AtlasVertex atlasVertex : resultList) {
                AtlasEntityHeader entity = this.entityRetriever.toAtlasEntityHeader(atlasVertex, resultAttributes);
                if (searchParameters.getIncludeClassificationAttributes()) {
                    entity.setClassifications(this.entityRetriever.getAllClassifications(atlasVertex));
                }
                ret.addEntity(entity);
                for (String entityAttribute : entityAttributes) {
                    Object attrValue = entity.getAttribute(entityAttribute);
                    if (attrValue instanceof AtlasObjectId) {
                        AtlasObjectId objId = (AtlasObjectId)attrValue;
                        if (ret.getReferredEntities() == null) {
                            ret.setReferredEntities(new HashMap());
                        }
                        if (ret.getReferredEntities().containsKey(objId.getGuid())) continue;
                        ret.getReferredEntities().put(objId.getGuid(), this.entityRetriever.toAtlasEntityHeader(objId.getGuid()));
                        continue;
                    }
                    if (!(attrValue instanceof Collection)) continue;
                    Collection objIds = (Collection)attrValue;
                    for (Object obj : objIds) {
                        if (!(obj instanceof AtlasObjectId)) continue;
                        AtlasObjectId objId = (AtlasObjectId)obj;
                        if (ret.getReferredEntities() == null) {
                            ret.setReferredEntities(new HashMap());
                        }
                        if (ret.getReferredEntities().containsKey(objId.getGuid())) continue;
                        ret.getReferredEntities().put(objId.getGuid(), this.entityRetriever.toAtlasEntityHeader(objId.getGuid()));
                    }
                }
            }
        }
        finally {
            this.searchTracker.remove(searchID);
        }
        this.scrubSearchResults(ret);
        return ret;
    }

    @Override
    @GraphTransaction
    public AtlasSearchResult searchRelatedEntities(String guid, String relation, boolean getApproximateCount, SearchParameters searchParameters) throws AtlasBaseException {
        AtlasSearchResult ret = new AtlasSearchResult(AtlasSearchResult.AtlasQueryType.RELATIONSHIP);
        if (StringUtils.isEmpty((String)guid) || StringUtils.isEmpty((String)relation)) {
            throw new AtlasBaseException(AtlasErrorCode.INVALID_PARAMETERS, new String[]{"guid: '" + guid + "', relation: '" + relation + "'"});
        }
        AtlasVertex entityVertex = this.entityRetriever.getEntityVertex(guid);
        String entityTypeName = GraphHelper.getTypeName((AtlasElement)entityVertex);
        AtlasEntityType entityType = this.typeRegistry.getEntityTypeByName(entityTypeName);
        if (entityType == null) {
            throw new AtlasBaseException(AtlasErrorCode.INVALID_RELATIONSHIP_TYPE, new String[]{entityTypeName, guid});
        }
        AtlasEntityType endEntityType = null;
        AtlasStructType.AtlasAttribute attribute = entityType.getAttribute(relation);
        if (attribute == null) {
            attribute = entityType.getRelationshipAttribute(relation, null);
        }
        if (attribute != null) {
            endEntityType = attribute.getReferencedEntityType(this.typeRegistry);
            if (endEntityType == null) {
                throw new AtlasBaseException(AtlasErrorCode.INVALID_RELATIONSHIP_ATTRIBUTE, new String[]{relation, attribute.getTypeName()});
            }
            relation = attribute.getRelationshipEdgeLabel();
        } else {
            String endEntityTypeName = GraphHelper.getReferencedEntityTypeName(entityVertex, relation);
            if (StringUtils.isNotEmpty((String)endEntityTypeName)) {
                endEntityType = this.typeRegistry.getEntityTypeByName(endEntityTypeName);
            }
        }
        String sortBy = searchParameters.getSortBy();
        SortOrder sortOrder = searchParameters.getSortOrder();
        int offset = searchParameters.getOffset();
        int limit = searchParameters.getLimit();
        String sortByAttributeName = DEFAULT_SORT_ATTRIBUTE_NAME;
        if (StringUtils.isNotEmpty((String)sortBy)) {
            sortByAttributeName = sortBy;
        }
        if (endEntityType != null) {
            AtlasStructType.AtlasAttribute sortByAttribute = endEntityType.getAttribute(sortByAttributeName);
            if (sortByAttribute == null) {
                sortByAttributeName = null;
                sortOrder = null;
                if (StringUtils.isNotEmpty((String)sortBy)) {
                    LOG.info("Invalid sortBy Attribute {} for entityType {}, Ignoring Sorting", (Object)sortBy, (Object)endEntityType.getTypeName());
                } else {
                    LOG.info("Invalid Default sortBy Attribute {} for entityType {}, Ignoring Sorting", (Object)DEFAULT_SORT_ATTRIBUTE_NAME, (Object)endEntityType.getTypeName());
                }
            } else {
                sortByAttributeName = sortByAttribute.getVertexPropertyName();
                if (sortOrder == null) {
                    sortOrder = SortOrder.ASCENDING;
                }
            }
        } else {
            sortOrder = null;
            if (StringUtils.isNotEmpty((String)sortBy)) {
                LOG.info("Invalid sortBy Attribute {}, Ignoring Sorting", (Object)sortBy);
            }
        }
        GraphTraversal gt = this.graph.V(new Object[]{entityVertex.getId()}).bothE(new String[]{relation}).otherV();
        if (searchParameters.getExcludeDeletedEntities()) {
            gt.has(Constants.STATE_PROPERTY_KEY, (Object)AtlasEntity.Status.ACTIVE.name());
        }
        if (sortOrder != null) {
            if (sortOrder == SortOrder.ASCENDING) {
                gt.order().by(sortByAttributeName, (Comparator)Order.asc);
            } else {
                gt.order().by(sortByAttributeName, (Comparator)Order.desc);
            }
        }
        gt.range((long)offset, (long)(offset + limit));
        ArrayList<AtlasEntityHeader> resultList = new ArrayList<AtlasEntityHeader>();
        while (gt.hasNext()) {
            Vertex v = (Vertex)gt.next();
            if (v == null || !v.property(Constants.GUID_PROPERTY_KEY).isPresent()) continue;
            String endVertexGuid = v.property(Constants.GUID_PROPERTY_KEY).value().toString();
            AtlasVertex vertex = this.entityRetriever.getEntityVertex(endVertexGuid);
            AtlasEntityHeader entity = this.entityRetriever.toAtlasEntityHeader(vertex, (Set<String>)searchParameters.getAttributes());
            if (searchParameters.getIncludeClassificationAttributes()) {
                entity.setClassifications(this.entityRetriever.getAllClassifications(vertex));
            }
            resultList.add(entity);
        }
        ret.setEntities(resultList);
        if (ret.getEntities() == null) {
            ret.setEntities(new ArrayList());
        }
        if (getApproximateCount) {
            Iterator<AtlasEdge> edges = GraphHelper.getAdjacentEdgesByLabel(entityVertex, AtlasEdgeDirection.BOTH, relation);
            if (searchParameters.getExcludeDeletedEntities()) {
                ArrayList edgeList = new ArrayList();
                edges.forEachRemaining(edgeList::add);
                Predicate activePredicate = SearchPredicateUtil.getEQPredicateGenerator().generatePredicate(Constants.STATE_PROPERTY_KEY, AtlasEntity.Status.ACTIVE.name(), String.class);
                CollectionUtils.filter(edgeList, (Predicate)activePredicate);
                ret.setApproximateCount((long)edgeList.size());
            } else {
                ret.setApproximateCount((long)IteratorUtils.size(edges));
            }
        }
        this.scrubSearchResults(ret);
        return ret;
    }

    public int getMaxResultSetSize() {
        return this.maxResultSetSize;
    }

    private String getQueryForFullTextSearch(String userKeyedString, String typeName, String classification) {
        String typeFilter = EntityDiscoveryService.getTypeFilter(this.typeRegistry, typeName, this.maxTypesLengthInIdxQuery);
        String classificationFilter = EntityDiscoveryService.getClassificationFilter(this.typeRegistry, classification, this.maxTagsLengthInIdxQuery);
        StringBuilder queryText = new StringBuilder();
        if (!StringUtils.isEmpty((String)userKeyedString)) {
            queryText.append(userKeyedString);
        }
        if (!StringUtils.isEmpty((String)typeFilter)) {
            if (queryText.length() > 0) {
                queryText.append(" AND ");
            }
            queryText.append(typeFilter);
        }
        if (!StringUtils.isEmpty((String)classificationFilter)) {
            if (queryText.length() > 0) {
                queryText.append(" AND ");
            }
            queryText.append(classificationFilter);
        }
        return String.format(this.indexSearchPrefix + "\"%s\":(%s)", Constants.ENTITY_TEXT_PROPERTY_KEY, queryText.toString());
    }

    private List<AtlasSearchResult.AtlasFullTextResult> getIndexQueryResults(AtlasIndexQuery query, QueryParams params, boolean excludeDeletedEntities) throws AtlasBaseException {
        ArrayList<AtlasSearchResult.AtlasFullTextResult> ret = new ArrayList<AtlasSearchResult.AtlasFullTextResult>();
        Iterator iter = query.vertices();
        while (iter.hasNext() && ret.size() < params.limit()) {
            String guid;
            AtlasIndexQuery.Result idxQueryResult = (AtlasIndexQuery.Result)iter.next();
            AtlasVertex vertex = idxQueryResult.getVertex();
            if (this.skipDeletedEntities(excludeDeletedEntities, vertex) || (guid = vertex != null ? (String)vertex.getProperty(Constants.GUID_PROPERTY_KEY, String.class) : null) == null) continue;
            AtlasEntityHeader entity = this.entityRetriever.toAtlasEntityHeader(vertex);
            Double score = idxQueryResult.getScore();
            ret.add(new AtlasSearchResult.AtlasFullTextResult(entity, score));
        }
        return ret;
    }

    private AtlasIndexQuery toAtlasIndexQuery(String fullTextQuery) {
        String graphQuery = String.format(this.indexSearchPrefix + "\"%s\":(%s)", Constants.ENTITY_TEXT_PROPERTY_KEY, fullTextQuery);
        return this.graph.indexQuery("fulltext_index", graphQuery);
    }

    private boolean skipDeletedEntities(boolean excludeDeletedEntities, AtlasVertex<?, ?> vertex) {
        return excludeDeletedEntities && GraphHelper.getStatus(vertex) == AtlasEntity.Status.DELETED;
    }

    private static String getClassificationFilter(AtlasTypeRegistry typeRegistry, String classificationName, int maxTypesLengthInIdxQuery) {
        String typeAndSubTypesQryStr;
        AtlasClassificationType type = typeRegistry.getClassificationTypeByName(classificationName);
        String string = typeAndSubTypesQryStr = type != null ? type.getTypeAndAllSubTypesQryStr() : null;
        if (StringUtils.isNotEmpty((String)typeAndSubTypesQryStr) && typeAndSubTypesQryStr.length() <= maxTypesLengthInIdxQuery) {
            return typeAndSubTypesQryStr;
        }
        return "";
    }

    @VisibleForTesting
    static String getTypeFilter(AtlasTypeRegistry typeRegistry, String typeName, int maxTypesLengthInIdxQuery) {
        String typeAndSubTypesQryStr;
        AtlasEntityType type = typeRegistry.getEntityTypeByName(typeName);
        String string = typeAndSubTypesQryStr = type != null ? type.getTypeAndAllSubTypesQryStr() : null;
        if (StringUtils.isNotEmpty((String)typeAndSubTypesQryStr) && typeAndSubTypesQryStr.length() <= maxTypesLengthInIdxQuery) {
            return typeAndSubTypesQryStr;
        }
        return "";
    }

    private Set<String> getEntityStates() {
        return new HashSet<String>(Arrays.asList(AtlasEntity.Status.ACTIVE.toString(), AtlasEntity.Status.DELETED.toString()));
    }

    @Override
    public AtlasUserSavedSearch addSavedSearch(String currentUser, AtlasUserSavedSearch savedSearch) throws AtlasBaseException {
        try {
            if (StringUtils.isEmpty((String)savedSearch.getOwnerName())) {
                savedSearch.setOwnerName(currentUser);
            }
            this.checkSavedSearchOwnership(currentUser, savedSearch);
            return this.userProfileService.addSavedSearch(savedSearch);
        }
        catch (AtlasBaseException e) {
            LOG.error("addSavedSearch({})", (Object)savedSearch, (Object)e);
            throw e;
        }
    }

    @Override
    public AtlasUserSavedSearch updateSavedSearch(String currentUser, AtlasUserSavedSearch savedSearch) throws AtlasBaseException {
        try {
            if (StringUtils.isEmpty((String)savedSearch.getOwnerName())) {
                savedSearch.setOwnerName(currentUser);
            }
            this.checkSavedSearchOwnership(currentUser, savedSearch);
            return this.userProfileService.updateSavedSearch(savedSearch);
        }
        catch (AtlasBaseException e) {
            LOG.error("updateSavedSearch({})", (Object)savedSearch, (Object)e);
            throw e;
        }
    }

    @Override
    public List<AtlasUserSavedSearch> getSavedSearches(String currentUser, String userName) throws AtlasBaseException {
        try {
            if (StringUtils.isEmpty((String)userName)) {
                userName = currentUser;
            } else if (!StringUtils.equals((String)currentUser, (String)userName)) {
                throw new AtlasBaseException(AtlasErrorCode.BAD_REQUEST, new String[]{"invalid data"});
            }
            return this.userProfileService.getSavedSearches(userName);
        }
        catch (AtlasBaseException e) {
            LOG.error("getSavedSearches({})", (Object)userName, (Object)e);
            throw e;
        }
    }

    @Override
    public AtlasUserSavedSearch getSavedSearchByGuid(String currentUser, String guid) throws AtlasBaseException {
        try {
            AtlasUserSavedSearch savedSearch = this.userProfileService.getSavedSearch(guid);
            this.checkSavedSearchOwnership(currentUser, savedSearch);
            return savedSearch;
        }
        catch (AtlasBaseException e) {
            LOG.error("getSavedSearchByGuid({})", (Object)guid, (Object)e);
            throw e;
        }
    }

    @Override
    public AtlasUserSavedSearch getSavedSearchByName(String currentUser, String userName, String searchName) throws AtlasBaseException {
        try {
            if (StringUtils.isEmpty((String)userName)) {
                userName = currentUser;
            } else if (!StringUtils.equals((String)currentUser, (String)userName)) {
                throw new AtlasBaseException(AtlasErrorCode.BAD_REQUEST, new String[]{"invalid data"});
            }
            return this.userProfileService.getSavedSearch(userName, searchName);
        }
        catch (AtlasBaseException e) {
            LOG.error("getSavedSearchByName({}, {})", new Object[]{userName, searchName, e});
            throw e;
        }
    }

    @Override
    public void deleteSavedSearch(String currentUser, String guid) throws AtlasBaseException {
        try {
            AtlasUserSavedSearch savedSearch = this.userProfileService.getSavedSearch(guid);
            this.checkSavedSearchOwnership(currentUser, savedSearch);
            this.userProfileService.deleteSavedSearch(guid);
        }
        catch (AtlasBaseException e) {
            LOG.error("deleteSavedSearch({})", (Object)guid, (Object)e);
            throw e;
        }
    }

    @Override
    public String getDslQueryUsingTypeNameClassification(String query, String typeName, String classification) {
        String queryStr;
        String string = queryStr = query == null ? "" : query;
        if (StringUtils.isNotEmpty((String)typeName)) {
            queryStr = this.escapeTypeName(typeName) + " " + queryStr;
        }
        if (StringUtils.isNotEmpty((String)classification) && StringUtils.isEmpty((String)query)) {
            queryStr = queryStr + " isa " + classification;
        }
        return queryStr;
    }

    public static SearchParameters createSearchParameters(QuickSearchParameters quickSearchParameters) {
        SearchParameters searchParameters = new SearchParameters();
        searchParameters.setQuery(quickSearchParameters.getQuery());
        searchParameters.setTypeName(quickSearchParameters.getTypeName());
        searchParameters.setExcludeDeletedEntities(quickSearchParameters.getExcludeDeletedEntities());
        searchParameters.setIncludeSubTypes(quickSearchParameters.getIncludeSubTypes());
        searchParameters.setLimit(quickSearchParameters.getLimit());
        searchParameters.setOffset(quickSearchParameters.getOffset());
        searchParameters.setEntityFilters(quickSearchParameters.getEntityFilters());
        searchParameters.setAttributes(quickSearchParameters.getAttributes());
        searchParameters.setSortBy(quickSearchParameters.getSortBy());
        searchParameters.setSortOrder(quickSearchParameters.getSortOrder());
        searchParameters.setExcludeHeaderAttributes(quickSearchParameters.getExcludeHeaderAttributes());
        return searchParameters;
    }

    public static SearchParameters createSearchParameters(RelationshipSearchParameters relationshipSearchParameters) {
        SearchParameters searchParameters = new SearchParameters();
        searchParameters.setRelationshipName(relationshipSearchParameters.getRelationshipName());
        searchParameters.setIncludeSubTypes(relationshipSearchParameters.isIncludeSubTypes());
        searchParameters.setLimit(relationshipSearchParameters.getLimit());
        searchParameters.setOffset(relationshipSearchParameters.getOffset());
        searchParameters.setRelationshipFilters(relationshipSearchParameters.getRelationshipFilters());
        searchParameters.setSortBy(relationshipSearchParameters.getSortBy());
        searchParameters.setSortOrder(relationshipSearchParameters.getSortOrder());
        searchParameters.setMarker(relationshipSearchParameters.getMarker());
        return searchParameters;
    }

    private String escapeTypeName(String typeName) {
        String ret = StringUtils.startsWith((String)typeName, (String)"`") && StringUtils.endsWith((String)typeName, (String)"`") ? typeName : String.format("`%s`", typeName);
        return ret;
    }

    private void checkSavedSearchOwnership(String claimedOwner, AtlasUserSavedSearch savedSearch) throws AtlasBaseException {
        if (savedSearch != null && !StringUtils.equals((String)savedSearch.getOwnerName(), (String)claimedOwner)) {
            throw new AtlasBaseException(AtlasErrorCode.BAD_REQUEST, new String[]{"invalid data"});
        }
    }

    private void scrubSearchResults(AtlasSearchResult result) throws AtlasBaseException {
        AtlasAuthorizationUtils.scrubSearchResults((AtlasSearchResultScrubRequest)new AtlasSearchResultScrubRequest(this.typeRegistry, result));
    }

    private Set<String> getAggregationFields() {
        HashSet<String> ret = new HashSet<String>();
        ret.add(Constants.ENTITY_TYPE_PROPERTY_KEY);
        ret.add(Constants.STATE_PROPERTY_KEY);
        return ret;
    }

    private Set<AtlasStructType.AtlasAttribute> getAggregationAtlasAttributes() {
        HashSet<AtlasStructType.AtlasAttribute> ret = new HashSet<AtlasStructType.AtlasAttribute>();
        ret.add(this.getAtlasAttributeForAssetOwner());
        return ret;
    }

    private AtlasStructType.AtlasAttribute getAtlasAttributeForAssetOwner() {
        AtlasStructType.AtlasAttribute atttOwner;
        AtlasEntityType typeAsset = this.typeRegistry.getEntityTypeByName("Asset");
        AtlasStructType.AtlasAttribute atlasAttribute = atttOwner = typeAsset != null ? typeAsset.getAttribute("owner") : null;
        if (atttOwner == null) {
            String msg = String.format("Unable to resolve the attribute %s.%s", "Asset", "owner");
            LOG.error(msg);
            throw new RuntimeException(msg);
        }
        return atttOwner;
    }
}

