/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.utils;

import java.util.ArrayList;
import java.util.List;
import org.apache.atlas.GraphTransactionInterceptor;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.RandomStringUtils;
import org.springframework.util.CollectionUtils;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ObjectUpdateSynchronizerTest {
    private static final GraphTransactionInterceptor.ObjectUpdateSynchronizer objectUpdateSynchronizer = new GraphTransactionInterceptor.ObjectUpdateSynchronizer();
    private final List<Integer> outputList = new ArrayList<Integer>();
    private final int MAX_COUNT = 10;

    @BeforeMethod
    public void clearOutputList() {
        this.outputList.clear();
    }

    @Test
    public void singleThreadRun() throws InterruptedException {
        this.verifyMultipleThreadRun(1);
    }

    @Test
    public void twoThreadsAccessingDifferntGuids_DoNotSerialize() throws InterruptedException {
        CounterThread[] th = this.getCounterThreads(false, 2);
        this.startCounterThreads(th);
        this.waitForThreadsToEnd(th);
        this.assertArrayNotEquals(this.populateExpectedArrayOutput(2));
    }

    @Test
    public void twoThreadsAccessingSameGuid_Serialize() throws InterruptedException {
        this.verifyMultipleThreadRun(2);
    }

    @Test
    public void severalThreadsAccessingSameGuid_Serialize() throws InterruptedException {
        this.verifyMultipleThreadRun(10);
    }

    @Test
    public void severalThreadsSequentialAccessingListOfGuids() throws InterruptedException {
        CounterThread[] th = this.getCounterThreads(false, 10);
        int i = 0;
        th[i++].setIds("1", "2", "3", "4", "5");
        th[i++].setIds("1", "2", "3", "4");
        th[i++].setIds("1", "2", "3");
        th[i++].setIds("1", "2");
        th[i++].setIds("1");
        th[i++].setIds("1", "2");
        th[i++].setIds("1", "2", "3");
        th[i++].setIds("1", "2", "3", "4");
        th[i++].setIds("1", "2", "3", "4", "5");
        th[i++].setIds("1");
        this.startCounterThreads(th);
        this.waitForThreadsToEnd(th);
        this.assertArrayEquals(this.populateExpectedArrayOutput(th.length));
    }

    @Test
    public void severalThreadsNonSequentialAccessingListOfGuids() throws InterruptedException {
        CounterThread[] th = this.getCounterThreads(false, 5);
        int i = 0;
        th[i++].setIds("2", "1", "3", "4", "5");
        th[i++].setIds("3", "2", "4", "1");
        th[i++].setIds("2", "3", "1");
        th[i++].setIds("1", "2");
        th[i++].setIds("1");
        this.startCounterThreads(th);
        this.waitForThreadsToEnd(th);
        this.assertArrayEquals(this.populateExpectedArrayOutput(th.length));
    }

    @Test
    public void severalThreadsAccessingOverlappingListOfGuids() throws InterruptedException {
        CounterThread[] th = this.getCounterThreads(false, 5);
        int i = 0;
        th[i++].setIds("1", "2", "3", "4", "5");
        th[i++].setIds("3", "4", "5", "6");
        th[i++].setIds("5", "6", "7");
        th[i++].setIds("7", "8");
        th[i++].setIds("8");
        this.startCounterThreads(th);
        this.waitForThreadsToEnd(th);
        this.assertArrayNotEquals(this.populateExpectedArrayOutput(th.length));
    }

    @Test
    public void severalThreadsAccessingOverlappingListOfGuids2() throws InterruptedException {
        CounterThread[] th = this.getCounterThreads(false, 3);
        int i = 0;
        th[i++].setIds("1", "2", "3", "4", "5");
        th[i++].setIds("6", "7", "8", "9");
        th[i++].setIds("4", "5", "6");
        this.startCounterThreads(th);
        this.waitForThreadsToEnd(th);
        this.assertArrayNotEquals(this.populateExpectedArrayOutput(th.length));
    }

    @Test
    public void severalThreadsAccessingOverlappingListOfGuidsEnsuringSerialOutput() throws InterruptedException {
        CounterThread[] th = this.getCounterThreads(false, 5);
        int i = 0;
        th[i++].setIds("1", "2", "3", "4", "7");
        th[i++].setIds("3", "4", "5", "7");
        th[i++].setIds("5", "6", "7");
        th[i++].setIds("7", "8");
        th[i++].setIds("7");
        this.startCounterThreads(th);
        this.waitForThreadsToEnd(th);
        this.assertArrayEquals(this.populateExpectedArrayOutput(th.length));
    }

    private void verifyMultipleThreadRun(int limit) throws InterruptedException {
        CounterThread[] th = this.getCounterThreads(limit);
        this.startCounterThreads(th);
        this.waitForThreadsToEnd(th);
        this.assertArrayEquals(this.populateExpectedArrayOutput(limit));
    }

    private void startCounterThreads(CounterThread[] th) {
        for (int i = 0; i < th.length; ++i) {
            th[i].start();
        }
    }

    private CounterThread[] getCounterThreads(int limit) {
        return this.getCounterThreads(true, limit);
    }

    private CounterThread[] getCounterThreads(boolean sameId, int limit) {
        CounterThread[] th = new CounterThread[limit];
        Integer i = 0;
        while (i < limit) {
            th[i.intValue()] = new CounterThread(sameId ? "1" : i.toString());
            Integer n = i;
            i = i + 1;
        }
        return th;
    }

    private void assertArrayEquals(List<Integer> expected) {
        Assert.assertEquals((Object[])this.outputList.toArray(), (Object[])expected.toArray());
    }

    private void assertArrayNotEquals(List<Integer> expected) {
        Assert.assertFalse((boolean)ArrayUtils.isEquals((Object)this.outputList.toArray(), expected));
    }

    private void waitForThreadsToEnd(CounterThread ... threads) throws InterruptedException {
        for (CounterThread t : threads) {
            t.join();
        }
    }

    private List<Integer> populateExpectedArrayOutput(int limit) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 0; i < limit * 10; i += 10) {
            for (int j = 0; j < 10; ++j) {
                list.add(j);
            }
        }
        return list;
    }

    class CounterThread
    extends Thread {
        String[] ids = new String[1];

        public CounterThread(String id) {
            this.ids[0] = id;
        }

        public void setIds(String ... ids) {
            this.ids = ids;
        }

        @Override
        public void run() {
            objectUpdateSynchronizer.lockObject(CollectionUtils.arrayToList((Object)this.ids));
            for (int i = 0; i < 10; ++i) {
                ObjectUpdateSynchronizerTest.this.outputList.add(i);
                RandomStringUtils.randomAlphabetic((int)20);
            }
            objectUpdateSynchronizer.releaseLockedObjects();
        }
    }
}

